/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Model definition for MeasurementPartnerCampaignLink.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MeasurementPartnerCampaignLink extends com.google.api.client.json.GenericJson {

  /**
   * .
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String linkStatus;

  /**
   * Measurement partner used for tag wrapping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String measurementPartner;

  /**
   * Partner campaign ID needed for establishing linking with Measurement partner.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String partnerCampaignId;

  /**
   * .
   * @return value or {@code null} for none
   */
  public java.lang.String getLinkStatus() {
    return linkStatus;
  }

  /**
   * .
   * @param linkStatus linkStatus or {@code null} for none
   */
  public MeasurementPartnerCampaignLink setLinkStatus(java.lang.String linkStatus) {
    this.linkStatus = linkStatus;
    return this;
  }

  /**
   * Measurement partner used for tag wrapping.
   * @return value or {@code null} for none
   */
  public java.lang.String getMeasurementPartner() {
    return measurementPartner;
  }

  /**
   * Measurement partner used for tag wrapping.
   * @param measurementPartner measurementPartner or {@code null} for none
   */
  public MeasurementPartnerCampaignLink setMeasurementPartner(java.lang.String measurementPartner) {
    this.measurementPartner = measurementPartner;
    return this;
  }

  /**
   * Partner campaign ID needed for establishing linking with Measurement partner.
   * @return value or {@code null} for none
   */
  public java.lang.String getPartnerCampaignId() {
    return partnerCampaignId;
  }

  /**
   * Partner campaign ID needed for establishing linking with Measurement partner.
   * @param partnerCampaignId partnerCampaignId or {@code null} for none
   */
  public MeasurementPartnerCampaignLink setPartnerCampaignId(java.lang.String partnerCampaignId) {
    this.partnerCampaignId = partnerCampaignId;
    return this;
  }

  @Override
  public MeasurementPartnerCampaignLink set(String fieldName, Object value) {
    return (MeasurementPartnerCampaignLink) super.set(fieldName, value);
  }

  @Override
  public MeasurementPartnerCampaignLink clone() {
    return (MeasurementPartnerCampaignLink) super.clone();
  }

}
