/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Placement tag wrapping
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MeasurementPartnerWrappingData extends com.google.api.client.json.GenericJson {

  /**
   * Placement wrapping status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String linkStatus;

  /**
   * Measurement partner used for wrapping the placement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String measurementPartner;

  /**
   * Measurement mode for the wrapped placement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tagWrappingMode;

  /**
   * Tag provided by the measurement partner during wrapping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String wrappedTag;

  /**
   * Placement wrapping status.
   * @return value or {@code null} for none
   */
  public java.lang.String getLinkStatus() {
    return linkStatus;
  }

  /**
   * Placement wrapping status.
   * @param linkStatus linkStatus or {@code null} for none
   */
  public MeasurementPartnerWrappingData setLinkStatus(java.lang.String linkStatus) {
    this.linkStatus = linkStatus;
    return this;
  }

  /**
   * Measurement partner used for wrapping the placement.
   * @return value or {@code null} for none
   */
  public java.lang.String getMeasurementPartner() {
    return measurementPartner;
  }

  /**
   * Measurement partner used for wrapping the placement.
   * @param measurementPartner measurementPartner or {@code null} for none
   */
  public MeasurementPartnerWrappingData setMeasurementPartner(java.lang.String measurementPartner) {
    this.measurementPartner = measurementPartner;
    return this;
  }

  /**
   * Measurement mode for the wrapped placement.
   * @return value or {@code null} for none
   */
  public java.lang.String getTagWrappingMode() {
    return tagWrappingMode;
  }

  /**
   * Measurement mode for the wrapped placement.
   * @param tagWrappingMode tagWrappingMode or {@code null} for none
   */
  public MeasurementPartnerWrappingData setTagWrappingMode(java.lang.String tagWrappingMode) {
    this.tagWrappingMode = tagWrappingMode;
    return this;
  }

  /**
   * Tag provided by the measurement partner during wrapping.
   * @return value or {@code null} for none
   */
  public java.lang.String getWrappedTag() {
    return wrappedTag;
  }

  /**
   * Tag provided by the measurement partner during wrapping.
   * @param wrappedTag wrappedTag or {@code null} for none
   */
  public MeasurementPartnerWrappingData setWrappedTag(java.lang.String wrappedTag) {
    this.wrappedTag = wrappedTag;
    return this;
  }

  @Override
  public MeasurementPartnerWrappingData set(String fieldName, Object value) {
    return (MeasurementPartnerWrappingData) super.set(fieldName, value);
  }

  @Override
  public MeasurementPartnerWrappingData clone() {
    return (MeasurementPartnerWrappingData) super.clone();
  }

}
