/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Identify a user by name and address.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OfflineUserAddressInfo extends com.google.api.client.json.GenericJson {

  /**
   * City of the address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String city;

  /**
   * 2-letter country code in ISO-3166-1 alpha-2 of the user's address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * First name of the user, which is hashed as SHA-256 after normalized (Lowercase all characters;
   * Remove any extra spaces before, after, and in between).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hashedFirstName;

  /**
   * Last name of the user, which is hashed as SHA-256 after normalized (lower case only and no
   * punctuation).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hashedLastName;

  /**
   * The street address of the user hashed using SHA-256 hash function after normalization (lower
   * case only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hashedStreetAddress;

  /**
   * Postal code of the user's address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String postalCode;

  /**
   * State code of the address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * City of the address.
   * @return value or {@code null} for none
   */
  public java.lang.String getCity() {
    return city;
  }

  /**
   * City of the address.
   * @param city city or {@code null} for none
   */
  public OfflineUserAddressInfo setCity(java.lang.String city) {
    this.city = city;
    return this;
  }

  /**
   * 2-letter country code in ISO-3166-1 alpha-2 of the user's address.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * 2-letter country code in ISO-3166-1 alpha-2 of the user's address.
   * @param countryCode countryCode or {@code null} for none
   */
  public OfflineUserAddressInfo setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * First name of the user, which is hashed as SHA-256 after normalized (Lowercase all characters;
   * Remove any extra spaces before, after, and in between).
   * @return value or {@code null} for none
   */
  public java.lang.String getHashedFirstName() {
    return hashedFirstName;
  }

  /**
   * First name of the user, which is hashed as SHA-256 after normalized (Lowercase all characters;
   * Remove any extra spaces before, after, and in between).
   * @param hashedFirstName hashedFirstName or {@code null} for none
   */
  public OfflineUserAddressInfo setHashedFirstName(java.lang.String hashedFirstName) {
    this.hashedFirstName = hashedFirstName;
    return this;
  }

  /**
   * Last name of the user, which is hashed as SHA-256 after normalized (lower case only and no
   * punctuation).
   * @return value or {@code null} for none
   */
  public java.lang.String getHashedLastName() {
    return hashedLastName;
  }

  /**
   * Last name of the user, which is hashed as SHA-256 after normalized (lower case only and no
   * punctuation).
   * @param hashedLastName hashedLastName or {@code null} for none
   */
  public OfflineUserAddressInfo setHashedLastName(java.lang.String hashedLastName) {
    this.hashedLastName = hashedLastName;
    return this;
  }

  /**
   * The street address of the user hashed using SHA-256 hash function after normalization (lower
   * case only).
   * @return value or {@code null} for none
   */
  public java.lang.String getHashedStreetAddress() {
    return hashedStreetAddress;
  }

  /**
   * The street address of the user hashed using SHA-256 hash function after normalization (lower
   * case only).
   * @param hashedStreetAddress hashedStreetAddress or {@code null} for none
   */
  public OfflineUserAddressInfo setHashedStreetAddress(java.lang.String hashedStreetAddress) {
    this.hashedStreetAddress = hashedStreetAddress;
    return this;
  }

  /**
   * Postal code of the user's address.
   * @return value or {@code null} for none
   */
  public java.lang.String getPostalCode() {
    return postalCode;
  }

  /**
   * Postal code of the user's address.
   * @param postalCode postalCode or {@code null} for none
   */
  public OfflineUserAddressInfo setPostalCode(java.lang.String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

  /**
   * State code of the address.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * State code of the address.
   * @param state state or {@code null} for none
   */
  public OfflineUserAddressInfo setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public OfflineUserAddressInfo set(String fieldName, Object value) {
    return (OfflineUserAddressInfo) super.set(fieldName, value);
  }

  @Override
  public OfflineUserAddressInfo clone() {
    return (OfflineUserAddressInfo) super.clone();
  }

}
