/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Represents a DfaReporting path filter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PathFilter extends com.google.api.client.json.GenericJson {

  /**
   * Event filters in path report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EventFilter> eventFilters;

  static {
    // hack to force ProGuard to consider EventFilter used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(EventFilter.class);
  }

  /**
   * The kind of resource this is, in this case dfareporting#pathFilter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Determines how the 'value' field is matched when filtering. If not specified, defaults to
   * EXACT. If set to WILDCARD_EXPRESSION, '*' is allowed as a placeholder for variable length
   * character sequences, and it can be escaped with a backslash. Note, only paid search dimensions
   * ('dfa:paidSearch*') allow a matchType other than EXACT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pathMatchPosition;

  /**
   * Event filters in path report.
   * @return value or {@code null} for none
   */
  public java.util.List<EventFilter> getEventFilters() {
    return eventFilters;
  }

  /**
   * Event filters in path report.
   * @param eventFilters eventFilters or {@code null} for none
   */
  public PathFilter setEventFilters(java.util.List<EventFilter> eventFilters) {
    this.eventFilters = eventFilters;
    return this;
  }

  /**
   * The kind of resource this is, in this case dfareporting#pathFilter.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of resource this is, in this case dfareporting#pathFilter.
   * @param kind kind or {@code null} for none
   */
  public PathFilter setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Determines how the 'value' field is matched when filtering. If not specified, defaults to
   * EXACT. If set to WILDCARD_EXPRESSION, '*' is allowed as a placeholder for variable length
   * character sequences, and it can be escaped with a backslash. Note, only paid search dimensions
   * ('dfa:paidSearch*') allow a matchType other than EXACT.
   * @return value or {@code null} for none
   */
  public java.lang.String getPathMatchPosition() {
    return pathMatchPosition;
  }

  /**
   * Determines how the 'value' field is matched when filtering. If not specified, defaults to
   * EXACT. If set to WILDCARD_EXPRESSION, '*' is allowed as a placeholder for variable length
   * character sequences, and it can be escaped with a backslash. Note, only paid search dimensions
   * ('dfa:paidSearch*') allow a matchType other than EXACT.
   * @param pathMatchPosition pathMatchPosition or {@code null} for none
   */
  public PathFilter setPathMatchPosition(java.lang.String pathMatchPosition) {
    this.pathMatchPosition = pathMatchPosition;
    return this;
  }

  @Override
  public PathFilter set(String fieldName, Object value) {
    return (PathFilter) super.set(fieldName, value);
  }

  @Override
  public PathFilter clone() {
    return (PathFilter) super.clone();
  }

}
