/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Popup Window Properties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PopupWindowProperties extends com.google.api.client.json.GenericJson {

  /**
   * Popup dimension for a creative. This is a read-only field. Applicable to the following creative
   * types: all RICH_MEDIA and all VPAID
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Size dimension;

  /**
   * Upper-left corner coordinates of the popup window. Applicable if positionType is COORDINATES.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OffsetPosition offset;

  /**
   * Popup window position either centered or at specific coordinate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String positionType;

  /**
   * Whether to display the browser address bar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean showAddressBar;

  /**
   * Whether to display the browser menu bar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean showMenuBar;

  /**
   * Whether to display the browser scroll bar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean showScrollBar;

  /**
   * Whether to display the browser status bar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean showStatusBar;

  /**
   * Whether to display the browser tool bar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean showToolBar;

  /**
   * Title of popup window.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Popup dimension for a creative. This is a read-only field. Applicable to the following creative
   * types: all RICH_MEDIA and all VPAID
   * @return value or {@code null} for none
   */
  public Size getDimension() {
    return dimension;
  }

  /**
   * Popup dimension for a creative. This is a read-only field. Applicable to the following creative
   * types: all RICH_MEDIA and all VPAID
   * @param dimension dimension or {@code null} for none
   */
  public PopupWindowProperties setDimension(Size dimension) {
    this.dimension = dimension;
    return this;
  }

  /**
   * Upper-left corner coordinates of the popup window. Applicable if positionType is COORDINATES.
   * @return value or {@code null} for none
   */
  public OffsetPosition getOffset() {
    return offset;
  }

  /**
   * Upper-left corner coordinates of the popup window. Applicable if positionType is COORDINATES.
   * @param offset offset or {@code null} for none
   */
  public PopupWindowProperties setOffset(OffsetPosition offset) {
    this.offset = offset;
    return this;
  }

  /**
   * Popup window position either centered or at specific coordinate.
   * @return value or {@code null} for none
   */
  public java.lang.String getPositionType() {
    return positionType;
  }

  /**
   * Popup window position either centered or at specific coordinate.
   * @param positionType positionType or {@code null} for none
   */
  public PopupWindowProperties setPositionType(java.lang.String positionType) {
    this.positionType = positionType;
    return this;
  }

  /**
   * Whether to display the browser address bar.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShowAddressBar() {
    return showAddressBar;
  }

  /**
   * Whether to display the browser address bar.
   * @param showAddressBar showAddressBar or {@code null} for none
   */
  public PopupWindowProperties setShowAddressBar(java.lang.Boolean showAddressBar) {
    this.showAddressBar = showAddressBar;
    return this;
  }

  /**
   * Whether to display the browser menu bar.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShowMenuBar() {
    return showMenuBar;
  }

  /**
   * Whether to display the browser menu bar.
   * @param showMenuBar showMenuBar or {@code null} for none
   */
  public PopupWindowProperties setShowMenuBar(java.lang.Boolean showMenuBar) {
    this.showMenuBar = showMenuBar;
    return this;
  }

  /**
   * Whether to display the browser scroll bar.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShowScrollBar() {
    return showScrollBar;
  }

  /**
   * Whether to display the browser scroll bar.
   * @param showScrollBar showScrollBar or {@code null} for none
   */
  public PopupWindowProperties setShowScrollBar(java.lang.Boolean showScrollBar) {
    this.showScrollBar = showScrollBar;
    return this;
  }

  /**
   * Whether to display the browser status bar.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShowStatusBar() {
    return showStatusBar;
  }

  /**
   * Whether to display the browser status bar.
   * @param showStatusBar showStatusBar or {@code null} for none
   */
  public PopupWindowProperties setShowStatusBar(java.lang.Boolean showStatusBar) {
    this.showStatusBar = showStatusBar;
    return this;
  }

  /**
   * Whether to display the browser tool bar.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShowToolBar() {
    return showToolBar;
  }

  /**
   * Whether to display the browser tool bar.
   * @param showToolBar showToolBar or {@code null} for none
   */
  public PopupWindowProperties setShowToolBar(java.lang.Boolean showToolBar) {
    this.showToolBar = showToolBar;
    return this;
  }

  /**
   * Title of popup window.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Title of popup window.
   * @param title title or {@code null} for none
   */
  public PopupWindowProperties setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public PopupWindowProperties set(String fieldName, Object value) {
    return (PopupWindowProperties) super.set(fieldName, value);
  }

  @Override
  public PopupWindowProperties clone() {
    return (PopupWindowProperties) super.clone();
  }

}
