/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Region List Response
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionsListResponse extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#regionsListResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Region collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Region> regions;

  static {
    // hack to force ProGuard to consider Region used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Region.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#regionsListResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#regionsListResponse".
   * @param kind kind or {@code null} for none
   */
  public RegionsListResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Region collection.
   * @return value or {@code null} for none
   */
  public java.util.List<Region> getRegions() {
    return regions;
  }

  /**
   * Region collection.
   * @param regions regions or {@code null} for none
   */
  public RegionsListResponse setRegions(java.util.List<Region> regions) {
    this.regions = regions;
    return this;
  }

  @Override
  public RegionsListResponse set(String fieldName, Object value) {
    return (RegionsListResponse) super.set(fieldName, value);
  }

  @Override
  public RegionsListResponse clone() {
    return (RegionsListResponse) super.clone();
  }

}
