/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * User identifying information. Exactly one type of identifier must be specified.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserIdentifier extends com.google.api.client.json.GenericJson {

  /**
   * Address information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OfflineUserAddressInfo addressInfo;

  /**
   * Hashed email address using SHA-256 hash function after normalization.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hashedEmail;

  /**
   * Hashed phone number using SHA-256 hash function after normalization (E164 standard).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hashedPhoneNumber;

  /**
   * Address information.
   * @return value or {@code null} for none
   */
  public OfflineUserAddressInfo getAddressInfo() {
    return addressInfo;
  }

  /**
   * Address information.
   * @param addressInfo addressInfo or {@code null} for none
   */
  public UserIdentifier setAddressInfo(OfflineUserAddressInfo addressInfo) {
    this.addressInfo = addressInfo;
    return this;
  }

  /**
   * Hashed email address using SHA-256 hash function after normalization.
   * @return value or {@code null} for none
   */
  public java.lang.String getHashedEmail() {
    return hashedEmail;
  }

  /**
   * Hashed email address using SHA-256 hash function after normalization.
   * @param hashedEmail hashedEmail or {@code null} for none
   */
  public UserIdentifier setHashedEmail(java.lang.String hashedEmail) {
    this.hashedEmail = hashedEmail;
    return this;
  }

  /**
   * Hashed phone number using SHA-256 hash function after normalization (E164 standard).
   * @return value or {@code null} for none
   */
  public java.lang.String getHashedPhoneNumber() {
    return hashedPhoneNumber;
  }

  /**
   * Hashed phone number using SHA-256 hash function after normalization (E164 standard).
   * @param hashedPhoneNumber hashedPhoneNumber or {@code null} for none
   */
  public UserIdentifier setHashedPhoneNumber(java.lang.String hashedPhoneNumber) {
    this.hashedPhoneNumber = hashedPhoneNumber;
    return this;
  }

  @Override
  public UserIdentifier set(String fieldName, Object value) {
    return (UserIdentifier) super.set(fieldName, value);
  }

  @Override
  public UserIdentifier clone() {
    return (UserIdentifier) super.clone();
  }

}
