/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Represents the list of user profiles.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserProfileList extends com.google.api.client.json.GenericJson {

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The user profiles returned in this response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UserProfile> items;

  static {
    // hack to force ProGuard to consider UserProfile used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(UserProfile.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#userProfileList".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public UserProfileList setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The user profiles returned in this response.
   * @return value or {@code null} for none
   */
  public java.util.List<UserProfile> getItems() {
    return items;
  }

  /**
   * The user profiles returned in this response.
   * @param items items or {@code null} for none
   */
  public UserProfileList setItems(java.util.List<UserProfile> items) {
    this.items = items;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#userProfileList".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#userProfileList".
   * @param kind kind or {@code null} for none
   */
  public UserProfileList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public UserProfileList set(String fieldName, Object value) {
    return (UserProfileList) super.set(fieldName, value);
  }

  @Override
  public UserProfileList clone() {
    return (UserProfileList) super.clone();
  }

}
