/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * User Role Permission Group List Response
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserRolePermissionGroupsListResponse extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#userRolePermissionGroupsListResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * User role permission group collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UserRolePermissionGroup> userRolePermissionGroups;

  static {
    // hack to force ProGuard to consider UserRolePermissionGroup used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(UserRolePermissionGroup.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#userRolePermissionGroupsListResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#userRolePermissionGroupsListResponse".
   * @param kind kind or {@code null} for none
   */
  public UserRolePermissionGroupsListResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * User role permission group collection.
   * @return value or {@code null} for none
   */
  public java.util.List<UserRolePermissionGroup> getUserRolePermissionGroups() {
    return userRolePermissionGroups;
  }

  /**
   * User role permission group collection.
   * @param userRolePermissionGroups userRolePermissionGroups or {@code null} for none
   */
  public UserRolePermissionGroupsListResponse setUserRolePermissionGroups(java.util.List<UserRolePermissionGroup> userRolePermissionGroups) {
    this.userRolePermissionGroups = userRolePermissionGroups;
    return this;
  }

  @Override
  public UserRolePermissionGroupsListResponse set(String fieldName, Object value) {
    return (UserRolePermissionGroupsListResponse) super.set(fieldName, value);
  }

  @Override
  public UserRolePermissionGroupsListResponse clone() {
    return (UserRolePermissionGroupsListResponse) super.clone();
  }

}
