/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Defines the filtering on a single uvar.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UvarFilter extends com.google.api.client.json.GenericJson {

  /**
   * Return rows which don't match this filter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean complement;

  /**
   * Custom variable index the filter is applied to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long index;

  /**
   * The kind of resource this is, in this case dfareporting#uvarFilter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Indicates how the filter should be matched to the values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String match;

  /**
   * Values to filter on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> values;

  /**
   * Return rows which don't match this filter.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getComplement() {
    return complement;
  }

  /**
   * Return rows which don't match this filter.
   * @param complement complement or {@code null} for none
   */
  public UvarFilter setComplement(java.lang.Boolean complement) {
    this.complement = complement;
    return this;
  }

  /**
   * Custom variable index the filter is applied to.
   * @return value or {@code null} for none
   */
  public java.lang.Long getIndex() {
    return index;
  }

  /**
   * Custom variable index the filter is applied to.
   * @param index index or {@code null} for none
   */
  public UvarFilter setIndex(java.lang.Long index) {
    this.index = index;
    return this;
  }

  /**
   * The kind of resource this is, in this case dfareporting#uvarFilter.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of resource this is, in this case dfareporting#uvarFilter.
   * @param kind kind or {@code null} for none
   */
  public UvarFilter setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Indicates how the filter should be matched to the values.
   * @return value or {@code null} for none
   */
  public java.lang.String getMatch() {
    return match;
  }

  /**
   * Indicates how the filter should be matched to the values.
   * @param match match or {@code null} for none
   */
  public UvarFilter setMatch(java.lang.String match) {
    this.match = match;
    return this;
  }

  /**
   * Values to filter on.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getValues() {
    return values;
  }

  /**
   * Values to filter on.
   * @param values values or {@code null} for none
   */
  public UvarFilter setValues(java.util.List<java.lang.String> values) {
    this.values = values;
    return this;
  }

  @Override
  public UvarFilter set(String fieldName, Object value) {
    return (UvarFilter) super.set(fieldName, value);
  }

  @Override
  public UvarFilter clone() {
    return (UvarFilter) super.clone();
  }

}
