/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.dialogflow.v2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.dialogflow.v2.DialogflowRequest;
import com.google.api.services.dialogflow.v2.DialogflowRequestInitializer;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2Agent;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2BatchCreateEntitiesRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2BatchDeleteEntitiesRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2BatchDeleteEntityTypesRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2BatchDeleteIntentsRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2BatchUpdateEntitiesRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2BatchUpdateEntityTypesRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2BatchUpdateIntentsRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2Context;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2DetectIntentRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2DetectIntentResponse;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2EntityType;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2ExportAgentRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2Fulfillment;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2ImportAgentRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2Intent;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2ListContextsResponse;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2ListEntityTypesResponse;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2ListEnvironmentsResponse;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2ListIntentsResponse;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2ListSessionEntityTypesResponse;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2RestoreAgentRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2SearchAgentsResponse;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2SessionEntityType;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2TrainAgentRequest;
import com.google.api.services.dialogflow.v2.model.GoogleCloudDialogflowV2ValidationResult;
import com.google.api.services.dialogflow.v2.model.GoogleLongrunningListOperationsResponse;
import com.google.api.services.dialogflow.v2.model.GoogleLongrunningOperation;
import com.google.api.services.dialogflow.v2.model.GoogleProtobufEmpty;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dialogflow
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://dialogflow.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://dialogflow.googleapis.com/";

    public Dialogflow(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Dialogflow(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Dialogflow API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://dialogflow.googleapis.com/", Dialogflow.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Dialogflow.DEFAULT_BATCH_PATH);
        }

        public Dialogflow build() {
            return new Dialogflow(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDialogflowRequestInitializer(DialogflowRequestInitializer dialogflowRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)dialogflowRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public DeleteAgent deleteAgent(String string) throws IOException {
            DeleteAgent deleteAgent = new DeleteAgent(string);
            Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)deleteAgent);
            return deleteAgent;
        }

        public GetAgent getAgent(String string) throws IOException {
            GetAgent getAgent = new GetAgent(string);
            Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)getAgent);
            return getAgent;
        }

        public SetAgent setAgent(String string, GoogleCloudDialogflowV2Agent googleCloudDialogflowV2Agent) throws IOException {
            SetAgent setAgent = new SetAgent(string, googleCloudDialogflowV2Agent);
            Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)setAgent);
            return setAgent;
        }

        public Agent agent() {
            return new Agent();
        }

        public Locations locations() {
            return new Locations();
        }

        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Cancel cancel(String string) throws IOException {
                Cancel cancel = new Cancel(string);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)cancel);
                return cancel;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends DialogflowRequest<GoogleLongrunningListOperationsResponse> {
                private static final String REST_PATH = "v2/{+name}/operations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;
                @Key
                private String filter;

                protected List(String string) {
                    super(Dialogflow.this, "GET", REST_PATH, null, GoogleLongrunningListOperationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String string) {
                    this.filter = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends DialogflowRequest<GoogleLongrunningOperation> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(Dialogflow.this, "GET", REST_PATH, null, GoogleLongrunningOperation.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/operations/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Cancel
            extends DialogflowRequest<GoogleProtobufEmpty> {
                private static final String REST_PATH = "v2/{+name}:cancel";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Cancel(String string) {
                    super(Dialogflow.this, "POST", REST_PATH, null, GoogleProtobufEmpty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/operations/[^/]+$");
                    }
                }

                public Cancel set$Xgafv(String string) {
                    return (Cancel)super.set$Xgafv(string);
                }

                public Cancel setAccessToken(String string) {
                    return (Cancel)super.setAccessToken(string);
                }

                public Cancel setAlt(String string) {
                    return (Cancel)super.setAlt(string);
                }

                public Cancel setCallback(String string) {
                    return (Cancel)super.setCallback(string);
                }

                public Cancel setFields(String string) {
                    return (Cancel)super.setFields(string);
                }

                public Cancel setKey(String string) {
                    return (Cancel)super.setKey(string);
                }

                public Cancel setOauthToken(String string) {
                    return (Cancel)super.setOauthToken(string);
                }

                public Cancel setPrettyPrint(Boolean bl) {
                    return (Cancel)super.setPrettyPrint(bl);
                }

                public Cancel setQuotaUser(String string) {
                    return (Cancel)super.setQuotaUser(string);
                }

                public Cancel setUploadType(String string) {
                    return (Cancel)super.setUploadType(string);
                }

                public Cancel setUploadProtocol(String string) {
                    return (Cancel)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Cancel setName(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/operations/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Cancel set(String string, Object object) {
                    return (Cancel)super.set(string, object);
                }
            }
        }

        public class Locations {
            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String string) throws IOException {
                    Cancel cancel = new Cancel(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)cancel);
                    return cancel;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DialogflowRequest<GoogleLongrunningListOperationsResponse> {
                    private static final String REST_PATH = "v2/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(Dialogflow.this, "GET", REST_PATH, null, GoogleLongrunningListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String string) {
                        this.filter = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DialogflowRequest<GoogleLongrunningOperation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String string) {
                        super(Dialogflow.this, "GET", REST_PATH, null, GoogleLongrunningOperation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Cancel
                extends DialogflowRequest<GoogleProtobufEmpty> {
                    private static final String REST_PATH = "v2/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String string) {
                        super(Dialogflow.this, "POST", REST_PATH, null, GoogleProtobufEmpty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String string) {
                        return (Cancel)super.set$Xgafv(string);
                    }

                    public Cancel setAccessToken(String string) {
                        return (Cancel)super.setAccessToken(string);
                    }

                    public Cancel setAlt(String string) {
                        return (Cancel)super.setAlt(string);
                    }

                    public Cancel setCallback(String string) {
                        return (Cancel)super.setCallback(string);
                    }

                    public Cancel setFields(String string) {
                        return (Cancel)super.setFields(string);
                    }

                    public Cancel setKey(String string) {
                        return (Cancel)super.setKey(string);
                    }

                    public Cancel setOauthToken(String string) {
                        return (Cancel)super.setOauthToken(string);
                    }

                    public Cancel setPrettyPrint(Boolean bl) {
                        return (Cancel)super.setPrettyPrint(bl);
                    }

                    public Cancel setQuotaUser(String string) {
                        return (Cancel)super.setQuotaUser(string);
                    }

                    public Cancel setUploadType(String string) {
                        return (Cancel)super.setUploadType(string);
                    }

                    public Cancel setUploadProtocol(String string) {
                        return (Cancel)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Cancel set(String string, Object object) {
                        return (Cancel)super.set(string, object);
                    }
                }
            }
        }

        public class Agent {
            public Export export(String string, GoogleCloudDialogflowV2ExportAgentRequest googleCloudDialogflowV2ExportAgentRequest) throws IOException {
                Export export = new Export(string, googleCloudDialogflowV2ExportAgentRequest);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)export);
                return export;
            }

            public GetFulfillment getFulfillment(String string) throws IOException {
                GetFulfillment getFulfillment = new GetFulfillment(string);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)getFulfillment);
                return getFulfillment;
            }

            public GetValidationResult getValidationResult(String string) throws IOException {
                GetValidationResult getValidationResult = new GetValidationResult(string);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)getValidationResult);
                return getValidationResult;
            }

            public DialogflowImport dialogflowImport(String string, GoogleCloudDialogflowV2ImportAgentRequest googleCloudDialogflowV2ImportAgentRequest) throws IOException {
                DialogflowImport dialogflowImport = new DialogflowImport(string, googleCloudDialogflowV2ImportAgentRequest);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)dialogflowImport);
                return dialogflowImport;
            }

            public Restore restore(String string, GoogleCloudDialogflowV2RestoreAgentRequest googleCloudDialogflowV2RestoreAgentRequest) throws IOException {
                Restore restore = new Restore(string, googleCloudDialogflowV2RestoreAgentRequest);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)restore);
                return restore;
            }

            public Search search(String string) throws IOException {
                Search search = new Search(string);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)search);
                return search;
            }

            public Train train(String string, GoogleCloudDialogflowV2TrainAgentRequest googleCloudDialogflowV2TrainAgentRequest) throws IOException {
                Train train = new Train(string, googleCloudDialogflowV2TrainAgentRequest);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)train);
                return train;
            }

            public UpdateFulfillment updateFulfillment(String string, GoogleCloudDialogflowV2Fulfillment googleCloudDialogflowV2Fulfillment) throws IOException {
                UpdateFulfillment updateFulfillment = new UpdateFulfillment(string, googleCloudDialogflowV2Fulfillment);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)updateFulfillment);
                return updateFulfillment;
            }

            public EntityTypes entityTypes() {
                return new EntityTypes();
            }

            public Environments environments() {
                return new Environments();
            }

            public Intents intents() {
                return new Intents();
            }

            public Sessions sessions() {
                return new Sessions();
            }

            public class Sessions {
                public DeleteContexts deleteContexts(String string) throws IOException {
                    DeleteContexts deleteContexts = new DeleteContexts(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)deleteContexts);
                    return deleteContexts;
                }

                public DetectIntent detectIntent(String string, GoogleCloudDialogflowV2DetectIntentRequest googleCloudDialogflowV2DetectIntentRequest) throws IOException {
                    DetectIntent detectIntent = new DetectIntent(string, googleCloudDialogflowV2DetectIntentRequest);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)detectIntent);
                    return detectIntent;
                }

                public Contexts contexts() {
                    return new Contexts();
                }

                public EntityTypes entityTypes() {
                    return new EntityTypes();
                }

                public class EntityTypes {
                    public Create create(String string, GoogleCloudDialogflowV2SessionEntityType googleCloudDialogflowV2SessionEntityType) throws IOException {
                        Create create = new Create(string, googleCloudDialogflowV2SessionEntityType);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)create);
                        return create;
                    }

                    public Delete delete(String string) throws IOException {
                        Delete delete = new Delete(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)delete);
                        return delete;
                    }

                    public Get get(String string) throws IOException {
                        Get get = new Get(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                        return get;
                    }

                    public List list(String string) throws IOException {
                        List list = new List(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                        return list;
                    }

                    public Patch patch(String string, GoogleCloudDialogflowV2SessionEntityType googleCloudDialogflowV2SessionEntityType) throws IOException {
                        Patch patch = new Patch(string, googleCloudDialogflowV2SessionEntityType);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)patch);
                        return patch;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Patch
                    extends DialogflowRequest<GoogleCloudDialogflowV2SessionEntityType> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String string, GoogleCloudDialogflowV2SessionEntityType googleCloudDialogflowV2SessionEntityType) {
                            super(Dialogflow.this, "PATCH", REST_PATH, (Object)googleCloudDialogflowV2SessionEntityType, GoogleCloudDialogflowV2SessionEntityType.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String string) {
                            return (Patch)super.set$Xgafv(string);
                        }

                        public Patch setAccessToken(String string) {
                            return (Patch)super.setAccessToken(string);
                        }

                        public Patch setAlt(String string) {
                            return (Patch)super.setAlt(string);
                        }

                        public Patch setCallback(String string) {
                            return (Patch)super.setCallback(string);
                        }

                        public Patch setFields(String string) {
                            return (Patch)super.setFields(string);
                        }

                        public Patch setKey(String string) {
                            return (Patch)super.setKey(string);
                        }

                        public Patch setOauthToken(String string) {
                            return (Patch)super.setOauthToken(string);
                        }

                        public Patch setPrettyPrint(Boolean bl) {
                            return (Patch)super.setPrettyPrint(bl);
                        }

                        public Patch setQuotaUser(String string) {
                            return (Patch)super.setQuotaUser(string);
                        }

                        public Patch setUploadType(String string) {
                            return (Patch)super.setUploadType(string);
                        }

                        public Patch setUploadProtocol(String string) {
                            return (Patch)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String string) {
                            this.updateMask = string;
                            return this;
                        }

                        @Override
                        public Patch set(String string, Object object) {
                            return (Patch)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class List
                    extends DialogflowRequest<GoogleCloudDialogflowV2ListSessionEntityTypesResponse> {
                        private static final String REST_PATH = "v2/{+parent}/entityTypes";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String pageToken;
                        @Key
                        private Integer pageSize;

                        protected List(String string) {
                            super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2ListSessionEntityTypesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String string) {
                            return (List)super.set$Xgafv(string);
                        }

                        public List setAccessToken(String string) {
                            return (List)super.setAccessToken(string);
                        }

                        public List setAlt(String string) {
                            return (List)super.setAlt(string);
                        }

                        public List setCallback(String string) {
                            return (List)super.setCallback(string);
                        }

                        public List setFields(String string) {
                            return (List)super.setFields(string);
                        }

                        public List setKey(String string) {
                            return (List)super.setKey(string);
                        }

                        public List setOauthToken(String string) {
                            return (List)super.setOauthToken(string);
                        }

                        public List setPrettyPrint(Boolean bl) {
                            return (List)super.setPrettyPrint(bl);
                        }

                        public List setQuotaUser(String string) {
                            return (List)super.setQuotaUser(string);
                        }

                        public List setUploadType(String string) {
                            return (List)super.setUploadType(string);
                        }

                        public List setUploadProtocol(String string) {
                            return (List)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String string) {
                            this.pageToken = string;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer n) {
                            this.pageSize = n;
                            return this;
                        }

                        @Override
                        public List set(String string, Object object) {
                            return (List)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Get
                    extends DialogflowRequest<GoogleCloudDialogflowV2SessionEntityType> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String string) {
                            super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2SessionEntityType.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String string) {
                            return (Get)super.set$Xgafv(string);
                        }

                        public Get setAccessToken(String string) {
                            return (Get)super.setAccessToken(string);
                        }

                        public Get setAlt(String string) {
                            return (Get)super.setAlt(string);
                        }

                        public Get setCallback(String string) {
                            return (Get)super.setCallback(string);
                        }

                        public Get setFields(String string) {
                            return (Get)super.setFields(string);
                        }

                        public Get setKey(String string) {
                            return (Get)super.setKey(string);
                        }

                        public Get setOauthToken(String string) {
                            return (Get)super.setOauthToken(string);
                        }

                        public Get setPrettyPrint(Boolean bl) {
                            return (Get)super.setPrettyPrint(bl);
                        }

                        public Get setQuotaUser(String string) {
                            return (Get)super.setQuotaUser(string);
                        }

                        public Get setUploadType(String string) {
                            return (Get)super.setUploadType(string);
                        }

                        public Get setUploadProtocol(String string) {
                            return (Get)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Get set(String string, Object object) {
                            return (Get)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Delete
                    extends DialogflowRequest<GoogleProtobufEmpty> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String string) {
                            super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String string) {
                            return (Delete)super.set$Xgafv(string);
                        }

                        public Delete setAccessToken(String string) {
                            return (Delete)super.setAccessToken(string);
                        }

                        public Delete setAlt(String string) {
                            return (Delete)super.setAlt(string);
                        }

                        public Delete setCallback(String string) {
                            return (Delete)super.setCallback(string);
                        }

                        public Delete setFields(String string) {
                            return (Delete)super.setFields(string);
                        }

                        public Delete setKey(String string) {
                            return (Delete)super.setKey(string);
                        }

                        public Delete setOauthToken(String string) {
                            return (Delete)super.setOauthToken(string);
                        }

                        public Delete setPrettyPrint(Boolean bl) {
                            return (Delete)super.setPrettyPrint(bl);
                        }

                        public Delete setQuotaUser(String string) {
                            return (Delete)super.setQuotaUser(string);
                        }

                        public Delete setUploadType(String string) {
                            return (Delete)super.setUploadType(string);
                        }

                        public Delete setUploadProtocol(String string) {
                            return (Delete)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Delete set(String string, Object object) {
                            return (Delete)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Create
                    extends DialogflowRequest<GoogleCloudDialogflowV2SessionEntityType> {
                        private static final String REST_PATH = "v2/{+parent}/entityTypes";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Create(String string, GoogleCloudDialogflowV2SessionEntityType googleCloudDialogflowV2SessionEntityType) {
                            super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2SessionEntityType, GoogleCloudDialogflowV2SessionEntityType.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String string) {
                            return (Create)super.set$Xgafv(string);
                        }

                        public Create setAccessToken(String string) {
                            return (Create)super.setAccessToken(string);
                        }

                        public Create setAlt(String string) {
                            return (Create)super.setAlt(string);
                        }

                        public Create setCallback(String string) {
                            return (Create)super.setCallback(string);
                        }

                        public Create setFields(String string) {
                            return (Create)super.setFields(string);
                        }

                        public Create setKey(String string) {
                            return (Create)super.setKey(string);
                        }

                        public Create setOauthToken(String string) {
                            return (Create)super.setOauthToken(string);
                        }

                        public Create setPrettyPrint(Boolean bl) {
                            return (Create)super.setPrettyPrint(bl);
                        }

                        public Create setQuotaUser(String string) {
                            return (Create)super.setQuotaUser(string);
                        }

                        public Create setUploadType(String string) {
                            return (Create)super.setUploadType(string);
                        }

                        public Create setUploadProtocol(String string) {
                            return (Create)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public Create set(String string, Object object) {
                            return (Create)super.set(string, object);
                        }
                    }
                }

                public class Contexts {
                    public Create create(String string, GoogleCloudDialogflowV2Context googleCloudDialogflowV2Context) throws IOException {
                        Create create = new Create(string, googleCloudDialogflowV2Context);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)create);
                        return create;
                    }

                    public Delete delete(String string) throws IOException {
                        Delete delete = new Delete(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)delete);
                        return delete;
                    }

                    public Get get(String string) throws IOException {
                        Get get = new Get(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                        return get;
                    }

                    public List list(String string) throws IOException {
                        List list = new List(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                        return list;
                    }

                    public Patch patch(String string, GoogleCloudDialogflowV2Context googleCloudDialogflowV2Context) throws IOException {
                        Patch patch = new Patch(string, googleCloudDialogflowV2Context);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)patch);
                        return patch;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Patch
                    extends DialogflowRequest<GoogleCloudDialogflowV2Context> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String string, GoogleCloudDialogflowV2Context googleCloudDialogflowV2Context) {
                            super(Dialogflow.this, "PATCH", REST_PATH, (Object)googleCloudDialogflowV2Context, GoogleCloudDialogflowV2Context.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String string) {
                            return (Patch)super.set$Xgafv(string);
                        }

                        public Patch setAccessToken(String string) {
                            return (Patch)super.setAccessToken(string);
                        }

                        public Patch setAlt(String string) {
                            return (Patch)super.setAlt(string);
                        }

                        public Patch setCallback(String string) {
                            return (Patch)super.setCallback(string);
                        }

                        public Patch setFields(String string) {
                            return (Patch)super.setFields(string);
                        }

                        public Patch setKey(String string) {
                            return (Patch)super.setKey(string);
                        }

                        public Patch setOauthToken(String string) {
                            return (Patch)super.setOauthToken(string);
                        }

                        public Patch setPrettyPrint(Boolean bl) {
                            return (Patch)super.setPrettyPrint(bl);
                        }

                        public Patch setQuotaUser(String string) {
                            return (Patch)super.setQuotaUser(string);
                        }

                        public Patch setUploadType(String string) {
                            return (Patch)super.setUploadType(string);
                        }

                        public Patch setUploadProtocol(String string) {
                            return (Patch)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String string) {
                            this.updateMask = string;
                            return this;
                        }

                        @Override
                        public Patch set(String string, Object object) {
                            return (Patch)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class List
                    extends DialogflowRequest<GoogleCloudDialogflowV2ListContextsResponse> {
                        private static final String REST_PATH = "v2/{+parent}/contexts";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String pageToken;
                        @Key
                        private Integer pageSize;

                        protected List(String string) {
                            super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2ListContextsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String string) {
                            return (List)super.set$Xgafv(string);
                        }

                        public List setAccessToken(String string) {
                            return (List)super.setAccessToken(string);
                        }

                        public List setAlt(String string) {
                            return (List)super.setAlt(string);
                        }

                        public List setCallback(String string) {
                            return (List)super.setCallback(string);
                        }

                        public List setFields(String string) {
                            return (List)super.setFields(string);
                        }

                        public List setKey(String string) {
                            return (List)super.setKey(string);
                        }

                        public List setOauthToken(String string) {
                            return (List)super.setOauthToken(string);
                        }

                        public List setPrettyPrint(Boolean bl) {
                            return (List)super.setPrettyPrint(bl);
                        }

                        public List setQuotaUser(String string) {
                            return (List)super.setQuotaUser(string);
                        }

                        public List setUploadType(String string) {
                            return (List)super.setUploadType(string);
                        }

                        public List setUploadProtocol(String string) {
                            return (List)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String string) {
                            this.pageToken = string;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer n) {
                            this.pageSize = n;
                            return this;
                        }

                        @Override
                        public List set(String string, Object object) {
                            return (List)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Get
                    extends DialogflowRequest<GoogleCloudDialogflowV2Context> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String string) {
                            super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2Context.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String string) {
                            return (Get)super.set$Xgafv(string);
                        }

                        public Get setAccessToken(String string) {
                            return (Get)super.setAccessToken(string);
                        }

                        public Get setAlt(String string) {
                            return (Get)super.setAlt(string);
                        }

                        public Get setCallback(String string) {
                            return (Get)super.setCallback(string);
                        }

                        public Get setFields(String string) {
                            return (Get)super.setFields(string);
                        }

                        public Get setKey(String string) {
                            return (Get)super.setKey(string);
                        }

                        public Get setOauthToken(String string) {
                            return (Get)super.setOauthToken(string);
                        }

                        public Get setPrettyPrint(Boolean bl) {
                            return (Get)super.setPrettyPrint(bl);
                        }

                        public Get setQuotaUser(String string) {
                            return (Get)super.setQuotaUser(string);
                        }

                        public Get setUploadType(String string) {
                            return (Get)super.setUploadType(string);
                        }

                        public Get setUploadProtocol(String string) {
                            return (Get)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Get set(String string, Object object) {
                            return (Get)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Delete
                    extends DialogflowRequest<GoogleProtobufEmpty> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String string) {
                            super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String string) {
                            return (Delete)super.set$Xgafv(string);
                        }

                        public Delete setAccessToken(String string) {
                            return (Delete)super.setAccessToken(string);
                        }

                        public Delete setAlt(String string) {
                            return (Delete)super.setAlt(string);
                        }

                        public Delete setCallback(String string) {
                            return (Delete)super.setCallback(string);
                        }

                        public Delete setFields(String string) {
                            return (Delete)super.setFields(string);
                        }

                        public Delete setKey(String string) {
                            return (Delete)super.setKey(string);
                        }

                        public Delete setOauthToken(String string) {
                            return (Delete)super.setOauthToken(string);
                        }

                        public Delete setPrettyPrint(Boolean bl) {
                            return (Delete)super.setPrettyPrint(bl);
                        }

                        public Delete setQuotaUser(String string) {
                            return (Delete)super.setQuotaUser(string);
                        }

                        public Delete setUploadType(String string) {
                            return (Delete)super.setUploadType(string);
                        }

                        public Delete setUploadProtocol(String string) {
                            return (Delete)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Delete set(String string, Object object) {
                            return (Delete)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Create
                    extends DialogflowRequest<GoogleCloudDialogflowV2Context> {
                        private static final String REST_PATH = "v2/{+parent}/contexts";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Create(String string, GoogleCloudDialogflowV2Context googleCloudDialogflowV2Context) {
                            super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2Context, GoogleCloudDialogflowV2Context.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String string) {
                            return (Create)super.set$Xgafv(string);
                        }

                        public Create setAccessToken(String string) {
                            return (Create)super.setAccessToken(string);
                        }

                        public Create setAlt(String string) {
                            return (Create)super.setAlt(string);
                        }

                        public Create setCallback(String string) {
                            return (Create)super.setCallback(string);
                        }

                        public Create setFields(String string) {
                            return (Create)super.setFields(string);
                        }

                        public Create setKey(String string) {
                            return (Create)super.setKey(string);
                        }

                        public Create setOauthToken(String string) {
                            return (Create)super.setOauthToken(string);
                        }

                        public Create setPrettyPrint(Boolean bl) {
                            return (Create)super.setPrettyPrint(bl);
                        }

                        public Create setQuotaUser(String string) {
                            return (Create)super.setQuotaUser(string);
                        }

                        public Create setUploadType(String string) {
                            return (Create)super.setUploadType(string);
                        }

                        public Create setUploadProtocol(String string) {
                            return (Create)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public Create set(String string, Object object) {
                            return (Create)super.set(string, object);
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class DetectIntent
                extends DialogflowRequest<GoogleCloudDialogflowV2DetectIntentResponse> {
                    private static final String REST_PATH = "v2/{+session}:detectIntent";
                    private final Pattern SESSION_PATTERN;
                    @Key
                    private String session;

                    protected DetectIntent(String string, GoogleCloudDialogflowV2DetectIntentRequest googleCloudDialogflowV2DetectIntentRequest) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2DetectIntentRequest, GoogleCloudDialogflowV2DetectIntentResponse.class);
                        this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                        this.session = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter session must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(string).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                        }
                    }

                    public DetectIntent set$Xgafv(String string) {
                        return (DetectIntent)super.set$Xgafv(string);
                    }

                    public DetectIntent setAccessToken(String string) {
                        return (DetectIntent)super.setAccessToken(string);
                    }

                    public DetectIntent setAlt(String string) {
                        return (DetectIntent)super.setAlt(string);
                    }

                    public DetectIntent setCallback(String string) {
                        return (DetectIntent)super.setCallback(string);
                    }

                    public DetectIntent setFields(String string) {
                        return (DetectIntent)super.setFields(string);
                    }

                    public DetectIntent setKey(String string) {
                        return (DetectIntent)super.setKey(string);
                    }

                    public DetectIntent setOauthToken(String string) {
                        return (DetectIntent)super.setOauthToken(string);
                    }

                    public DetectIntent setPrettyPrint(Boolean bl) {
                        return (DetectIntent)super.setPrettyPrint(bl);
                    }

                    public DetectIntent setQuotaUser(String string) {
                        return (DetectIntent)super.setQuotaUser(string);
                    }

                    public DetectIntent setUploadType(String string) {
                        return (DetectIntent)super.setUploadType(string);
                    }

                    public DetectIntent setUploadProtocol(String string) {
                        return (DetectIntent)super.setUploadProtocol(string);
                    }

                    public String getSession() {
                        return this.session;
                    }

                    public DetectIntent setSession(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(string).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                        }
                        this.session = string;
                        return this;
                    }

                    @Override
                    public DetectIntent set(String string, Object object) {
                        return (DetectIntent)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class DeleteContexts
                extends DialogflowRequest<GoogleProtobufEmpty> {
                    private static final String REST_PATH = "v2/{+parent}/contexts";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected DeleteContexts(String string) {
                        super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                        }
                    }

                    public DeleteContexts set$Xgafv(String string) {
                        return (DeleteContexts)super.set$Xgafv(string);
                    }

                    public DeleteContexts setAccessToken(String string) {
                        return (DeleteContexts)super.setAccessToken(string);
                    }

                    public DeleteContexts setAlt(String string) {
                        return (DeleteContexts)super.setAlt(string);
                    }

                    public DeleteContexts setCallback(String string) {
                        return (DeleteContexts)super.setCallback(string);
                    }

                    public DeleteContexts setFields(String string) {
                        return (DeleteContexts)super.setFields(string);
                    }

                    public DeleteContexts setKey(String string) {
                        return (DeleteContexts)super.setKey(string);
                    }

                    public DeleteContexts setOauthToken(String string) {
                        return (DeleteContexts)super.setOauthToken(string);
                    }

                    public DeleteContexts setPrettyPrint(Boolean bl) {
                        return (DeleteContexts)super.setPrettyPrint(bl);
                    }

                    public DeleteContexts setQuotaUser(String string) {
                        return (DeleteContexts)super.setQuotaUser(string);
                    }

                    public DeleteContexts setUploadType(String string) {
                        return (DeleteContexts)super.setUploadType(string);
                    }

                    public DeleteContexts setUploadProtocol(String string) {
                        return (DeleteContexts)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public DeleteContexts setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public DeleteContexts set(String string, Object object) {
                        return (DeleteContexts)super.set(string, object);
                    }
                }
            }

            public class Intents {
                public BatchDelete batchDelete(String string, GoogleCloudDialogflowV2BatchDeleteIntentsRequest googleCloudDialogflowV2BatchDeleteIntentsRequest) throws IOException {
                    BatchDelete batchDelete = new BatchDelete(string, googleCloudDialogflowV2BatchDeleteIntentsRequest);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                    return batchDelete;
                }

                public BatchUpdate batchUpdate(String string, GoogleCloudDialogflowV2BatchUpdateIntentsRequest googleCloudDialogflowV2BatchUpdateIntentsRequest) throws IOException {
                    BatchUpdate batchUpdate = new BatchUpdate(string, googleCloudDialogflowV2BatchUpdateIntentsRequest);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                    return batchUpdate;
                }

                public Create create(String string, GoogleCloudDialogflowV2Intent googleCloudDialogflowV2Intent) throws IOException {
                    Create create = new Create(string, googleCloudDialogflowV2Intent);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, GoogleCloudDialogflowV2Intent googleCloudDialogflowV2Intent) throws IOException {
                    Patch patch = new Patch(string, googleCloudDialogflowV2Intent);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends DialogflowRequest<GoogleCloudDialogflowV2Intent> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String languageCode;
                    @Key
                    private String updateMask;
                    @Key
                    private String intentView;

                    protected Patch(String string, GoogleCloudDialogflowV2Intent googleCloudDialogflowV2Intent) {
                        super(Dialogflow.this, "PATCH", REST_PATH, (Object)googleCloudDialogflowV2Intent, GoogleCloudDialogflowV2Intent.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/intents/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Patch setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    public String getIntentView() {
                        return this.intentView;
                    }

                    public Patch setIntentView(String string) {
                        this.intentView = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DialogflowRequest<GoogleCloudDialogflowV2ListIntentsResponse> {
                    private static final String REST_PATH = "v2/{+parent}/intents";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String intentView;
                    @Key
                    private String languageCode;

                    protected List(String string) {
                        super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2ListIntentsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public String getIntentView() {
                        return this.intentView;
                    }

                    public List setIntentView(String string) {
                        this.intentView = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public List setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DialogflowRequest<GoogleCloudDialogflowV2Intent> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String languageCode;
                    @Key
                    private String intentView;

                    protected Get(String string) {
                        super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2Intent.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/intents/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Get setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    public String getIntentView() {
                        return this.intentView;
                    }

                    public Get setIntentView(String string) {
                        this.intentView = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DialogflowRequest<GoogleProtobufEmpty> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/intents/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends DialogflowRequest<GoogleCloudDialogflowV2Intent> {
                    private static final String REST_PATH = "v2/{+parent}/intents";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String intentView;
                    @Key
                    private String languageCode;

                    protected Create(String string, GoogleCloudDialogflowV2Intent googleCloudDialogflowV2Intent) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2Intent, GoogleCloudDialogflowV2Intent.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getIntentView() {
                        return this.intentView;
                    }

                    public Create setIntentView(String string) {
                        this.intentView = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Create setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class BatchUpdate
                extends DialogflowRequest<GoogleLongrunningOperation> {
                    private static final String REST_PATH = "v2/{+parent}/intents:batchUpdate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected BatchUpdate(String string, GoogleCloudDialogflowV2BatchUpdateIntentsRequest googleCloudDialogflowV2BatchUpdateIntentsRequest) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2BatchUpdateIntentsRequest, GoogleLongrunningOperation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public BatchUpdate set$Xgafv(String string) {
                        return (BatchUpdate)super.set$Xgafv(string);
                    }

                    public BatchUpdate setAccessToken(String string) {
                        return (BatchUpdate)super.setAccessToken(string);
                    }

                    public BatchUpdate setAlt(String string) {
                        return (BatchUpdate)super.setAlt(string);
                    }

                    public BatchUpdate setCallback(String string) {
                        return (BatchUpdate)super.setCallback(string);
                    }

                    public BatchUpdate setFields(String string) {
                        return (BatchUpdate)super.setFields(string);
                    }

                    public BatchUpdate setKey(String string) {
                        return (BatchUpdate)super.setKey(string);
                    }

                    public BatchUpdate setOauthToken(String string) {
                        return (BatchUpdate)super.setOauthToken(string);
                    }

                    public BatchUpdate setPrettyPrint(Boolean bl) {
                        return (BatchUpdate)super.setPrettyPrint(bl);
                    }

                    public BatchUpdate setQuotaUser(String string) {
                        return (BatchUpdate)super.setQuotaUser(string);
                    }

                    public BatchUpdate setUploadType(String string) {
                        return (BatchUpdate)super.setUploadType(string);
                    }

                    public BatchUpdate setUploadProtocol(String string) {
                        return (BatchUpdate)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public BatchUpdate setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public BatchUpdate set(String string, Object object) {
                        return (BatchUpdate)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class BatchDelete
                extends DialogflowRequest<GoogleLongrunningOperation> {
                    private static final String REST_PATH = "v2/{+parent}/intents:batchDelete";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected BatchDelete(String string, GoogleCloudDialogflowV2BatchDeleteIntentsRequest googleCloudDialogflowV2BatchDeleteIntentsRequest) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2BatchDeleteIntentsRequest, GoogleLongrunningOperation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public BatchDelete set$Xgafv(String string) {
                        return (BatchDelete)super.set$Xgafv(string);
                    }

                    public BatchDelete setAccessToken(String string) {
                        return (BatchDelete)super.setAccessToken(string);
                    }

                    public BatchDelete setAlt(String string) {
                        return (BatchDelete)super.setAlt(string);
                    }

                    public BatchDelete setCallback(String string) {
                        return (BatchDelete)super.setCallback(string);
                    }

                    public BatchDelete setFields(String string) {
                        return (BatchDelete)super.setFields(string);
                    }

                    public BatchDelete setKey(String string) {
                        return (BatchDelete)super.setKey(string);
                    }

                    public BatchDelete setOauthToken(String string) {
                        return (BatchDelete)super.setOauthToken(string);
                    }

                    public BatchDelete setPrettyPrint(Boolean bl) {
                        return (BatchDelete)super.setPrettyPrint(bl);
                    }

                    public BatchDelete setQuotaUser(String string) {
                        return (BatchDelete)super.setQuotaUser(string);
                    }

                    public BatchDelete setUploadType(String string) {
                        return (BatchDelete)super.setUploadType(string);
                    }

                    public BatchDelete setUploadProtocol(String string) {
                        return (BatchDelete)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public BatchDelete setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public BatchDelete set(String string, Object object) {
                        return (BatchDelete)super.set(string, object);
                    }
                }
            }

            public class Environments {
                public List list(String string) throws IOException {
                    List list = new List(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Users users() {
                    return new Users();
                }

                public class Users {
                    public Sessions sessions() {
                        return new Sessions();
                    }

                    public class Sessions {
                        public DeleteContexts deleteContexts(String string) throws IOException {
                            DeleteContexts deleteContexts = new DeleteContexts(string);
                            Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)deleteContexts);
                            return deleteContexts;
                        }

                        public DetectIntent detectIntent(String string, GoogleCloudDialogflowV2DetectIntentRequest googleCloudDialogflowV2DetectIntentRequest) throws IOException {
                            DetectIntent detectIntent = new DetectIntent(string, googleCloudDialogflowV2DetectIntentRequest);
                            Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)detectIntent);
                            return detectIntent;
                        }

                        public Contexts contexts() {
                            return new Contexts();
                        }

                        public EntityTypes entityTypes() {
                            return new EntityTypes();
                        }

                        public class EntityTypes {
                            public Create create(String string, GoogleCloudDialogflowV2SessionEntityType googleCloudDialogflowV2SessionEntityType) throws IOException {
                                Create create = new Create(string, googleCloudDialogflowV2SessionEntityType);
                                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)create);
                                return create;
                            }

                            public Delete delete(String string) throws IOException {
                                Delete delete = new Delete(string);
                                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)delete);
                                return delete;
                            }

                            public Get get(String string) throws IOException {
                                Get get = new Get(string);
                                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                                return get;
                            }

                            public List list(String string) throws IOException {
                                List list = new List(string);
                                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                                return list;
                            }

                            public Patch patch(String string, GoogleCloudDialogflowV2SessionEntityType googleCloudDialogflowV2SessionEntityType) throws IOException {
                                Patch patch = new Patch(string, googleCloudDialogflowV2SessionEntityType);
                                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)patch);
                                return patch;
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            public class Patch
                            extends DialogflowRequest<GoogleCloudDialogflowV2SessionEntityType> {
                                private static final String REST_PATH = "v2/{+name}";
                                private final Pattern NAME_PATTERN;
                                @Key
                                private String name;
                                @Key
                                private String updateMask;

                                protected Patch(String string, GoogleCloudDialogflowV2SessionEntityType googleCloudDialogflowV2SessionEntityType) {
                                    super(Dialogflow.this, "PATCH", REST_PATH, (Object)googleCloudDialogflowV2SessionEntityType, GoogleCloudDialogflowV2SessionEntityType.class);
                                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/entityTypes/[^/]+$");
                                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/entityTypes/[^/]+$");
                                    }
                                }

                                public Patch set$Xgafv(String string) {
                                    return (Patch)super.set$Xgafv(string);
                                }

                                public Patch setAccessToken(String string) {
                                    return (Patch)super.setAccessToken(string);
                                }

                                public Patch setAlt(String string) {
                                    return (Patch)super.setAlt(string);
                                }

                                public Patch setCallback(String string) {
                                    return (Patch)super.setCallback(string);
                                }

                                public Patch setFields(String string) {
                                    return (Patch)super.setFields(string);
                                }

                                public Patch setKey(String string) {
                                    return (Patch)super.setKey(string);
                                }

                                public Patch setOauthToken(String string) {
                                    return (Patch)super.setOauthToken(string);
                                }

                                public Patch setPrettyPrint(Boolean bl) {
                                    return (Patch)super.setPrettyPrint(bl);
                                }

                                public Patch setQuotaUser(String string) {
                                    return (Patch)super.setQuotaUser(string);
                                }

                                public Patch setUploadType(String string) {
                                    return (Patch)super.setUploadType(string);
                                }

                                public Patch setUploadProtocol(String string) {
                                    return (Patch)super.setUploadProtocol(string);
                                }

                                public String getName() {
                                    return this.name;
                                }

                                public Patch setName(String string) {
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/entityTypes/[^/]+$");
                                    }
                                    this.name = string;
                                    return this;
                                }

                                public String getUpdateMask() {
                                    return this.updateMask;
                                }

                                public Patch setUpdateMask(String string) {
                                    this.updateMask = string;
                                    return this;
                                }

                                @Override
                                public Patch set(String string, Object object) {
                                    return (Patch)super.set(string, object);
                                }
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            public class List
                            extends DialogflowRequest<GoogleCloudDialogflowV2ListSessionEntityTypesResponse> {
                                private static final String REST_PATH = "v2/{+parent}/entityTypes";
                                private final Pattern PARENT_PATTERN;
                                @Key
                                private String parent;
                                @Key
                                private String pageToken;
                                @Key
                                private Integer pageSize;

                                protected List(String string) {
                                    super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2ListSessionEntityTypesResponse.class);
                                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    }
                                }

                                public HttpResponse executeUsingHead() throws IOException {
                                    return super.executeUsingHead();
                                }

                                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                    return super.buildHttpRequestUsingHead();
                                }

                                public List set$Xgafv(String string) {
                                    return (List)super.set$Xgafv(string);
                                }

                                public List setAccessToken(String string) {
                                    return (List)super.setAccessToken(string);
                                }

                                public List setAlt(String string) {
                                    return (List)super.setAlt(string);
                                }

                                public List setCallback(String string) {
                                    return (List)super.setCallback(string);
                                }

                                public List setFields(String string) {
                                    return (List)super.setFields(string);
                                }

                                public List setKey(String string) {
                                    return (List)super.setKey(string);
                                }

                                public List setOauthToken(String string) {
                                    return (List)super.setOauthToken(string);
                                }

                                public List setPrettyPrint(Boolean bl) {
                                    return (List)super.setPrettyPrint(bl);
                                }

                                public List setQuotaUser(String string) {
                                    return (List)super.setQuotaUser(string);
                                }

                                public List setUploadType(String string) {
                                    return (List)super.setUploadType(string);
                                }

                                public List setUploadProtocol(String string) {
                                    return (List)super.setUploadProtocol(string);
                                }

                                public String getParent() {
                                    return this.parent;
                                }

                                public List setParent(String string) {
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    }
                                    this.parent = string;
                                    return this;
                                }

                                public String getPageToken() {
                                    return this.pageToken;
                                }

                                public List setPageToken(String string) {
                                    this.pageToken = string;
                                    return this;
                                }

                                public Integer getPageSize() {
                                    return this.pageSize;
                                }

                                public List setPageSize(Integer n) {
                                    this.pageSize = n;
                                    return this;
                                }

                                @Override
                                public List set(String string, Object object) {
                                    return (List)super.set(string, object);
                                }
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            public class Get
                            extends DialogflowRequest<GoogleCloudDialogflowV2SessionEntityType> {
                                private static final String REST_PATH = "v2/{+name}";
                                private final Pattern NAME_PATTERN;
                                @Key
                                private String name;

                                protected Get(String string) {
                                    super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2SessionEntityType.class);
                                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/entityTypes/[^/]+$");
                                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/entityTypes/[^/]+$");
                                    }
                                }

                                public HttpResponse executeUsingHead() throws IOException {
                                    return super.executeUsingHead();
                                }

                                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                    return super.buildHttpRequestUsingHead();
                                }

                                public Get set$Xgafv(String string) {
                                    return (Get)super.set$Xgafv(string);
                                }

                                public Get setAccessToken(String string) {
                                    return (Get)super.setAccessToken(string);
                                }

                                public Get setAlt(String string) {
                                    return (Get)super.setAlt(string);
                                }

                                public Get setCallback(String string) {
                                    return (Get)super.setCallback(string);
                                }

                                public Get setFields(String string) {
                                    return (Get)super.setFields(string);
                                }

                                public Get setKey(String string) {
                                    return (Get)super.setKey(string);
                                }

                                public Get setOauthToken(String string) {
                                    return (Get)super.setOauthToken(string);
                                }

                                public Get setPrettyPrint(Boolean bl) {
                                    return (Get)super.setPrettyPrint(bl);
                                }

                                public Get setQuotaUser(String string) {
                                    return (Get)super.setQuotaUser(string);
                                }

                                public Get setUploadType(String string) {
                                    return (Get)super.setUploadType(string);
                                }

                                public Get setUploadProtocol(String string) {
                                    return (Get)super.setUploadProtocol(string);
                                }

                                public String getName() {
                                    return this.name;
                                }

                                public Get setName(String string) {
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/entityTypes/[^/]+$");
                                    }
                                    this.name = string;
                                    return this;
                                }

                                @Override
                                public Get set(String string, Object object) {
                                    return (Get)super.set(string, object);
                                }
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            public class Delete
                            extends DialogflowRequest<GoogleProtobufEmpty> {
                                private static final String REST_PATH = "v2/{+name}";
                                private final Pattern NAME_PATTERN;
                                @Key
                                private String name;

                                protected Delete(String string) {
                                    super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/entityTypes/[^/]+$");
                                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/entityTypes/[^/]+$");
                                    }
                                }

                                public Delete set$Xgafv(String string) {
                                    return (Delete)super.set$Xgafv(string);
                                }

                                public Delete setAccessToken(String string) {
                                    return (Delete)super.setAccessToken(string);
                                }

                                public Delete setAlt(String string) {
                                    return (Delete)super.setAlt(string);
                                }

                                public Delete setCallback(String string) {
                                    return (Delete)super.setCallback(string);
                                }

                                public Delete setFields(String string) {
                                    return (Delete)super.setFields(string);
                                }

                                public Delete setKey(String string) {
                                    return (Delete)super.setKey(string);
                                }

                                public Delete setOauthToken(String string) {
                                    return (Delete)super.setOauthToken(string);
                                }

                                public Delete setPrettyPrint(Boolean bl) {
                                    return (Delete)super.setPrettyPrint(bl);
                                }

                                public Delete setQuotaUser(String string) {
                                    return (Delete)super.setQuotaUser(string);
                                }

                                public Delete setUploadType(String string) {
                                    return (Delete)super.setUploadType(string);
                                }

                                public Delete setUploadProtocol(String string) {
                                    return (Delete)super.setUploadProtocol(string);
                                }

                                public String getName() {
                                    return this.name;
                                }

                                public Delete setName(String string) {
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/entityTypes/[^/]+$");
                                    }
                                    this.name = string;
                                    return this;
                                }

                                @Override
                                public Delete set(String string, Object object) {
                                    return (Delete)super.set(string, object);
                                }
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            public class Create
                            extends DialogflowRequest<GoogleCloudDialogflowV2SessionEntityType> {
                                private static final String REST_PATH = "v2/{+parent}/entityTypes";
                                private final Pattern PARENT_PATTERN;
                                @Key
                                private String parent;

                                protected Create(String string, GoogleCloudDialogflowV2SessionEntityType googleCloudDialogflowV2SessionEntityType) {
                                    super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2SessionEntityType, GoogleCloudDialogflowV2SessionEntityType.class);
                                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    }
                                }

                                public Create set$Xgafv(String string) {
                                    return (Create)super.set$Xgafv(string);
                                }

                                public Create setAccessToken(String string) {
                                    return (Create)super.setAccessToken(string);
                                }

                                public Create setAlt(String string) {
                                    return (Create)super.setAlt(string);
                                }

                                public Create setCallback(String string) {
                                    return (Create)super.setCallback(string);
                                }

                                public Create setFields(String string) {
                                    return (Create)super.setFields(string);
                                }

                                public Create setKey(String string) {
                                    return (Create)super.setKey(string);
                                }

                                public Create setOauthToken(String string) {
                                    return (Create)super.setOauthToken(string);
                                }

                                public Create setPrettyPrint(Boolean bl) {
                                    return (Create)super.setPrettyPrint(bl);
                                }

                                public Create setQuotaUser(String string) {
                                    return (Create)super.setQuotaUser(string);
                                }

                                public Create setUploadType(String string) {
                                    return (Create)super.setUploadType(string);
                                }

                                public Create setUploadProtocol(String string) {
                                    return (Create)super.setUploadProtocol(string);
                                }

                                public String getParent() {
                                    return this.parent;
                                }

                                public Create setParent(String string) {
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    }
                                    this.parent = string;
                                    return this;
                                }

                                @Override
                                public Create set(String string, Object object) {
                                    return (Create)super.set(string, object);
                                }
                            }
                        }

                        public class Contexts {
                            public Create create(String string, GoogleCloudDialogflowV2Context googleCloudDialogflowV2Context) throws IOException {
                                Create create = new Create(string, googleCloudDialogflowV2Context);
                                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)create);
                                return create;
                            }

                            public Delete delete(String string) throws IOException {
                                Delete delete = new Delete(string);
                                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)delete);
                                return delete;
                            }

                            public Get get(String string) throws IOException {
                                Get get = new Get(string);
                                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                                return get;
                            }

                            public List list(String string) throws IOException {
                                List list = new List(string);
                                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                                return list;
                            }

                            public Patch patch(String string, GoogleCloudDialogflowV2Context googleCloudDialogflowV2Context) throws IOException {
                                Patch patch = new Patch(string, googleCloudDialogflowV2Context);
                                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)patch);
                                return patch;
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            public class Patch
                            extends DialogflowRequest<GoogleCloudDialogflowV2Context> {
                                private static final String REST_PATH = "v2/{+name}";
                                private final Pattern NAME_PATTERN;
                                @Key
                                private String name;
                                @Key
                                private String updateMask;

                                protected Patch(String string, GoogleCloudDialogflowV2Context googleCloudDialogflowV2Context) {
                                    super(Dialogflow.this, "PATCH", REST_PATH, (Object)googleCloudDialogflowV2Context, GoogleCloudDialogflowV2Context.class);
                                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/contexts/[^/]+$");
                                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/contexts/[^/]+$");
                                    }
                                }

                                public Patch set$Xgafv(String string) {
                                    return (Patch)super.set$Xgafv(string);
                                }

                                public Patch setAccessToken(String string) {
                                    return (Patch)super.setAccessToken(string);
                                }

                                public Patch setAlt(String string) {
                                    return (Patch)super.setAlt(string);
                                }

                                public Patch setCallback(String string) {
                                    return (Patch)super.setCallback(string);
                                }

                                public Patch setFields(String string) {
                                    return (Patch)super.setFields(string);
                                }

                                public Patch setKey(String string) {
                                    return (Patch)super.setKey(string);
                                }

                                public Patch setOauthToken(String string) {
                                    return (Patch)super.setOauthToken(string);
                                }

                                public Patch setPrettyPrint(Boolean bl) {
                                    return (Patch)super.setPrettyPrint(bl);
                                }

                                public Patch setQuotaUser(String string) {
                                    return (Patch)super.setQuotaUser(string);
                                }

                                public Patch setUploadType(String string) {
                                    return (Patch)super.setUploadType(string);
                                }

                                public Patch setUploadProtocol(String string) {
                                    return (Patch)super.setUploadProtocol(string);
                                }

                                public String getName() {
                                    return this.name;
                                }

                                public Patch setName(String string) {
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/contexts/[^/]+$");
                                    }
                                    this.name = string;
                                    return this;
                                }

                                public String getUpdateMask() {
                                    return this.updateMask;
                                }

                                public Patch setUpdateMask(String string) {
                                    this.updateMask = string;
                                    return this;
                                }

                                @Override
                                public Patch set(String string, Object object) {
                                    return (Patch)super.set(string, object);
                                }
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            public class List
                            extends DialogflowRequest<GoogleCloudDialogflowV2ListContextsResponse> {
                                private static final String REST_PATH = "v2/{+parent}/contexts";
                                private final Pattern PARENT_PATTERN;
                                @Key
                                private String parent;
                                @Key
                                private String pageToken;
                                @Key
                                private Integer pageSize;

                                protected List(String string) {
                                    super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2ListContextsResponse.class);
                                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    }
                                }

                                public HttpResponse executeUsingHead() throws IOException {
                                    return super.executeUsingHead();
                                }

                                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                    return super.buildHttpRequestUsingHead();
                                }

                                public List set$Xgafv(String string) {
                                    return (List)super.set$Xgafv(string);
                                }

                                public List setAccessToken(String string) {
                                    return (List)super.setAccessToken(string);
                                }

                                public List setAlt(String string) {
                                    return (List)super.setAlt(string);
                                }

                                public List setCallback(String string) {
                                    return (List)super.setCallback(string);
                                }

                                public List setFields(String string) {
                                    return (List)super.setFields(string);
                                }

                                public List setKey(String string) {
                                    return (List)super.setKey(string);
                                }

                                public List setOauthToken(String string) {
                                    return (List)super.setOauthToken(string);
                                }

                                public List setPrettyPrint(Boolean bl) {
                                    return (List)super.setPrettyPrint(bl);
                                }

                                public List setQuotaUser(String string) {
                                    return (List)super.setQuotaUser(string);
                                }

                                public List setUploadType(String string) {
                                    return (List)super.setUploadType(string);
                                }

                                public List setUploadProtocol(String string) {
                                    return (List)super.setUploadProtocol(string);
                                }

                                public String getParent() {
                                    return this.parent;
                                }

                                public List setParent(String string) {
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    }
                                    this.parent = string;
                                    return this;
                                }

                                public String getPageToken() {
                                    return this.pageToken;
                                }

                                public List setPageToken(String string) {
                                    this.pageToken = string;
                                    return this;
                                }

                                public Integer getPageSize() {
                                    return this.pageSize;
                                }

                                public List setPageSize(Integer n) {
                                    this.pageSize = n;
                                    return this;
                                }

                                @Override
                                public List set(String string, Object object) {
                                    return (List)super.set(string, object);
                                }
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            public class Get
                            extends DialogflowRequest<GoogleCloudDialogflowV2Context> {
                                private static final String REST_PATH = "v2/{+name}";
                                private final Pattern NAME_PATTERN;
                                @Key
                                private String name;

                                protected Get(String string) {
                                    super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2Context.class);
                                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/contexts/[^/]+$");
                                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/contexts/[^/]+$");
                                    }
                                }

                                public HttpResponse executeUsingHead() throws IOException {
                                    return super.executeUsingHead();
                                }

                                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                    return super.buildHttpRequestUsingHead();
                                }

                                public Get set$Xgafv(String string) {
                                    return (Get)super.set$Xgafv(string);
                                }

                                public Get setAccessToken(String string) {
                                    return (Get)super.setAccessToken(string);
                                }

                                public Get setAlt(String string) {
                                    return (Get)super.setAlt(string);
                                }

                                public Get setCallback(String string) {
                                    return (Get)super.setCallback(string);
                                }

                                public Get setFields(String string) {
                                    return (Get)super.setFields(string);
                                }

                                public Get setKey(String string) {
                                    return (Get)super.setKey(string);
                                }

                                public Get setOauthToken(String string) {
                                    return (Get)super.setOauthToken(string);
                                }

                                public Get setPrettyPrint(Boolean bl) {
                                    return (Get)super.setPrettyPrint(bl);
                                }

                                public Get setQuotaUser(String string) {
                                    return (Get)super.setQuotaUser(string);
                                }

                                public Get setUploadType(String string) {
                                    return (Get)super.setUploadType(string);
                                }

                                public Get setUploadProtocol(String string) {
                                    return (Get)super.setUploadProtocol(string);
                                }

                                public String getName() {
                                    return this.name;
                                }

                                public Get setName(String string) {
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/contexts/[^/]+$");
                                    }
                                    this.name = string;
                                    return this;
                                }

                                @Override
                                public Get set(String string, Object object) {
                                    return (Get)super.set(string, object);
                                }
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            public class Delete
                            extends DialogflowRequest<GoogleProtobufEmpty> {
                                private static final String REST_PATH = "v2/{+name}";
                                private final Pattern NAME_PATTERN;
                                @Key
                                private String name;

                                protected Delete(String string) {
                                    super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/contexts/[^/]+$");
                                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/contexts/[^/]+$");
                                    }
                                }

                                public Delete set$Xgafv(String string) {
                                    return (Delete)super.set$Xgafv(string);
                                }

                                public Delete setAccessToken(String string) {
                                    return (Delete)super.setAccessToken(string);
                                }

                                public Delete setAlt(String string) {
                                    return (Delete)super.setAlt(string);
                                }

                                public Delete setCallback(String string) {
                                    return (Delete)super.setCallback(string);
                                }

                                public Delete setFields(String string) {
                                    return (Delete)super.setFields(string);
                                }

                                public Delete setKey(String string) {
                                    return (Delete)super.setKey(string);
                                }

                                public Delete setOauthToken(String string) {
                                    return (Delete)super.setOauthToken(string);
                                }

                                public Delete setPrettyPrint(Boolean bl) {
                                    return (Delete)super.setPrettyPrint(bl);
                                }

                                public Delete setQuotaUser(String string) {
                                    return (Delete)super.setQuotaUser(string);
                                }

                                public Delete setUploadType(String string) {
                                    return (Delete)super.setUploadType(string);
                                }

                                public Delete setUploadProtocol(String string) {
                                    return (Delete)super.setUploadProtocol(string);
                                }

                                public String getName() {
                                    return this.name;
                                }

                                public Delete setName(String string) {
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+/contexts/[^/]+$");
                                    }
                                    this.name = string;
                                    return this;
                                }

                                @Override
                                public Delete set(String string, Object object) {
                                    return (Delete)super.set(string, object);
                                }
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            public class Create
                            extends DialogflowRequest<GoogleCloudDialogflowV2Context> {
                                private static final String REST_PATH = "v2/{+parent}/contexts";
                                private final Pattern PARENT_PATTERN;
                                @Key
                                private String parent;

                                protected Create(String string, GoogleCloudDialogflowV2Context googleCloudDialogflowV2Context) {
                                    super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2Context, GoogleCloudDialogflowV2Context.class);
                                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    }
                                }

                                public Create set$Xgafv(String string) {
                                    return (Create)super.set$Xgafv(string);
                                }

                                public Create setAccessToken(String string) {
                                    return (Create)super.setAccessToken(string);
                                }

                                public Create setAlt(String string) {
                                    return (Create)super.setAlt(string);
                                }

                                public Create setCallback(String string) {
                                    return (Create)super.setCallback(string);
                                }

                                public Create setFields(String string) {
                                    return (Create)super.setFields(string);
                                }

                                public Create setKey(String string) {
                                    return (Create)super.setKey(string);
                                }

                                public Create setOauthToken(String string) {
                                    return (Create)super.setOauthToken(string);
                                }

                                public Create setPrettyPrint(Boolean bl) {
                                    return (Create)super.setPrettyPrint(bl);
                                }

                                public Create setQuotaUser(String string) {
                                    return (Create)super.setQuotaUser(string);
                                }

                                public Create setUploadType(String string) {
                                    return (Create)super.setUploadType(string);
                                }

                                public Create setUploadProtocol(String string) {
                                    return (Create)super.setUploadProtocol(string);
                                }

                                public String getParent() {
                                    return this.parent;
                                }

                                public Create setParent(String string) {
                                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                    }
                                    this.parent = string;
                                    return this;
                                }

                                @Override
                                public Create set(String string, Object object) {
                                    return (Create)super.set(string, object);
                                }
                            }
                        }

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        public class DetectIntent
                        extends DialogflowRequest<GoogleCloudDialogflowV2DetectIntentResponse> {
                            private static final String REST_PATH = "v2/{+session}:detectIntent";
                            private final Pattern SESSION_PATTERN;
                            @Key
                            private String session;

                            protected DetectIntent(String string, GoogleCloudDialogflowV2DetectIntentRequest googleCloudDialogflowV2DetectIntentRequest) {
                                super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2DetectIntentRequest, GoogleCloudDialogflowV2DetectIntentResponse.class);
                                this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                this.session = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter session must be specified.");
                                if (!Dialogflow.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(string).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                }
                            }

                            public DetectIntent set$Xgafv(String string) {
                                return (DetectIntent)super.set$Xgafv(string);
                            }

                            public DetectIntent setAccessToken(String string) {
                                return (DetectIntent)super.setAccessToken(string);
                            }

                            public DetectIntent setAlt(String string) {
                                return (DetectIntent)super.setAlt(string);
                            }

                            public DetectIntent setCallback(String string) {
                                return (DetectIntent)super.setCallback(string);
                            }

                            public DetectIntent setFields(String string) {
                                return (DetectIntent)super.setFields(string);
                            }

                            public DetectIntent setKey(String string) {
                                return (DetectIntent)super.setKey(string);
                            }

                            public DetectIntent setOauthToken(String string) {
                                return (DetectIntent)super.setOauthToken(string);
                            }

                            public DetectIntent setPrettyPrint(Boolean bl) {
                                return (DetectIntent)super.setPrettyPrint(bl);
                            }

                            public DetectIntent setQuotaUser(String string) {
                                return (DetectIntent)super.setQuotaUser(string);
                            }

                            public DetectIntent setUploadType(String string) {
                                return (DetectIntent)super.setUploadType(string);
                            }

                            public DetectIntent setUploadProtocol(String string) {
                                return (DetectIntent)super.setUploadProtocol(string);
                            }

                            public String getSession() {
                                return this.session;
                            }

                            public DetectIntent setSession(String string) {
                                if (!Dialogflow.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(string).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                }
                                this.session = string;
                                return this;
                            }

                            @Override
                            public DetectIntent set(String string, Object object) {
                                return (DetectIntent)super.set(string, object);
                            }
                        }

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        public class DeleteContexts
                        extends DialogflowRequest<GoogleProtobufEmpty> {
                            private static final String REST_PATH = "v2/{+parent}/contexts";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;

                            protected DeleteContexts(String string) {
                                super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                                if (!Dialogflow.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                }
                            }

                            public DeleteContexts set$Xgafv(String string) {
                                return (DeleteContexts)super.set$Xgafv(string);
                            }

                            public DeleteContexts setAccessToken(String string) {
                                return (DeleteContexts)super.setAccessToken(string);
                            }

                            public DeleteContexts setAlt(String string) {
                                return (DeleteContexts)super.setAlt(string);
                            }

                            public DeleteContexts setCallback(String string) {
                                return (DeleteContexts)super.setCallback(string);
                            }

                            public DeleteContexts setFields(String string) {
                                return (DeleteContexts)super.setFields(string);
                            }

                            public DeleteContexts setKey(String string) {
                                return (DeleteContexts)super.setKey(string);
                            }

                            public DeleteContexts setOauthToken(String string) {
                                return (DeleteContexts)super.setOauthToken(string);
                            }

                            public DeleteContexts setPrettyPrint(Boolean bl) {
                                return (DeleteContexts)super.setPrettyPrint(bl);
                            }

                            public DeleteContexts setQuotaUser(String string) {
                                return (DeleteContexts)super.setQuotaUser(string);
                            }

                            public DeleteContexts setUploadType(String string) {
                                return (DeleteContexts)super.setUploadType(string);
                            }

                            public DeleteContexts setUploadProtocol(String string) {
                                return (DeleteContexts)super.setUploadProtocol(string);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public DeleteContexts setParent(String string) {
                                if (!Dialogflow.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/environments/[^/]+/users/[^/]+/sessions/[^/]+$");
                                }
                                this.parent = string;
                                return this;
                            }

                            @Override
                            public DeleteContexts set(String string, Object object) {
                                return (DeleteContexts)super.set(string, object);
                            }
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DialogflowRequest<GoogleCloudDialogflowV2ListEnvironmentsResponse> {
                    private static final String REST_PATH = "v2/{+parent}/environments";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2ListEnvironmentsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }
            }

            public class EntityTypes {
                public BatchDelete batchDelete(String string, GoogleCloudDialogflowV2BatchDeleteEntityTypesRequest googleCloudDialogflowV2BatchDeleteEntityTypesRequest) throws IOException {
                    BatchDelete batchDelete = new BatchDelete(string, googleCloudDialogflowV2BatchDeleteEntityTypesRequest);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                    return batchDelete;
                }

                public BatchUpdate batchUpdate(String string, GoogleCloudDialogflowV2BatchUpdateEntityTypesRequest googleCloudDialogflowV2BatchUpdateEntityTypesRequest) throws IOException {
                    BatchUpdate batchUpdate = new BatchUpdate(string, googleCloudDialogflowV2BatchUpdateEntityTypesRequest);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                    return batchUpdate;
                }

                public Create create(String string, GoogleCloudDialogflowV2EntityType googleCloudDialogflowV2EntityType) throws IOException {
                    Create create = new Create(string, googleCloudDialogflowV2EntityType);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, GoogleCloudDialogflowV2EntityType googleCloudDialogflowV2EntityType) throws IOException {
                    Patch patch = new Patch(string, googleCloudDialogflowV2EntityType);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                public Entities entities() {
                    return new Entities();
                }

                public class Entities {
                    public BatchCreate batchCreate(String string, GoogleCloudDialogflowV2BatchCreateEntitiesRequest googleCloudDialogflowV2BatchCreateEntitiesRequest) throws IOException {
                        BatchCreate batchCreate = new BatchCreate(string, googleCloudDialogflowV2BatchCreateEntitiesRequest);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchCreate);
                        return batchCreate;
                    }

                    public BatchDelete batchDelete(String string, GoogleCloudDialogflowV2BatchDeleteEntitiesRequest googleCloudDialogflowV2BatchDeleteEntitiesRequest) throws IOException {
                        BatchDelete batchDelete = new BatchDelete(string, googleCloudDialogflowV2BatchDeleteEntitiesRequest);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                        return batchDelete;
                    }

                    public BatchUpdate batchUpdate(String string, GoogleCloudDialogflowV2BatchUpdateEntitiesRequest googleCloudDialogflowV2BatchUpdateEntitiesRequest) throws IOException {
                        BatchUpdate batchUpdate = new BatchUpdate(string, googleCloudDialogflowV2BatchUpdateEntitiesRequest);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                        return batchUpdate;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class BatchUpdate
                    extends DialogflowRequest<GoogleLongrunningOperation> {
                        private static final String REST_PATH = "v2/{+parent}/entities:batchUpdate";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected BatchUpdate(String string, GoogleCloudDialogflowV2BatchUpdateEntitiesRequest googleCloudDialogflowV2BatchUpdateEntitiesRequest) {
                            super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2BatchUpdateEntitiesRequest, GoogleLongrunningOperation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                        }

                        public BatchUpdate set$Xgafv(String string) {
                            return (BatchUpdate)super.set$Xgafv(string);
                        }

                        public BatchUpdate setAccessToken(String string) {
                            return (BatchUpdate)super.setAccessToken(string);
                        }

                        public BatchUpdate setAlt(String string) {
                            return (BatchUpdate)super.setAlt(string);
                        }

                        public BatchUpdate setCallback(String string) {
                            return (BatchUpdate)super.setCallback(string);
                        }

                        public BatchUpdate setFields(String string) {
                            return (BatchUpdate)super.setFields(string);
                        }

                        public BatchUpdate setKey(String string) {
                            return (BatchUpdate)super.setKey(string);
                        }

                        public BatchUpdate setOauthToken(String string) {
                            return (BatchUpdate)super.setOauthToken(string);
                        }

                        public BatchUpdate setPrettyPrint(Boolean bl) {
                            return (BatchUpdate)super.setPrettyPrint(bl);
                        }

                        public BatchUpdate setQuotaUser(String string) {
                            return (BatchUpdate)super.setQuotaUser(string);
                        }

                        public BatchUpdate setUploadType(String string) {
                            return (BatchUpdate)super.setUploadType(string);
                        }

                        public BatchUpdate setUploadProtocol(String string) {
                            return (BatchUpdate)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public BatchUpdate setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public BatchUpdate set(String string, Object object) {
                            return (BatchUpdate)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class BatchDelete
                    extends DialogflowRequest<GoogleLongrunningOperation> {
                        private static final String REST_PATH = "v2/{+parent}/entities:batchDelete";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected BatchDelete(String string, GoogleCloudDialogflowV2BatchDeleteEntitiesRequest googleCloudDialogflowV2BatchDeleteEntitiesRequest) {
                            super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2BatchDeleteEntitiesRequest, GoogleLongrunningOperation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                        }

                        public BatchDelete set$Xgafv(String string) {
                            return (BatchDelete)super.set$Xgafv(string);
                        }

                        public BatchDelete setAccessToken(String string) {
                            return (BatchDelete)super.setAccessToken(string);
                        }

                        public BatchDelete setAlt(String string) {
                            return (BatchDelete)super.setAlt(string);
                        }

                        public BatchDelete setCallback(String string) {
                            return (BatchDelete)super.setCallback(string);
                        }

                        public BatchDelete setFields(String string) {
                            return (BatchDelete)super.setFields(string);
                        }

                        public BatchDelete setKey(String string) {
                            return (BatchDelete)super.setKey(string);
                        }

                        public BatchDelete setOauthToken(String string) {
                            return (BatchDelete)super.setOauthToken(string);
                        }

                        public BatchDelete setPrettyPrint(Boolean bl) {
                            return (BatchDelete)super.setPrettyPrint(bl);
                        }

                        public BatchDelete setQuotaUser(String string) {
                            return (BatchDelete)super.setQuotaUser(string);
                        }

                        public BatchDelete setUploadType(String string) {
                            return (BatchDelete)super.setUploadType(string);
                        }

                        public BatchDelete setUploadProtocol(String string) {
                            return (BatchDelete)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public BatchDelete setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public BatchDelete set(String string, Object object) {
                            return (BatchDelete)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class BatchCreate
                    extends DialogflowRequest<GoogleLongrunningOperation> {
                        private static final String REST_PATH = "v2/{+parent}/entities:batchCreate";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected BatchCreate(String string, GoogleCloudDialogflowV2BatchCreateEntitiesRequest googleCloudDialogflowV2BatchCreateEntitiesRequest) {
                            super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2BatchCreateEntitiesRequest, GoogleLongrunningOperation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                        }

                        public BatchCreate set$Xgafv(String string) {
                            return (BatchCreate)super.set$Xgafv(string);
                        }

                        public BatchCreate setAccessToken(String string) {
                            return (BatchCreate)super.setAccessToken(string);
                        }

                        public BatchCreate setAlt(String string) {
                            return (BatchCreate)super.setAlt(string);
                        }

                        public BatchCreate setCallback(String string) {
                            return (BatchCreate)super.setCallback(string);
                        }

                        public BatchCreate setFields(String string) {
                            return (BatchCreate)super.setFields(string);
                        }

                        public BatchCreate setKey(String string) {
                            return (BatchCreate)super.setKey(string);
                        }

                        public BatchCreate setOauthToken(String string) {
                            return (BatchCreate)super.setOauthToken(string);
                        }

                        public BatchCreate setPrettyPrint(Boolean bl) {
                            return (BatchCreate)super.setPrettyPrint(bl);
                        }

                        public BatchCreate setQuotaUser(String string) {
                            return (BatchCreate)super.setQuotaUser(string);
                        }

                        public BatchCreate setUploadType(String string) {
                            return (BatchCreate)super.setUploadType(string);
                        }

                        public BatchCreate setUploadProtocol(String string) {
                            return (BatchCreate)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public BatchCreate setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public BatchCreate set(String string, Object object) {
                            return (BatchCreate)super.set(string, object);
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends DialogflowRequest<GoogleCloudDialogflowV2EntityType> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String languageCode;
                    @Key
                    private String updateMask;

                    protected Patch(String string, GoogleCloudDialogflowV2EntityType googleCloudDialogflowV2EntityType) {
                        super(Dialogflow.this, "PATCH", REST_PATH, (Object)googleCloudDialogflowV2EntityType, GoogleCloudDialogflowV2EntityType.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Patch setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DialogflowRequest<GoogleCloudDialogflowV2ListEntityTypesResponse> {
                    private static final String REST_PATH = "v2/{+parent}/entityTypes";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String languageCode;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2ListEntityTypesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public List setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DialogflowRequest<GoogleCloudDialogflowV2EntityType> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String languageCode;

                    protected Get(String string) {
                        super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2EntityType.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Get setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DialogflowRequest<GoogleProtobufEmpty> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends DialogflowRequest<GoogleCloudDialogflowV2EntityType> {
                    private static final String REST_PATH = "v2/{+parent}/entityTypes";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String languageCode;

                    protected Create(String string, GoogleCloudDialogflowV2EntityType googleCloudDialogflowV2EntityType) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2EntityType, GoogleCloudDialogflowV2EntityType.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Create setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class BatchUpdate
                extends DialogflowRequest<GoogleLongrunningOperation> {
                    private static final String REST_PATH = "v2/{+parent}/entityTypes:batchUpdate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected BatchUpdate(String string, GoogleCloudDialogflowV2BatchUpdateEntityTypesRequest googleCloudDialogflowV2BatchUpdateEntityTypesRequest) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2BatchUpdateEntityTypesRequest, GoogleLongrunningOperation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public BatchUpdate set$Xgafv(String string) {
                        return (BatchUpdate)super.set$Xgafv(string);
                    }

                    public BatchUpdate setAccessToken(String string) {
                        return (BatchUpdate)super.setAccessToken(string);
                    }

                    public BatchUpdate setAlt(String string) {
                        return (BatchUpdate)super.setAlt(string);
                    }

                    public BatchUpdate setCallback(String string) {
                        return (BatchUpdate)super.setCallback(string);
                    }

                    public BatchUpdate setFields(String string) {
                        return (BatchUpdate)super.setFields(string);
                    }

                    public BatchUpdate setKey(String string) {
                        return (BatchUpdate)super.setKey(string);
                    }

                    public BatchUpdate setOauthToken(String string) {
                        return (BatchUpdate)super.setOauthToken(string);
                    }

                    public BatchUpdate setPrettyPrint(Boolean bl) {
                        return (BatchUpdate)super.setPrettyPrint(bl);
                    }

                    public BatchUpdate setQuotaUser(String string) {
                        return (BatchUpdate)super.setQuotaUser(string);
                    }

                    public BatchUpdate setUploadType(String string) {
                        return (BatchUpdate)super.setUploadType(string);
                    }

                    public BatchUpdate setUploadProtocol(String string) {
                        return (BatchUpdate)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public BatchUpdate setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public BatchUpdate set(String string, Object object) {
                        return (BatchUpdate)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class BatchDelete
                extends DialogflowRequest<GoogleLongrunningOperation> {
                    private static final String REST_PATH = "v2/{+parent}/entityTypes:batchDelete";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected BatchDelete(String string, GoogleCloudDialogflowV2BatchDeleteEntityTypesRequest googleCloudDialogflowV2BatchDeleteEntityTypesRequest) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2BatchDeleteEntityTypesRequest, GoogleLongrunningOperation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public BatchDelete set$Xgafv(String string) {
                        return (BatchDelete)super.set$Xgafv(string);
                    }

                    public BatchDelete setAccessToken(String string) {
                        return (BatchDelete)super.setAccessToken(string);
                    }

                    public BatchDelete setAlt(String string) {
                        return (BatchDelete)super.setAlt(string);
                    }

                    public BatchDelete setCallback(String string) {
                        return (BatchDelete)super.setCallback(string);
                    }

                    public BatchDelete setFields(String string) {
                        return (BatchDelete)super.setFields(string);
                    }

                    public BatchDelete setKey(String string) {
                        return (BatchDelete)super.setKey(string);
                    }

                    public BatchDelete setOauthToken(String string) {
                        return (BatchDelete)super.setOauthToken(string);
                    }

                    public BatchDelete setPrettyPrint(Boolean bl) {
                        return (BatchDelete)super.setPrettyPrint(bl);
                    }

                    public BatchDelete setQuotaUser(String string) {
                        return (BatchDelete)super.setQuotaUser(string);
                    }

                    public BatchDelete setUploadType(String string) {
                        return (BatchDelete)super.setUploadType(string);
                    }

                    public BatchDelete setUploadProtocol(String string) {
                        return (BatchDelete)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public BatchDelete setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public BatchDelete set(String string, Object object) {
                        return (BatchDelete)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class UpdateFulfillment
            extends DialogflowRequest<GoogleCloudDialogflowV2Fulfillment> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected UpdateFulfillment(String string, GoogleCloudDialogflowV2Fulfillment googleCloudDialogflowV2Fulfillment) {
                    super(Dialogflow.this, "PATCH", REST_PATH, (Object)googleCloudDialogflowV2Fulfillment, GoogleCloudDialogflowV2Fulfillment.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/fulfillment$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/fulfillment$");
                    }
                }

                public UpdateFulfillment set$Xgafv(String string) {
                    return (UpdateFulfillment)super.set$Xgafv(string);
                }

                public UpdateFulfillment setAccessToken(String string) {
                    return (UpdateFulfillment)super.setAccessToken(string);
                }

                public UpdateFulfillment setAlt(String string) {
                    return (UpdateFulfillment)super.setAlt(string);
                }

                public UpdateFulfillment setCallback(String string) {
                    return (UpdateFulfillment)super.setCallback(string);
                }

                public UpdateFulfillment setFields(String string) {
                    return (UpdateFulfillment)super.setFields(string);
                }

                public UpdateFulfillment setKey(String string) {
                    return (UpdateFulfillment)super.setKey(string);
                }

                public UpdateFulfillment setOauthToken(String string) {
                    return (UpdateFulfillment)super.setOauthToken(string);
                }

                public UpdateFulfillment setPrettyPrint(Boolean bl) {
                    return (UpdateFulfillment)super.setPrettyPrint(bl);
                }

                public UpdateFulfillment setQuotaUser(String string) {
                    return (UpdateFulfillment)super.setQuotaUser(string);
                }

                public UpdateFulfillment setUploadType(String string) {
                    return (UpdateFulfillment)super.setUploadType(string);
                }

                public UpdateFulfillment setUploadProtocol(String string) {
                    return (UpdateFulfillment)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public UpdateFulfillment setName(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/fulfillment$");
                    }
                    this.name = string;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public UpdateFulfillment setUpdateMask(String string) {
                    this.updateMask = string;
                    return this;
                }

                @Override
                public UpdateFulfillment set(String string, Object object) {
                    return (UpdateFulfillment)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Train
            extends DialogflowRequest<GoogleLongrunningOperation> {
                private static final String REST_PATH = "v2/{+parent}/agent:train";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Train(String string, GoogleCloudDialogflowV2TrainAgentRequest googleCloudDialogflowV2TrainAgentRequest) {
                    super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2TrainAgentRequest, GoogleLongrunningOperation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Train set$Xgafv(String string) {
                    return (Train)super.set$Xgafv(string);
                }

                public Train setAccessToken(String string) {
                    return (Train)super.setAccessToken(string);
                }

                public Train setAlt(String string) {
                    return (Train)super.setAlt(string);
                }

                public Train setCallback(String string) {
                    return (Train)super.setCallback(string);
                }

                public Train setFields(String string) {
                    return (Train)super.setFields(string);
                }

                public Train setKey(String string) {
                    return (Train)super.setKey(string);
                }

                public Train setOauthToken(String string) {
                    return (Train)super.setOauthToken(string);
                }

                public Train setPrettyPrint(Boolean bl) {
                    return (Train)super.setPrettyPrint(bl);
                }

                public Train setQuotaUser(String string) {
                    return (Train)super.setQuotaUser(string);
                }

                public Train setUploadType(String string) {
                    return (Train)super.setUploadType(string);
                }

                public Train setUploadProtocol(String string) {
                    return (Train)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Train setParent(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Train set(String string, Object object) {
                    return (Train)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Search
            extends DialogflowRequest<GoogleCloudDialogflowV2SearchAgentsResponse> {
                private static final String REST_PATH = "v2/{+parent}/agent:search";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected Search(String string) {
                    super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2SearchAgentsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Search set$Xgafv(String string) {
                    return (Search)super.set$Xgafv(string);
                }

                public Search setAccessToken(String string) {
                    return (Search)super.setAccessToken(string);
                }

                public Search setAlt(String string) {
                    return (Search)super.setAlt(string);
                }

                public Search setCallback(String string) {
                    return (Search)super.setCallback(string);
                }

                public Search setFields(String string) {
                    return (Search)super.setFields(string);
                }

                public Search setKey(String string) {
                    return (Search)super.setKey(string);
                }

                public Search setOauthToken(String string) {
                    return (Search)super.setOauthToken(string);
                }

                public Search setPrettyPrint(Boolean bl) {
                    return (Search)super.setPrettyPrint(bl);
                }

                public Search setQuotaUser(String string) {
                    return (Search)super.setQuotaUser(string);
                }

                public Search setUploadType(String string) {
                    return (Search)super.setUploadType(string);
                }

                public Search setUploadProtocol(String string) {
                    return (Search)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Search setParent(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public Search setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public Search setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public Search set(String string, Object object) {
                    return (Search)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Restore
            extends DialogflowRequest<GoogleLongrunningOperation> {
                private static final String REST_PATH = "v2/{+parent}/agent:restore";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Restore(String string, GoogleCloudDialogflowV2RestoreAgentRequest googleCloudDialogflowV2RestoreAgentRequest) {
                    super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2RestoreAgentRequest, GoogleLongrunningOperation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Restore set$Xgafv(String string) {
                    return (Restore)super.set$Xgafv(string);
                }

                public Restore setAccessToken(String string) {
                    return (Restore)super.setAccessToken(string);
                }

                public Restore setAlt(String string) {
                    return (Restore)super.setAlt(string);
                }

                public Restore setCallback(String string) {
                    return (Restore)super.setCallback(string);
                }

                public Restore setFields(String string) {
                    return (Restore)super.setFields(string);
                }

                public Restore setKey(String string) {
                    return (Restore)super.setKey(string);
                }

                public Restore setOauthToken(String string) {
                    return (Restore)super.setOauthToken(string);
                }

                public Restore setPrettyPrint(Boolean bl) {
                    return (Restore)super.setPrettyPrint(bl);
                }

                public Restore setQuotaUser(String string) {
                    return (Restore)super.setQuotaUser(string);
                }

                public Restore setUploadType(String string) {
                    return (Restore)super.setUploadType(string);
                }

                public Restore setUploadProtocol(String string) {
                    return (Restore)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Restore setParent(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Restore set(String string, Object object) {
                    return (Restore)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class DialogflowImport
            extends DialogflowRequest<GoogleLongrunningOperation> {
                private static final String REST_PATH = "v2/{+parent}/agent:import";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected DialogflowImport(String string, GoogleCloudDialogflowV2ImportAgentRequest googleCloudDialogflowV2ImportAgentRequest) {
                    super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2ImportAgentRequest, GoogleLongrunningOperation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public DialogflowImport set$Xgafv(String string) {
                    return (DialogflowImport)super.set$Xgafv(string);
                }

                public DialogflowImport setAccessToken(String string) {
                    return (DialogflowImport)super.setAccessToken(string);
                }

                public DialogflowImport setAlt(String string) {
                    return (DialogflowImport)super.setAlt(string);
                }

                public DialogflowImport setCallback(String string) {
                    return (DialogflowImport)super.setCallback(string);
                }

                public DialogflowImport setFields(String string) {
                    return (DialogflowImport)super.setFields(string);
                }

                public DialogflowImport setKey(String string) {
                    return (DialogflowImport)super.setKey(string);
                }

                public DialogflowImport setOauthToken(String string) {
                    return (DialogflowImport)super.setOauthToken(string);
                }

                public DialogflowImport setPrettyPrint(Boolean bl) {
                    return (DialogflowImport)super.setPrettyPrint(bl);
                }

                public DialogflowImport setQuotaUser(String string) {
                    return (DialogflowImport)super.setQuotaUser(string);
                }

                public DialogflowImport setUploadType(String string) {
                    return (DialogflowImport)super.setUploadType(string);
                }

                public DialogflowImport setUploadProtocol(String string) {
                    return (DialogflowImport)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public DialogflowImport setParent(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public DialogflowImport set(String string, Object object) {
                    return (DialogflowImport)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetValidationResult
            extends DialogflowRequest<GoogleCloudDialogflowV2ValidationResult> {
                private static final String REST_PATH = "v2/{+parent}/agent/validationResult";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String languageCode;

                protected GetValidationResult(String string) {
                    super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2ValidationResult.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetValidationResult set$Xgafv(String string) {
                    return (GetValidationResult)super.set$Xgafv(string);
                }

                public GetValidationResult setAccessToken(String string) {
                    return (GetValidationResult)super.setAccessToken(string);
                }

                public GetValidationResult setAlt(String string) {
                    return (GetValidationResult)super.setAlt(string);
                }

                public GetValidationResult setCallback(String string) {
                    return (GetValidationResult)super.setCallback(string);
                }

                public GetValidationResult setFields(String string) {
                    return (GetValidationResult)super.setFields(string);
                }

                public GetValidationResult setKey(String string) {
                    return (GetValidationResult)super.setKey(string);
                }

                public GetValidationResult setOauthToken(String string) {
                    return (GetValidationResult)super.setOauthToken(string);
                }

                public GetValidationResult setPrettyPrint(Boolean bl) {
                    return (GetValidationResult)super.setPrettyPrint(bl);
                }

                public GetValidationResult setQuotaUser(String string) {
                    return (GetValidationResult)super.setQuotaUser(string);
                }

                public GetValidationResult setUploadType(String string) {
                    return (GetValidationResult)super.setUploadType(string);
                }

                public GetValidationResult setUploadProtocol(String string) {
                    return (GetValidationResult)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public GetValidationResult setParent(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getLanguageCode() {
                    return this.languageCode;
                }

                public GetValidationResult setLanguageCode(String string) {
                    this.languageCode = string;
                    return this;
                }

                @Override
                public GetValidationResult set(String string, Object object) {
                    return (GetValidationResult)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetFulfillment
            extends DialogflowRequest<GoogleCloudDialogflowV2Fulfillment> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected GetFulfillment(String string) {
                    super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2Fulfillment.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/fulfillment$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/fulfillment$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetFulfillment set$Xgafv(String string) {
                    return (GetFulfillment)super.set$Xgafv(string);
                }

                public GetFulfillment setAccessToken(String string) {
                    return (GetFulfillment)super.setAccessToken(string);
                }

                public GetFulfillment setAlt(String string) {
                    return (GetFulfillment)super.setAlt(string);
                }

                public GetFulfillment setCallback(String string) {
                    return (GetFulfillment)super.setCallback(string);
                }

                public GetFulfillment setFields(String string) {
                    return (GetFulfillment)super.setFields(string);
                }

                public GetFulfillment setKey(String string) {
                    return (GetFulfillment)super.setKey(string);
                }

                public GetFulfillment setOauthToken(String string) {
                    return (GetFulfillment)super.setOauthToken(string);
                }

                public GetFulfillment setPrettyPrint(Boolean bl) {
                    return (GetFulfillment)super.setPrettyPrint(bl);
                }

                public GetFulfillment setQuotaUser(String string) {
                    return (GetFulfillment)super.setQuotaUser(string);
                }

                public GetFulfillment setUploadType(String string) {
                    return (GetFulfillment)super.setUploadType(string);
                }

                public GetFulfillment setUploadProtocol(String string) {
                    return (GetFulfillment)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public GetFulfillment setName(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/fulfillment$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public GetFulfillment set(String string, Object object) {
                    return (GetFulfillment)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Export
            extends DialogflowRequest<GoogleLongrunningOperation> {
                private static final String REST_PATH = "v2/{+parent}/agent:export";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Export(String string, GoogleCloudDialogflowV2ExportAgentRequest googleCloudDialogflowV2ExportAgentRequest) {
                    super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2ExportAgentRequest, GoogleLongrunningOperation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Export set$Xgafv(String string) {
                    return (Export)super.set$Xgafv(string);
                }

                public Export setAccessToken(String string) {
                    return (Export)super.setAccessToken(string);
                }

                public Export setAlt(String string) {
                    return (Export)super.setAlt(string);
                }

                public Export setCallback(String string) {
                    return (Export)super.setCallback(string);
                }

                public Export setFields(String string) {
                    return (Export)super.setFields(string);
                }

                public Export setKey(String string) {
                    return (Export)super.setKey(string);
                }

                public Export setOauthToken(String string) {
                    return (Export)super.setOauthToken(string);
                }

                public Export setPrettyPrint(Boolean bl) {
                    return (Export)super.setPrettyPrint(bl);
                }

                public Export setQuotaUser(String string) {
                    return (Export)super.setQuotaUser(string);
                }

                public Export setUploadType(String string) {
                    return (Export)super.setUploadType(string);
                }

                public Export setUploadProtocol(String string) {
                    return (Export)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Export setParent(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Export set(String string, Object object) {
                    return (Export)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetAgent
        extends DialogflowRequest<GoogleCloudDialogflowV2Agent> {
            private static final String REST_PATH = "v2/{+parent}/agent";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String updateMask;

            protected SetAgent(String string, GoogleCloudDialogflowV2Agent googleCloudDialogflowV2Agent) {
                super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2Agent, GoogleCloudDialogflowV2Agent.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                if (!Dialogflow.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public SetAgent set$Xgafv(String string) {
                return (SetAgent)super.set$Xgafv(string);
            }

            public SetAgent setAccessToken(String string) {
                return (SetAgent)super.setAccessToken(string);
            }

            public SetAgent setAlt(String string) {
                return (SetAgent)super.setAlt(string);
            }

            public SetAgent setCallback(String string) {
                return (SetAgent)super.setCallback(string);
            }

            public SetAgent setFields(String string) {
                return (SetAgent)super.setFields(string);
            }

            public SetAgent setKey(String string) {
                return (SetAgent)super.setKey(string);
            }

            public SetAgent setOauthToken(String string) {
                return (SetAgent)super.setOauthToken(string);
            }

            public SetAgent setPrettyPrint(Boolean bl) {
                return (SetAgent)super.setPrettyPrint(bl);
            }

            public SetAgent setQuotaUser(String string) {
                return (SetAgent)super.setQuotaUser(string);
            }

            public SetAgent setUploadType(String string) {
                return (SetAgent)super.setUploadType(string);
            }

            public SetAgent setUploadProtocol(String string) {
                return (SetAgent)super.setUploadProtocol(string);
            }

            public String getParent() {
                return this.parent;
            }

            public SetAgent setParent(String string) {
                if (!Dialogflow.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = string;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public SetAgent setUpdateMask(String string) {
                this.updateMask = string;
                return this;
            }

            @Override
            public SetAgent set(String string, Object object) {
                return (SetAgent)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetAgent
        extends DialogflowRequest<GoogleCloudDialogflowV2Agent> {
            private static final String REST_PATH = "v2/{+parent}/agent";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected GetAgent(String string) {
                super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2Agent.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                if (!Dialogflow.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetAgent set$Xgafv(String string) {
                return (GetAgent)super.set$Xgafv(string);
            }

            public GetAgent setAccessToken(String string) {
                return (GetAgent)super.setAccessToken(string);
            }

            public GetAgent setAlt(String string) {
                return (GetAgent)super.setAlt(string);
            }

            public GetAgent setCallback(String string) {
                return (GetAgent)super.setCallback(string);
            }

            public GetAgent setFields(String string) {
                return (GetAgent)super.setFields(string);
            }

            public GetAgent setKey(String string) {
                return (GetAgent)super.setKey(string);
            }

            public GetAgent setOauthToken(String string) {
                return (GetAgent)super.setOauthToken(string);
            }

            public GetAgent setPrettyPrint(Boolean bl) {
                return (GetAgent)super.setPrettyPrint(bl);
            }

            public GetAgent setQuotaUser(String string) {
                return (GetAgent)super.setQuotaUser(string);
            }

            public GetAgent setUploadType(String string) {
                return (GetAgent)super.setUploadType(string);
            }

            public GetAgent setUploadProtocol(String string) {
                return (GetAgent)super.setUploadProtocol(string);
            }

            public String getParent() {
                return this.parent;
            }

            public GetAgent setParent(String string) {
                if (!Dialogflow.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = string;
                return this;
            }

            @Override
            public GetAgent set(String string, Object object) {
                return (GetAgent)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DeleteAgent
        extends DialogflowRequest<GoogleProtobufEmpty> {
            private static final String REST_PATH = "v2/{+parent}/agent";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected DeleteAgent(String string) {
                super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                if (!Dialogflow.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public DeleteAgent set$Xgafv(String string) {
                return (DeleteAgent)super.set$Xgafv(string);
            }

            public DeleteAgent setAccessToken(String string) {
                return (DeleteAgent)super.setAccessToken(string);
            }

            public DeleteAgent setAlt(String string) {
                return (DeleteAgent)super.setAlt(string);
            }

            public DeleteAgent setCallback(String string) {
                return (DeleteAgent)super.setCallback(string);
            }

            public DeleteAgent setFields(String string) {
                return (DeleteAgent)super.setFields(string);
            }

            public DeleteAgent setKey(String string) {
                return (DeleteAgent)super.setKey(string);
            }

            public DeleteAgent setOauthToken(String string) {
                return (DeleteAgent)super.setOauthToken(string);
            }

            public DeleteAgent setPrettyPrint(Boolean bl) {
                return (DeleteAgent)super.setPrettyPrint(bl);
            }

            public DeleteAgent setQuotaUser(String string) {
                return (DeleteAgent)super.setQuotaUser(string);
            }

            public DeleteAgent setUploadType(String string) {
                return (DeleteAgent)super.setUploadType(string);
            }

            public DeleteAgent setUploadProtocol(String string) {
                return (DeleteAgent)super.setUploadProtocol(string);
            }

            public String getParent() {
                return this.parent;
            }

            public DeleteAgent setParent(String string) {
                if (!Dialogflow.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = string;
                return this;
            }

            @Override
            public DeleteAgent set(String string, Object object) {
                return (DeleteAgent)super.set(string, object);
            }
        }
    }
}

