/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.dialogflow.v2beta1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.dialogflow.v2beta1.DialogflowRequest;
import com.google.api.services.dialogflow.v2beta1.DialogflowRequestInitializer;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1Agent;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1BatchCreateEntitiesRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1BatchDeleteEntitiesRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1BatchDeleteIntentsRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1BatchUpdateEntitiesRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1BatchUpdateIntentsRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1Context;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1DetectIntentRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1DetectIntentResponse;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1EntityType;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1ExportAgentRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1ImportAgentRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1Intent;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1ListContextsResponse;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1ListEntityTypesResponse;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1ListIntentsResponse;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1RestoreAgentRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1SearchAgentsResponse;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1SessionEntityType;
import com.google.api.services.dialogflow.v2beta1.model.GoogleCloudDialogflowV2beta1TrainAgentRequest;
import com.google.api.services.dialogflow.v2beta1.model.GoogleLongrunningOperation;
import com.google.api.services.dialogflow.v2beta1.model.GoogleProtobufEmpty;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dialogflow
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://dialogflow.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://dialogflow.googleapis.com/";

    public Dialogflow(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Dialogflow(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Dialogflow API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://dialogflow.googleapis.com/", Dialogflow.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Dialogflow.DEFAULT_BATCH_PATH);
        }

        public Dialogflow build() {
            return new Dialogflow(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDialogflowRequestInitializer(DialogflowRequestInitializer dialogflowRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)dialogflowRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public GetAgent getAgent(String string) throws IOException {
            GetAgent getAgent = new GetAgent(string);
            Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)getAgent);
            return getAgent;
        }

        public Agent agent() {
            return new Agent();
        }

        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends DialogflowRequest<GoogleLongrunningOperation> {
                private static final String REST_PATH = "v2beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(Dialogflow.this, "GET", REST_PATH, null, GoogleLongrunningOperation.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/operations/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Agent {
            public Export export(String string, GoogleCloudDialogflowV2beta1ExportAgentRequest googleCloudDialogflowV2beta1ExportAgentRequest) throws IOException {
                Export export = new Export(string, googleCloudDialogflowV2beta1ExportAgentRequest);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)export);
                return export;
            }

            public DialogflowImport dialogflowImport(String string, GoogleCloudDialogflowV2beta1ImportAgentRequest googleCloudDialogflowV2beta1ImportAgentRequest) throws IOException {
                DialogflowImport dialogflowImport = new DialogflowImport(string, googleCloudDialogflowV2beta1ImportAgentRequest);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)dialogflowImport);
                return dialogflowImport;
            }

            public Restore restore(String string, GoogleCloudDialogflowV2beta1RestoreAgentRequest googleCloudDialogflowV2beta1RestoreAgentRequest) throws IOException {
                Restore restore = new Restore(string, googleCloudDialogflowV2beta1RestoreAgentRequest);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)restore);
                return restore;
            }

            public Search search(String string) throws IOException {
                Search search = new Search(string);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)search);
                return search;
            }

            public Train train(String string, GoogleCloudDialogflowV2beta1TrainAgentRequest googleCloudDialogflowV2beta1TrainAgentRequest) throws IOException {
                Train train = new Train(string, googleCloudDialogflowV2beta1TrainAgentRequest);
                Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)train);
                return train;
            }

            public EntityTypes entityTypes() {
                return new EntityTypes();
            }

            public Intents intents() {
                return new Intents();
            }

            public Sessions sessions() {
                return new Sessions();
            }

            public class Sessions {
                public DeleteContexts deleteContexts(String string) throws IOException {
                    DeleteContexts deleteContexts = new DeleteContexts(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)deleteContexts);
                    return deleteContexts;
                }

                public DetectIntent detectIntent(String string, GoogleCloudDialogflowV2beta1DetectIntentRequest googleCloudDialogflowV2beta1DetectIntentRequest) throws IOException {
                    DetectIntent detectIntent = new DetectIntent(string, googleCloudDialogflowV2beta1DetectIntentRequest);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)detectIntent);
                    return detectIntent;
                }

                public Contexts contexts() {
                    return new Contexts();
                }

                public EntityTypes entityTypes() {
                    return new EntityTypes();
                }

                public class EntityTypes {
                    public Create create(String string, GoogleCloudDialogflowV2beta1SessionEntityType googleCloudDialogflowV2beta1SessionEntityType) throws IOException {
                        Create create = new Create(string, googleCloudDialogflowV2beta1SessionEntityType);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)create);
                        return create;
                    }

                    public Delete delete(String string) throws IOException {
                        Delete delete = new Delete(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)delete);
                        return delete;
                    }

                    public Get get(String string) throws IOException {
                        Get get = new Get(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                        return get;
                    }

                    public List list(String string) throws IOException {
                        List list = new List(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                        return list;
                    }

                    public Patch patch(String string, GoogleCloudDialogflowV2beta1SessionEntityType googleCloudDialogflowV2beta1SessionEntityType) throws IOException {
                        Patch patch = new Patch(string, googleCloudDialogflowV2beta1SessionEntityType);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)patch);
                        return patch;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Patch
                    extends DialogflowRequest<GoogleCloudDialogflowV2beta1SessionEntityType> {
                        private static final String REST_PATH = "v2beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String string, GoogleCloudDialogflowV2beta1SessionEntityType googleCloudDialogflowV2beta1SessionEntityType) {
                            super(Dialogflow.this, "PATCH", REST_PATH, (Object)googleCloudDialogflowV2beta1SessionEntityType, GoogleCloudDialogflowV2beta1SessionEntityType.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String string) {
                            return (Patch)super.set$Xgafv(string);
                        }

                        public Patch setAccessToken(String string) {
                            return (Patch)super.setAccessToken(string);
                        }

                        public Patch setAlt(String string) {
                            return (Patch)super.setAlt(string);
                        }

                        public Patch setBearerToken(String string) {
                            return (Patch)super.setBearerToken(string);
                        }

                        public Patch setCallback(String string) {
                            return (Patch)super.setCallback(string);
                        }

                        public Patch setFields(String string) {
                            return (Patch)super.setFields(string);
                        }

                        public Patch setKey(String string) {
                            return (Patch)super.setKey(string);
                        }

                        public Patch setOauthToken(String string) {
                            return (Patch)super.setOauthToken(string);
                        }

                        public Patch setPp(Boolean bl) {
                            return (Patch)super.setPp(bl);
                        }

                        public Patch setPrettyPrint(Boolean bl) {
                            return (Patch)super.setPrettyPrint(bl);
                        }

                        public Patch setQuotaUser(String string) {
                            return (Patch)super.setQuotaUser(string);
                        }

                        public Patch setUploadType(String string) {
                            return (Patch)super.setUploadType(string);
                        }

                        public Patch setUploadProtocol(String string) {
                            return (Patch)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String string) {
                            this.updateMask = string;
                            return this;
                        }

                        @Override
                        public Patch set(String string, Object object) {
                            return (Patch)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class List
                    extends DialogflowRequest<GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse> {
                        private static final String REST_PATH = "v2beta1/{+parent}/entityTypes";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String string) {
                            super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String string) {
                            return (List)super.set$Xgafv(string);
                        }

                        public List setAccessToken(String string) {
                            return (List)super.setAccessToken(string);
                        }

                        public List setAlt(String string) {
                            return (List)super.setAlt(string);
                        }

                        public List setBearerToken(String string) {
                            return (List)super.setBearerToken(string);
                        }

                        public List setCallback(String string) {
                            return (List)super.setCallback(string);
                        }

                        public List setFields(String string) {
                            return (List)super.setFields(string);
                        }

                        public List setKey(String string) {
                            return (List)super.setKey(string);
                        }

                        public List setOauthToken(String string) {
                            return (List)super.setOauthToken(string);
                        }

                        public List setPp(Boolean bl) {
                            return (List)super.setPp(bl);
                        }

                        public List setPrettyPrint(Boolean bl) {
                            return (List)super.setPrettyPrint(bl);
                        }

                        public List setQuotaUser(String string) {
                            return (List)super.setQuotaUser(string);
                        }

                        public List setUploadType(String string) {
                            return (List)super.setUploadType(string);
                        }

                        public List setUploadProtocol(String string) {
                            return (List)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer n) {
                            this.pageSize = n;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String string) {
                            this.pageToken = string;
                            return this;
                        }

                        @Override
                        public List set(String string, Object object) {
                            return (List)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Get
                    extends DialogflowRequest<GoogleCloudDialogflowV2beta1SessionEntityType> {
                        private static final String REST_PATH = "v2beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String string) {
                            super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2beta1SessionEntityType.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String string) {
                            return (Get)super.set$Xgafv(string);
                        }

                        public Get setAccessToken(String string) {
                            return (Get)super.setAccessToken(string);
                        }

                        public Get setAlt(String string) {
                            return (Get)super.setAlt(string);
                        }

                        public Get setBearerToken(String string) {
                            return (Get)super.setBearerToken(string);
                        }

                        public Get setCallback(String string) {
                            return (Get)super.setCallback(string);
                        }

                        public Get setFields(String string) {
                            return (Get)super.setFields(string);
                        }

                        public Get setKey(String string) {
                            return (Get)super.setKey(string);
                        }

                        public Get setOauthToken(String string) {
                            return (Get)super.setOauthToken(string);
                        }

                        public Get setPp(Boolean bl) {
                            return (Get)super.setPp(bl);
                        }

                        public Get setPrettyPrint(Boolean bl) {
                            return (Get)super.setPrettyPrint(bl);
                        }

                        public Get setQuotaUser(String string) {
                            return (Get)super.setQuotaUser(string);
                        }

                        public Get setUploadType(String string) {
                            return (Get)super.setUploadType(string);
                        }

                        public Get setUploadProtocol(String string) {
                            return (Get)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Get set(String string, Object object) {
                            return (Get)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Delete
                    extends DialogflowRequest<GoogleProtobufEmpty> {
                        private static final String REST_PATH = "v2beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String string) {
                            super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String string) {
                            return (Delete)super.set$Xgafv(string);
                        }

                        public Delete setAccessToken(String string) {
                            return (Delete)super.setAccessToken(string);
                        }

                        public Delete setAlt(String string) {
                            return (Delete)super.setAlt(string);
                        }

                        public Delete setBearerToken(String string) {
                            return (Delete)super.setBearerToken(string);
                        }

                        public Delete setCallback(String string) {
                            return (Delete)super.setCallback(string);
                        }

                        public Delete setFields(String string) {
                            return (Delete)super.setFields(string);
                        }

                        public Delete setKey(String string) {
                            return (Delete)super.setKey(string);
                        }

                        public Delete setOauthToken(String string) {
                            return (Delete)super.setOauthToken(string);
                        }

                        public Delete setPp(Boolean bl) {
                            return (Delete)super.setPp(bl);
                        }

                        public Delete setPrettyPrint(Boolean bl) {
                            return (Delete)super.setPrettyPrint(bl);
                        }

                        public Delete setQuotaUser(String string) {
                            return (Delete)super.setQuotaUser(string);
                        }

                        public Delete setUploadType(String string) {
                            return (Delete)super.setUploadType(string);
                        }

                        public Delete setUploadProtocol(String string) {
                            return (Delete)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/entityTypes/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Delete set(String string, Object object) {
                            return (Delete)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Create
                    extends DialogflowRequest<GoogleCloudDialogflowV2beta1SessionEntityType> {
                        private static final String REST_PATH = "v2beta1/{+parent}/entityTypes";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Create(String string, GoogleCloudDialogflowV2beta1SessionEntityType googleCloudDialogflowV2beta1SessionEntityType) {
                            super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1SessionEntityType, GoogleCloudDialogflowV2beta1SessionEntityType.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String string) {
                            return (Create)super.set$Xgafv(string);
                        }

                        public Create setAccessToken(String string) {
                            return (Create)super.setAccessToken(string);
                        }

                        public Create setAlt(String string) {
                            return (Create)super.setAlt(string);
                        }

                        public Create setBearerToken(String string) {
                            return (Create)super.setBearerToken(string);
                        }

                        public Create setCallback(String string) {
                            return (Create)super.setCallback(string);
                        }

                        public Create setFields(String string) {
                            return (Create)super.setFields(string);
                        }

                        public Create setKey(String string) {
                            return (Create)super.setKey(string);
                        }

                        public Create setOauthToken(String string) {
                            return (Create)super.setOauthToken(string);
                        }

                        public Create setPp(Boolean bl) {
                            return (Create)super.setPp(bl);
                        }

                        public Create setPrettyPrint(Boolean bl) {
                            return (Create)super.setPrettyPrint(bl);
                        }

                        public Create setQuotaUser(String string) {
                            return (Create)super.setQuotaUser(string);
                        }

                        public Create setUploadType(String string) {
                            return (Create)super.setUploadType(string);
                        }

                        public Create setUploadProtocol(String string) {
                            return (Create)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public Create set(String string, Object object) {
                            return (Create)super.set(string, object);
                        }
                    }
                }

                public class Contexts {
                    public Create create(String string, GoogleCloudDialogflowV2beta1Context googleCloudDialogflowV2beta1Context) throws IOException {
                        Create create = new Create(string, googleCloudDialogflowV2beta1Context);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)create);
                        return create;
                    }

                    public Delete delete(String string) throws IOException {
                        Delete delete = new Delete(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)delete);
                        return delete;
                    }

                    public Get get(String string) throws IOException {
                        Get get = new Get(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                        return get;
                    }

                    public List list(String string) throws IOException {
                        List list = new List(string);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                        return list;
                    }

                    public Patch patch(String string, GoogleCloudDialogflowV2beta1Context googleCloudDialogflowV2beta1Context) throws IOException {
                        Patch patch = new Patch(string, googleCloudDialogflowV2beta1Context);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)patch);
                        return patch;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Patch
                    extends DialogflowRequest<GoogleCloudDialogflowV2beta1Context> {
                        private static final String REST_PATH = "v2beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String string, GoogleCloudDialogflowV2beta1Context googleCloudDialogflowV2beta1Context) {
                            super(Dialogflow.this, "PATCH", REST_PATH, (Object)googleCloudDialogflowV2beta1Context, GoogleCloudDialogflowV2beta1Context.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String string) {
                            return (Patch)super.set$Xgafv(string);
                        }

                        public Patch setAccessToken(String string) {
                            return (Patch)super.setAccessToken(string);
                        }

                        public Patch setAlt(String string) {
                            return (Patch)super.setAlt(string);
                        }

                        public Patch setBearerToken(String string) {
                            return (Patch)super.setBearerToken(string);
                        }

                        public Patch setCallback(String string) {
                            return (Patch)super.setCallback(string);
                        }

                        public Patch setFields(String string) {
                            return (Patch)super.setFields(string);
                        }

                        public Patch setKey(String string) {
                            return (Patch)super.setKey(string);
                        }

                        public Patch setOauthToken(String string) {
                            return (Patch)super.setOauthToken(string);
                        }

                        public Patch setPp(Boolean bl) {
                            return (Patch)super.setPp(bl);
                        }

                        public Patch setPrettyPrint(Boolean bl) {
                            return (Patch)super.setPrettyPrint(bl);
                        }

                        public Patch setQuotaUser(String string) {
                            return (Patch)super.setQuotaUser(string);
                        }

                        public Patch setUploadType(String string) {
                            return (Patch)super.setUploadType(string);
                        }

                        public Patch setUploadProtocol(String string) {
                            return (Patch)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String string) {
                            this.updateMask = string;
                            return this;
                        }

                        @Override
                        public Patch set(String string, Object object) {
                            return (Patch)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class List
                    extends DialogflowRequest<GoogleCloudDialogflowV2beta1ListContextsResponse> {
                        private static final String REST_PATH = "v2beta1/{+parent}/contexts";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String string) {
                            super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2beta1ListContextsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String string) {
                            return (List)super.set$Xgafv(string);
                        }

                        public List setAccessToken(String string) {
                            return (List)super.setAccessToken(string);
                        }

                        public List setAlt(String string) {
                            return (List)super.setAlt(string);
                        }

                        public List setBearerToken(String string) {
                            return (List)super.setBearerToken(string);
                        }

                        public List setCallback(String string) {
                            return (List)super.setCallback(string);
                        }

                        public List setFields(String string) {
                            return (List)super.setFields(string);
                        }

                        public List setKey(String string) {
                            return (List)super.setKey(string);
                        }

                        public List setOauthToken(String string) {
                            return (List)super.setOauthToken(string);
                        }

                        public List setPp(Boolean bl) {
                            return (List)super.setPp(bl);
                        }

                        public List setPrettyPrint(Boolean bl) {
                            return (List)super.setPrettyPrint(bl);
                        }

                        public List setQuotaUser(String string) {
                            return (List)super.setQuotaUser(string);
                        }

                        public List setUploadType(String string) {
                            return (List)super.setUploadType(string);
                        }

                        public List setUploadProtocol(String string) {
                            return (List)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer n) {
                            this.pageSize = n;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String string) {
                            this.pageToken = string;
                            return this;
                        }

                        @Override
                        public List set(String string, Object object) {
                            return (List)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Get
                    extends DialogflowRequest<GoogleCloudDialogflowV2beta1Context> {
                        private static final String REST_PATH = "v2beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String string) {
                            super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2beta1Context.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String string) {
                            return (Get)super.set$Xgafv(string);
                        }

                        public Get setAccessToken(String string) {
                            return (Get)super.setAccessToken(string);
                        }

                        public Get setAlt(String string) {
                            return (Get)super.setAlt(string);
                        }

                        public Get setBearerToken(String string) {
                            return (Get)super.setBearerToken(string);
                        }

                        public Get setCallback(String string) {
                            return (Get)super.setCallback(string);
                        }

                        public Get setFields(String string) {
                            return (Get)super.setFields(string);
                        }

                        public Get setKey(String string) {
                            return (Get)super.setKey(string);
                        }

                        public Get setOauthToken(String string) {
                            return (Get)super.setOauthToken(string);
                        }

                        public Get setPp(Boolean bl) {
                            return (Get)super.setPp(bl);
                        }

                        public Get setPrettyPrint(Boolean bl) {
                            return (Get)super.setPrettyPrint(bl);
                        }

                        public Get setQuotaUser(String string) {
                            return (Get)super.setQuotaUser(string);
                        }

                        public Get setUploadType(String string) {
                            return (Get)super.setUploadType(string);
                        }

                        public Get setUploadProtocol(String string) {
                            return (Get)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Get set(String string, Object object) {
                            return (Get)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Delete
                    extends DialogflowRequest<GoogleProtobufEmpty> {
                        private static final String REST_PATH = "v2beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String string) {
                            super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String string) {
                            return (Delete)super.set$Xgafv(string);
                        }

                        public Delete setAccessToken(String string) {
                            return (Delete)super.setAccessToken(string);
                        }

                        public Delete setAlt(String string) {
                            return (Delete)super.setAlt(string);
                        }

                        public Delete setBearerToken(String string) {
                            return (Delete)super.setBearerToken(string);
                        }

                        public Delete setCallback(String string) {
                            return (Delete)super.setCallback(string);
                        }

                        public Delete setFields(String string) {
                            return (Delete)super.setFields(string);
                        }

                        public Delete setKey(String string) {
                            return (Delete)super.setKey(string);
                        }

                        public Delete setOauthToken(String string) {
                            return (Delete)super.setOauthToken(string);
                        }

                        public Delete setPp(Boolean bl) {
                            return (Delete)super.setPp(bl);
                        }

                        public Delete setPrettyPrint(Boolean bl) {
                            return (Delete)super.setPrettyPrint(bl);
                        }

                        public Delete setQuotaUser(String string) {
                            return (Delete)super.setQuotaUser(string);
                        }

                        public Delete setUploadType(String string) {
                            return (Delete)super.setUploadType(string);
                        }

                        public Delete setUploadProtocol(String string) {
                            return (Delete)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+/contexts/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Delete set(String string, Object object) {
                            return (Delete)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Create
                    extends DialogflowRequest<GoogleCloudDialogflowV2beta1Context> {
                        private static final String REST_PATH = "v2beta1/{+parent}/contexts";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Create(String string, GoogleCloudDialogflowV2beta1Context googleCloudDialogflowV2beta1Context) {
                            super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1Context, GoogleCloudDialogflowV2beta1Context.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String string) {
                            return (Create)super.set$Xgafv(string);
                        }

                        public Create setAccessToken(String string) {
                            return (Create)super.setAccessToken(string);
                        }

                        public Create setAlt(String string) {
                            return (Create)super.setAlt(string);
                        }

                        public Create setBearerToken(String string) {
                            return (Create)super.setBearerToken(string);
                        }

                        public Create setCallback(String string) {
                            return (Create)super.setCallback(string);
                        }

                        public Create setFields(String string) {
                            return (Create)super.setFields(string);
                        }

                        public Create setKey(String string) {
                            return (Create)super.setKey(string);
                        }

                        public Create setOauthToken(String string) {
                            return (Create)super.setOauthToken(string);
                        }

                        public Create setPp(Boolean bl) {
                            return (Create)super.setPp(bl);
                        }

                        public Create setPrettyPrint(Boolean bl) {
                            return (Create)super.setPrettyPrint(bl);
                        }

                        public Create setQuotaUser(String string) {
                            return (Create)super.setQuotaUser(string);
                        }

                        public Create setUploadType(String string) {
                            return (Create)super.setUploadType(string);
                        }

                        public Create setUploadProtocol(String string) {
                            return (Create)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public Create set(String string, Object object) {
                            return (Create)super.set(string, object);
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class DetectIntent
                extends DialogflowRequest<GoogleCloudDialogflowV2beta1DetectIntentResponse> {
                    private static final String REST_PATH = "v2beta1/{+session}:detectIntent";
                    private final Pattern SESSION_PATTERN;
                    @Key
                    private String session;

                    protected DetectIntent(String string, GoogleCloudDialogflowV2beta1DetectIntentRequest googleCloudDialogflowV2beta1DetectIntentRequest) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1DetectIntentRequest, GoogleCloudDialogflowV2beta1DetectIntentResponse.class);
                        this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                        this.session = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter session must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(string).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                        }
                    }

                    public DetectIntent set$Xgafv(String string) {
                        return (DetectIntent)super.set$Xgafv(string);
                    }

                    public DetectIntent setAccessToken(String string) {
                        return (DetectIntent)super.setAccessToken(string);
                    }

                    public DetectIntent setAlt(String string) {
                        return (DetectIntent)super.setAlt(string);
                    }

                    public DetectIntent setBearerToken(String string) {
                        return (DetectIntent)super.setBearerToken(string);
                    }

                    public DetectIntent setCallback(String string) {
                        return (DetectIntent)super.setCallback(string);
                    }

                    public DetectIntent setFields(String string) {
                        return (DetectIntent)super.setFields(string);
                    }

                    public DetectIntent setKey(String string) {
                        return (DetectIntent)super.setKey(string);
                    }

                    public DetectIntent setOauthToken(String string) {
                        return (DetectIntent)super.setOauthToken(string);
                    }

                    public DetectIntent setPp(Boolean bl) {
                        return (DetectIntent)super.setPp(bl);
                    }

                    public DetectIntent setPrettyPrint(Boolean bl) {
                        return (DetectIntent)super.setPrettyPrint(bl);
                    }

                    public DetectIntent setQuotaUser(String string) {
                        return (DetectIntent)super.setQuotaUser(string);
                    }

                    public DetectIntent setUploadType(String string) {
                        return (DetectIntent)super.setUploadType(string);
                    }

                    public DetectIntent setUploadProtocol(String string) {
                        return (DetectIntent)super.setUploadProtocol(string);
                    }

                    public String getSession() {
                        return this.session;
                    }

                    public DetectIntent setSession(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(string).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                        }
                        this.session = string;
                        return this;
                    }

                    @Override
                    public DetectIntent set(String string, Object object) {
                        return (DetectIntent)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class DeleteContexts
                extends DialogflowRequest<GoogleProtobufEmpty> {
                    private static final String REST_PATH = "v2beta1/{+parent}/contexts";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected DeleteContexts(String string) {
                        super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/sessions/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                        }
                    }

                    public DeleteContexts set$Xgafv(String string) {
                        return (DeleteContexts)super.set$Xgafv(string);
                    }

                    public DeleteContexts setAccessToken(String string) {
                        return (DeleteContexts)super.setAccessToken(string);
                    }

                    public DeleteContexts setAlt(String string) {
                        return (DeleteContexts)super.setAlt(string);
                    }

                    public DeleteContexts setBearerToken(String string) {
                        return (DeleteContexts)super.setBearerToken(string);
                    }

                    public DeleteContexts setCallback(String string) {
                        return (DeleteContexts)super.setCallback(string);
                    }

                    public DeleteContexts setFields(String string) {
                        return (DeleteContexts)super.setFields(string);
                    }

                    public DeleteContexts setKey(String string) {
                        return (DeleteContexts)super.setKey(string);
                    }

                    public DeleteContexts setOauthToken(String string) {
                        return (DeleteContexts)super.setOauthToken(string);
                    }

                    public DeleteContexts setPp(Boolean bl) {
                        return (DeleteContexts)super.setPp(bl);
                    }

                    public DeleteContexts setPrettyPrint(Boolean bl) {
                        return (DeleteContexts)super.setPrettyPrint(bl);
                    }

                    public DeleteContexts setQuotaUser(String string) {
                        return (DeleteContexts)super.setQuotaUser(string);
                    }

                    public DeleteContexts setUploadType(String string) {
                        return (DeleteContexts)super.setUploadType(string);
                    }

                    public DeleteContexts setUploadProtocol(String string) {
                        return (DeleteContexts)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public DeleteContexts setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/sessions/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public DeleteContexts set(String string, Object object) {
                        return (DeleteContexts)super.set(string, object);
                    }
                }
            }

            public class Intents {
                public BatchDelete batchDelete(String string, GoogleCloudDialogflowV2beta1BatchDeleteIntentsRequest googleCloudDialogflowV2beta1BatchDeleteIntentsRequest) throws IOException {
                    BatchDelete batchDelete = new BatchDelete(string, googleCloudDialogflowV2beta1BatchDeleteIntentsRequest);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                    return batchDelete;
                }

                public BatchUpdate batchUpdate(String string, GoogleCloudDialogflowV2beta1BatchUpdateIntentsRequest googleCloudDialogflowV2beta1BatchUpdateIntentsRequest) throws IOException {
                    BatchUpdate batchUpdate = new BatchUpdate(string, googleCloudDialogflowV2beta1BatchUpdateIntentsRequest);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                    return batchUpdate;
                }

                public Create create(String string, GoogleCloudDialogflowV2beta1Intent googleCloudDialogflowV2beta1Intent) throws IOException {
                    Create create = new Create(string, googleCloudDialogflowV2beta1Intent);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, GoogleCloudDialogflowV2beta1Intent googleCloudDialogflowV2beta1Intent) throws IOException {
                    Patch patch = new Patch(string, googleCloudDialogflowV2beta1Intent);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends DialogflowRequest<GoogleCloudDialogflowV2beta1Intent> {
                    private static final String REST_PATH = "v2beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String languageCode;
                    @Key
                    private String updateMask;
                    @Key
                    private String intentView;

                    protected Patch(String string, GoogleCloudDialogflowV2beta1Intent googleCloudDialogflowV2beta1Intent) {
                        super(Dialogflow.this, "PATCH", REST_PATH, (Object)googleCloudDialogflowV2beta1Intent, GoogleCloudDialogflowV2beta1Intent.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/intents/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setBearerToken(String string) {
                        return (Patch)super.setBearerToken(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPp(Boolean bl) {
                        return (Patch)super.setPp(bl);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Patch setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    public String getIntentView() {
                        return this.intentView;
                    }

                    public Patch setIntentView(String string) {
                        this.intentView = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DialogflowRequest<GoogleCloudDialogflowV2beta1ListIntentsResponse> {
                    private static final String REST_PATH = "v2beta1/{+parent}/intents";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String intentView;
                    @Key
                    private String languageCode;
                    @Key
                    private String pageToken;

                    protected List(String string) {
                        super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2beta1ListIntentsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public String getIntentView() {
                        return this.intentView;
                    }

                    public List setIntentView(String string) {
                        this.intentView = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public List setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DialogflowRequest<GoogleCloudDialogflowV2beta1Intent> {
                    private static final String REST_PATH = "v2beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String languageCode;
                    @Key
                    private String intentView;

                    protected Get(String string) {
                        super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2beta1Intent.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/intents/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Get setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    public String getIntentView() {
                        return this.intentView;
                    }

                    public Get setIntentView(String string) {
                        this.intentView = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DialogflowRequest<GoogleProtobufEmpty> {
                    private static final String REST_PATH = "v2beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/intents/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setBearerToken(String string) {
                        return (Delete)super.setBearerToken(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPp(Boolean bl) {
                        return (Delete)super.setPp(bl);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/intents/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends DialogflowRequest<GoogleCloudDialogflowV2beta1Intent> {
                    private static final String REST_PATH = "v2beta1/{+parent}/intents";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String languageCode;
                    @Key
                    private String intentView;

                    protected Create(String string, GoogleCloudDialogflowV2beta1Intent googleCloudDialogflowV2beta1Intent) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1Intent, GoogleCloudDialogflowV2beta1Intent.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setBearerToken(String string) {
                        return (Create)super.setBearerToken(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPp(Boolean bl) {
                        return (Create)super.setPp(bl);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Create setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    public String getIntentView() {
                        return this.intentView;
                    }

                    public Create setIntentView(String string) {
                        this.intentView = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class BatchUpdate
                extends DialogflowRequest<GoogleLongrunningOperation> {
                    private static final String REST_PATH = "v2beta1/{+parent}/intents:batchUpdate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected BatchUpdate(String string, GoogleCloudDialogflowV2beta1BatchUpdateIntentsRequest googleCloudDialogflowV2beta1BatchUpdateIntentsRequest) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1BatchUpdateIntentsRequest, GoogleLongrunningOperation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public BatchUpdate set$Xgafv(String string) {
                        return (BatchUpdate)super.set$Xgafv(string);
                    }

                    public BatchUpdate setAccessToken(String string) {
                        return (BatchUpdate)super.setAccessToken(string);
                    }

                    public BatchUpdate setAlt(String string) {
                        return (BatchUpdate)super.setAlt(string);
                    }

                    public BatchUpdate setBearerToken(String string) {
                        return (BatchUpdate)super.setBearerToken(string);
                    }

                    public BatchUpdate setCallback(String string) {
                        return (BatchUpdate)super.setCallback(string);
                    }

                    public BatchUpdate setFields(String string) {
                        return (BatchUpdate)super.setFields(string);
                    }

                    public BatchUpdate setKey(String string) {
                        return (BatchUpdate)super.setKey(string);
                    }

                    public BatchUpdate setOauthToken(String string) {
                        return (BatchUpdate)super.setOauthToken(string);
                    }

                    public BatchUpdate setPp(Boolean bl) {
                        return (BatchUpdate)super.setPp(bl);
                    }

                    public BatchUpdate setPrettyPrint(Boolean bl) {
                        return (BatchUpdate)super.setPrettyPrint(bl);
                    }

                    public BatchUpdate setQuotaUser(String string) {
                        return (BatchUpdate)super.setQuotaUser(string);
                    }

                    public BatchUpdate setUploadType(String string) {
                        return (BatchUpdate)super.setUploadType(string);
                    }

                    public BatchUpdate setUploadProtocol(String string) {
                        return (BatchUpdate)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public BatchUpdate setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public BatchUpdate set(String string, Object object) {
                        return (BatchUpdate)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class BatchDelete
                extends DialogflowRequest<GoogleLongrunningOperation> {
                    private static final String REST_PATH = "v2beta1/{+parent}/intents:batchDelete";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected BatchDelete(String string, GoogleCloudDialogflowV2beta1BatchDeleteIntentsRequest googleCloudDialogflowV2beta1BatchDeleteIntentsRequest) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1BatchDeleteIntentsRequest, GoogleLongrunningOperation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public BatchDelete set$Xgafv(String string) {
                        return (BatchDelete)super.set$Xgafv(string);
                    }

                    public BatchDelete setAccessToken(String string) {
                        return (BatchDelete)super.setAccessToken(string);
                    }

                    public BatchDelete setAlt(String string) {
                        return (BatchDelete)super.setAlt(string);
                    }

                    public BatchDelete setBearerToken(String string) {
                        return (BatchDelete)super.setBearerToken(string);
                    }

                    public BatchDelete setCallback(String string) {
                        return (BatchDelete)super.setCallback(string);
                    }

                    public BatchDelete setFields(String string) {
                        return (BatchDelete)super.setFields(string);
                    }

                    public BatchDelete setKey(String string) {
                        return (BatchDelete)super.setKey(string);
                    }

                    public BatchDelete setOauthToken(String string) {
                        return (BatchDelete)super.setOauthToken(string);
                    }

                    public BatchDelete setPp(Boolean bl) {
                        return (BatchDelete)super.setPp(bl);
                    }

                    public BatchDelete setPrettyPrint(Boolean bl) {
                        return (BatchDelete)super.setPrettyPrint(bl);
                    }

                    public BatchDelete setQuotaUser(String string) {
                        return (BatchDelete)super.setQuotaUser(string);
                    }

                    public BatchDelete setUploadType(String string) {
                        return (BatchDelete)super.setUploadType(string);
                    }

                    public BatchDelete setUploadProtocol(String string) {
                        return (BatchDelete)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public BatchDelete setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public BatchDelete set(String string, Object object) {
                        return (BatchDelete)super.set(string, object);
                    }
                }
            }

            public class EntityTypes {
                public BatchDelete batchDelete(String string, GoogleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest googleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest) throws IOException {
                    BatchDelete batchDelete = new BatchDelete(string, googleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                    return batchDelete;
                }

                public BatchUpdate batchUpdate(String string, GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest googleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest) throws IOException {
                    BatchUpdate batchUpdate = new BatchUpdate(string, googleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                    return batchUpdate;
                }

                public Create create(String string, GoogleCloudDialogflowV2beta1EntityType googleCloudDialogflowV2beta1EntityType) throws IOException {
                    Create create = new Create(string, googleCloudDialogflowV2beta1EntityType);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, GoogleCloudDialogflowV2beta1EntityType googleCloudDialogflowV2beta1EntityType) throws IOException {
                    Patch patch = new Patch(string, googleCloudDialogflowV2beta1EntityType);
                    Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                public Entities entities() {
                    return new Entities();
                }

                public class Entities {
                    public BatchCreate batchCreate(String string, GoogleCloudDialogflowV2beta1BatchCreateEntitiesRequest googleCloudDialogflowV2beta1BatchCreateEntitiesRequest) throws IOException {
                        BatchCreate batchCreate = new BatchCreate(string, googleCloudDialogflowV2beta1BatchCreateEntitiesRequest);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchCreate);
                        return batchCreate;
                    }

                    public BatchDelete batchDelete(String string, GoogleCloudDialogflowV2beta1BatchDeleteEntitiesRequest googleCloudDialogflowV2beta1BatchDeleteEntitiesRequest) throws IOException {
                        BatchDelete batchDelete = new BatchDelete(string, googleCloudDialogflowV2beta1BatchDeleteEntitiesRequest);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                        return batchDelete;
                    }

                    public BatchUpdate batchUpdate(String string, GoogleCloudDialogflowV2beta1BatchUpdateEntitiesRequest googleCloudDialogflowV2beta1BatchUpdateEntitiesRequest) throws IOException {
                        BatchUpdate batchUpdate = new BatchUpdate(string, googleCloudDialogflowV2beta1BatchUpdateEntitiesRequest);
                        Dialogflow.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                        return batchUpdate;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class BatchUpdate
                    extends DialogflowRequest<GoogleLongrunningOperation> {
                        private static final String REST_PATH = "v2beta1/{+parent}/entities:batchUpdate";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected BatchUpdate(String string, GoogleCloudDialogflowV2beta1BatchUpdateEntitiesRequest googleCloudDialogflowV2beta1BatchUpdateEntitiesRequest) {
                            super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1BatchUpdateEntitiesRequest, GoogleLongrunningOperation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                        }

                        public BatchUpdate set$Xgafv(String string) {
                            return (BatchUpdate)super.set$Xgafv(string);
                        }

                        public BatchUpdate setAccessToken(String string) {
                            return (BatchUpdate)super.setAccessToken(string);
                        }

                        public BatchUpdate setAlt(String string) {
                            return (BatchUpdate)super.setAlt(string);
                        }

                        public BatchUpdate setBearerToken(String string) {
                            return (BatchUpdate)super.setBearerToken(string);
                        }

                        public BatchUpdate setCallback(String string) {
                            return (BatchUpdate)super.setCallback(string);
                        }

                        public BatchUpdate setFields(String string) {
                            return (BatchUpdate)super.setFields(string);
                        }

                        public BatchUpdate setKey(String string) {
                            return (BatchUpdate)super.setKey(string);
                        }

                        public BatchUpdate setOauthToken(String string) {
                            return (BatchUpdate)super.setOauthToken(string);
                        }

                        public BatchUpdate setPp(Boolean bl) {
                            return (BatchUpdate)super.setPp(bl);
                        }

                        public BatchUpdate setPrettyPrint(Boolean bl) {
                            return (BatchUpdate)super.setPrettyPrint(bl);
                        }

                        public BatchUpdate setQuotaUser(String string) {
                            return (BatchUpdate)super.setQuotaUser(string);
                        }

                        public BatchUpdate setUploadType(String string) {
                            return (BatchUpdate)super.setUploadType(string);
                        }

                        public BatchUpdate setUploadProtocol(String string) {
                            return (BatchUpdate)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public BatchUpdate setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public BatchUpdate set(String string, Object object) {
                            return (BatchUpdate)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class BatchDelete
                    extends DialogflowRequest<GoogleLongrunningOperation> {
                        private static final String REST_PATH = "v2beta1/{+parent}/entities:batchDelete";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected BatchDelete(String string, GoogleCloudDialogflowV2beta1BatchDeleteEntitiesRequest googleCloudDialogflowV2beta1BatchDeleteEntitiesRequest) {
                            super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1BatchDeleteEntitiesRequest, GoogleLongrunningOperation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                        }

                        public BatchDelete set$Xgafv(String string) {
                            return (BatchDelete)super.set$Xgafv(string);
                        }

                        public BatchDelete setAccessToken(String string) {
                            return (BatchDelete)super.setAccessToken(string);
                        }

                        public BatchDelete setAlt(String string) {
                            return (BatchDelete)super.setAlt(string);
                        }

                        public BatchDelete setBearerToken(String string) {
                            return (BatchDelete)super.setBearerToken(string);
                        }

                        public BatchDelete setCallback(String string) {
                            return (BatchDelete)super.setCallback(string);
                        }

                        public BatchDelete setFields(String string) {
                            return (BatchDelete)super.setFields(string);
                        }

                        public BatchDelete setKey(String string) {
                            return (BatchDelete)super.setKey(string);
                        }

                        public BatchDelete setOauthToken(String string) {
                            return (BatchDelete)super.setOauthToken(string);
                        }

                        public BatchDelete setPp(Boolean bl) {
                            return (BatchDelete)super.setPp(bl);
                        }

                        public BatchDelete setPrettyPrint(Boolean bl) {
                            return (BatchDelete)super.setPrettyPrint(bl);
                        }

                        public BatchDelete setQuotaUser(String string) {
                            return (BatchDelete)super.setQuotaUser(string);
                        }

                        public BatchDelete setUploadType(String string) {
                            return (BatchDelete)super.setUploadType(string);
                        }

                        public BatchDelete setUploadProtocol(String string) {
                            return (BatchDelete)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public BatchDelete setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public BatchDelete set(String string, Object object) {
                            return (BatchDelete)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class BatchCreate
                    extends DialogflowRequest<GoogleLongrunningOperation> {
                        private static final String REST_PATH = "v2beta1/{+parent}/entities:batchCreate";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected BatchCreate(String string, GoogleCloudDialogflowV2beta1BatchCreateEntitiesRequest googleCloudDialogflowV2beta1BatchCreateEntitiesRequest) {
                            super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1BatchCreateEntitiesRequest, GoogleLongrunningOperation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                        }

                        public BatchCreate set$Xgafv(String string) {
                            return (BatchCreate)super.set$Xgafv(string);
                        }

                        public BatchCreate setAccessToken(String string) {
                            return (BatchCreate)super.setAccessToken(string);
                        }

                        public BatchCreate setAlt(String string) {
                            return (BatchCreate)super.setAlt(string);
                        }

                        public BatchCreate setBearerToken(String string) {
                            return (BatchCreate)super.setBearerToken(string);
                        }

                        public BatchCreate setCallback(String string) {
                            return (BatchCreate)super.setCallback(string);
                        }

                        public BatchCreate setFields(String string) {
                            return (BatchCreate)super.setFields(string);
                        }

                        public BatchCreate setKey(String string) {
                            return (BatchCreate)super.setKey(string);
                        }

                        public BatchCreate setOauthToken(String string) {
                            return (BatchCreate)super.setOauthToken(string);
                        }

                        public BatchCreate setPp(Boolean bl) {
                            return (BatchCreate)super.setPp(bl);
                        }

                        public BatchCreate setPrettyPrint(Boolean bl) {
                            return (BatchCreate)super.setPrettyPrint(bl);
                        }

                        public BatchCreate setQuotaUser(String string) {
                            return (BatchCreate)super.setQuotaUser(string);
                        }

                        public BatchCreate setUploadType(String string) {
                            return (BatchCreate)super.setUploadType(string);
                        }

                        public BatchCreate setUploadProtocol(String string) {
                            return (BatchCreate)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public BatchCreate setParent(String string) {
                            if (!Dialogflow.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public BatchCreate set(String string, Object object) {
                            return (BatchCreate)super.set(string, object);
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends DialogflowRequest<GoogleCloudDialogflowV2beta1EntityType> {
                    private static final String REST_PATH = "v2beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String languageCode;
                    @Key
                    private String updateMask;

                    protected Patch(String string, GoogleCloudDialogflowV2beta1EntityType googleCloudDialogflowV2beta1EntityType) {
                        super(Dialogflow.this, "PATCH", REST_PATH, (Object)googleCloudDialogflowV2beta1EntityType, GoogleCloudDialogflowV2beta1EntityType.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setBearerToken(String string) {
                        return (Patch)super.setBearerToken(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPp(Boolean bl) {
                        return (Patch)super.setPp(bl);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Patch setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DialogflowRequest<GoogleCloudDialogflowV2beta1ListEntityTypesResponse> {
                    private static final String REST_PATH = "v2beta1/{+parent}/entityTypes";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String languageCode;
                    @Key
                    private String pageToken;

                    protected List(String string) {
                        super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2beta1ListEntityTypesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public List setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DialogflowRequest<GoogleCloudDialogflowV2beta1EntityType> {
                    private static final String REST_PATH = "v2beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String languageCode;

                    protected Get(String string) {
                        super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2beta1EntityType.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Get setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DialogflowRequest<GoogleProtobufEmpty> {
                    private static final String REST_PATH = "v2beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Dialogflow.this, "DELETE", REST_PATH, null, GoogleProtobufEmpty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/agent/entityTypes/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setBearerToken(String string) {
                        return (Delete)super.setBearerToken(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPp(Boolean bl) {
                        return (Delete)super.setPp(bl);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/agent/entityTypes/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends DialogflowRequest<GoogleCloudDialogflowV2beta1EntityType> {
                    private static final String REST_PATH = "v2beta1/{+parent}/entityTypes";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String languageCode;

                    protected Create(String string, GoogleCloudDialogflowV2beta1EntityType googleCloudDialogflowV2beta1EntityType) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1EntityType, GoogleCloudDialogflowV2beta1EntityType.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setBearerToken(String string) {
                        return (Create)super.setBearerToken(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPp(Boolean bl) {
                        return (Create)super.setPp(bl);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public Create setLanguageCode(String string) {
                        this.languageCode = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class BatchUpdate
                extends DialogflowRequest<GoogleLongrunningOperation> {
                    private static final String REST_PATH = "v2beta1/{+parent}/entityTypes:batchUpdate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected BatchUpdate(String string, GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest googleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest, GoogleLongrunningOperation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public BatchUpdate set$Xgafv(String string) {
                        return (BatchUpdate)super.set$Xgafv(string);
                    }

                    public BatchUpdate setAccessToken(String string) {
                        return (BatchUpdate)super.setAccessToken(string);
                    }

                    public BatchUpdate setAlt(String string) {
                        return (BatchUpdate)super.setAlt(string);
                    }

                    public BatchUpdate setBearerToken(String string) {
                        return (BatchUpdate)super.setBearerToken(string);
                    }

                    public BatchUpdate setCallback(String string) {
                        return (BatchUpdate)super.setCallback(string);
                    }

                    public BatchUpdate setFields(String string) {
                        return (BatchUpdate)super.setFields(string);
                    }

                    public BatchUpdate setKey(String string) {
                        return (BatchUpdate)super.setKey(string);
                    }

                    public BatchUpdate setOauthToken(String string) {
                        return (BatchUpdate)super.setOauthToken(string);
                    }

                    public BatchUpdate setPp(Boolean bl) {
                        return (BatchUpdate)super.setPp(bl);
                    }

                    public BatchUpdate setPrettyPrint(Boolean bl) {
                        return (BatchUpdate)super.setPrettyPrint(bl);
                    }

                    public BatchUpdate setQuotaUser(String string) {
                        return (BatchUpdate)super.setQuotaUser(string);
                    }

                    public BatchUpdate setUploadType(String string) {
                        return (BatchUpdate)super.setUploadType(string);
                    }

                    public BatchUpdate setUploadProtocol(String string) {
                        return (BatchUpdate)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public BatchUpdate setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public BatchUpdate set(String string, Object object) {
                        return (BatchUpdate)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class BatchDelete
                extends DialogflowRequest<GoogleLongrunningOperation> {
                    private static final String REST_PATH = "v2beta1/{+parent}/entityTypes:batchDelete";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected BatchDelete(String string, GoogleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest googleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest) {
                        super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest, GoogleLongrunningOperation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/agent$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                    }

                    public BatchDelete set$Xgafv(String string) {
                        return (BatchDelete)super.set$Xgafv(string);
                    }

                    public BatchDelete setAccessToken(String string) {
                        return (BatchDelete)super.setAccessToken(string);
                    }

                    public BatchDelete setAlt(String string) {
                        return (BatchDelete)super.setAlt(string);
                    }

                    public BatchDelete setBearerToken(String string) {
                        return (BatchDelete)super.setBearerToken(string);
                    }

                    public BatchDelete setCallback(String string) {
                        return (BatchDelete)super.setCallback(string);
                    }

                    public BatchDelete setFields(String string) {
                        return (BatchDelete)super.setFields(string);
                    }

                    public BatchDelete setKey(String string) {
                        return (BatchDelete)super.setKey(string);
                    }

                    public BatchDelete setOauthToken(String string) {
                        return (BatchDelete)super.setOauthToken(string);
                    }

                    public BatchDelete setPp(Boolean bl) {
                        return (BatchDelete)super.setPp(bl);
                    }

                    public BatchDelete setPrettyPrint(Boolean bl) {
                        return (BatchDelete)super.setPrettyPrint(bl);
                    }

                    public BatchDelete setQuotaUser(String string) {
                        return (BatchDelete)super.setQuotaUser(string);
                    }

                    public BatchDelete setUploadType(String string) {
                        return (BatchDelete)super.setUploadType(string);
                    }

                    public BatchDelete setUploadProtocol(String string) {
                        return (BatchDelete)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public BatchDelete setParent(String string) {
                        if (!Dialogflow.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/agent$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public BatchDelete set(String string, Object object) {
                        return (BatchDelete)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Train
            extends DialogflowRequest<GoogleLongrunningOperation> {
                private static final String REST_PATH = "v2beta1/{+parent}/agent:train";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Train(String string, GoogleCloudDialogflowV2beta1TrainAgentRequest googleCloudDialogflowV2beta1TrainAgentRequest) {
                    super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1TrainAgentRequest, GoogleLongrunningOperation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Train set$Xgafv(String string) {
                    return (Train)super.set$Xgafv(string);
                }

                public Train setAccessToken(String string) {
                    return (Train)super.setAccessToken(string);
                }

                public Train setAlt(String string) {
                    return (Train)super.setAlt(string);
                }

                public Train setBearerToken(String string) {
                    return (Train)super.setBearerToken(string);
                }

                public Train setCallback(String string) {
                    return (Train)super.setCallback(string);
                }

                public Train setFields(String string) {
                    return (Train)super.setFields(string);
                }

                public Train setKey(String string) {
                    return (Train)super.setKey(string);
                }

                public Train setOauthToken(String string) {
                    return (Train)super.setOauthToken(string);
                }

                public Train setPp(Boolean bl) {
                    return (Train)super.setPp(bl);
                }

                public Train setPrettyPrint(Boolean bl) {
                    return (Train)super.setPrettyPrint(bl);
                }

                public Train setQuotaUser(String string) {
                    return (Train)super.setQuotaUser(string);
                }

                public Train setUploadType(String string) {
                    return (Train)super.setUploadType(string);
                }

                public Train setUploadProtocol(String string) {
                    return (Train)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Train setParent(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Train set(String string, Object object) {
                    return (Train)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Search
            extends DialogflowRequest<GoogleCloudDialogflowV2beta1SearchAgentsResponse> {
                private static final String REST_PATH = "v2beta1/{+parent}/agent:search";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected Search(String string) {
                    super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2beta1SearchAgentsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Search set$Xgafv(String string) {
                    return (Search)super.set$Xgafv(string);
                }

                public Search setAccessToken(String string) {
                    return (Search)super.setAccessToken(string);
                }

                public Search setAlt(String string) {
                    return (Search)super.setAlt(string);
                }

                public Search setBearerToken(String string) {
                    return (Search)super.setBearerToken(string);
                }

                public Search setCallback(String string) {
                    return (Search)super.setCallback(string);
                }

                public Search setFields(String string) {
                    return (Search)super.setFields(string);
                }

                public Search setKey(String string) {
                    return (Search)super.setKey(string);
                }

                public Search setOauthToken(String string) {
                    return (Search)super.setOauthToken(string);
                }

                public Search setPp(Boolean bl) {
                    return (Search)super.setPp(bl);
                }

                public Search setPrettyPrint(Boolean bl) {
                    return (Search)super.setPrettyPrint(bl);
                }

                public Search setQuotaUser(String string) {
                    return (Search)super.setQuotaUser(string);
                }

                public Search setUploadType(String string) {
                    return (Search)super.setUploadType(string);
                }

                public Search setUploadProtocol(String string) {
                    return (Search)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Search setParent(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public Search setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public Search setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public Search set(String string, Object object) {
                    return (Search)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Restore
            extends DialogflowRequest<GoogleLongrunningOperation> {
                private static final String REST_PATH = "v2beta1/{+parent}/agent:restore";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Restore(String string, GoogleCloudDialogflowV2beta1RestoreAgentRequest googleCloudDialogflowV2beta1RestoreAgentRequest) {
                    super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1RestoreAgentRequest, GoogleLongrunningOperation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Restore set$Xgafv(String string) {
                    return (Restore)super.set$Xgafv(string);
                }

                public Restore setAccessToken(String string) {
                    return (Restore)super.setAccessToken(string);
                }

                public Restore setAlt(String string) {
                    return (Restore)super.setAlt(string);
                }

                public Restore setBearerToken(String string) {
                    return (Restore)super.setBearerToken(string);
                }

                public Restore setCallback(String string) {
                    return (Restore)super.setCallback(string);
                }

                public Restore setFields(String string) {
                    return (Restore)super.setFields(string);
                }

                public Restore setKey(String string) {
                    return (Restore)super.setKey(string);
                }

                public Restore setOauthToken(String string) {
                    return (Restore)super.setOauthToken(string);
                }

                public Restore setPp(Boolean bl) {
                    return (Restore)super.setPp(bl);
                }

                public Restore setPrettyPrint(Boolean bl) {
                    return (Restore)super.setPrettyPrint(bl);
                }

                public Restore setQuotaUser(String string) {
                    return (Restore)super.setQuotaUser(string);
                }

                public Restore setUploadType(String string) {
                    return (Restore)super.setUploadType(string);
                }

                public Restore setUploadProtocol(String string) {
                    return (Restore)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Restore setParent(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Restore set(String string, Object object) {
                    return (Restore)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class DialogflowImport
            extends DialogflowRequest<GoogleLongrunningOperation> {
                private static final String REST_PATH = "v2beta1/{+parent}/agent:import";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected DialogflowImport(String string, GoogleCloudDialogflowV2beta1ImportAgentRequest googleCloudDialogflowV2beta1ImportAgentRequest) {
                    super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1ImportAgentRequest, GoogleLongrunningOperation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public DialogflowImport set$Xgafv(String string) {
                    return (DialogflowImport)super.set$Xgafv(string);
                }

                public DialogflowImport setAccessToken(String string) {
                    return (DialogflowImport)super.setAccessToken(string);
                }

                public DialogflowImport setAlt(String string) {
                    return (DialogflowImport)super.setAlt(string);
                }

                public DialogflowImport setBearerToken(String string) {
                    return (DialogflowImport)super.setBearerToken(string);
                }

                public DialogflowImport setCallback(String string) {
                    return (DialogflowImport)super.setCallback(string);
                }

                public DialogflowImport setFields(String string) {
                    return (DialogflowImport)super.setFields(string);
                }

                public DialogflowImport setKey(String string) {
                    return (DialogflowImport)super.setKey(string);
                }

                public DialogflowImport setOauthToken(String string) {
                    return (DialogflowImport)super.setOauthToken(string);
                }

                public DialogflowImport setPp(Boolean bl) {
                    return (DialogflowImport)super.setPp(bl);
                }

                public DialogflowImport setPrettyPrint(Boolean bl) {
                    return (DialogflowImport)super.setPrettyPrint(bl);
                }

                public DialogflowImport setQuotaUser(String string) {
                    return (DialogflowImport)super.setQuotaUser(string);
                }

                public DialogflowImport setUploadType(String string) {
                    return (DialogflowImport)super.setUploadType(string);
                }

                public DialogflowImport setUploadProtocol(String string) {
                    return (DialogflowImport)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public DialogflowImport setParent(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public DialogflowImport set(String string, Object object) {
                    return (DialogflowImport)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Export
            extends DialogflowRequest<GoogleLongrunningOperation> {
                private static final String REST_PATH = "v2beta1/{+parent}/agent:export";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Export(String string, GoogleCloudDialogflowV2beta1ExportAgentRequest googleCloudDialogflowV2beta1ExportAgentRequest) {
                    super(Dialogflow.this, "POST", REST_PATH, (Object)googleCloudDialogflowV2beta1ExportAgentRequest, GoogleLongrunningOperation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Export set$Xgafv(String string) {
                    return (Export)super.set$Xgafv(string);
                }

                public Export setAccessToken(String string) {
                    return (Export)super.setAccessToken(string);
                }

                public Export setAlt(String string) {
                    return (Export)super.setAlt(string);
                }

                public Export setBearerToken(String string) {
                    return (Export)super.setBearerToken(string);
                }

                public Export setCallback(String string) {
                    return (Export)super.setCallback(string);
                }

                public Export setFields(String string) {
                    return (Export)super.setFields(string);
                }

                public Export setKey(String string) {
                    return (Export)super.setKey(string);
                }

                public Export setOauthToken(String string) {
                    return (Export)super.setOauthToken(string);
                }

                public Export setPp(Boolean bl) {
                    return (Export)super.setPp(bl);
                }

                public Export setPrettyPrint(Boolean bl) {
                    return (Export)super.setPrettyPrint(bl);
                }

                public Export setQuotaUser(String string) {
                    return (Export)super.setQuotaUser(string);
                }

                public Export setUploadType(String string) {
                    return (Export)super.setUploadType(string);
                }

                public Export setUploadProtocol(String string) {
                    return (Export)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Export setParent(String string) {
                    if (!Dialogflow.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Export set(String string, Object object) {
                    return (Export)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetAgent
        extends DialogflowRequest<GoogleCloudDialogflowV2beta1Agent> {
            private static final String REST_PATH = "v2beta1/{+parent}/agent";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected GetAgent(String string) {
                super(Dialogflow.this, "GET", REST_PATH, null, GoogleCloudDialogflowV2beta1Agent.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                if (!Dialogflow.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetAgent set$Xgafv(String string) {
                return (GetAgent)super.set$Xgafv(string);
            }

            public GetAgent setAccessToken(String string) {
                return (GetAgent)super.setAccessToken(string);
            }

            public GetAgent setAlt(String string) {
                return (GetAgent)super.setAlt(string);
            }

            public GetAgent setBearerToken(String string) {
                return (GetAgent)super.setBearerToken(string);
            }

            public GetAgent setCallback(String string) {
                return (GetAgent)super.setCallback(string);
            }

            public GetAgent setFields(String string) {
                return (GetAgent)super.setFields(string);
            }

            public GetAgent setKey(String string) {
                return (GetAgent)super.setKey(string);
            }

            public GetAgent setOauthToken(String string) {
                return (GetAgent)super.setOauthToken(string);
            }

            public GetAgent setPp(Boolean bl) {
                return (GetAgent)super.setPp(bl);
            }

            public GetAgent setPrettyPrint(Boolean bl) {
                return (GetAgent)super.setPrettyPrint(bl);
            }

            public GetAgent setQuotaUser(String string) {
                return (GetAgent)super.setQuotaUser(string);
            }

            public GetAgent setUploadType(String string) {
                return (GetAgent)super.setUploadType(string);
            }

            public GetAgent setUploadProtocol(String string) {
                return (GetAgent)super.setUploadProtocol(string);
            }

            public String getParent() {
                return this.parent;
            }

            public GetAgent setParent(String string) {
                if (!Dialogflow.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = string;
                return this;
            }

            @Override
            public GetAgent set(String string, Object object) {
                return (GetAgent)super.set(string, object);
            }
        }
    }
}

