/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.discovery;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.discovery.DiscoveryRequest;
import com.google.api.services.discovery.DiscoveryRequestInitializer;
import com.google.api.services.discovery.model.DirectoryList;
import com.google.api.services.discovery.model.RestDescription;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Discovery
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "discovery/v1/";
    public static final String DEFAULT_BATCH_PATH = "batch/discovery/v1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/discovery/v1/";

    public Discovery(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Discovery(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Apis apis() {
        return new Apis();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the API Discovery Service library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Discovery.DEFAULT_ROOT_URL, Discovery.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Discovery.DEFAULT_BATCH_PATH);
        }

        public Discovery build() {
            return new Discovery(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDiscoveryRequestInitializer(DiscoveryRequestInitializer discoveryRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)discoveryRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Apis {
        public GetRest getRest(String string, String string2) throws IOException {
            GetRest getRest = new GetRest(string, string2);
            Discovery.this.initialize((AbstractGoogleClientRequest<?>)getRest);
            return getRest;
        }

        public List list() throws IOException {
            List list = new List();
            Discovery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DiscoveryRequest<DirectoryList> {
            private static final String REST_PATH = "apis";
            @Key
            private String name;
            @Key
            private Boolean preferred;

            protected List() {
                super(Discovery.this, "GET", REST_PATH, null, DirectoryList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String string) {
                this.name = string;
                return this;
            }

            public Boolean getPreferred() {
                return this.preferred;
            }

            public List setPreferred(Boolean bl) {
                this.preferred = bl;
                return this;
            }

            public boolean isPreferred() {
                if (this.preferred == null || this.preferred == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.preferred;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetRest
        extends DiscoveryRequest<RestDescription> {
            private static final String REST_PATH = "apis/{api}/{version}/rest";
            @Key
            private String api;
            @Key
            private String version;

            protected GetRest(String string, String string2) {
                super(Discovery.this, "GET", REST_PATH, null, RestDescription.class);
                this.api = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter api must be specified.");
                this.version = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter version must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetRest setAlt(String string) {
                return (GetRest)super.setAlt(string);
            }

            public GetRest setFields(String string) {
                return (GetRest)super.setFields(string);
            }

            public GetRest setKey(String string) {
                return (GetRest)super.setKey(string);
            }

            public GetRest setOauthToken(String string) {
                return (GetRest)super.setOauthToken(string);
            }

            public GetRest setPrettyPrint(Boolean bl) {
                return (GetRest)super.setPrettyPrint(bl);
            }

            public GetRest setQuotaUser(String string) {
                return (GetRest)super.setQuotaUser(string);
            }

            public GetRest setUserIp(String string) {
                return (GetRest)super.setUserIp(string);
            }

            public String getApi() {
                return this.api;
            }

            public GetRest setApi(String string) {
                this.api = string;
                return this;
            }

            public String getVersion() {
                return this.version;
            }

            public GetRest setVersion(String string) {
                this.version = string;
                return this;
            }

            @Override
            public GetRest set(String string, Object object) {
                return (GetRest)super.set(string, object);
            }
        }
    }
}

