/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.dns;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.dns.DnsRequest;
import com.google.api.services.dns.DnsRequestInitializer;
import com.google.api.services.dns.model.Change;
import com.google.api.services.dns.model.ChangesListResponse;
import com.google.api.services.dns.model.DnsKey;
import com.google.api.services.dns.model.DnsKeysListResponse;
import com.google.api.services.dns.model.ManagedZone;
import com.google.api.services.dns.model.ManagedZoneOperationsListResponse;
import com.google.api.services.dns.model.ManagedZonesListResponse;
import com.google.api.services.dns.model.Operation;
import com.google.api.services.dns.model.Project;
import com.google.api.services.dns.model.ResourceRecordSetsListResponse;
import java.io.IOException;

public class Dns
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "dns/v1/projects/";
    public static final String DEFAULT_BATCH_PATH = "batch/dns/v1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/dns/v1/projects/";

    public Dns(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Dns(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Changes changes() {
        return new Changes();
    }

    public DnsKeys dnsKeys() {
        return new DnsKeys();
    }

    public ManagedZoneOperations managedZoneOperations() {
        return new ManagedZoneOperations();
    }

    public ManagedZones managedZones() {
        return new ManagedZones();
    }

    public Projects projects() {
        return new Projects();
    }

    public ResourceRecordSets resourceRecordSets() {
        return new ResourceRecordSets();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.28.0 of the Google Cloud DNS API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Dns.DEFAULT_ROOT_URL, Dns.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Dns.DEFAULT_BATCH_PATH);
        }

        public Dns build() {
            return new Dns(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDnsRequestInitializer(DnsRequestInitializer dnsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)dnsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class ResourceRecordSets {
        public List list(String project, String managedZone) throws IOException {
            List result = new List(project, managedZone);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DnsRequest<ResourceRecordSetsListResponse> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/rrsets";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private Integer maxResults;
            @Key
            private String name;
            @Key
            private String pageToken;
            @Key
            private String type;

            protected List(String project, String managedZone) {
                super(Dns.this, "GET", REST_PATH, null, ResourceRecordSetsListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public List setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                this.name = name;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public List setType(String type) {
                this.type = type;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public Get get(String project) throws IOException {
            Get result = new Get(project);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends DnsRequest<Project> {
            private static final String REST_PATH = "{project}";
            @Key
            private String project;
            @Key
            private String clientOperationId;

            protected Get(String project) {
                super(Dns.this, "GET", REST_PATH, null, Project.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Get setClientOperationId(String clientOperationId) {
                this.clientOperationId = clientOperationId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class ManagedZones {
        public Create create(String project, ManagedZone content) throws IOException {
            Create result = new Create(project, content);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String managedZone) throws IOException {
            Delete result = new Delete(project, managedZone);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String managedZone) throws IOException {
            Get result = new Get(project, managedZone);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String managedZone, ManagedZone content) throws IOException {
            Patch result = new Patch(project, managedZone, content);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String project, String managedZone, ManagedZone content) throws IOException {
            Update result = new Update(project, managedZone, content);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DnsRequest<Operation> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String clientOperationId;

            protected Update(String project, String managedZone, ManagedZone content) {
                super(Dns.this, "PUT", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Update setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Update setClientOperationId(String clientOperationId) {
                this.clientOperationId = clientOperationId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DnsRequest<Operation> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String clientOperationId;

            protected Patch(String project, String managedZone, ManagedZone content) {
                super(Dns.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Patch setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Patch setClientOperationId(String clientOperationId) {
                this.clientOperationId = clientOperationId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DnsRequest<ManagedZonesListResponse> {
            private static final String REST_PATH = "{project}/managedZones";
            @Key
            private String project;
            @Key
            private String dnsName;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String project) {
                super(Dns.this, "GET", REST_PATH, null, ManagedZonesListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public String getDnsName() {
                return this.dnsName;
            }

            public List setDnsName(String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DnsRequest<ManagedZone> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String clientOperationId;

            protected Get(String project, String managedZone) {
                super(Dns.this, "GET", REST_PATH, null, ManagedZone.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Get setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Get setClientOperationId(String clientOperationId) {
                this.clientOperationId = clientOperationId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DnsRequest<Void> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String clientOperationId;

            protected Delete(String project, String managedZone) {
                super(Dns.this, "DELETE", REST_PATH, null, Void.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Delete setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Delete setClientOperationId(String clientOperationId) {
                this.clientOperationId = clientOperationId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DnsRequest<ManagedZone> {
            private static final String REST_PATH = "{project}/managedZones";
            @Key
            private String project;
            @Key
            private String clientOperationId;

            protected Create(String project, ManagedZone content) {
                super(Dns.this, "POST", REST_PATH, (Object)content, ManagedZone.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUserIp(String userIp) {
                return (Create)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Create setProject(String project) {
                this.project = project;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Create setClientOperationId(String clientOperationId) {
                this.clientOperationId = clientOperationId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class ManagedZoneOperations {
        public Get get(String project, String managedZone, String operation) throws IOException {
            Get result = new Get(project, managedZone, operation);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String managedZone) throws IOException {
            List result = new List(project, managedZone);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DnsRequest<ManagedZoneOperationsListResponse> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/operations";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortBy;

            protected List(String project, String managedZone) {
                super(Dns.this, "GET", REST_PATH, null, ManagedZoneOperationsListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public List setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSortBy() {
                return this.sortBy;
            }

            public List setSortBy(String sortBy) {
                this.sortBy = sortBy;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DnsRequest<Operation> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/operations/{operation}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String operation;
            @Key
            private String clientOperationId;

            protected Get(String project, String managedZone, String operation) {
                super(Dns.this, "GET", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
                this.operation = (String)Preconditions.checkNotNull((Object)operation, (Object)"Required parameter operation must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Get setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String operation) {
                this.operation = operation;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Get setClientOperationId(String clientOperationId) {
                this.clientOperationId = clientOperationId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class DnsKeys {
        public Get get(String project, String managedZone, String dnsKeyId) throws IOException {
            Get result = new Get(project, managedZone, dnsKeyId);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String managedZone) throws IOException {
            List result = new List(project, managedZone);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DnsRequest<DnsKeysListResponse> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/dnsKeys";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String digestType;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String project, String managedZone) {
                super(Dns.this, "GET", REST_PATH, null, DnsKeysListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public List setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public String getDigestType() {
                return this.digestType;
            }

            public List setDigestType(String digestType) {
                this.digestType = digestType;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DnsRequest<DnsKey> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/dnsKeys/{dnsKeyId}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String dnsKeyId;
            @Key
            private String clientOperationId;
            @Key
            private String digestType;

            protected Get(String project, String managedZone, String dnsKeyId) {
                super(Dns.this, "GET", REST_PATH, null, DnsKey.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
                this.dnsKeyId = (String)Preconditions.checkNotNull((Object)dnsKeyId, (Object)"Required parameter dnsKeyId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Get setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public String getDnsKeyId() {
                return this.dnsKeyId;
            }

            public Get setDnsKeyId(String dnsKeyId) {
                this.dnsKeyId = dnsKeyId;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Get setClientOperationId(String clientOperationId) {
                this.clientOperationId = clientOperationId;
                return this;
            }

            public String getDigestType() {
                return this.digestType;
            }

            public Get setDigestType(String digestType) {
                this.digestType = digestType;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Changes {
        public Create create(String project, String managedZone, Change content) throws IOException {
            Create result = new Create(project, managedZone, content);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String managedZone, String changeId) throws IOException {
            Get result = new Get(project, managedZone, changeId);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String managedZone) throws IOException {
            List result = new List(project, managedZone);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DnsRequest<ChangesListResponse> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortBy;
            @Key
            private String sortOrder;

            protected List(String project, String managedZone) {
                super(Dns.this, "GET", REST_PATH, null, ChangesListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public List setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSortBy() {
                return this.sortBy;
            }

            public List setSortBy(String sortBy) {
                this.sortBy = sortBy;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DnsRequest<Change> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes/{changeId}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String changeId;
            @Key
            private String clientOperationId;

            protected Get(String project, String managedZone, String changeId) {
                super(Dns.this, "GET", REST_PATH, null, Change.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
                this.changeId = (String)Preconditions.checkNotNull((Object)changeId, (Object)"Required parameter changeId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Get setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public String getChangeId() {
                return this.changeId;
            }

            public Get setChangeId(String changeId) {
                this.changeId = changeId;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Get setClientOperationId(String clientOperationId) {
                this.clientOperationId = clientOperationId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Create
        extends DnsRequest<Change> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String clientOperationId;

            protected Create(String project, String managedZone, Change content) {
                super(Dns.this, "POST", REST_PATH, (Object)content, Change.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)managedZone, (Object)"Required parameter managedZone must be specified.");
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUserIp(String userIp) {
                return (Create)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Create setProject(String project) {
                this.project = project;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Create setManagedZone(String managedZone) {
                this.managedZone = managedZone;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Create setClientOperationId(String clientOperationId) {
                this.clientOperationId = clientOperationId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }
}

