/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dns;

/**
 * Service definition for Dns (v1).
 *
 * <p>
 * 
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/dns/docs" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link DnsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Dns extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the Cloud DNS API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://dns.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://dns.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Dns(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Dns(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Changes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.Changes.List request = dns.changes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Changes changes() {
    return new Changes();
  }

  /**
   * The "changes" collection of methods.
   */
  public class Changes {

    /**
     * Atomically updates the ResourceRecordSet collection.
     *
     * Create a request for the method "changes.create".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @param content the {@link com.google.api.services.dns.model.Change}
     * @return the request
     */
    public Create create(java.lang.String project, java.lang.String managedZone, com.google.api.services.dns.model.Change content) throws java.io.IOException {
      Create result = new Create(project, managedZone, content);
      initialize(result);
      return result;
    }

    public class Create extends DnsRequest<com.google.api.services.dns.model.Change> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/changes";

      /**
       * Atomically updates the ResourceRecordSet collection.
       *
       * Create a request for the method "changes.create".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @param content the {@link com.google.api.services.dns.model.Change}
       * @since 1.13
       */
      protected Create(java.lang.String project, java.lang.String managedZone, com.google.api.services.dns.model.Change content) {
        super(Dns.this, "POST", REST_PATH, content, com.google.api.services.dns.model.Change.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Create setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public Create setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Create setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Fetches the representation of an existing Change.
     *
     * Create a request for the method "changes.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @param changeId The identifier of the requested change, from a previous ResourceRecordSetsChangeResponse.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String managedZone, java.lang.String changeId) throws java.io.IOException {
      Get result = new Get(project, managedZone, changeId);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.Change> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/changes/{changeId}";

      /**
       * Fetches the representation of an existing Change.
       *
       * Create a request for the method "changes.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @param changeId The identifier of the requested change, from a previous ResourceRecordSetsChangeResponse.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String managedZone, java.lang.String changeId) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.Change.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
        this.changeId = com.google.api.client.util.Preconditions.checkNotNull(changeId, "Required parameter changeId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public Get setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * The identifier of the requested change, from a previous ResourceRecordSetsChangeResponse.
       */
      @com.google.api.client.util.Key
      private java.lang.String changeId;

      /** The identifier of the requested change, from a previous ResourceRecordSetsChangeResponse.
       */
      public java.lang.String getChangeId() {
        return changeId;
      }

      /**
       * The identifier of the requested change, from a previous ResourceRecordSetsChangeResponse.
       */
      public Get setChangeId(java.lang.String changeId) {
        this.changeId = changeId;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Get setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Enumerates Changes to a ResourceRecordSet collection.
     *
     * Create a request for the method "changes.list".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String managedZone) throws java.io.IOException {
      List result = new List(project, managedZone);
      initialize(result);
      return result;
    }

    public class List extends DnsRequest<com.google.api.services.dns.model.ChangesListResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/changes";

      /**
       * Enumerates Changes to a ResourceRecordSet collection.
       *
       * Create a request for the method "changes.list".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String managedZone) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ChangesListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public List setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Optional. Maximum number of results to be returned. If unspecified, the server decides how many
     results to return.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A tag returned by a previous list request that was truncated. Use this parameter to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Sorting criterion. The only supported value is change sequence. */
      @com.google.api.client.util.Key
      private java.lang.String sortBy;

      /** Sorting criterion. The only supported value is change sequence. [default: changeSequence]
       */
      public java.lang.String getSortBy() {
        return sortBy;
      }

      /** Sorting criterion. The only supported value is change sequence. */
      public List setSortBy(java.lang.String sortBy) {
        this.sortBy = sortBy;
        return this;
      }

      /** Sorting order direction: 'ascending' or 'descending'. */
      @com.google.api.client.util.Key
      private java.lang.String sortOrder;

      /** Sorting order direction: 'ascending' or 'descending'.
       */
      public java.lang.String getSortOrder() {
        return sortOrder;
      }

      /** Sorting order direction: 'ascending' or 'descending'. */
      public List setSortOrder(java.lang.String sortOrder) {
        this.sortOrder = sortOrder;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the DnsKeys collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.DnsKeys.List request = dns.dnsKeys().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public DnsKeys dnsKeys() {
    return new DnsKeys();
  }

  /**
   * The "dnsKeys" collection of methods.
   */
  public class DnsKeys {

    /**
     * Fetches the representation of an existing DnsKey.
     *
     * Create a request for the method "dnsKeys.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @param dnsKeyId The identifier of the requested DnsKey.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String managedZone, java.lang.String dnsKeyId) throws java.io.IOException {
      Get result = new Get(project, managedZone, dnsKeyId);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.DnsKey> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/dnsKeys/{dnsKeyId}";

      /**
       * Fetches the representation of an existing DnsKey.
       *
       * Create a request for the method "dnsKeys.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @param dnsKeyId The identifier of the requested DnsKey.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String managedZone, java.lang.String dnsKeyId) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.DnsKey.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
        this.dnsKeyId = com.google.api.client.util.Preconditions.checkNotNull(dnsKeyId, "Required parameter dnsKeyId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public Get setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /** The identifier of the requested DnsKey. */
      @com.google.api.client.util.Key
      private java.lang.String dnsKeyId;

      /** The identifier of the requested DnsKey.
       */
      public java.lang.String getDnsKeyId() {
        return dnsKeyId;
      }

      /** The identifier of the requested DnsKey. */
      public Get setDnsKeyId(java.lang.String dnsKeyId) {
        this.dnsKeyId = dnsKeyId;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Get setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      /**
       * An optional comma-separated list of digest types to compute and display for key signing
       * keys. If omitted, the recommended digest type is computed and displayed.
       */
      @com.google.api.client.util.Key
      private java.lang.String digestType;

      /** An optional comma-separated list of digest types to compute and display for key signing keys. If
     omitted, the recommended digest type is computed and displayed.
       */
      public java.lang.String getDigestType() {
        return digestType;
      }

      /**
       * An optional comma-separated list of digest types to compute and display for key signing
       * keys. If omitted, the recommended digest type is computed and displayed.
       */
      public Get setDigestType(java.lang.String digestType) {
        this.digestType = digestType;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Enumerates DnsKeys to a ResourceRecordSet collection.
     *
     * Create a request for the method "dnsKeys.list".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String managedZone) throws java.io.IOException {
      List result = new List(project, managedZone);
      initialize(result);
      return result;
    }

    public class List extends DnsRequest<com.google.api.services.dns.model.DnsKeysListResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/dnsKeys";

      /**
       * Enumerates DnsKeys to a ResourceRecordSet collection.
       *
       * Create a request for the method "dnsKeys.list".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String managedZone) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.DnsKeysListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public List setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * An optional comma-separated list of digest types to compute and display for key signing
       * keys. If omitted, the recommended digest type is computed and displayed.
       */
      @com.google.api.client.util.Key
      private java.lang.String digestType;

      /** An optional comma-separated list of digest types to compute and display for key signing keys. If
     omitted, the recommended digest type is computed and displayed.
       */
      public java.lang.String getDigestType() {
        return digestType;
      }

      /**
       * An optional comma-separated list of digest types to compute and display for key signing
       * keys. If omitted, the recommended digest type is computed and displayed.
       */
      public List setDigestType(java.lang.String digestType) {
        this.digestType = digestType;
        return this;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Optional. Maximum number of results to be returned. If unspecified, the server decides how many
     results to return.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A tag returned by a previous list request that was truncated. Use this parameter to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ManagedZoneOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.ManagedZoneOperations.List request = dns.managedZoneOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ManagedZoneOperations managedZoneOperations() {
    return new ManagedZoneOperations();
  }

  /**
   * The "managedZoneOperations" collection of methods.
   */
  public class ManagedZoneOperations {

    /**
     * Fetches the representation of an existing Operation.
     *
     * Create a request for the method "managedZoneOperations.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request.
     * @param operation Identifies the operation addressed by this request (ID of the operation).
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String managedZone, java.lang.String operation) throws java.io.IOException {
      Get result = new Get(project, managedZone, operation);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.Operation> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/operations/{operation}";

      /**
       * Fetches the representation of an existing Operation.
       *
       * Create a request for the method "managedZoneOperations.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request.
       * @param operation Identifies the operation addressed by this request (ID of the operation).
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String managedZone, java.lang.String operation) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Identifies the managed zone addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /** Identifies the managed zone addressed by this request. */
      public Get setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /** Identifies the operation addressed by this request (ID of the operation). */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Identifies the operation addressed by this request (ID of the operation).
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Identifies the operation addressed by this request (ID of the operation). */
      public Get setOperation(java.lang.String operation) {
        this.operation = operation;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Get setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Enumerates Operations for the given ManagedZone.
     *
     * Create a request for the method "managedZoneOperations.list".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String managedZone) throws java.io.IOException {
      List result = new List(project, managedZone);
      initialize(result);
      return result;
    }

    public class List extends DnsRequest<com.google.api.services.dns.model.ManagedZoneOperationsListResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/operations";

      /**
       * Enumerates Operations for the given ManagedZone.
       *
       * Create a request for the method "managedZoneOperations.list".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String managedZone) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ManagedZoneOperationsListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Identifies the managed zone addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /** Identifies the managed zone addressed by this request. */
      public List setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Optional. Maximum number of results to be returned. If unspecified, the server decides how many
     results to return.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A tag returned by a previous list request that was truncated. Use this parameter to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Sorting criterion. The only supported values are START_TIME and ID. */
      @com.google.api.client.util.Key
      private java.lang.String sortBy;

      /** Sorting criterion. The only supported values are START_TIME and ID. [default: startTime]
       */
      public java.lang.String getSortBy() {
        return sortBy;
      }

      /** Sorting criterion. The only supported values are START_TIME and ID. */
      public List setSortBy(java.lang.String sortBy) {
        this.sortBy = sortBy;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ManagedZones collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.ManagedZones.List request = dns.managedZones().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ManagedZones managedZones() {
    return new ManagedZones();
  }

  /**
   * The "managedZones" collection of methods.
   */
  public class ManagedZones {

    /**
     * Creates a new ManagedZone.
     *
     * Create a request for the method "managedZones.create".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param content the {@link com.google.api.services.dns.model.ManagedZone}
     * @return the request
     */
    public Create create(java.lang.String project, com.google.api.services.dns.model.ManagedZone content) throws java.io.IOException {
      Create result = new Create(project, content);
      initialize(result);
      return result;
    }

    public class Create extends DnsRequest<com.google.api.services.dns.model.ManagedZone> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones";

      /**
       * Creates a new ManagedZone.
       *
       * Create a request for the method "managedZones.create".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param content the {@link com.google.api.services.dns.model.ManagedZone}
       * @since 1.13
       */
      protected Create(java.lang.String project, com.google.api.services.dns.model.ManagedZone content) {
        super(Dns.this, "POST", REST_PATH, content, com.google.api.services.dns.model.ManagedZone.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Create setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Create setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a previously created ManagedZone.
     *
     * Create a request for the method "managedZones.delete".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String managedZone) throws java.io.IOException {
      Delete result = new Delete(project, managedZone);
      initialize(result);
      return result;
    }

    public class Delete extends DnsRequest<Void> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}";

      /**
       * Deletes a previously created ManagedZone.
       *
       * Create a request for the method "managedZones.delete".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String managedZone) {
        super(Dns.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Delete setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public Delete setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Delete setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Fetches the representation of an existing ManagedZone.
     *
     * Create a request for the method "managedZones.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String managedZone) throws java.io.IOException {
      Get result = new Get(project, managedZone);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.ManagedZone> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}";

      /**
       * Fetches the representation of an existing ManagedZone.
       *
       * Create a request for the method "managedZones.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String managedZone) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ManagedZone.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public Get setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Get setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
     * does not have a policy set.
     *
     * Create a request for the method "managedZones.getIamPolicy".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
     * @param content the {@link com.google.api.services.dns.model.GoogleIamV1GetIamPolicyRequest}
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String resource, com.google.api.services.dns.model.GoogleIamV1GetIamPolicyRequest content) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends DnsRequest<com.google.api.services.dns.model.GoogleIamV1Policy> {

      private static final String REST_PATH = "dns/v1/{+resource}:getIamPolicy";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/managedZones/[^/]+$");

      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists
       * and does not have a policy set.
       *
       * Create a request for the method "managedZones.getIamPolicy".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
       * @param content the {@link com.google.api.services.dns.model.GoogleIamV1GetIamPolicyRequest}
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String resource, com.google.api.services.dns.model.GoogleIamV1GetIamPolicyRequest content) {
        super(Dns.this, "POST", REST_PATH, content, com.google.api.services.dns.model.GoogleIamV1Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/managedZones/[^/]+$");
        }
      }

      @Override
      public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (GetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (GetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setCallback(java.lang.String callback) {
        return (GetIamPolicy) super.setCallback(callback);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUploadType(java.lang.String uploadType) {
        return (GetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being requested. See [Resource
     names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
     field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      public GetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/managedZones/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Enumerates ManagedZones that have been created but not yet deleted.
     *
     * Create a request for the method "managedZones.list".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends DnsRequest<com.google.api.services.dns.model.ManagedZonesListResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones";

      /**
       * Enumerates ManagedZones that have been created but not yet deleted.
       *
       * Create a request for the method "managedZones.list".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ManagedZonesListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Restricts the list to return only zones with this domain name. */
      @com.google.api.client.util.Key
      private java.lang.String dnsName;

      /** Restricts the list to return only zones with this domain name.
       */
      public java.lang.String getDnsName() {
        return dnsName;
      }

      /** Restricts the list to return only zones with this domain name. */
      public List setDnsName(java.lang.String dnsName) {
        this.dnsName = dnsName;
        return this;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Optional. Maximum number of results to be returned. If unspecified, the server decides how many
     results to return.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A tag returned by a previous list request that was truncated. Use this parameter to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Applies a partial update to an existing ManagedZone.
     *
     * Create a request for the method "managedZones.patch".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @param content the {@link com.google.api.services.dns.model.ManagedZone}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String managedZone, com.google.api.services.dns.model.ManagedZone content) throws java.io.IOException {
      Patch result = new Patch(project, managedZone, content);
      initialize(result);
      return result;
    }

    public class Patch extends DnsRequest<com.google.api.services.dns.model.Operation> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}";

      /**
       * Applies a partial update to an existing ManagedZone.
       *
       * Create a request for the method "managedZones.patch".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @param content the {@link com.google.api.services.dns.model.ManagedZone}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String managedZone, com.google.api.services.dns.model.ManagedZone content) {
        super(Dns.this, "PATCH", REST_PATH, content, com.google.api.services.dns.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Patch setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public Patch setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Patch setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Sets the access control policy on the specified resource. Replaces any existing policy. Can
     * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
     *
     * Create a request for the method "managedZones.setIamPolicy".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
     * @param content the {@link com.google.api.services.dns.model.GoogleIamV1SetIamPolicyRequest}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.dns.model.GoogleIamV1SetIamPolicyRequest content) throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy extends DnsRequest<com.google.api.services.dns.model.GoogleIamV1Policy> {

      private static final String REST_PATH = "dns/v1/{+resource}:setIamPolicy";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/managedZones/[^/]+$");

      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy. Can
       * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
       *
       * Create a request for the method "managedZones.setIamPolicy".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
       * @param content the {@link com.google.api.services.dns.model.GoogleIamV1SetIamPolicyRequest}
       * @since 1.13
       */
      protected SetIamPolicy(java.lang.String resource, com.google.api.services.dns.model.GoogleIamV1SetIamPolicyRequest content) {
        super(Dns.this, "POST", REST_PATH, content, com.google.api.services.dns.model.GoogleIamV1Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/managedZones/[^/]+$");
        }
      }

      @Override
      public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (SetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (SetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public SetIamPolicy setAlt(java.lang.String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setCallback(java.lang.String callback) {
        return (SetIamPolicy) super.setCallback(callback);
      }

      @Override
      public SetIamPolicy setFields(java.lang.String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(java.lang.String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUploadType(java.lang.String uploadType) {
        return (SetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being specified. See [Resource
     names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
     field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      public SetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/managedZones/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource. If the resource does not exist,
     * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
     * designed to be used for building permission-aware UIs and command-line tools, not for
     * authorization checking. This operation may "fail open" without warning.
     *
     * Create a request for the method "managedZones.testIamPermissions".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
     * @param content the {@link com.google.api.services.dns.model.GoogleIamV1TestIamPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.dns.model.GoogleIamV1TestIamPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends DnsRequest<com.google.api.services.dns.model.GoogleIamV1TestIamPermissionsResponse> {

      private static final String REST_PATH = "dns/v1/{+resource}:testIamPermissions";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/managedZones/[^/]+$");

      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not
       * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
       * operation is designed to be used for building permission-aware UIs and command-line tools, not
       * for authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "managedZones.testIamPermissions".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
       * @param content the {@link com.google.api.services.dns.model.GoogleIamV1TestIamPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String resource, com.google.api.services.dns.model.GoogleIamV1TestIamPermissionsRequest content) {
        super(Dns.this, "POST", REST_PATH, content, com.google.api.services.dns.model.GoogleIamV1TestIamPermissionsResponse.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/managedZones/[^/]+$");
        }
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy detail is being requested. See [Resource
     names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
     field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/managedZones/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing ManagedZone.
     *
     * Create a request for the method "managedZones.update".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @param content the {@link com.google.api.services.dns.model.ManagedZone}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String managedZone, com.google.api.services.dns.model.ManagedZone content) throws java.io.IOException {
      Update result = new Update(project, managedZone, content);
      initialize(result);
      return result;
    }

    public class Update extends DnsRequest<com.google.api.services.dns.model.Operation> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}";

      /**
       * Updates an existing ManagedZone.
       *
       * Create a request for the method "managedZones.update".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @param content the {@link com.google.api.services.dns.model.ManagedZone}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String managedZone, com.google.api.services.dns.model.ManagedZone content) {
        super(Dns.this, "PUT", REST_PATH, content, com.google.api.services.dns.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Update setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public Update setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Update setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Policies collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.Policies.List request = dns.policies().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Policies policies() {
    return new Policies();
  }

  /**
   * The "policies" collection of methods.
   */
  public class Policies {

    /**
     * Creates a new Policy.
     *
     * Create a request for the method "policies.create".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param content the {@link com.google.api.services.dns.model.Policy}
     * @return the request
     */
    public Create create(java.lang.String project, com.google.api.services.dns.model.Policy content) throws java.io.IOException {
      Create result = new Create(project, content);
      initialize(result);
      return result;
    }

    public class Create extends DnsRequest<com.google.api.services.dns.model.Policy> {

      private static final String REST_PATH = "dns/v1/projects/{project}/policies";

      /**
       * Creates a new Policy.
       *
       * Create a request for the method "policies.create".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param content the {@link com.google.api.services.dns.model.Policy}
       * @since 1.13
       */
      protected Create(java.lang.String project, com.google.api.services.dns.model.Policy content) {
        super(Dns.this, "POST", REST_PATH, content, com.google.api.services.dns.model.Policy.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Create setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Create setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a previously created Policy. Fails if the policy is still being referenced by a network.
     *
     * Create a request for the method "policies.delete".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param policy User given friendly name of the policy addressed by this request.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String policy) throws java.io.IOException {
      Delete result = new Delete(project, policy);
      initialize(result);
      return result;
    }

    public class Delete extends DnsRequest<Void> {

      private static final String REST_PATH = "dns/v1/projects/{project}/policies/{policy}";

      /**
       * Deletes a previously created Policy. Fails if the policy is still being referenced by a
       * network.
       *
       * Create a request for the method "policies.delete".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param policy User given friendly name of the policy addressed by this request.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String policy) {
        super(Dns.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.policy = com.google.api.client.util.Preconditions.checkNotNull(policy, "Required parameter policy must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Delete setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User given friendly name of the policy addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String policy;

      /** User given friendly name of the policy addressed by this request.
       */
      public java.lang.String getPolicy() {
        return policy;
      }

      /** User given friendly name of the policy addressed by this request. */
      public Delete setPolicy(java.lang.String policy) {
        this.policy = policy;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Delete setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Fetches the representation of an existing Policy.
     *
     * Create a request for the method "policies.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param policy User given friendly name of the policy addressed by this request.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String policy) throws java.io.IOException {
      Get result = new Get(project, policy);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.Policy> {

      private static final String REST_PATH = "dns/v1/projects/{project}/policies/{policy}";

      /**
       * Fetches the representation of an existing Policy.
       *
       * Create a request for the method "policies.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param policy User given friendly name of the policy addressed by this request.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String policy) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.Policy.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.policy = com.google.api.client.util.Preconditions.checkNotNull(policy, "Required parameter policy must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User given friendly name of the policy addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String policy;

      /** User given friendly name of the policy addressed by this request.
       */
      public java.lang.String getPolicy() {
        return policy;
      }

      /** User given friendly name of the policy addressed by this request. */
      public Get setPolicy(java.lang.String policy) {
        this.policy = policy;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Get setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Enumerates all Policies associated with a project.
     *
     * Create a request for the method "policies.list".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends DnsRequest<com.google.api.services.dns.model.PoliciesListResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/policies";

      /**
       * Enumerates all Policies associated with a project.
       *
       * Create a request for the method "policies.list".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.PoliciesListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Optional. Maximum number of results to be returned. If unspecified, the server decides how many
     results to return.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A tag returned by a previous list request that was truncated. Use this parameter to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Applies a partial update to an existing Policy.
     *
     * Create a request for the method "policies.patch".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param policy User given friendly name of the policy addressed by this request.
     * @param content the {@link com.google.api.services.dns.model.Policy}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String policy, com.google.api.services.dns.model.Policy content) throws java.io.IOException {
      Patch result = new Patch(project, policy, content);
      initialize(result);
      return result;
    }

    public class Patch extends DnsRequest<com.google.api.services.dns.model.PoliciesPatchResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/policies/{policy}";

      /**
       * Applies a partial update to an existing Policy.
       *
       * Create a request for the method "policies.patch".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param policy User given friendly name of the policy addressed by this request.
       * @param content the {@link com.google.api.services.dns.model.Policy}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String policy, com.google.api.services.dns.model.Policy content) {
        super(Dns.this, "PATCH", REST_PATH, content, com.google.api.services.dns.model.PoliciesPatchResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.policy = com.google.api.client.util.Preconditions.checkNotNull(policy, "Required parameter policy must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Patch setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User given friendly name of the policy addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String policy;

      /** User given friendly name of the policy addressed by this request.
       */
      public java.lang.String getPolicy() {
        return policy;
      }

      /** User given friendly name of the policy addressed by this request. */
      public Patch setPolicy(java.lang.String policy) {
        this.policy = policy;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Patch setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing Policy.
     *
     * Create a request for the method "policies.update".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param policy User given friendly name of the policy addressed by this request.
     * @param content the {@link com.google.api.services.dns.model.Policy}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String policy, com.google.api.services.dns.model.Policy content) throws java.io.IOException {
      Update result = new Update(project, policy, content);
      initialize(result);
      return result;
    }

    public class Update extends DnsRequest<com.google.api.services.dns.model.PoliciesUpdateResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/policies/{policy}";

      /**
       * Updates an existing Policy.
       *
       * Create a request for the method "policies.update".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param policy User given friendly name of the policy addressed by this request.
       * @param content the {@link com.google.api.services.dns.model.Policy}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String policy, com.google.api.services.dns.model.Policy content) {
        super(Dns.this, "PUT", REST_PATH, content, com.google.api.services.dns.model.PoliciesUpdateResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.policy = com.google.api.client.util.Preconditions.checkNotNull(policy, "Required parameter policy must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Update setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User given friendly name of the policy addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String policy;

      /** User given friendly name of the policy addressed by this request.
       */
      public java.lang.String getPolicy() {
        return policy;
      }

      /** User given friendly name of the policy addressed by this request. */
      public Update setPolicy(java.lang.String policy) {
        this.policy = policy;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Update setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.Projects.List request = dns.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Fetches the representation of an existing Project.
     *
     * Create a request for the method "projects.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @return the request
     */
    public Get get(java.lang.String project) throws java.io.IOException {
      Get result = new Get(project);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.Project> {

      private static final String REST_PATH = "dns/v1/projects/{project}";

      /**
       * Fetches the representation of an existing Project.
       *
       * Create a request for the method "projects.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @since 1.13
       */
      protected Get(java.lang.String project) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.Project.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Get setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ResourceRecordSets collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.ResourceRecordSets.List request = dns.resourceRecordSets().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ResourceRecordSets resourceRecordSets() {
    return new ResourceRecordSets();
  }

  /**
   * The "resourceRecordSets" collection of methods.
   */
  public class ResourceRecordSets {

    /**
     * Creates a new ResourceRecordSet.
     *
     * Create a request for the method "resourceRecordSets.create".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @param content the {@link com.google.api.services.dns.model.ResourceRecordSet}
     * @return the request
     */
    public Create create(java.lang.String project, java.lang.String managedZone, com.google.api.services.dns.model.ResourceRecordSet content) throws java.io.IOException {
      Create result = new Create(project, managedZone, content);
      initialize(result);
      return result;
    }

    public class Create extends DnsRequest<com.google.api.services.dns.model.ResourceRecordSet> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/rrsets";

      /**
       * Creates a new ResourceRecordSet.
       *
       * Create a request for the method "resourceRecordSets.create".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @param content the {@link com.google.api.services.dns.model.ResourceRecordSet}
       * @since 1.13
       */
      protected Create(java.lang.String project, java.lang.String managedZone, com.google.api.services.dns.model.ResourceRecordSet content) {
        super(Dns.this, "POST", REST_PATH, content, com.google.api.services.dns.model.ResourceRecordSet.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Create setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public Create setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Create setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a previously created ResourceRecordSet.
     *
     * Create a request for the method "resourceRecordSets.delete".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @param name Fully qualified domain name.
     * @param type RRSet type.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String managedZone, java.lang.String name, java.lang.String type) throws java.io.IOException {
      Delete result = new Delete(project, managedZone, name, type);
      initialize(result);
      return result;
    }

    public class Delete extends DnsRequest<com.google.api.services.dns.model.ResourceRecordSetsDeleteResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/rrsets/{name}/{type}";

      /**
       * Deletes a previously created ResourceRecordSet.
       *
       * Create a request for the method "resourceRecordSets.delete".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @param name Fully qualified domain name.
       * @param type RRSet type.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String managedZone, java.lang.String name, java.lang.String type) {
        super(Dns.this, "DELETE", REST_PATH, null, com.google.api.services.dns.model.ResourceRecordSetsDeleteResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        this.type = com.google.api.client.util.Preconditions.checkNotNull(type, "Required parameter type must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Delete setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public Delete setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /** Fully qualified domain name. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Fully qualified domain name.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Fully qualified domain name. */
      public Delete setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      /** RRSet type. */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /** RRSet type.
       */
      public java.lang.String getType() {
        return type;
      }

      /** RRSet type. */
      public Delete setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Delete setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Fetches the representation of an existing ResourceRecordSet.
     *
     * Create a request for the method "resourceRecordSets.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @param name Fully qualified domain name.
     * @param type RRSet type.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String managedZone, java.lang.String name, java.lang.String type) throws java.io.IOException {
      Get result = new Get(project, managedZone, name, type);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.ResourceRecordSet> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/rrsets/{name}/{type}";

      /**
       * Fetches the representation of an existing ResourceRecordSet.
       *
       * Create a request for the method "resourceRecordSets.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @param name Fully qualified domain name.
       * @param type RRSet type.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String managedZone, java.lang.String name, java.lang.String type) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ResourceRecordSet.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        this.type = com.google.api.client.util.Preconditions.checkNotNull(type, "Required parameter type must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public Get setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /** Fully qualified domain name. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Fully qualified domain name.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Fully qualified domain name. */
      public Get setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      /** RRSet type. */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /** RRSet type.
       */
      public java.lang.String getType() {
        return type;
      }

      /** RRSet type. */
      public Get setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Get setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Enumerates ResourceRecordSets that you have created but not yet deleted.
     *
     * Create a request for the method "resourceRecordSets.list".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String managedZone) throws java.io.IOException {
      List result = new List(project, managedZone);
      initialize(result);
      return result;
    }

    public class List extends DnsRequest<com.google.api.services.dns.model.ResourceRecordSetsListResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/rrsets";

      /**
       * Enumerates ResourceRecordSets that you have created but not yet deleted.
       *
       * Create a request for the method "resourceRecordSets.list".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String managedZone) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ResourceRecordSetsListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public List setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Optional. Maximum number of results to be returned. If unspecified, the server decides how many
     results to return.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Restricts the list to return only records with this fully qualified domain name. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Restricts the list to return only records with this fully qualified domain name.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Restricts the list to return only records with this fully qualified domain name. */
      public List setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A tag returned by a previous list request that was truncated. Use this parameter to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Restricts the list to return only records of this type. If present, the "name" parameter
       * must also be present.
       */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /** Restricts the list to return only records of this type. If present, the "name" parameter must also
     be present.
       */
      public java.lang.String getType() {
        return type;
      }

      /**
       * Restricts the list to return only records of this type. If present, the "name" parameter
       * must also be present.
       */
      public List setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Applies a partial update to an existing ResourceRecordSet.
     *
     * Create a request for the method "resourceRecordSets.patch".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
     * @param name Fully qualified domain name.
     * @param type RRSet type.
     * @param content the {@link com.google.api.services.dns.model.ResourceRecordSet}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String managedZone, java.lang.String name, java.lang.String type, com.google.api.services.dns.model.ResourceRecordSet content) throws java.io.IOException {
      Patch result = new Patch(project, managedZone, name, type, content);
      initialize(result);
      return result;
    }

    public class Patch extends DnsRequest<com.google.api.services.dns.model.ResourceRecordSet> {

      private static final String REST_PATH = "dns/v1/projects/{project}/managedZones/{managedZone}/rrsets/{name}/{type}";

      /**
       * Applies a partial update to an existing ResourceRecordSet.
       *
       * Create a request for the method "resourceRecordSets.patch".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       * @param name Fully qualified domain name.
       * @param type RRSet type.
       * @param content the {@link com.google.api.services.dns.model.ResourceRecordSet}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String managedZone, java.lang.String name, java.lang.String type, com.google.api.services.dns.model.ResourceRecordSet content) {
        super(Dns.this, "PATCH", REST_PATH, content, com.google.api.services.dns.model.ResourceRecordSet.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        this.type = com.google.api.client.util.Preconditions.checkNotNull(type, "Required parameter type must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Patch setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or ID.
       */
      public Patch setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /** Fully qualified domain name. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Fully qualified domain name.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Fully qualified domain name. */
      public Patch setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      /** RRSet type. */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /** RRSet type.
       */
      public java.lang.String getType() {
        return type;
      }

      /** RRSet type. */
      public Patch setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Patch setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ResponsePolicies collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.ResponsePolicies.List request = dns.responsePolicies().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ResponsePolicies responsePolicies() {
    return new ResponsePolicies();
  }

  /**
   * The "responsePolicies" collection of methods.
   */
  public class ResponsePolicies {

    /**
     * Creates a new Response Policy
     *
     * Create a request for the method "responsePolicies.create".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param content the {@link com.google.api.services.dns.model.ResponsePolicy}
     * @return the request
     */
    public Create create(java.lang.String project, com.google.api.services.dns.model.ResponsePolicy content) throws java.io.IOException {
      Create result = new Create(project, content);
      initialize(result);
      return result;
    }

    public class Create extends DnsRequest<com.google.api.services.dns.model.ResponsePolicy> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies";

      /**
       * Creates a new Response Policy
       *
       * Create a request for the method "responsePolicies.create".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param content the {@link com.google.api.services.dns.model.ResponsePolicy}
       * @since 1.13
       */
      protected Create(java.lang.String project, com.google.api.services.dns.model.ResponsePolicy content) {
        super(Dns.this, "POST", REST_PATH, content, com.google.api.services.dns.model.ResponsePolicy.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Create setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Create setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a previously created Response Policy. Fails if the response policy is non-empty or still
     * being referenced by a network.
     *
     * Create a request for the method "responsePolicies.delete".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param responsePolicy User assigned name of the Response Policy addressed by this request.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String responsePolicy) throws java.io.IOException {
      Delete result = new Delete(project, responsePolicy);
      initialize(result);
      return result;
    }

    public class Delete extends DnsRequest<Void> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies/{responsePolicy}";

      /**
       * Deletes a previously created Response Policy. Fails if the response policy is non-empty or
       * still being referenced by a network.
       *
       * Create a request for the method "responsePolicies.delete".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param responsePolicy User assigned name of the Response Policy addressed by this request.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String responsePolicy) {
        super(Dns.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.responsePolicy = com.google.api.client.util.Preconditions.checkNotNull(responsePolicy, "Required parameter responsePolicy must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Delete setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User assigned name of the Response Policy addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicy;

      /** User assigned name of the Response Policy addressed by this request.
       */
      public java.lang.String getResponsePolicy() {
        return responsePolicy;
      }

      /** User assigned name of the Response Policy addressed by this request. */
      public Delete setResponsePolicy(java.lang.String responsePolicy) {
        this.responsePolicy = responsePolicy;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Delete setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Fetches the representation of an existing Response Policy.
     *
     * Create a request for the method "responsePolicies.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param responsePolicy User assigned name of the Response Policy addressed by this request.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String responsePolicy) throws java.io.IOException {
      Get result = new Get(project, responsePolicy);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.ResponsePolicy> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies/{responsePolicy}";

      /**
       * Fetches the representation of an existing Response Policy.
       *
       * Create a request for the method "responsePolicies.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param responsePolicy User assigned name of the Response Policy addressed by this request.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String responsePolicy) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ResponsePolicy.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.responsePolicy = com.google.api.client.util.Preconditions.checkNotNull(responsePolicy, "Required parameter responsePolicy must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User assigned name of the Response Policy addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicy;

      /** User assigned name of the Response Policy addressed by this request.
       */
      public java.lang.String getResponsePolicy() {
        return responsePolicy;
      }

      /** User assigned name of the Response Policy addressed by this request. */
      public Get setResponsePolicy(java.lang.String responsePolicy) {
        this.responsePolicy = responsePolicy;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Get setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Enumerates all Response Policies associated with a project.
     *
     * Create a request for the method "responsePolicies.list".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends DnsRequest<com.google.api.services.dns.model.ResponsePoliciesListResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies";

      /**
       * Enumerates all Response Policies associated with a project.
       *
       * Create a request for the method "responsePolicies.list".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ResponsePoliciesListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Optional. Maximum number of results to be returned. If unspecified, the server decides how many
     results to return.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A tag returned by a previous list request that was truncated. Use this parameter to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Applies a partial update to an existing Response Policy.
     *
     * Create a request for the method "responsePolicies.patch".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param responsePolicy User assigned name of the Respones Policy addressed by this request.
     * @param content the {@link com.google.api.services.dns.model.ResponsePolicy}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String responsePolicy, com.google.api.services.dns.model.ResponsePolicy content) throws java.io.IOException {
      Patch result = new Patch(project, responsePolicy, content);
      initialize(result);
      return result;
    }

    public class Patch extends DnsRequest<com.google.api.services.dns.model.ResponsePoliciesPatchResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies/{responsePolicy}";

      /**
       * Applies a partial update to an existing Response Policy.
       *
       * Create a request for the method "responsePolicies.patch".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param responsePolicy User assigned name of the Respones Policy addressed by this request.
       * @param content the {@link com.google.api.services.dns.model.ResponsePolicy}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String responsePolicy, com.google.api.services.dns.model.ResponsePolicy content) {
        super(Dns.this, "PATCH", REST_PATH, content, com.google.api.services.dns.model.ResponsePoliciesPatchResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.responsePolicy = com.google.api.client.util.Preconditions.checkNotNull(responsePolicy, "Required parameter responsePolicy must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Patch setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User assigned name of the Respones Policy addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicy;

      /** User assigned name of the Respones Policy addressed by this request.
       */
      public java.lang.String getResponsePolicy() {
        return responsePolicy;
      }

      /** User assigned name of the Respones Policy addressed by this request. */
      public Patch setResponsePolicy(java.lang.String responsePolicy) {
        this.responsePolicy = responsePolicy;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Patch setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing Response Policy.
     *
     * Create a request for the method "responsePolicies.update".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param responsePolicy User assigned name of the Response Policy addressed by this request.
     * @param content the {@link com.google.api.services.dns.model.ResponsePolicy}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String responsePolicy, com.google.api.services.dns.model.ResponsePolicy content) throws java.io.IOException {
      Update result = new Update(project, responsePolicy, content);
      initialize(result);
      return result;
    }

    public class Update extends DnsRequest<com.google.api.services.dns.model.ResponsePoliciesUpdateResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies/{responsePolicy}";

      /**
       * Updates an existing Response Policy.
       *
       * Create a request for the method "responsePolicies.update".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param responsePolicy User assigned name of the Response Policy addressed by this request.
       * @param content the {@link com.google.api.services.dns.model.ResponsePolicy}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String responsePolicy, com.google.api.services.dns.model.ResponsePolicy content) {
        super(Dns.this, "PUT", REST_PATH, content, com.google.api.services.dns.model.ResponsePoliciesUpdateResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.responsePolicy = com.google.api.client.util.Preconditions.checkNotNull(responsePolicy, "Required parameter responsePolicy must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Update setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User assigned name of the Response Policy addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicy;

      /** User assigned name of the Response Policy addressed by this request.
       */
      public java.lang.String getResponsePolicy() {
        return responsePolicy;
      }

      /** User assigned name of the Response Policy addressed by this request. */
      public Update setResponsePolicy(java.lang.String responsePolicy) {
        this.responsePolicy = responsePolicy;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Update setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ResponsePolicyRules collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.ResponsePolicyRules.List request = dns.responsePolicyRules().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ResponsePolicyRules responsePolicyRules() {
    return new ResponsePolicyRules();
  }

  /**
   * The "responsePolicyRules" collection of methods.
   */
  public class ResponsePolicyRules {

    /**
     * Creates a new Response Policy Rule.
     *
     * Create a request for the method "responsePolicyRules.create".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param responsePolicy User assigned name of the Response Policy containing the Response Policy Rule.
     * @param content the {@link com.google.api.services.dns.model.ResponsePolicyRule}
     * @return the request
     */
    public Create create(java.lang.String project, java.lang.String responsePolicy, com.google.api.services.dns.model.ResponsePolicyRule content) throws java.io.IOException {
      Create result = new Create(project, responsePolicy, content);
      initialize(result);
      return result;
    }

    public class Create extends DnsRequest<com.google.api.services.dns.model.ResponsePolicyRule> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies/{responsePolicy}/rules";

      /**
       * Creates a new Response Policy Rule.
       *
       * Create a request for the method "responsePolicyRules.create".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param responsePolicy User assigned name of the Response Policy containing the Response Policy Rule.
       * @param content the {@link com.google.api.services.dns.model.ResponsePolicyRule}
       * @since 1.13
       */
      protected Create(java.lang.String project, java.lang.String responsePolicy, com.google.api.services.dns.model.ResponsePolicyRule content) {
        super(Dns.this, "POST", REST_PATH, content, com.google.api.services.dns.model.ResponsePolicyRule.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.responsePolicy = com.google.api.client.util.Preconditions.checkNotNull(responsePolicy, "Required parameter responsePolicy must be specified.");
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Create setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User assigned name of the Response Policy containing the Response Policy Rule. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicy;

      /** User assigned name of the Response Policy containing the Response Policy Rule.
       */
      public java.lang.String getResponsePolicy() {
        return responsePolicy;
      }

      /** User assigned name of the Response Policy containing the Response Policy Rule. */
      public Create setResponsePolicy(java.lang.String responsePolicy) {
        this.responsePolicy = responsePolicy;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Create setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a previously created Response Policy Rule.
     *
     * Create a request for the method "responsePolicyRules.delete".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param responsePolicy User assigned name of the Response Policy containing the Response Policy Rule.
     * @param responsePolicyRule User assigned name of the Response Policy Rule addressed by this request.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String responsePolicy, java.lang.String responsePolicyRule) throws java.io.IOException {
      Delete result = new Delete(project, responsePolicy, responsePolicyRule);
      initialize(result);
      return result;
    }

    public class Delete extends DnsRequest<Void> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies/{responsePolicy}/rules/{responsePolicyRule}";

      /**
       * Deletes a previously created Response Policy Rule.
       *
       * Create a request for the method "responsePolicyRules.delete".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param responsePolicy User assigned name of the Response Policy containing the Response Policy Rule.
       * @param responsePolicyRule User assigned name of the Response Policy Rule addressed by this request.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String responsePolicy, java.lang.String responsePolicyRule) {
        super(Dns.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.responsePolicy = com.google.api.client.util.Preconditions.checkNotNull(responsePolicy, "Required parameter responsePolicy must be specified.");
        this.responsePolicyRule = com.google.api.client.util.Preconditions.checkNotNull(responsePolicyRule, "Required parameter responsePolicyRule must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Delete setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User assigned name of the Response Policy containing the Response Policy Rule. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicy;

      /** User assigned name of the Response Policy containing the Response Policy Rule.
       */
      public java.lang.String getResponsePolicy() {
        return responsePolicy;
      }

      /** User assigned name of the Response Policy containing the Response Policy Rule. */
      public Delete setResponsePolicy(java.lang.String responsePolicy) {
        this.responsePolicy = responsePolicy;
        return this;
      }

      /** User assigned name of the Response Policy Rule addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicyRule;

      /** User assigned name of the Response Policy Rule addressed by this request.
       */
      public java.lang.String getResponsePolicyRule() {
        return responsePolicyRule;
      }

      /** User assigned name of the Response Policy Rule addressed by this request. */
      public Delete setResponsePolicyRule(java.lang.String responsePolicyRule) {
        this.responsePolicyRule = responsePolicyRule;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Delete setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Fetches the representation of an existing Response Policy Rule.
     *
     * Create a request for the method "responsePolicyRules.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param responsePolicy User assigned name of the Response Policy containing the Response Policy Rule.
     * @param responsePolicyRule User assigned name of the Response Policy Rule addressed by this request.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String responsePolicy, java.lang.String responsePolicyRule) throws java.io.IOException {
      Get result = new Get(project, responsePolicy, responsePolicyRule);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.ResponsePolicyRule> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies/{responsePolicy}/rules/{responsePolicyRule}";

      /**
       * Fetches the representation of an existing Response Policy Rule.
       *
       * Create a request for the method "responsePolicyRules.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param responsePolicy User assigned name of the Response Policy containing the Response Policy Rule.
       * @param responsePolicyRule User assigned name of the Response Policy Rule addressed by this request.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String responsePolicy, java.lang.String responsePolicyRule) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ResponsePolicyRule.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.responsePolicy = com.google.api.client.util.Preconditions.checkNotNull(responsePolicy, "Required parameter responsePolicy must be specified.");
        this.responsePolicyRule = com.google.api.client.util.Preconditions.checkNotNull(responsePolicyRule, "Required parameter responsePolicyRule must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User assigned name of the Response Policy containing the Response Policy Rule. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicy;

      /** User assigned name of the Response Policy containing the Response Policy Rule.
       */
      public java.lang.String getResponsePolicy() {
        return responsePolicy;
      }

      /** User assigned name of the Response Policy containing the Response Policy Rule. */
      public Get setResponsePolicy(java.lang.String responsePolicy) {
        this.responsePolicy = responsePolicy;
        return this;
      }

      /** User assigned name of the Response Policy Rule addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicyRule;

      /** User assigned name of the Response Policy Rule addressed by this request.
       */
      public java.lang.String getResponsePolicyRule() {
        return responsePolicyRule;
      }

      /** User assigned name of the Response Policy Rule addressed by this request. */
      public Get setResponsePolicyRule(java.lang.String responsePolicyRule) {
        this.responsePolicyRule = responsePolicyRule;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Get setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Enumerates all Response Policy Rules associated with a project.
     *
     * Create a request for the method "responsePolicyRules.list".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param responsePolicy User assigned name of the Response Policy to list.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String responsePolicy) throws java.io.IOException {
      List result = new List(project, responsePolicy);
      initialize(result);
      return result;
    }

    public class List extends DnsRequest<com.google.api.services.dns.model.ResponsePolicyRulesListResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies/{responsePolicy}/rules";

      /**
       * Enumerates all Response Policy Rules associated with a project.
       *
       * Create a request for the method "responsePolicyRules.list".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param responsePolicy User assigned name of the Response Policy to list.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String responsePolicy) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ResponsePolicyRulesListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.responsePolicy = com.google.api.client.util.Preconditions.checkNotNull(responsePolicy, "Required parameter responsePolicy must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User assigned name of the Response Policy to list. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicy;

      /** User assigned name of the Response Policy to list.
       */
      public java.lang.String getResponsePolicy() {
        return responsePolicy;
      }

      /** User assigned name of the Response Policy to list. */
      public List setResponsePolicy(java.lang.String responsePolicy) {
        this.responsePolicy = responsePolicy;
        return this;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Optional. Maximum number of results to be returned. If unspecified, the server decides how many
     results to return.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server decides how
       * many results to return.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A tag returned by a previous list request that was truncated. Use this parameter to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Applies a partial update to an existing Response Policy Rule.
     *
     * Create a request for the method "responsePolicyRules.patch".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param responsePolicy User assigned name of the Response Policy containing the Response Policy Rule.
     * @param responsePolicyRule User assigned name of the Response Policy Rule addressed by this request.
     * @param content the {@link com.google.api.services.dns.model.ResponsePolicyRule}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String responsePolicy, java.lang.String responsePolicyRule, com.google.api.services.dns.model.ResponsePolicyRule content) throws java.io.IOException {
      Patch result = new Patch(project, responsePolicy, responsePolicyRule, content);
      initialize(result);
      return result;
    }

    public class Patch extends DnsRequest<com.google.api.services.dns.model.ResponsePolicyRulesPatchResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies/{responsePolicy}/rules/{responsePolicyRule}";

      /**
       * Applies a partial update to an existing Response Policy Rule.
       *
       * Create a request for the method "responsePolicyRules.patch".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param responsePolicy User assigned name of the Response Policy containing the Response Policy Rule.
       * @param responsePolicyRule User assigned name of the Response Policy Rule addressed by this request.
       * @param content the {@link com.google.api.services.dns.model.ResponsePolicyRule}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String responsePolicy, java.lang.String responsePolicyRule, com.google.api.services.dns.model.ResponsePolicyRule content) {
        super(Dns.this, "PATCH", REST_PATH, content, com.google.api.services.dns.model.ResponsePolicyRulesPatchResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.responsePolicy = com.google.api.client.util.Preconditions.checkNotNull(responsePolicy, "Required parameter responsePolicy must be specified.");
        this.responsePolicyRule = com.google.api.client.util.Preconditions.checkNotNull(responsePolicyRule, "Required parameter responsePolicyRule must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Patch setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User assigned name of the Response Policy containing the Response Policy Rule. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicy;

      /** User assigned name of the Response Policy containing the Response Policy Rule.
       */
      public java.lang.String getResponsePolicy() {
        return responsePolicy;
      }

      /** User assigned name of the Response Policy containing the Response Policy Rule. */
      public Patch setResponsePolicy(java.lang.String responsePolicy) {
        this.responsePolicy = responsePolicy;
        return this;
      }

      /** User assigned name of the Response Policy Rule addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicyRule;

      /** User assigned name of the Response Policy Rule addressed by this request.
       */
      public java.lang.String getResponsePolicyRule() {
        return responsePolicyRule;
      }

      /** User assigned name of the Response Policy Rule addressed by this request. */
      public Patch setResponsePolicyRule(java.lang.String responsePolicyRule) {
        this.responsePolicyRule = responsePolicyRule;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Patch setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing Response Policy Rule.
     *
     * Create a request for the method "responsePolicyRules.update".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param responsePolicy User assigned name of the Response Policy containing the Response Policy Rule.
     * @param responsePolicyRule User assigned name of the Response Policy Rule addressed by this request.
     * @param content the {@link com.google.api.services.dns.model.ResponsePolicyRule}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String responsePolicy, java.lang.String responsePolicyRule, com.google.api.services.dns.model.ResponsePolicyRule content) throws java.io.IOException {
      Update result = new Update(project, responsePolicy, responsePolicyRule, content);
      initialize(result);
      return result;
    }

    public class Update extends DnsRequest<com.google.api.services.dns.model.ResponsePolicyRulesUpdateResponse> {

      private static final String REST_PATH = "dns/v1/projects/{project}/responsePolicies/{responsePolicy}/rules/{responsePolicyRule}";

      /**
       * Updates an existing Response Policy Rule.
       *
       * Create a request for the method "responsePolicyRules.update".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param responsePolicy User assigned name of the Response Policy containing the Response Policy Rule.
       * @param responsePolicyRule User assigned name of the Response Policy Rule addressed by this request.
       * @param content the {@link com.google.api.services.dns.model.ResponsePolicyRule}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String responsePolicy, java.lang.String responsePolicyRule, com.google.api.services.dns.model.ResponsePolicyRule content) {
        super(Dns.this, "PUT", REST_PATH, content, com.google.api.services.dns.model.ResponsePolicyRulesUpdateResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.responsePolicy = com.google.api.client.util.Preconditions.checkNotNull(responsePolicy, "Required parameter responsePolicy must be specified.");
        this.responsePolicyRule = com.google.api.client.util.Preconditions.checkNotNull(responsePolicyRule, "Required parameter responsePolicyRule must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Update setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** User assigned name of the Response Policy containing the Response Policy Rule. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicy;

      /** User assigned name of the Response Policy containing the Response Policy Rule.
       */
      public java.lang.String getResponsePolicy() {
        return responsePolicy;
      }

      /** User assigned name of the Response Policy containing the Response Policy Rule. */
      public Update setResponsePolicy(java.lang.String responsePolicy) {
        this.responsePolicy = responsePolicy;
        return this;
      }

      /** User assigned name of the Response Policy Rule addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String responsePolicyRule;

      /** User assigned name of the Response Policy Rule addressed by this request.
       */
      public java.lang.String getResponsePolicyRule() {
        return responsePolicyRule;
      }

      /** User assigned name of the Response Policy Rule addressed by this request. */
      public Update setResponsePolicyRule(java.lang.String responsePolicyRule) {
        this.responsePolicyRule = responsePolicyRule;
        return this;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      @com.google.api.client.util.Key
      private java.lang.String clientOperationId;

      /** For mutating operation requests only. An optional identifier specified by the client. Must be
     unique for operation resources in the Operations collection.
       */
      public java.lang.String getClientOperationId() {
        return clientOperationId;
      }

      /**
       * For mutating operation requests only. An optional identifier specified by the client. Must
       * be unique for operation resources in the Operations collection.
       */
      public Update setClientOperationId(java.lang.String clientOperationId) {
        this.clientOperationId = clientOperationId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Dns}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Dns}. */
    @Override
    public Dns build() {
      return new Dns(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link DnsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setDnsRequestInitializer(
        DnsRequestInitializer dnsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(dnsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
