/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * A DNSSEC key pair.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DnsKey extends com.google.api.client.json.GenericJson {

  /**
   * String mnemonic specifying the DNSSEC algorithm of this key. Immutable after creation time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String algorithm;

  /**
   * The time that this resource was created in the control plane. This is in RFC3339 text format.
   * Output only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTime;

  /**
   * A mutable string of at most 1024 characters associated with this resource for the user's
   * convenience. Has no effect on the resource's function.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Cryptographic hashes of the DNSKEY resource record associated with this DnsKey. These digests
   * are needed to construct a DS record that points at this DNS key. Output only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DnsKeyDigest> digests;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Active keys are used to sign subsequent changes to the ManagedZone. Inactive keys are still
   * present as DNSKEY Resource Records for the use of resolvers validating existing signatures.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isActive;

  /**
   * Length of the key in bits. Specified at creation time, and then immutable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long keyLength;

  /**
   * The key tag is a non-cryptographic hash of the a DNSKEY resource record associated with this
   * DnsKey. The key tag can be used to identify a DNSKEY more quickly (but it is not a unique
   * identifier). In particular, the key tag is used in a parent zone's DS record to point at the
   * DNSKEY in this child ManagedZone. The key tag is a number in the range [0, 65535] and the
   * algorithm to calculate it is specified in RFC4034 Appendix B. Output only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer keyTag;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Base64 encoded public half of this key. Output only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publicKey;

  /**
   * One of "KEY_SIGNING" or "ZONE_SIGNING". Keys of type KEY_SIGNING have the Secure Entry Point
   * flag set and, when active, are used to sign only resource record sets of type DNSKEY.
   * Otherwise, the Secure Entry Point flag is cleared, and this key is used to sign only resource
   * record sets of other types. Immutable after creation time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * String mnemonic specifying the DNSSEC algorithm of this key. Immutable after creation time.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlgorithm() {
    return algorithm;
  }

  /**
   * String mnemonic specifying the DNSSEC algorithm of this key. Immutable after creation time.
   * @param algorithm algorithm or {@code null} for none
   */
  public DnsKey setAlgorithm(java.lang.String algorithm) {
    this.algorithm = algorithm;
    return this;
  }

  /**
   * The time that this resource was created in the control plane. This is in RFC3339 text format.
   * Output only.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTime() {
    return creationTime;
  }

  /**
   * The time that this resource was created in the control plane. This is in RFC3339 text format.
   * Output only.
   * @param creationTime creationTime or {@code null} for none
   */
  public DnsKey setCreationTime(java.lang.String creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * A mutable string of at most 1024 characters associated with this resource for the user's
   * convenience. Has no effect on the resource's function.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A mutable string of at most 1024 characters associated with this resource for the user's
   * convenience. Has no effect on the resource's function.
   * @param description description or {@code null} for none
   */
  public DnsKey setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Cryptographic hashes of the DNSKEY resource record associated with this DnsKey. These digests
   * are needed to construct a DS record that points at this DNS key. Output only.
   * @return value or {@code null} for none
   */
  public java.util.List<DnsKeyDigest> getDigests() {
    return digests;
  }

  /**
   * Cryptographic hashes of the DNSKEY resource record associated with this DnsKey. These digests
   * are needed to construct a DS record that points at this DNS key. Output only.
   * @param digests digests or {@code null} for none
   */
  public DnsKey setDigests(java.util.List<DnsKeyDigest> digests) {
    this.digests = digests;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public DnsKey setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Active keys are used to sign subsequent changes to the ManagedZone. Inactive keys are still
   * present as DNSKEY Resource Records for the use of resolvers validating existing signatures.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsActive() {
    return isActive;
  }

  /**
   * Active keys are used to sign subsequent changes to the ManagedZone. Inactive keys are still
   * present as DNSKEY Resource Records for the use of resolvers validating existing signatures.
   * @param isActive isActive or {@code null} for none
   */
  public DnsKey setIsActive(java.lang.Boolean isActive) {
    this.isActive = isActive;
    return this;
  }

  /**
   * Length of the key in bits. Specified at creation time, and then immutable.
   * @return value or {@code null} for none
   */
  public java.lang.Long getKeyLength() {
    return keyLength;
  }

  /**
   * Length of the key in bits. Specified at creation time, and then immutable.
   * @param keyLength keyLength or {@code null} for none
   */
  public DnsKey setKeyLength(java.lang.Long keyLength) {
    this.keyLength = keyLength;
    return this;
  }

  /**
   * The key tag is a non-cryptographic hash of the a DNSKEY resource record associated with this
   * DnsKey. The key tag can be used to identify a DNSKEY more quickly (but it is not a unique
   * identifier). In particular, the key tag is used in a parent zone's DS record to point at the
   * DNSKEY in this child ManagedZone. The key tag is a number in the range [0, 65535] and the
   * algorithm to calculate it is specified in RFC4034 Appendix B. Output only.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getKeyTag() {
    return keyTag;
  }

  /**
   * The key tag is a non-cryptographic hash of the a DNSKEY resource record associated with this
   * DnsKey. The key tag can be used to identify a DNSKEY more quickly (but it is not a unique
   * identifier). In particular, the key tag is used in a parent zone's DS record to point at the
   * DNSKEY in this child ManagedZone. The key tag is a number in the range [0, 65535] and the
   * algorithm to calculate it is specified in RFC4034 Appendix B. Output only.
   * @param keyTag keyTag or {@code null} for none
   */
  public DnsKey setKeyTag(java.lang.Integer keyTag) {
    this.keyTag = keyTag;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * @param kind kind or {@code null} for none
   */
  public DnsKey setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Base64 encoded public half of this key. Output only.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublicKey() {
    return publicKey;
  }

  /**
   * Base64 encoded public half of this key. Output only.
   * @param publicKey publicKey or {@code null} for none
   */
  public DnsKey setPublicKey(java.lang.String publicKey) {
    this.publicKey = publicKey;
    return this;
  }

  /**
   * One of "KEY_SIGNING" or "ZONE_SIGNING". Keys of type KEY_SIGNING have the Secure Entry Point
   * flag set and, when active, are used to sign only resource record sets of type DNSKEY.
   * Otherwise, the Secure Entry Point flag is cleared, and this key is used to sign only resource
   * record sets of other types. Immutable after creation time.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * One of "KEY_SIGNING" or "ZONE_SIGNING". Keys of type KEY_SIGNING have the Secure Entry Point
   * flag set and, when active, are used to sign only resource record sets of type DNSKEY.
   * Otherwise, the Secure Entry Point flag is cleared, and this key is used to sign only resource
   * record sets of other types. Immutable after creation time.
   * @param type type or {@code null} for none
   */
  public DnsKey setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public DnsKey set(String fieldName, Object value) {
    return (DnsKey) super.set(fieldName, value);
  }

  @Override
  public DnsKey clone() {
    return (DnsKey) super.clone();
  }

}
