/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * Model definition for DnsKeyDigest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DnsKeyDigest extends com.google.api.client.json.GenericJson {

  /**
   * The base-16 encoded bytes of this digest. Suitable for use in a DS resource record.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String digest;

  /**
   * Specifies the algorithm used to calculate this digest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The base-16 encoded bytes of this digest. Suitable for use in a DS resource record.
   * @return value or {@code null} for none
   */
  public java.lang.String getDigest() {
    return digest;
  }

  /**
   * The base-16 encoded bytes of this digest. Suitable for use in a DS resource record.
   * @param digest digest or {@code null} for none
   */
  public DnsKeyDigest setDigest(java.lang.String digest) {
    this.digest = digest;
    return this;
  }

  /**
   * Specifies the algorithm used to calculate this digest.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Specifies the algorithm used to calculate this digest.
   * @param type type or {@code null} for none
   */
  public DnsKeyDigest setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public DnsKeyDigest set(String fieldName, Object value) {
    return (DnsKeyDigest) super.set(fieldName, value);
  }

  @Override
  public DnsKeyDigest clone() {
    return (DnsKeyDigest) super.clone();
  }

}
