/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * Parameters for DnsKey key generation. Used for generating initial keys for a new ManagedZone and
 * as default when adding a new DnsKey.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DnsKeySpec extends com.google.api.client.json.GenericJson {

  /**
   * String mnemonic specifying the DNSSEC algorithm of this key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String algorithm;

  /**
   * Length of the keys in bits.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long keyLength;

  /**
   * Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK). Key signing keys
   * have the Secure Entry Point flag set and, when active, are only used to sign resource record
   * sets of type DNSKEY. Zone signing keys do not have the Secure Entry Point flag set and are used
   * to sign all other types of resource record sets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String keyType;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * String mnemonic specifying the DNSSEC algorithm of this key.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlgorithm() {
    return algorithm;
  }

  /**
   * String mnemonic specifying the DNSSEC algorithm of this key.
   * @param algorithm algorithm or {@code null} for none
   */
  public DnsKeySpec setAlgorithm(java.lang.String algorithm) {
    this.algorithm = algorithm;
    return this;
  }

  /**
   * Length of the keys in bits.
   * @return value or {@code null} for none
   */
  public java.lang.Long getKeyLength() {
    return keyLength;
  }

  /**
   * Length of the keys in bits.
   * @param keyLength keyLength or {@code null} for none
   */
  public DnsKeySpec setKeyLength(java.lang.Long keyLength) {
    this.keyLength = keyLength;
    return this;
  }

  /**
   * Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK). Key signing keys
   * have the Secure Entry Point flag set and, when active, are only used to sign resource record
   * sets of type DNSKEY. Zone signing keys do not have the Secure Entry Point flag set and are used
   * to sign all other types of resource record sets.
   * @return value or {@code null} for none
   */
  public java.lang.String getKeyType() {
    return keyType;
  }

  /**
   * Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK). Key signing keys
   * have the Secure Entry Point flag set and, when active, are only used to sign resource record
   * sets of type DNSKEY. Zone signing keys do not have the Secure Entry Point flag set and are used
   * to sign all other types of resource record sets.
   * @param keyType keyType or {@code null} for none
   */
  public DnsKeySpec setKeyType(java.lang.String keyType) {
    this.keyType = keyType;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * @param kind kind or {@code null} for none
   */
  public DnsKeySpec setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public DnsKeySpec set(String fieldName, Object value) {
    return (DnsKeySpec) super.set(fieldName, value);
  }

  @Override
  public DnsKeySpec clone() {
    return (DnsKeySpec) super.clone();
  }

}
