/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * Model definition for ManagedZoneServiceDirectoryConfigNamespace.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedZoneServiceDirectoryConfigNamespace extends com.google.api.client.json.GenericJson {

  /**
   * The time that the namespace backing this zone was deleted; an empty string if it still exists.
   * This is in RFC3339 text format. Output only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deletionTime;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The fully qualified URL of the namespace associated with the zone. Format must be https://servi
   * cedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String namespaceUrl;

  /**
   * The time that the namespace backing this zone was deleted; an empty string if it still exists.
   * This is in RFC3339 text format. Output only.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeletionTime() {
    return deletionTime;
  }

  /**
   * The time that the namespace backing this zone was deleted; an empty string if it still exists.
   * This is in RFC3339 text format. Output only.
   * @param deletionTime deletionTime or {@code null} for none
   */
  public ManagedZoneServiceDirectoryConfigNamespace setDeletionTime(java.lang.String deletionTime) {
    this.deletionTime = deletionTime;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * @param kind kind or {@code null} for none
   */
  public ManagedZoneServiceDirectoryConfigNamespace setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The fully qualified URL of the namespace associated with the zone. Format must be https://servi
   * cedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace}
   * @return value or {@code null} for none
   */
  public java.lang.String getNamespaceUrl() {
    return namespaceUrl;
  }

  /**
   * The fully qualified URL of the namespace associated with the zone. Format must be https://servi
   * cedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace}
   * @param namespaceUrl namespaceUrl or {@code null} for none
   */
  public ManagedZoneServiceDirectoryConfigNamespace setNamespaceUrl(java.lang.String namespaceUrl) {
    this.namespaceUrl = namespaceUrl;
    return this;
  }

  @Override
  public ManagedZoneServiceDirectoryConfigNamespace set(String fieldName, Object value) {
    return (ManagedZoneServiceDirectoryConfigNamespace) super.set(fieldName, value);
  }

  @Override
  public ManagedZoneServiceDirectoryConfigNamespace clone() {
    return (ManagedZoneServiceDirectoryConfigNamespace) super.clone();
  }

}
