/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * A unit of data that is returned by the DNS servers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceRecordSet extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * For example, www.example.com.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Configures dynamic query responses based on geo location of querying user or a weighted round
   * robin based routing policy. A ResourceRecordSet should only have either rrdata (static) or
   * routing_policy (dynamic). An error is returned otherwise.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RRSetRoutingPolicy routingPolicy;

  /**
   * As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1) -- see examples.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> rrdatas;

  /**
   * As defined in RFC 4034 (section 3.2).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> signatureRrdatas;

  /**
   * Number of seconds that this ResourceRecordSet can be cached by resolvers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer ttl;

  /**
   * The identifier of a supported record type. See the list of Supported DNS record types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * @param kind kind or {@code null} for none
   */
  public ResourceRecordSet setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * For example, www.example.com.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * For example, www.example.com.
   * @param name name or {@code null} for none
   */
  public ResourceRecordSet setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Configures dynamic query responses based on geo location of querying user or a weighted round
   * robin based routing policy. A ResourceRecordSet should only have either rrdata (static) or
   * routing_policy (dynamic). An error is returned otherwise.
   * @return value or {@code null} for none
   */
  public RRSetRoutingPolicy getRoutingPolicy() {
    return routingPolicy;
  }

  /**
   * Configures dynamic query responses based on geo location of querying user or a weighted round
   * robin based routing policy. A ResourceRecordSet should only have either rrdata (static) or
   * routing_policy (dynamic). An error is returned otherwise.
   * @param routingPolicy routingPolicy or {@code null} for none
   */
  public ResourceRecordSet setRoutingPolicy(RRSetRoutingPolicy routingPolicy) {
    this.routingPolicy = routingPolicy;
    return this;
  }

  /**
   * As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1) -- see examples.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRrdatas() {
    return rrdatas;
  }

  /**
   * As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1) -- see examples.
   * @param rrdatas rrdatas or {@code null} for none
   */
  public ResourceRecordSet setRrdatas(java.util.List<java.lang.String> rrdatas) {
    this.rrdatas = rrdatas;
    return this;
  }

  /**
   * As defined in RFC 4034 (section 3.2).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSignatureRrdatas() {
    return signatureRrdatas;
  }

  /**
   * As defined in RFC 4034 (section 3.2).
   * @param signatureRrdatas signatureRrdatas or {@code null} for none
   */
  public ResourceRecordSet setSignatureRrdatas(java.util.List<java.lang.String> signatureRrdatas) {
    this.signatureRrdatas = signatureRrdatas;
    return this;
  }

  /**
   * Number of seconds that this ResourceRecordSet can be cached by resolvers.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTtl() {
    return ttl;
  }

  /**
   * Number of seconds that this ResourceRecordSet can be cached by resolvers.
   * @param ttl ttl or {@code null} for none
   */
  public ResourceRecordSet setTtl(java.lang.Integer ttl) {
    this.ttl = ttl;
    return this;
  }

  /**
   * The identifier of a supported record type. See the list of Supported DNS record types.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The identifier of a supported record type. See the list of Supported DNS record types.
   * @param type type or {@code null} for none
   */
  public ResourceRecordSet setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ResourceRecordSet set(String fieldName, Object value) {
    return (ResourceRecordSet) super.set(fieldName, value);
  }

  @Override
  public ResourceRecordSet clone() {
    return (ResourceRecordSet) super.clone();
  }

}
