/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * A Response Policy is a collection of selectors that apply to queries made against one or more
 * Virtual Private Cloud networks.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResponsePolicy extends com.google.api.client.json.GenericJson {

  /**
   * User-provided description for this Response Policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * List of network names specifying networks to which this policy is applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ResponsePolicyNetwork> networks;

  /**
   * User assigned name for this Response Policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String responsePolicyName;

  /**
   * User-provided description for this Response Policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * User-provided description for this Response Policy.
   * @param description description or {@code null} for none
   */
  public ResponsePolicy setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public ResponsePolicy setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * @param kind kind or {@code null} for none
   */
  public ResponsePolicy setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * List of network names specifying networks to which this policy is applied.
   * @return value or {@code null} for none
   */
  public java.util.List<ResponsePolicyNetwork> getNetworks() {
    return networks;
  }

  /**
   * List of network names specifying networks to which this policy is applied.
   * @param networks networks or {@code null} for none
   */
  public ResponsePolicy setNetworks(java.util.List<ResponsePolicyNetwork> networks) {
    this.networks = networks;
    return this;
  }

  /**
   * User assigned name for this Response Policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponsePolicyName() {
    return responsePolicyName;
  }

  /**
   * User assigned name for this Response Policy.
   * @param responsePolicyName responsePolicyName or {@code null} for none
   */
  public ResponsePolicy setResponsePolicyName(java.lang.String responsePolicyName) {
    this.responsePolicyName = responsePolicyName;
    return this;
  }

  @Override
  public ResponsePolicy set(String fieldName, Object value) {
    return (ResponsePolicy) super.set(fieldName, value);
  }

  @Override
  public ResponsePolicy clone() {
    return (ResponsePolicy) super.clone();
  }

}
