/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * A Response Policy Rule is a selector that applies its behavior to queries that match the
 * selector. Selectors are DNS names, which may be wildcards or exact matches. Each DNS query
 * subject to a Response Policy matches at most one ResponsePolicyRule, as identified by the
 * dns_name field with the longest matching suffix.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResponsePolicyRule extends com.google.api.client.json.GenericJson {

  /**
   * Answer this query with a behavior rather than DNS data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String behavior;

  /**
   * The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response
   * Policy Rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dnsName;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Answer this query directly with DNS data. These ResourceRecordSets override any other DNS
   * behavior for the matched name; in particular they override private zones, the public internet,
   * and GCP internal DNS. No SOA nor NS types are allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResponsePolicyRuleLocalData localData;

  /**
   * An identifier for this rule. Must be unique with the ResponsePolicy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ruleName;

  /**
   * Answer this query with a behavior rather than DNS data.
   * @return value or {@code null} for none
   */
  public java.lang.String getBehavior() {
    return behavior;
  }

  /**
   * Answer this query with a behavior rather than DNS data.
   * @param behavior behavior or {@code null} for none
   */
  public ResponsePolicyRule setBehavior(java.lang.String behavior) {
    this.behavior = behavior;
    return this;
  }

  /**
   * The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response
   * Policy Rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getDnsName() {
    return dnsName;
  }

  /**
   * The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response
   * Policy Rule.
   * @param dnsName dnsName or {@code null} for none
   */
  public ResponsePolicyRule setDnsName(java.lang.String dnsName) {
    this.dnsName = dnsName;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * @param kind kind or {@code null} for none
   */
  public ResponsePolicyRule setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Answer this query directly with DNS data. These ResourceRecordSets override any other DNS
   * behavior for the matched name; in particular they override private zones, the public internet,
   * and GCP internal DNS. No SOA nor NS types are allowed.
   * @return value or {@code null} for none
   */
  public ResponsePolicyRuleLocalData getLocalData() {
    return localData;
  }

  /**
   * Answer this query directly with DNS data. These ResourceRecordSets override any other DNS
   * behavior for the matched name; in particular they override private zones, the public internet,
   * and GCP internal DNS. No SOA nor NS types are allowed.
   * @param localData localData or {@code null} for none
   */
  public ResponsePolicyRule setLocalData(ResponsePolicyRuleLocalData localData) {
    this.localData = localData;
    return this;
  }

  /**
   * An identifier for this rule. Must be unique with the ResponsePolicy.
   * @return value or {@code null} for none
   */
  public java.lang.String getRuleName() {
    return ruleName;
  }

  /**
   * An identifier for this rule. Must be unique with the ResponsePolicy.
   * @param ruleName ruleName or {@code null} for none
   */
  public ResponsePolicyRule setRuleName(java.lang.String ruleName) {
    this.ruleName = ruleName;
    return this;
  }

  @Override
  public ResponsePolicyRule set(String fieldName, Object value) {
    return (ResponsePolicyRule) super.set(fieldName, value);
  }

  @Override
  public ResponsePolicyRule clone() {
    return (ResponsePolicyRule) super.clone();
  }

}
