/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * Model definition for ResponsePolicyRuleLocalData.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResponsePolicyRuleLocalData extends com.google.api.client.json.GenericJson {

  /**
   * All resource record sets for this selector, one per resource record type. The name must match
   * the dns_name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ResourceRecordSet> localDatas;

  static {
    // hack to force ProGuard to consider ResourceRecordSet used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ResourceRecordSet.class);
  }

  /**
   * All resource record sets for this selector, one per resource record type. The name must match
   * the dns_name.
   * @return value or {@code null} for none
   */
  public java.util.List<ResourceRecordSet> getLocalDatas() {
    return localDatas;
  }

  /**
   * All resource record sets for this selector, one per resource record type. The name must match
   * the dns_name.
   * @param localDatas localDatas or {@code null} for none
   */
  public ResponsePolicyRuleLocalData setLocalDatas(java.util.List<ResourceRecordSet> localDatas) {
    this.localDatas = localDatas;
    return this;
  }

  @Override
  public ResponsePolicyRuleLocalData set(String fieldName, Object value) {
    return (ResponsePolicyRuleLocalData) super.set(fieldName, value);
  }

  @Override
  public ResponsePolicyRuleLocalData clone() {
    return (ResponsePolicyRuleLocalData) super.clone();
  }

}
