/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * Model definition for ResponsePolicyRulesListResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResponsePolicyRulesListResponse extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResponseHeader header;

  /**
   * The presence of this field indicates that there exist more results following your last page of
   * results in pagination order. To fetch them, make another list request using this value as your
   * page token. This lets you the complete contents of even very large collections one page at a
   * time. However, if the contents of the collection change between the first and last paginated
   * list request, the set of all elements returned are an inconsistent view of the collection. You
   * cannot retrieve a consistent snapshot of a collection larger than the maximum page size.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The Response Policy Rule resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ResponsePolicyRule> responsePolicyRules;

  static {
    // hack to force ProGuard to consider ResponsePolicyRule used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ResponsePolicyRule.class);
  }

  /**
   * @return value or {@code null} for none
   */
  public ResponseHeader getHeader() {
    return header;
  }

  /**
   * @param header header or {@code null} for none
   */
  public ResponsePolicyRulesListResponse setHeader(ResponseHeader header) {
    this.header = header;
    return this;
  }

  /**
   * The presence of this field indicates that there exist more results following your last page of
   * results in pagination order. To fetch them, make another list request using this value as your
   * page token. This lets you the complete contents of even very large collections one page at a
   * time. However, if the contents of the collection change between the first and last paginated
   * list request, the set of all elements returned are an inconsistent view of the collection. You
   * cannot retrieve a consistent snapshot of a collection larger than the maximum page size.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The presence of this field indicates that there exist more results following your last page of
   * results in pagination order. To fetch them, make another list request using this value as your
   * page token. This lets you the complete contents of even very large collections one page at a
   * time. However, if the contents of the collection change between the first and last paginated
   * list request, the set of all elements returned are an inconsistent view of the collection. You
   * cannot retrieve a consistent snapshot of a collection larger than the maximum page size.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ResponsePolicyRulesListResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The Response Policy Rule resources.
   * @return value or {@code null} for none
   */
  public java.util.List<ResponsePolicyRule> getResponsePolicyRules() {
    return responsePolicyRules;
  }

  /**
   * The Response Policy Rule resources.
   * @param responsePolicyRules responsePolicyRules or {@code null} for none
   */
  public ResponsePolicyRulesListResponse setResponsePolicyRules(java.util.List<ResponsePolicyRule> responsePolicyRules) {
    this.responsePolicyRules = responsePolicyRules;
    return this;
  }

  @Override
  public ResponsePolicyRulesListResponse set(String fieldName, Object value) {
    return (ResponsePolicyRulesListResponse) super.set(fieldName, value);
  }

  @Override
  public ResponsePolicyRulesListResponse clone() {
    return (ResponsePolicyRulesListResponse) super.clone();
  }

}
