/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.dns;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.dns.DnsRequest;
import com.google.api.services.dns.DnsRequestInitializer;
import com.google.api.services.dns.model.Change;
import com.google.api.services.dns.model.ChangesListResponse;
import com.google.api.services.dns.model.DnsKey;
import com.google.api.services.dns.model.DnsKeysListResponse;
import com.google.api.services.dns.model.ManagedZone;
import com.google.api.services.dns.model.ManagedZoneOperationsListResponse;
import com.google.api.services.dns.model.ManagedZonesListResponse;
import com.google.api.services.dns.model.Operation;
import com.google.api.services.dns.model.PoliciesListResponse;
import com.google.api.services.dns.model.PoliciesPatchResponse;
import com.google.api.services.dns.model.PoliciesUpdateResponse;
import com.google.api.services.dns.model.Policy;
import com.google.api.services.dns.model.Project;
import com.google.api.services.dns.model.ResourceRecordSetsListResponse;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dns
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://dns.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "dns/v2beta1/projects/";
    public static final String DEFAULT_BATCH_PATH = "batch/dns/v2beta1";
    public static final String DEFAULT_BASE_URL = "https://dns.googleapis.com/dns/v2beta1/projects/";

    public Dns(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Dns(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Changes changes() {
        return new Changes();
    }

    public DnsKeys dnsKeys() {
        return new DnsKeys();
    }

    public ManagedZoneOperations managedZoneOperations() {
        return new ManagedZoneOperations();
    }

    public ManagedZones managedZones() {
        return new ManagedZones();
    }

    public Policies policies() {
        return new Policies();
    }

    public Projects projects() {
        return new Projects();
    }

    public ResourceRecordSets resourceRecordSets() {
        return new ResourceRecordSets();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Google Cloud DNS API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Dns.DEFAULT_ROOT_URL, Dns.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Dns.DEFAULT_BATCH_PATH);
        }

        public Dns build() {
            return new Dns(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDnsRequestInitializer(DnsRequestInitializer dnsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)dnsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class ResourceRecordSets {
        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DnsRequest<ResourceRecordSetsListResponse> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/rrsets";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private Integer maxResults;
            @Key
            private String name;
            @Key
            private String pageToken;
            @Key
            private String type;

            protected List(String string, String string2) {
                super(Dns.this, "GET", REST_PATH, null, ResourceRecordSetsListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public List setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String string) {
                this.name = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public List setType(String string) {
                this.type = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Projects {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DnsRequest<Project> {
            private static final String REST_PATH = "{project}";
            @Key
            private String project;
            @Key
            private String clientOperationId;

            protected Get(String string) {
                super(Dns.this, "GET", REST_PATH, null, Project.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Get setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Policies {
        public Create create(String string, Policy policy) throws IOException {
            Create create = new Create(string, policy);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Policy policy) throws IOException {
            Patch patch = new Patch(string, string2, policy);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Policy policy) throws IOException {
            Update update = new Update(string, string2, policy);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DnsRequest<PoliciesUpdateResponse> {
            private static final String REST_PATH = "{project}/policies/{policy}";
            @Key
            private String project;
            @Key
            private String policy;
            @Key
            private String clientOperationId;

            protected Update(String string, String string2, Policy policy) {
                super(Dns.this, "PUT", REST_PATH, (Object)policy, PoliciesUpdateResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.policy = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter policy must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                this.project = string;
                return this;
            }

            public String getPolicy() {
                return this.policy;
            }

            public Update setPolicy(String string) {
                this.policy = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Update setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DnsRequest<PoliciesPatchResponse> {
            private static final String REST_PATH = "{project}/policies/{policy}";
            @Key
            private String project;
            @Key
            private String policy;
            @Key
            private String clientOperationId;

            protected Patch(String string, String string2, Policy policy) {
                super(Dns.this, "PATCH", REST_PATH, (Object)policy, PoliciesPatchResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.policy = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter policy must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                this.project = string;
                return this;
            }

            public String getPolicy() {
                return this.policy;
            }

            public Patch setPolicy(String string) {
                this.policy = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Patch setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DnsRequest<PoliciesListResponse> {
            private static final String REST_PATH = "{project}/policies";
            @Key
            private String project;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Dns.this, "GET", REST_PATH, null, PoliciesListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DnsRequest<Policy> {
            private static final String REST_PATH = "{project}/policies/{policy}";
            @Key
            private String project;
            @Key
            private String policy;
            @Key
            private String clientOperationId;

            protected Get(String string, String string2) {
                super(Dns.this, "GET", REST_PATH, null, Policy.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.policy = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter policy must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getPolicy() {
                return this.policy;
            }

            public Get setPolicy(String string) {
                this.policy = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Get setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DnsRequest<Void> {
            private static final String REST_PATH = "{project}/policies/{policy}";
            @Key
            private String project;
            @Key
            private String policy;
            @Key
            private String clientOperationId;

            protected Delete(String string, String string2) {
                super(Dns.this, "DELETE", REST_PATH, null, Void.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.policy = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter policy must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                this.project = string;
                return this;
            }

            public String getPolicy() {
                return this.policy;
            }

            public Delete setPolicy(String string) {
                this.policy = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Delete setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DnsRequest<Policy> {
            private static final String REST_PATH = "{project}/policies";
            @Key
            private String project;
            @Key
            private String clientOperationId;

            protected Create(String string, Policy policy) {
                super(Dns.this, "POST", REST_PATH, (Object)policy, Policy.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Create setProject(String string) {
                this.project = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Create setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class ManagedZones {
        public Create create(String string, ManagedZone managedZone) throws IOException {
            Create create = new Create(string, managedZone);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, ManagedZone managedZone) throws IOException {
            Patch patch = new Patch(string, string2, managedZone);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, ManagedZone managedZone) throws IOException {
            Update update = new Update(string, string2, managedZone);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DnsRequest<Operation> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String clientOperationId;

            protected Update(String string, String string2, ManagedZone managedZone) {
                super(Dns.this, "PUT", REST_PATH, (Object)managedZone, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Update setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Update setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DnsRequest<Operation> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String clientOperationId;

            protected Patch(String string, String string2, ManagedZone managedZone) {
                super(Dns.this, "PATCH", REST_PATH, (Object)managedZone, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Patch setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Patch setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DnsRequest<ManagedZonesListResponse> {
            private static final String REST_PATH = "{project}/managedZones";
            @Key
            private String project;
            @Key
            private String dnsName;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Dns.this, "GET", REST_PATH, null, ManagedZonesListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getDnsName() {
                return this.dnsName;
            }

            public List setDnsName(String string) {
                this.dnsName = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DnsRequest<ManagedZone> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String clientOperationId;

            protected Get(String string, String string2) {
                super(Dns.this, "GET", REST_PATH, null, ManagedZone.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Get setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Get setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DnsRequest<Void> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String clientOperationId;

            protected Delete(String string, String string2) {
                super(Dns.this, "DELETE", REST_PATH, null, Void.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Delete setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Delete setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DnsRequest<ManagedZone> {
            private static final String REST_PATH = "{project}/managedZones";
            @Key
            private String project;
            @Key
            private String clientOperationId;

            protected Create(String string, ManagedZone managedZone) {
                super(Dns.this, "POST", REST_PATH, (Object)managedZone, ManagedZone.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Create setProject(String string) {
                this.project = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Create setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class ManagedZoneOperations {
        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DnsRequest<ManagedZoneOperationsListResponse> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/operations";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortBy;

            protected List(String string, String string2) {
                super(Dns.this, "GET", REST_PATH, null, ManagedZoneOperationsListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public List setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSortBy() {
                return this.sortBy;
            }

            public List setSortBy(String string) {
                this.sortBy = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DnsRequest<Operation> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/operations/{operation}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String operation;
            @Key
            private String clientOperationId;

            protected Get(String string, String string2, String string3) {
                super(Dns.this, "GET", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
                this.operation = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter operation must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Get setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String string) {
                this.operation = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Get setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class DnsKeys {
        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DnsRequest<DnsKeysListResponse> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/dnsKeys";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String digestType;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Dns.this, "GET", REST_PATH, null, DnsKeysListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public List setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public String getDigestType() {
                return this.digestType;
            }

            public List setDigestType(String string) {
                this.digestType = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DnsRequest<DnsKey> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/dnsKeys/{dnsKeyId}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String dnsKeyId;
            @Key
            private String clientOperationId;
            @Key
            private String digestType;

            protected Get(String string, String string2, String string3) {
                super(Dns.this, "GET", REST_PATH, null, DnsKey.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
                this.dnsKeyId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter dnsKeyId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Get setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public String getDnsKeyId() {
                return this.dnsKeyId;
            }

            public Get setDnsKeyId(String string) {
                this.dnsKeyId = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Get setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            public String getDigestType() {
                return this.digestType;
            }

            public Get setDigestType(String string) {
                this.digestType = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Changes {
        public Create create(String string, String string2, Change change) throws IOException {
            Create create = new Create(string, string2, change);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DnsRequest<ChangesListResponse> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortBy;
            @Key
            private String sortOrder;

            protected List(String string, String string2) {
                super(Dns.this, "GET", REST_PATH, null, ChangesListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public List setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSortBy() {
                return this.sortBy;
            }

            public List setSortBy(String string) {
                this.sortBy = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DnsRequest<Change> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes/{changeId}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String changeId;
            @Key
            private String clientOperationId;

            protected Get(String string, String string2, String string3) {
                super(Dns.this, "GET", REST_PATH, null, Change.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
                this.changeId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter changeId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Get setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public String getChangeId() {
                return this.changeId;
            }

            public Get setChangeId(String string) {
                this.changeId = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Get setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DnsRequest<Change> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String clientOperationId;

            protected Create(String string, String string2, Change change) {
                super(Dns.this, "POST", REST_PATH, (Object)change, Change.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Create setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Create setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public String getClientOperationId() {
                return this.clientOperationId;
            }

            public Create setClientOperationId(String string) {
                this.clientOperationId = string;
                return this;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }
}

