/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.doubleclickbidmanager;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.doubleclickbidmanager.DoubleClickBidManagerRequest;
import com.google.api.services.doubleclickbidmanager.DoubleClickBidManagerRequestInitializer;
import com.google.api.services.doubleclickbidmanager.model.ListQueriesResponse;
import com.google.api.services.doubleclickbidmanager.model.ListReportsResponse;
import com.google.api.services.doubleclickbidmanager.model.Query;
import com.google.api.services.doubleclickbidmanager.model.Report;
import com.google.api.services.doubleclickbidmanager.model.RunQueryRequest;
import java.io.IOException;

public class DoubleClickBidManager
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://doubleclickbidmanager.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://doubleclickbidmanager.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "v2/";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://doubleclickbidmanager.googleapis.com/v2/";

    public DoubleClickBidManager(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    DoubleClickBidManager(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Queries queries() {
        return new Queries();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the DoubleClick Bid Manager API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return DoubleClickBidManager.DEFAULT_MTLS_ROOT_URL;
            }
            return DoubleClickBidManager.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), DoubleClickBidManager.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(DoubleClickBidManager.DEFAULT_BATCH_PATH);
        }

        public DoubleClickBidManager build() {
            return new DoubleClickBidManager(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDoubleClickBidManagerRequestInitializer(DoubleClickBidManagerRequestInitializer doubleclickbidmanagerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)doubleclickbidmanagerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Queries {
        public Create create(Query content) throws IOException {
            Create result = new Create(content);
            DoubleClickBidManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long queryId) throws IOException {
            Delete result = new Delete(queryId);
            DoubleClickBidManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long queryId) throws IOException {
            Get result = new Get(queryId);
            DoubleClickBidManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            DoubleClickBidManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Run run(Long queryId, RunQueryRequest content) throws IOException {
            Run result = new Run(queryId, content);
            DoubleClickBidManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Reports reports() {
            return new Reports();
        }

        public class Reports {
            public Get get(Long queryId, Long reportId) throws IOException {
                Get result = new Get(queryId, reportId);
                DoubleClickBidManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long queryId) throws IOException {
                List result = new List(queryId);
                DoubleClickBidManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends DoubleClickBidManagerRequest<ListReportsResponse> {
                private static final String REST_PATH = "queries/{queryId}/reports";
                @Key
                private Long queryId;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long queryId) {
                    super(DoubleClickBidManager.this, "GET", REST_PATH, null, ListReportsResponse.class);
                    this.queryId = (Long)Preconditions.checkNotNull((Object)queryId, (Object)"Required parameter queryId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getQueryId() {
                    return this.queryId;
                }

                public List setQueryId(Long queryId) {
                    this.queryId = queryId;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DoubleClickBidManagerRequest<Report> {
                private static final String REST_PATH = "queries/{queryId}/reports/{reportId}";
                @Key
                private Long queryId;
                @Key
                private Long reportId;

                protected Get(Long queryId, Long reportId) {
                    super(DoubleClickBidManager.this, "GET", REST_PATH, null, Report.class);
                    this.queryId = (Long)Preconditions.checkNotNull((Object)queryId, (Object)"Required parameter queryId must be specified.");
                    this.reportId = (Long)Preconditions.checkNotNull((Object)reportId, (Object)"Required parameter reportId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getQueryId() {
                    return this.queryId;
                }

                public Get setQueryId(Long queryId) {
                    this.queryId = queryId;
                    return this;
                }

                public Long getReportId() {
                    return this.reportId;
                }

                public Get setReportId(Long reportId) {
                    this.reportId = reportId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Run
        extends DoubleClickBidManagerRequest<Report> {
            private static final String REST_PATH = "queries/{queryId}:run";
            @Key
            private Long queryId;
            @Key
            private Boolean synchronous;

            protected Run(Long queryId, RunQueryRequest content) {
                super(DoubleClickBidManager.this, "POST", REST_PATH, (Object)content, Report.class);
                this.queryId = (Long)Preconditions.checkNotNull((Object)queryId, (Object)"Required parameter queryId must be specified.");
            }

            public Run set$Xgafv(String $Xgafv) {
                return (Run)super.set$Xgafv($Xgafv);
            }

            public Run setAccessToken(String accessToken) {
                return (Run)super.setAccessToken(accessToken);
            }

            public Run setAlt(String alt) {
                return (Run)super.setAlt(alt);
            }

            public Run setCallback(String callback) {
                return (Run)super.setCallback(callback);
            }

            public Run setFields(String fields) {
                return (Run)super.setFields(fields);
            }

            public Run setKey(String key) {
                return (Run)super.setKey(key);
            }

            public Run setOauthToken(String oauthToken) {
                return (Run)super.setOauthToken(oauthToken);
            }

            public Run setPrettyPrint(Boolean prettyPrint) {
                return (Run)super.setPrettyPrint(prettyPrint);
            }

            public Run setQuotaUser(String quotaUser) {
                return (Run)super.setQuotaUser(quotaUser);
            }

            public Run setUploadType(String uploadType) {
                return (Run)super.setUploadType(uploadType);
            }

            public Run setUploadProtocol(String uploadProtocol) {
                return (Run)super.setUploadProtocol(uploadProtocol);
            }

            public Long getQueryId() {
                return this.queryId;
            }

            public Run setQueryId(Long queryId) {
                this.queryId = queryId;
                return this;
            }

            public Boolean getSynchronous() {
                return this.synchronous;
            }

            public Run setSynchronous(Boolean synchronous) {
                this.synchronous = synchronous;
                return this;
            }

            @Override
            public Run set(String parameterName, Object value) {
                return (Run)super.set(parameterName, value);
            }
        }

        public class List
        extends DoubleClickBidManagerRequest<ListQueriesResponse> {
            private static final String REST_PATH = "queries";
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(DoubleClickBidManager.this, "GET", REST_PATH, null, ListQueriesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DoubleClickBidManagerRequest<Query> {
            private static final String REST_PATH = "queries/{queryId}";
            @Key
            private Long queryId;

            protected Get(Long queryId) {
                super(DoubleClickBidManager.this, "GET", REST_PATH, null, Query.class);
                this.queryId = (Long)Preconditions.checkNotNull((Object)queryId, (Object)"Required parameter queryId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getQueryId() {
                return this.queryId;
            }

            public Get setQueryId(Long queryId) {
                this.queryId = queryId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DoubleClickBidManagerRequest<Void> {
            private static final String REST_PATH = "queries/{queryId}";
            @Key
            private Long queryId;

            protected Delete(Long queryId) {
                super(DoubleClickBidManager.this, "DELETE", REST_PATH, null, Void.class);
                this.queryId = (Long)Preconditions.checkNotNull((Object)queryId, (Object)"Required parameter queryId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getQueryId() {
                return this.queryId;
            }

            public Delete setQueryId(Long queryId) {
                this.queryId = queryId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DoubleClickBidManagerRequest<Query> {
            private static final String REST_PATH = "queries";

            protected Create(Query content) {
                super(DoubleClickBidManager.this, "POST", REST_PATH, (Object)content, Query.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }
}

