# Search Ads 360 API Client Library for Java

The Search Ads 360 API allows developers to automate uploading conversions and downloading reports from Search Ads 360.

This page contains information about getting started with the Search Ads 360 API
using the Google API Client Library for Java. In addition, you may be interested
in the following documentation:

* Browse the [Javadoc reference for the Search Ads 360 API][javadoc]
* Read the [Developer's Guide for the Google API Client Library for Java][google-api-client].
* Interact with this API in your browser using the [APIs Explorer for the Search Ads 360 API][api-explorer]

## Installation

### Maven

Add the following lines to your `pom.xml` file:

```xml
<project>
  <dependencies>
    <dependency>
      <groupId>com.google.apis</groupId>
      <artifactId>google-api-services-doubleclicksearch</artifactId>
      <version>v2-rev20231017-2.0.0</version>
    </dependency>
  </dependencies>
</project>
```

### Gradle

```gradle
repositories {
  mavenCentral()
}
dependencies {
  implementation 'com.google.apis:google-api-services-doubleclicksearch:v2-rev20231017-2.0.0'
}
```

[javadoc]: https://googleapis.dev/java/google-api-services-doubleclicksearch/latest/index.html
[google-api-client]: https://github.com/googleapis/google-api-java-client/
[api-explorer]: https://developers.google.com/apis-explorer/#p/doubleclicksearch/v1/
