/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.doubleclicksearch.model;

/**
 * A DoubleClick Search report. This object contains the report request, some report metadata such
 * as currency code, and the generated report rows or report files.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Search Ads 360 API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Report extends com.google.api.client.json.GenericJson {

  /**
   * Asynchronous report only. Contains a list of generated report files once the report has
   * successfully completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Files> files;

  static {
    // hack to force ProGuard to consider Files used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Files.class);
  }

  /**
   * Asynchronous report only. Id of the report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Asynchronous report only. True if and only if the report has completed successfully and the
   * report files are ready to be downloaded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isReportReady;

  /**
   * Identifies this as a Report resource. Value: the fixed string `doubleclicksearch#report`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The request that created the report. Optional fields not specified in the original request are
   * filled with default values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReportRequest request;

  /**
   * The number of report rows generated by the report, not including headers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer rowCount;

  /**
   * Synchronous report only. Generated report rows.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.util.Map<String, java.lang.Object>> rows;

  /**
   * The currency code of all monetary values produced in the report, including values that are set
   * by users (e.g., keyword bid settings) and metrics (e.g., cost and revenue). The currency code
   * of a report is determined by the `statisticsCurrency` field of the report request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String statisticsCurrencyCode;

  /**
   * If all statistics of the report are sourced from the same time zone, this would be it.
   * Otherwise the field is unset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String statisticsTimeZone;

  /**
   * Asynchronous report only. Contains a list of generated report files once the report has
   * successfully completed.
   * @return value or {@code null} for none
   */
  public java.util.List<Files> getFiles() {
    return files;
  }

  /**
   * Asynchronous report only. Contains a list of generated report files once the report has
   * successfully completed.
   * @param files files or {@code null} for none
   */
  public Report setFiles(java.util.List<Files> files) {
    this.files = files;
    return this;
  }

  /**
   * Asynchronous report only. Id of the report.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Asynchronous report only. Id of the report.
   * @param id id or {@code null} for none
   */
  public Report setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Asynchronous report only. True if and only if the report has completed successfully and the
   * report files are ready to be downloaded.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsReportReady() {
    return isReportReady;
  }

  /**
   * Asynchronous report only. True if and only if the report has completed successfully and the
   * report files are ready to be downloaded.
   * @param isReportReady isReportReady or {@code null} for none
   */
  public Report setIsReportReady(java.lang.Boolean isReportReady) {
    this.isReportReady = isReportReady;
    return this;
  }

  /**
   * Identifies this as a Report resource. Value: the fixed string `doubleclicksearch#report`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies this as a Report resource. Value: the fixed string `doubleclicksearch#report`.
   * @param kind kind or {@code null} for none
   */
  public Report setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The request that created the report. Optional fields not specified in the original request are
   * filled with default values.
   * @return value or {@code null} for none
   */
  public ReportRequest getRequest() {
    return request;
  }

  /**
   * The request that created the report. Optional fields not specified in the original request are
   * filled with default values.
   * @param request request or {@code null} for none
   */
  public Report setRequest(ReportRequest request) {
    this.request = request;
    return this;
  }

  /**
   * The number of report rows generated by the report, not including headers.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRowCount() {
    return rowCount;
  }

  /**
   * The number of report rows generated by the report, not including headers.
   * @param rowCount rowCount or {@code null} for none
   */
  public Report setRowCount(java.lang.Integer rowCount) {
    this.rowCount = rowCount;
    return this;
  }

  /**
   * Synchronous report only. Generated report rows.
   * @return value or {@code null} for none
   */
  public java.util.List<java.util.Map<String, java.lang.Object>> getRows() {
    return rows;
  }

  /**
   * Synchronous report only. Generated report rows.
   * @param rows rows or {@code null} for none
   */
  public Report setRows(java.util.List<java.util.Map<String, java.lang.Object>> rows) {
    this.rows = rows;
    return this;
  }

  /**
   * The currency code of all monetary values produced in the report, including values that are set
   * by users (e.g., keyword bid settings) and metrics (e.g., cost and revenue). The currency code
   * of a report is determined by the `statisticsCurrency` field of the report request.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatisticsCurrencyCode() {
    return statisticsCurrencyCode;
  }

  /**
   * The currency code of all monetary values produced in the report, including values that are set
   * by users (e.g., keyword bid settings) and metrics (e.g., cost and revenue). The currency code
   * of a report is determined by the `statisticsCurrency` field of the report request.
   * @param statisticsCurrencyCode statisticsCurrencyCode or {@code null} for none
   */
  public Report setStatisticsCurrencyCode(java.lang.String statisticsCurrencyCode) {
    this.statisticsCurrencyCode = statisticsCurrencyCode;
    return this;
  }

  /**
   * If all statistics of the report are sourced from the same time zone, this would be it.
   * Otherwise the field is unset.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatisticsTimeZone() {
    return statisticsTimeZone;
  }

  /**
   * If all statistics of the report are sourced from the same time zone, this would be it.
   * Otherwise the field is unset.
   * @param statisticsTimeZone statisticsTimeZone or {@code null} for none
   */
  public Report setStatisticsTimeZone(java.lang.String statisticsTimeZone) {
    this.statisticsTimeZone = statisticsTimeZone;
    return this;
  }

  @Override
  public Report set(String fieldName, Object value) {
    return (Report) super.set(fieldName, value);
  }

  @Override
  public Report clone() {
    return (Report) super.clone();
  }

  /**
   * Model definition for ReportFiles.
   */
  public static final class Files extends com.google.api.client.json.GenericJson {

    /**
     * The size of this report file in bytes.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long byteCount;

    /**
     * Use this url to download the report file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String url;

    /**
     * The size of this report file in bytes.
     * @return value or {@code null} for none
     */
    public java.lang.Long getByteCount() {
      return byteCount;
    }

    /**
     * The size of this report file in bytes.
     * @param byteCount byteCount or {@code null} for none
     */
    public Files setByteCount(java.lang.Long byteCount) {
      this.byteCount = byteCount;
      return this;
    }

    /**
     * Use this url to download the report file.
     * @return value or {@code null} for none
     */
    public java.lang.String getUrl() {
      return url;
    }

    /**
     * Use this url to download the report file.
     * @param url url or {@code null} for none
     */
    public Files setUrl(java.lang.String url) {
      this.url = url;
      return this;
    }

    @Override
    public Files set(String fieldName, Object value) {
      return (Files) super.set(fieldName, value);
    }

    @Override
    public Files clone() {
      return (Files) super.clone();
    }

  }

}
