/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.doubleclicksearch;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UriTemplate;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.doubleclicksearch.DoubleclicksearchRequest;
import com.google.api.services.doubleclicksearch.DoubleclicksearchRequestInitializer;
import com.google.api.services.doubleclicksearch.model.ConversionList;
import com.google.api.services.doubleclicksearch.model.IdMappingFile;
import com.google.api.services.doubleclicksearch.model.Report;
import com.google.api.services.doubleclicksearch.model.ReportRequest;
import com.google.api.services.doubleclicksearch.model.SavedColumnList;
import com.google.api.services.doubleclicksearch.model.UpdateAvailabilityRequest;
import com.google.api.services.doubleclicksearch.model.UpdateAvailabilityResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Doubleclicksearch
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://doubleclicksearch.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://doubleclicksearch.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://doubleclicksearch.googleapis.com/";

    public Doubleclicksearch(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Doubleclicksearch(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Conversion conversion() {
        return new Conversion();
    }

    public Reports reports() {
        return new Reports();
    }

    public SavedColumns savedColumns() {
        return new SavedColumns();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Search Ads 360 API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Doubleclicksearch.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://doubleclicksearch.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Doubleclicksearch.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Doubleclicksearch.DEFAULT_BATCH_PATH);
        }

        public Doubleclicksearch build() {
            return new Doubleclicksearch(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDoubleclicksearchRequestInitializer(DoubleclicksearchRequestInitializer doubleclicksearchRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)doubleclicksearchRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class SavedColumns {
        public List list(Long agencyId, Long advertiserId) throws IOException {
            List result = new List(agencyId, advertiserId);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DoubleclicksearchRequest<SavedColumnList> {
            private static final String REST_PATH = "doubleclicksearch/v2/agency/{agencyId}/advertiser/{advertiserId}/savedcolumns";
            @Key
            private Long agencyId;
            @Key
            private Long advertiserId;

            protected List(Long agencyId, Long advertiserId) {
                super(Doubleclicksearch.this, "GET", REST_PATH, null, SavedColumnList.class);
                this.agencyId = (Long)Preconditions.checkNotNull((Object)agencyId, (Object)"Required parameter agencyId must be specified.");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAgencyId() {
                return this.agencyId;
            }

            public List setAgencyId(Long agencyId) {
                this.agencyId = agencyId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Reports {
        public Generate generate(ReportRequest content) throws IOException {
            Generate result = new Generate(content);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String reportId) throws IOException {
            Get result = new Get(reportId);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetFile getFile(String reportId, Integer reportFragment) throws IOException {
            GetFile result = new GetFile(reportId, reportFragment);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIdMappingFile getIdMappingFile(Long agencyId, Long advertiserId) throws IOException {
            GetIdMappingFile result = new GetIdMappingFile(agencyId, advertiserId);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Request request(ReportRequest content) throws IOException {
            Request result = new Request(content);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Request
        extends DoubleclicksearchRequest<Report> {
            private static final String REST_PATH = "doubleclicksearch/v2/reports";

            protected Request(ReportRequest content) {
                super(Doubleclicksearch.this, "POST", REST_PATH, (Object)content, Report.class);
            }

            public Request set$Xgafv(String $Xgafv) {
                return (Request)super.set$Xgafv($Xgafv);
            }

            public Request setAccessToken(String accessToken) {
                return (Request)super.setAccessToken(accessToken);
            }

            public Request setAlt(String alt) {
                return (Request)super.setAlt(alt);
            }

            public Request setCallback(String callback) {
                return (Request)super.setCallback(callback);
            }

            public Request setFields(String fields) {
                return (Request)super.setFields(fields);
            }

            public Request setKey(String key) {
                return (Request)super.setKey(key);
            }

            public Request setOauthToken(String oauthToken) {
                return (Request)super.setOauthToken(oauthToken);
            }

            public Request setPrettyPrint(Boolean prettyPrint) {
                return (Request)super.setPrettyPrint(prettyPrint);
            }

            public Request setQuotaUser(String quotaUser) {
                return (Request)super.setQuotaUser(quotaUser);
            }

            public Request setUploadType(String uploadType) {
                return (Request)super.setUploadType(uploadType);
            }

            public Request setUploadProtocol(String uploadProtocol) {
                return (Request)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Request set(String parameterName, Object value) {
                return (Request)super.set(parameterName, value);
            }
        }

        public class GetIdMappingFile
        extends DoubleclicksearchRequest<IdMappingFile> {
            private static final String REST_PATH = "doubleclicksearch/v2/agency/{agencyId}/advertiser/{advertiserId}/idmapping";
            @Key
            private Long agencyId;
            @Key
            private Long advertiserId;

            protected GetIdMappingFile(Long agencyId, Long advertiserId) {
                super(Doubleclicksearch.this, "GET", REST_PATH, null, IdMappingFile.class);
                this.agencyId = (Long)Preconditions.checkNotNull((Object)agencyId, (Object)"Required parameter agencyId must be specified.");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public GenericUrl buildHttpRequestUrl() {
                String baseUrl = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? Doubleclicksearch.this.getRootUrl() + "download/" + Doubleclicksearch.this.getServicePath() : Doubleclicksearch.this.getBaseUrl();
                return new GenericUrl(UriTemplate.expand((String)baseUrl, (String)this.getUriTemplate(), (Object)((Object)this), (boolean)true));
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIdMappingFile set$Xgafv(String $Xgafv) {
                return (GetIdMappingFile)super.set$Xgafv($Xgafv);
            }

            public GetIdMappingFile setAccessToken(String accessToken) {
                return (GetIdMappingFile)super.setAccessToken(accessToken);
            }

            public GetIdMappingFile setAlt(String alt) {
                return (GetIdMappingFile)super.setAlt(alt);
            }

            public GetIdMappingFile setCallback(String callback) {
                return (GetIdMappingFile)super.setCallback(callback);
            }

            public GetIdMappingFile setFields(String fields) {
                return (GetIdMappingFile)super.setFields(fields);
            }

            public GetIdMappingFile setKey(String key) {
                return (GetIdMappingFile)super.setKey(key);
            }

            public GetIdMappingFile setOauthToken(String oauthToken) {
                return (GetIdMappingFile)super.setOauthToken(oauthToken);
            }

            public GetIdMappingFile setPrettyPrint(Boolean prettyPrint) {
                return (GetIdMappingFile)super.setPrettyPrint(prettyPrint);
            }

            public GetIdMappingFile setQuotaUser(String quotaUser) {
                return (GetIdMappingFile)super.setQuotaUser(quotaUser);
            }

            public GetIdMappingFile setUploadType(String uploadType) {
                return (GetIdMappingFile)super.setUploadType(uploadType);
            }

            public GetIdMappingFile setUploadProtocol(String uploadProtocol) {
                return (GetIdMappingFile)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAgencyId() {
                return this.agencyId;
            }

            public GetIdMappingFile setAgencyId(Long agencyId) {
                this.agencyId = agencyId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public GetIdMappingFile setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            @Override
            public GetIdMappingFile set(String parameterName, Object value) {
                return (GetIdMappingFile)super.set(parameterName, value);
            }
        }

        public class GetFile
        extends DoubleclicksearchRequest<Void> {
            private static final String REST_PATH = "doubleclicksearch/v2/reports/{reportId}/files/{reportFragment}";
            @Key
            private String reportId;
            @Key
            private Integer reportFragment;

            protected GetFile(String reportId, Integer reportFragment) {
                super(Doubleclicksearch.this, "GET", REST_PATH, null, Void.class);
                this.reportId = (String)Preconditions.checkNotNull((Object)reportId, (Object)"Required parameter reportId must be specified.");
                this.reportFragment = (Integer)Preconditions.checkNotNull((Object)reportFragment, (Object)"Required parameter reportFragment must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public GenericUrl buildHttpRequestUrl() {
                String baseUrl = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? Doubleclicksearch.this.getRootUrl() + "download/" + Doubleclicksearch.this.getServicePath() : Doubleclicksearch.this.getBaseUrl();
                return new GenericUrl(UriTemplate.expand((String)baseUrl, (String)this.getUriTemplate(), (Object)((Object)this), (boolean)true));
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetFile set$Xgafv(String $Xgafv) {
                return (GetFile)super.set$Xgafv($Xgafv);
            }

            public GetFile setAccessToken(String accessToken) {
                return (GetFile)super.setAccessToken(accessToken);
            }

            public GetFile setAlt(String alt) {
                return (GetFile)super.setAlt(alt);
            }

            public GetFile setCallback(String callback) {
                return (GetFile)super.setCallback(callback);
            }

            public GetFile setFields(String fields) {
                return (GetFile)super.setFields(fields);
            }

            public GetFile setKey(String key) {
                return (GetFile)super.setKey(key);
            }

            public GetFile setOauthToken(String oauthToken) {
                return (GetFile)super.setOauthToken(oauthToken);
            }

            public GetFile setPrettyPrint(Boolean prettyPrint) {
                return (GetFile)super.setPrettyPrint(prettyPrint);
            }

            public GetFile setQuotaUser(String quotaUser) {
                return (GetFile)super.setQuotaUser(quotaUser);
            }

            public GetFile setUploadType(String uploadType) {
                return (GetFile)super.setUploadType(uploadType);
            }

            public GetFile setUploadProtocol(String uploadProtocol) {
                return (GetFile)super.setUploadProtocol(uploadProtocol);
            }

            public String getReportId() {
                return this.reportId;
            }

            public GetFile setReportId(String reportId) {
                this.reportId = reportId;
                return this;
            }

            public Integer getReportFragment() {
                return this.reportFragment;
            }

            public GetFile setReportFragment(Integer reportFragment) {
                this.reportFragment = reportFragment;
                return this;
            }

            @Override
            public GetFile set(String parameterName, Object value) {
                return (GetFile)super.set(parameterName, value);
            }
        }

        public class Get
        extends DoubleclicksearchRequest<Report> {
            private static final String REST_PATH = "doubleclicksearch/v2/reports/{reportId}";
            @Key
            private String reportId;

            protected Get(String reportId) {
                super(Doubleclicksearch.this, "GET", REST_PATH, null, Report.class);
                this.reportId = (String)Preconditions.checkNotNull((Object)reportId, (Object)"Required parameter reportId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getReportId() {
                return this.reportId;
            }

            public Get setReportId(String reportId) {
                this.reportId = reportId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Generate
        extends DoubleclicksearchRequest<Report> {
            private static final String REST_PATH = "doubleclicksearch/v2/reports/generate";

            protected Generate(ReportRequest content) {
                super(Doubleclicksearch.this, "POST", REST_PATH, (Object)content, Report.class);
            }

            public Generate set$Xgafv(String $Xgafv) {
                return (Generate)super.set$Xgafv($Xgafv);
            }

            public Generate setAccessToken(String accessToken) {
                return (Generate)super.setAccessToken(accessToken);
            }

            public Generate setAlt(String alt) {
                return (Generate)super.setAlt(alt);
            }

            public Generate setCallback(String callback) {
                return (Generate)super.setCallback(callback);
            }

            public Generate setFields(String fields) {
                return (Generate)super.setFields(fields);
            }

            public Generate setKey(String key) {
                return (Generate)super.setKey(key);
            }

            public Generate setOauthToken(String oauthToken) {
                return (Generate)super.setOauthToken(oauthToken);
            }

            public Generate setPrettyPrint(Boolean prettyPrint) {
                return (Generate)super.setPrettyPrint(prettyPrint);
            }

            public Generate setQuotaUser(String quotaUser) {
                return (Generate)super.setQuotaUser(quotaUser);
            }

            public Generate setUploadType(String uploadType) {
                return (Generate)super.setUploadType(uploadType);
            }

            public Generate setUploadProtocol(String uploadProtocol) {
                return (Generate)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Generate set(String parameterName, Object value) {
                return (Generate)super.set(parameterName, value);
            }
        }
    }

    public class Conversion {
        public Get get(Long agencyId, Long advertiserId, Long engineAccountId, Integer endDate, Integer rowCount, Integer startDate, Long startRow) throws IOException {
            Get result = new Get(agencyId, advertiserId, engineAccountId, endDate, rowCount, startDate, startRow);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetByCustomerId getByCustomerId(String customerId, Integer endDate, Integer rowCount, Integer startDate, Long startRow) throws IOException {
            GetByCustomerId result = new GetByCustomerId(customerId, endDate, rowCount, startDate, startRow);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(ConversionList content) throws IOException {
            Insert result = new Insert(content);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(ConversionList content) throws IOException {
            Update result = new Update(content);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateAvailability updateAvailability(UpdateAvailabilityRequest content) throws IOException {
            UpdateAvailability result = new UpdateAvailability(content);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class UpdateAvailability
        extends DoubleclicksearchRequest<UpdateAvailabilityResponse> {
            private static final String REST_PATH = "doubleclicksearch/v2/conversion/updateAvailability";

            protected UpdateAvailability(UpdateAvailabilityRequest content) {
                super(Doubleclicksearch.this, "POST", REST_PATH, (Object)content, UpdateAvailabilityResponse.class);
            }

            public UpdateAvailability set$Xgafv(String $Xgafv) {
                return (UpdateAvailability)super.set$Xgafv($Xgafv);
            }

            public UpdateAvailability setAccessToken(String accessToken) {
                return (UpdateAvailability)super.setAccessToken(accessToken);
            }

            public UpdateAvailability setAlt(String alt) {
                return (UpdateAvailability)super.setAlt(alt);
            }

            public UpdateAvailability setCallback(String callback) {
                return (UpdateAvailability)super.setCallback(callback);
            }

            public UpdateAvailability setFields(String fields) {
                return (UpdateAvailability)super.setFields(fields);
            }

            public UpdateAvailability setKey(String key) {
                return (UpdateAvailability)super.setKey(key);
            }

            public UpdateAvailability setOauthToken(String oauthToken) {
                return (UpdateAvailability)super.setOauthToken(oauthToken);
            }

            public UpdateAvailability setPrettyPrint(Boolean prettyPrint) {
                return (UpdateAvailability)super.setPrettyPrint(prettyPrint);
            }

            public UpdateAvailability setQuotaUser(String quotaUser) {
                return (UpdateAvailability)super.setQuotaUser(quotaUser);
            }

            public UpdateAvailability setUploadType(String uploadType) {
                return (UpdateAvailability)super.setUploadType(uploadType);
            }

            public UpdateAvailability setUploadProtocol(String uploadProtocol) {
                return (UpdateAvailability)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public UpdateAvailability set(String parameterName, Object value) {
                return (UpdateAvailability)super.set(parameterName, value);
            }
        }

        public class Update
        extends DoubleclicksearchRequest<ConversionList> {
            private static final String REST_PATH = "doubleclicksearch/v2/conversion";

            protected Update(ConversionList content) {
                super(Doubleclicksearch.this, "PUT", REST_PATH, (Object)content, ConversionList.class);
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DoubleclicksearchRequest<ConversionList> {
            private static final String REST_PATH = "doubleclicksearch/v2/conversion";

            protected Insert(ConversionList content) {
                super(Doubleclicksearch.this, "POST", REST_PATH, (Object)content, ConversionList.class);
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetByCustomerId
        extends DoubleclicksearchRequest<ConversionList> {
            private static final String REST_PATH = "doubleclicksearch/v2/customer/{customerId}/conversion";
            @Key
            private String customerId;
            @Key
            private Integer endDate;
            @Key
            private Integer rowCount;
            @Key
            private Integer startDate;
            @Key
            private Long startRow;
            @Key
            private Long adGroupId;
            @Key
            private Long adId;
            @Key
            private Long advertiserId;
            @Key
            private Long agencyId;
            @Key
            private Long campaignId;
            @Key
            private Long criterionId;
            @Key
            private Long engineAccountId;

            protected GetByCustomerId(String customerId, Integer endDate, Integer rowCount, Integer startDate, Long startRow) {
                super(Doubleclicksearch.this, "GET", REST_PATH, null, ConversionList.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.endDate = (Integer)Preconditions.checkNotNull((Object)endDate, (Object)"Required parameter endDate must be specified.");
                this.rowCount = (Integer)Preconditions.checkNotNull((Object)rowCount, (Object)"Required parameter rowCount must be specified.");
                this.startDate = (Integer)Preconditions.checkNotNull((Object)startDate, (Object)"Required parameter startDate must be specified.");
                this.startRow = (Long)Preconditions.checkNotNull((Object)startRow, (Object)"Required parameter startRow must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetByCustomerId set$Xgafv(String $Xgafv) {
                return (GetByCustomerId)super.set$Xgafv($Xgafv);
            }

            public GetByCustomerId setAccessToken(String accessToken) {
                return (GetByCustomerId)super.setAccessToken(accessToken);
            }

            public GetByCustomerId setAlt(String alt) {
                return (GetByCustomerId)super.setAlt(alt);
            }

            public GetByCustomerId setCallback(String callback) {
                return (GetByCustomerId)super.setCallback(callback);
            }

            public GetByCustomerId setFields(String fields) {
                return (GetByCustomerId)super.setFields(fields);
            }

            public GetByCustomerId setKey(String key) {
                return (GetByCustomerId)super.setKey(key);
            }

            public GetByCustomerId setOauthToken(String oauthToken) {
                return (GetByCustomerId)super.setOauthToken(oauthToken);
            }

            public GetByCustomerId setPrettyPrint(Boolean prettyPrint) {
                return (GetByCustomerId)super.setPrettyPrint(prettyPrint);
            }

            public GetByCustomerId setQuotaUser(String quotaUser) {
                return (GetByCustomerId)super.setQuotaUser(quotaUser);
            }

            public GetByCustomerId setUploadType(String uploadType) {
                return (GetByCustomerId)super.setUploadType(uploadType);
            }

            public GetByCustomerId setUploadProtocol(String uploadProtocol) {
                return (GetByCustomerId)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public GetByCustomerId setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public Integer getEndDate() {
                return this.endDate;
            }

            public GetByCustomerId setEndDate(Integer endDate) {
                this.endDate = endDate;
                return this;
            }

            public Integer getRowCount() {
                return this.rowCount;
            }

            public GetByCustomerId setRowCount(Integer rowCount) {
                this.rowCount = rowCount;
                return this;
            }

            public Integer getStartDate() {
                return this.startDate;
            }

            public GetByCustomerId setStartDate(Integer startDate) {
                this.startDate = startDate;
                return this;
            }

            public Long getStartRow() {
                return this.startRow;
            }

            public GetByCustomerId setStartRow(Long startRow) {
                this.startRow = startRow;
                return this;
            }

            public Long getAdGroupId() {
                return this.adGroupId;
            }

            public GetByCustomerId setAdGroupId(Long adGroupId) {
                this.adGroupId = adGroupId;
                return this;
            }

            public Long getAdId() {
                return this.adId;
            }

            public GetByCustomerId setAdId(Long adId) {
                this.adId = adId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public GetByCustomerId setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getAgencyId() {
                return this.agencyId;
            }

            public GetByCustomerId setAgencyId(Long agencyId) {
                this.agencyId = agencyId;
                return this;
            }

            public Long getCampaignId() {
                return this.campaignId;
            }

            public GetByCustomerId setCampaignId(Long campaignId) {
                this.campaignId = campaignId;
                return this;
            }

            public Long getCriterionId() {
                return this.criterionId;
            }

            public GetByCustomerId setCriterionId(Long criterionId) {
                this.criterionId = criterionId;
                return this;
            }

            public Long getEngineAccountId() {
                return this.engineAccountId;
            }

            public GetByCustomerId setEngineAccountId(Long engineAccountId) {
                this.engineAccountId = engineAccountId;
                return this;
            }

            @Override
            public GetByCustomerId set(String parameterName, Object value) {
                return (GetByCustomerId)super.set(parameterName, value);
            }
        }

        public class Get
        extends DoubleclicksearchRequest<ConversionList> {
            private static final String REST_PATH = "doubleclicksearch/v2/agency/{agencyId}/advertiser/{advertiserId}/engine/{engineAccountId}/conversion";
            @Key
            private Long agencyId;
            @Key
            private Long advertiserId;
            @Key
            private Long engineAccountId;
            @Key
            private Integer endDate;
            @Key
            private Integer rowCount;
            @Key
            private Integer startDate;
            @Key
            private Long startRow;
            @Key
            private Long adGroupId;
            @Key
            private Long adId;
            @Key
            private Long campaignId;
            @Key
            private Long criterionId;
            @Key
            private String customerId;

            protected Get(Long agencyId, Long advertiserId, Long engineAccountId, Integer endDate, Integer rowCount, Integer startDate, Long startRow) {
                super(Doubleclicksearch.this, "GET", REST_PATH, null, ConversionList.class);
                this.agencyId = (Long)Preconditions.checkNotNull((Object)agencyId, (Object)"Required parameter agencyId must be specified.");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)advertiserId, (Object)"Required parameter advertiserId must be specified.");
                this.engineAccountId = (Long)Preconditions.checkNotNull((Object)engineAccountId, (Object)"Required parameter engineAccountId must be specified.");
                this.endDate = (Integer)Preconditions.checkNotNull((Object)endDate, (Object)"Required parameter endDate must be specified.");
                this.rowCount = (Integer)Preconditions.checkNotNull((Object)rowCount, (Object)"Required parameter rowCount must be specified.");
                this.startDate = (Integer)Preconditions.checkNotNull((Object)startDate, (Object)"Required parameter startDate must be specified.");
                this.startRow = (Long)Preconditions.checkNotNull((Object)startRow, (Object)"Required parameter startRow must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getAgencyId() {
                return this.agencyId;
            }

            public Get setAgencyId(Long agencyId) {
                this.agencyId = agencyId;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long advertiserId) {
                this.advertiserId = advertiserId;
                return this;
            }

            public Long getEngineAccountId() {
                return this.engineAccountId;
            }

            public Get setEngineAccountId(Long engineAccountId) {
                this.engineAccountId = engineAccountId;
                return this;
            }

            public Integer getEndDate() {
                return this.endDate;
            }

            public Get setEndDate(Integer endDate) {
                this.endDate = endDate;
                return this;
            }

            public Integer getRowCount() {
                return this.rowCount;
            }

            public Get setRowCount(Integer rowCount) {
                this.rowCount = rowCount;
                return this;
            }

            public Integer getStartDate() {
                return this.startDate;
            }

            public Get setStartDate(Integer startDate) {
                this.startDate = startDate;
                return this;
            }

            public Long getStartRow() {
                return this.startRow;
            }

            public Get setStartRow(Long startRow) {
                this.startRow = startRow;
                return this;
            }

            public Long getAdGroupId() {
                return this.adGroupId;
            }

            public Get setAdGroupId(Long adGroupId) {
                this.adGroupId = adGroupId;
                return this;
            }

            public Long getAdId() {
                return this.adId;
            }

            public Get setAdId(Long adId) {
                this.adId = adId;
                return this;
            }

            public Long getCampaignId() {
                return this.campaignId;
            }

            public Get setCampaignId(Long campaignId) {
                this.campaignId = campaignId;
                return this;
            }

            public Long getCriterionId() {
                return this.criterionId;
            }

            public Get setCriterionId(Long criterionId) {
                this.criterionId = criterionId;
                return this;
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

