/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-19 at 05:31:48 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.doubleclicksearch;

/**
 * Service definition for Doubleclicksearch (v2).
 *
 * <p>
 * Reports and modifies your advertising data in DoubleClick Search (for example, campaigns, ad groups, keywords, and conversions).
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/doubleclick-search/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link DoubleclicksearchRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Doubleclicksearch extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.25.0 of the Search Ads 360 API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "doubleclicksearch/v2/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/doubleclicksearch/v2";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Doubleclicksearch(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Doubleclicksearch(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Conversion collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Doubleclicksearch doubleclicksearch = new Doubleclicksearch(...);}
   *   {@code Doubleclicksearch.Conversion.List request = doubleclicksearch.conversion().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Conversion conversion() {
    return new Conversion();
  }

  /**
   * The "conversion" collection of methods.
   */
  public class Conversion {

    /**
     * Retrieves a list of conversions from a DoubleClick Search engine account.
     *
     * Create a request for the method "conversion.get".
     *
     * This request holds the parameters needed by the doubleclicksearch server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param agencyId Numeric ID of the agency.
     * @param advertiserId Numeric ID of the advertiser.
     * @param engineAccountId Numeric ID of the engine account.
     * @param endDate Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd.
    [minimum: 20091101]
     *        [maximum: 99991231]
     * @param rowCount The number of conversions to return per call.
    [minimum: 1]
    [maximum: 1000]
     * @param startDate First date (inclusive) on which to retrieve conversions. Format is yyyymmdd.
    [minimum: 20091101]
     *        [maximum: 99991231]
     * @param startRow The 0-based starting index for retrieving conversions results.
     * @return the request
     */
    public Get get(java.lang.Long agencyId, java.lang.Long advertiserId, java.lang.Long engineAccountId, java.lang.Integer endDate, java.lang.Integer rowCount, java.lang.Integer startDate, java.lang.Long startRow) throws java.io.IOException {
      Get result = new Get(agencyId, advertiserId, engineAccountId, endDate, rowCount, startDate, startRow);
      initialize(result);
      return result;
    }

    public class Get extends DoubleclicksearchRequest<com.google.api.services.doubleclicksearch.model.ConversionList> {

      private static final String REST_PATH = "agency/{agencyId}/advertiser/{advertiserId}/engine/{engineAccountId}/conversion";

      /**
       * Retrieves a list of conversions from a DoubleClick Search engine account.
       *
       * Create a request for the method "conversion.get".
       *
       * This request holds the parameters needed by the the doubleclicksearch server.  After setting
       * any optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       * <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param agencyId Numeric ID of the agency.
       * @param advertiserId Numeric ID of the advertiser.
       * @param engineAccountId Numeric ID of the engine account.
       * @param endDate Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd.
    [minimum: 20091101]
     *        [maximum: 99991231]
       * @param rowCount The number of conversions to return per call.
    [minimum: 1]
    [maximum: 1000]
       * @param startDate First date (inclusive) on which to retrieve conversions. Format is yyyymmdd.
    [minimum: 20091101]
     *        [maximum: 99991231]
       * @param startRow The 0-based starting index for retrieving conversions results.
       * @since 1.13
       */
      protected Get(java.lang.Long agencyId, java.lang.Long advertiserId, java.lang.Long engineAccountId, java.lang.Integer endDate, java.lang.Integer rowCount, java.lang.Integer startDate, java.lang.Long startRow) {
        super(Doubleclicksearch.this, "GET", REST_PATH, null, com.google.api.services.doubleclicksearch.model.ConversionList.class);
        this.agencyId = com.google.api.client.util.Preconditions.checkNotNull(agencyId, "Required parameter agencyId must be specified.");
        this.advertiserId = com.google.api.client.util.Preconditions.checkNotNull(advertiserId, "Required parameter advertiserId must be specified.");
        this.engineAccountId = com.google.api.client.util.Preconditions.checkNotNull(engineAccountId, "Required parameter engineAccountId must be specified.");
        this.endDate = com.google.api.client.util.Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
        this.rowCount = com.google.api.client.util.Preconditions.checkNotNull(rowCount, "Required parameter rowCount must be specified.");
        this.startDate = com.google.api.client.util.Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
        this.startRow = com.google.api.client.util.Preconditions.checkNotNull(startRow, "Required parameter startRow must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Numeric ID of the agency. */
      @com.google.api.client.util.Key
      private java.lang.Long agencyId;

      /** Numeric ID of the agency.
       */
      public java.lang.Long getAgencyId() {
        return agencyId;
      }

      /** Numeric ID of the agency. */
      public Get setAgencyId(java.lang.Long agencyId) {
        this.agencyId = agencyId;
        return this;
      }

      /** Numeric ID of the advertiser. */
      @com.google.api.client.util.Key
      private java.lang.Long advertiserId;

      /** Numeric ID of the advertiser.
       */
      public java.lang.Long getAdvertiserId() {
        return advertiserId;
      }

      /** Numeric ID of the advertiser. */
      public Get setAdvertiserId(java.lang.Long advertiserId) {
        this.advertiserId = advertiserId;
        return this;
      }

      /** Numeric ID of the engine account. */
      @com.google.api.client.util.Key
      private java.lang.Long engineAccountId;

      /** Numeric ID of the engine account.
       */
      public java.lang.Long getEngineAccountId() {
        return engineAccountId;
      }

      /** Numeric ID of the engine account. */
      public Get setEngineAccountId(java.lang.Long engineAccountId) {
        this.engineAccountId = engineAccountId;
        return this;
      }

      /** Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd. */
      @com.google.api.client.util.Key
      private java.lang.Integer endDate;

      /** Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd.

     [minimum: 20091101] [maximum: 99991231]
       */
      public java.lang.Integer getEndDate() {
        return endDate;
      }

      /** Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd. */
      public Get setEndDate(java.lang.Integer endDate) {
        this.endDate = endDate;
        return this;
      }

      /** The number of conversions to return per call. */
      @com.google.api.client.util.Key
      private java.lang.Integer rowCount;

      /** The number of conversions to return per call.

     [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getRowCount() {
        return rowCount;
      }

      /** The number of conversions to return per call. */
      public Get setRowCount(java.lang.Integer rowCount) {
        this.rowCount = rowCount;
        return this;
      }

      /** First date (inclusive) on which to retrieve conversions. Format is yyyymmdd. */
      @com.google.api.client.util.Key
      private java.lang.Integer startDate;

      /** First date (inclusive) on which to retrieve conversions. Format is yyyymmdd.

     [minimum: 20091101] [maximum: 99991231]
       */
      public java.lang.Integer getStartDate() {
        return startDate;
      }

      /** First date (inclusive) on which to retrieve conversions. Format is yyyymmdd. */
      public Get setStartDate(java.lang.Integer startDate) {
        this.startDate = startDate;
        return this;
      }

      /** The 0-based starting index for retrieving conversions results. */
      @com.google.api.client.util.Key
      private java.lang.Long startRow;

      /** The 0-based starting index for retrieving conversions results.
       */
      public java.lang.Long getStartRow() {
        return startRow;
      }

      /** The 0-based starting index for retrieving conversions results. */
      public Get setStartRow(java.lang.Long startRow) {
        this.startRow = startRow;
        return this;
      }

      /** Numeric ID of the ad group. */
      @com.google.api.client.util.Key
      private java.lang.Long adGroupId;

      /** Numeric ID of the ad group.
       */
      public java.lang.Long getAdGroupId() {
        return adGroupId;
      }

      /** Numeric ID of the ad group. */
      public Get setAdGroupId(java.lang.Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
      }

      /** Numeric ID of the ad. */
      @com.google.api.client.util.Key
      private java.lang.Long adId;

      /** Numeric ID of the ad.
       */
      public java.lang.Long getAdId() {
        return adId;
      }

      /** Numeric ID of the ad. */
      public Get setAdId(java.lang.Long adId) {
        this.adId = adId;
        return this;
      }

      /** Numeric ID of the campaign. */
      @com.google.api.client.util.Key
      private java.lang.Long campaignId;

      /** Numeric ID of the campaign.
       */
      public java.lang.Long getCampaignId() {
        return campaignId;
      }

      /** Numeric ID of the campaign. */
      public Get setCampaignId(java.lang.Long campaignId) {
        this.campaignId = campaignId;
        return this;
      }

      /** Numeric ID of the criterion. */
      @com.google.api.client.util.Key
      private java.lang.Long criterionId;

      /** Numeric ID of the criterion.
       */
      public java.lang.Long getCriterionId() {
        return criterionId;
      }

      /** Numeric ID of the criterion. */
      public Get setCriterionId(java.lang.Long criterionId) {
        this.criterionId = criterionId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a batch of new conversions into DoubleClick Search.
     *
     * Create a request for the method "conversion.insert".
     *
     * This request holds the parameters needed by the doubleclicksearch server.  After setting any
     * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.doubleclicksearch.model.ConversionList}
     * @return the request
     */
    public Insert insert(com.google.api.services.doubleclicksearch.model.ConversionList content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends DoubleclicksearchRequest<com.google.api.services.doubleclicksearch.model.ConversionList> {

      private static final String REST_PATH = "conversion";

      /**
       * Inserts a batch of new conversions into DoubleClick Search.
       *
       * Create a request for the method "conversion.insert".
       *
       * This request holds the parameters needed by the the doubleclicksearch server.  After setting
       * any optional parameters, call the {@link Insert#execute()} method to invoke the remote
       * operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.doubleclicksearch.model.ConversionList}
       * @since 1.13
       */
      protected Insert(com.google.api.services.doubleclicksearch.model.ConversionList content) {
        super(Doubleclicksearch.this, "POST", REST_PATH, content, com.google.api.services.doubleclicksearch.model.ConversionList.class);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Updates a batch of conversions in DoubleClick Search. This method supports patch semantics.
     *
     * Create a request for the method "conversion.patch".
     *
     * This request holds the parameters needed by the doubleclicksearch server.  After setting any
     * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param advertiserId Numeric ID of the advertiser.
     * @param agencyId Numeric ID of the agency.
     * @param endDate Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd.
    [minimum: 20091101]
     *        [maximum: 99991231]
     * @param engineAccountId Numeric ID of the engine account.
     * @param rowCount The number of conversions to return per call.
    [minimum: 1]
    [maximum: 1000]
     * @param startDate First date (inclusive) on which to retrieve conversions. Format is yyyymmdd.
    [minimum: 20091101]
     *        [maximum: 99991231]
     * @param startRow The 0-based starting index for retrieving conversions results.
     * @param content the {@link com.google.api.services.doubleclicksearch.model.ConversionList}
     * @return the request
     */
    public Patch patch(java.lang.Long advertiserId, java.lang.Long agencyId, java.lang.Integer endDate, java.lang.Long engineAccountId, java.lang.Integer rowCount, java.lang.Integer startDate, java.lang.Long startRow, com.google.api.services.doubleclicksearch.model.ConversionList content) throws java.io.IOException {
      Patch result = new Patch(advertiserId, agencyId, endDate, engineAccountId, rowCount, startDate, startRow, content);
      initialize(result);
      return result;
    }

    public class Patch extends DoubleclicksearchRequest<com.google.api.services.doubleclicksearch.model.ConversionList> {

      private static final String REST_PATH = "conversion";

      /**
       * Updates a batch of conversions in DoubleClick Search. This method supports patch semantics.
       *
       * Create a request for the method "conversion.patch".
       *
       * This request holds the parameters needed by the the doubleclicksearch server.  After setting
       * any optional parameters, call the {@link Patch#execute()} method to invoke the remote
       * operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param advertiserId Numeric ID of the advertiser.
       * @param agencyId Numeric ID of the agency.
       * @param endDate Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd.
    [minimum: 20091101]
     *        [maximum: 99991231]
       * @param engineAccountId Numeric ID of the engine account.
       * @param rowCount The number of conversions to return per call.
    [minimum: 1]
    [maximum: 1000]
       * @param startDate First date (inclusive) on which to retrieve conversions. Format is yyyymmdd.
    [minimum: 20091101]
     *        [maximum: 99991231]
       * @param startRow The 0-based starting index for retrieving conversions results.
       * @param content the {@link com.google.api.services.doubleclicksearch.model.ConversionList}
       * @since 1.13
       */
      protected Patch(java.lang.Long advertiserId, java.lang.Long agencyId, java.lang.Integer endDate, java.lang.Long engineAccountId, java.lang.Integer rowCount, java.lang.Integer startDate, java.lang.Long startRow, com.google.api.services.doubleclicksearch.model.ConversionList content) {
        super(Doubleclicksearch.this, "PATCH", REST_PATH, content, com.google.api.services.doubleclicksearch.model.ConversionList.class);
        this.advertiserId = com.google.api.client.util.Preconditions.checkNotNull(advertiserId, "Required parameter advertiserId must be specified.");
        this.agencyId = com.google.api.client.util.Preconditions.checkNotNull(agencyId, "Required parameter agencyId must be specified.");
        this.endDate = com.google.api.client.util.Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
        this.engineAccountId = com.google.api.client.util.Preconditions.checkNotNull(engineAccountId, "Required parameter engineAccountId must be specified.");
        this.rowCount = com.google.api.client.util.Preconditions.checkNotNull(rowCount, "Required parameter rowCount must be specified.");
        this.startDate = com.google.api.client.util.Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
        this.startRow = com.google.api.client.util.Preconditions.checkNotNull(startRow, "Required parameter startRow must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Numeric ID of the advertiser. */
      @com.google.api.client.util.Key
      private java.lang.Long advertiserId;

      /** Numeric ID of the advertiser.
       */
      public java.lang.Long getAdvertiserId() {
        return advertiserId;
      }

      /** Numeric ID of the advertiser. */
      public Patch setAdvertiserId(java.lang.Long advertiserId) {
        this.advertiserId = advertiserId;
        return this;
      }

      /** Numeric ID of the agency. */
      @com.google.api.client.util.Key
      private java.lang.Long agencyId;

      /** Numeric ID of the agency.
       */
      public java.lang.Long getAgencyId() {
        return agencyId;
      }

      /** Numeric ID of the agency. */
      public Patch setAgencyId(java.lang.Long agencyId) {
        this.agencyId = agencyId;
        return this;
      }

      /** Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd. */
      @com.google.api.client.util.Key
      private java.lang.Integer endDate;

      /** Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd.

     [minimum: 20091101] [maximum: 99991231]
       */
      public java.lang.Integer getEndDate() {
        return endDate;
      }

      /** Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd. */
      public Patch setEndDate(java.lang.Integer endDate) {
        this.endDate = endDate;
        return this;
      }

      /** Numeric ID of the engine account. */
      @com.google.api.client.util.Key
      private java.lang.Long engineAccountId;

      /** Numeric ID of the engine account.
       */
      public java.lang.Long getEngineAccountId() {
        return engineAccountId;
      }

      /** Numeric ID of the engine account. */
      public Patch setEngineAccountId(java.lang.Long engineAccountId) {
        this.engineAccountId = engineAccountId;
        return this;
      }

      /** The number of conversions to return per call. */
      @com.google.api.client.util.Key
      private java.lang.Integer rowCount;

      /** The number of conversions to return per call.

     [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getRowCount() {
        return rowCount;
      }

      /** The number of conversions to return per call. */
      public Patch setRowCount(java.lang.Integer rowCount) {
        this.rowCount = rowCount;
        return this;
      }

      /** First date (inclusive) on which to retrieve conversions. Format is yyyymmdd. */
      @com.google.api.client.util.Key
      private java.lang.Integer startDate;

      /** First date (inclusive) on which to retrieve conversions. Format is yyyymmdd.

     [minimum: 20091101] [maximum: 99991231]
       */
      public java.lang.Integer getStartDate() {
        return startDate;
      }

      /** First date (inclusive) on which to retrieve conversions. Format is yyyymmdd. */
      public Patch setStartDate(java.lang.Integer startDate) {
        this.startDate = startDate;
        return this;
      }

      /** The 0-based starting index for retrieving conversions results. */
      @com.google.api.client.util.Key
      private java.lang.Long startRow;

      /** The 0-based starting index for retrieving conversions results.
       */
      public java.lang.Long getStartRow() {
        return startRow;
      }

      /** The 0-based starting index for retrieving conversions results. */
      public Patch setStartRow(java.lang.Long startRow) {
        this.startRow = startRow;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a batch of conversions in DoubleClick Search.
     *
     * Create a request for the method "conversion.update".
     *
     * This request holds the parameters needed by the doubleclicksearch server.  After setting any
     * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.doubleclicksearch.model.ConversionList}
     * @return the request
     */
    public Update update(com.google.api.services.doubleclicksearch.model.ConversionList content) throws java.io.IOException {
      Update result = new Update(content);
      initialize(result);
      return result;
    }

    public class Update extends DoubleclicksearchRequest<com.google.api.services.doubleclicksearch.model.ConversionList> {

      private static final String REST_PATH = "conversion";

      /**
       * Updates a batch of conversions in DoubleClick Search.
       *
       * Create a request for the method "conversion.update".
       *
       * This request holds the parameters needed by the the doubleclicksearch server.  After setting
       * any optional parameters, call the {@link Update#execute()} method to invoke the remote
       * operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.doubleclicksearch.model.ConversionList}
       * @since 1.13
       */
      protected Update(com.google.api.services.doubleclicksearch.model.ConversionList content) {
        super(Doubleclicksearch.this, "PUT", REST_PATH, content, com.google.api.services.doubleclicksearch.model.ConversionList.class);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
    /**
     * Updates the availabilities of a batch of floodlight activities in DoubleClick Search.
     *
     * Create a request for the method "conversion.updateAvailability".
     *
     * This request holds the parameters needed by the doubleclicksearch server.  After setting any
     * optional parameters, call the {@link UpdateAvailability#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.doubleclicksearch.model.UpdateAvailabilityRequest}
     * @return the request
     */
    public UpdateAvailability updateAvailability(com.google.api.services.doubleclicksearch.model.UpdateAvailabilityRequest content) throws java.io.IOException {
      UpdateAvailability result = new UpdateAvailability(content);
      initialize(result);
      return result;
    }

    public class UpdateAvailability extends DoubleclicksearchRequest<com.google.api.services.doubleclicksearch.model.UpdateAvailabilityResponse> {

      private static final String REST_PATH = "conversion/updateAvailability";

      /**
       * Updates the availabilities of a batch of floodlight activities in DoubleClick Search.
       *
       * Create a request for the method "conversion.updateAvailability".
       *
       * This request holds the parameters needed by the the doubleclicksearch server.  After setting
       * any optional parameters, call the {@link UpdateAvailability#execute()} method to invoke the
       * remote operation. <p> {@link UpdateAvailability#initialize(com.google.api.client.googleapis.ser
       * vices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.doubleclicksearch.model.UpdateAvailabilityRequest}
       * @since 1.13
       */
      protected UpdateAvailability(com.google.api.services.doubleclicksearch.model.UpdateAvailabilityRequest content) {
        super(Doubleclicksearch.this, "POST", REST_PATH, content, com.google.api.services.doubleclicksearch.model.UpdateAvailabilityResponse.class);
      }

      @Override
      public UpdateAvailability setAlt(java.lang.String alt) {
        return (UpdateAvailability) super.setAlt(alt);
      }

      @Override
      public UpdateAvailability setFields(java.lang.String fields) {
        return (UpdateAvailability) super.setFields(fields);
      }

      @Override
      public UpdateAvailability setKey(java.lang.String key) {
        return (UpdateAvailability) super.setKey(key);
      }

      @Override
      public UpdateAvailability setOauthToken(java.lang.String oauthToken) {
        return (UpdateAvailability) super.setOauthToken(oauthToken);
      }

      @Override
      public UpdateAvailability setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (UpdateAvailability) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public UpdateAvailability setQuotaUser(java.lang.String quotaUser) {
        return (UpdateAvailability) super.setQuotaUser(quotaUser);
      }

      @Override
      public UpdateAvailability setUserIp(java.lang.String userIp) {
        return (UpdateAvailability) super.setUserIp(userIp);
      }

      @Override
      public UpdateAvailability set(String parameterName, Object value) {
        return (UpdateAvailability) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Reports collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Doubleclicksearch doubleclicksearch = new Doubleclicksearch(...);}
   *   {@code Doubleclicksearch.Reports.List request = doubleclicksearch.reports().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Reports reports() {
    return new Reports();
  }

  /**
   * The "reports" collection of methods.
   */
  public class Reports {

    /**
     * Generates and returns a report immediately.
     *
     * Create a request for the method "reports.generate".
     *
     * This request holds the parameters needed by the doubleclicksearch server.  After setting any
     * optional parameters, call the {@link Generate#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.doubleclicksearch.model.ReportRequest}
     * @return the request
     */
    public Generate generate(com.google.api.services.doubleclicksearch.model.ReportRequest content) throws java.io.IOException {
      Generate result = new Generate(content);
      initialize(result);
      return result;
    }

    public class Generate extends DoubleclicksearchRequest<com.google.api.services.doubleclicksearch.model.Report> {

      private static final String REST_PATH = "reports/generate";

      /**
       * Generates and returns a report immediately.
       *
       * Create a request for the method "reports.generate".
       *
       * This request holds the parameters needed by the the doubleclicksearch server.  After setting
       * any optional parameters, call the {@link Generate#execute()} method to invoke the remote
       * operation. <p> {@link
       * Generate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.doubleclicksearch.model.ReportRequest}
       * @since 1.13
       */
      protected Generate(com.google.api.services.doubleclicksearch.model.ReportRequest content) {
        super(Doubleclicksearch.this, "POST", REST_PATH, content, com.google.api.services.doubleclicksearch.model.Report.class);
      }

      @Override
      public Generate setAlt(java.lang.String alt) {
        return (Generate) super.setAlt(alt);
      }

      @Override
      public Generate setFields(java.lang.String fields) {
        return (Generate) super.setFields(fields);
      }

      @Override
      public Generate setKey(java.lang.String key) {
        return (Generate) super.setKey(key);
      }

      @Override
      public Generate setOauthToken(java.lang.String oauthToken) {
        return (Generate) super.setOauthToken(oauthToken);
      }

      @Override
      public Generate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Generate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Generate setQuotaUser(java.lang.String quotaUser) {
        return (Generate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Generate setUserIp(java.lang.String userIp) {
        return (Generate) super.setUserIp(userIp);
      }

      @Override
      public Generate set(String parameterName, Object value) {
        return (Generate) super.set(parameterName, value);
      }
    }
    /**
     * Polls for the status of a report request.
     *
     * Create a request for the method "reports.get".
     *
     * This request holds the parameters needed by the doubleclicksearch server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param reportId ID of the report request being polled.
     * @return the request
     */
    public Get get(java.lang.String reportId) throws java.io.IOException {
      Get result = new Get(reportId);
      initialize(result);
      return result;
    }

    public class Get extends DoubleclicksearchRequest<com.google.api.services.doubleclicksearch.model.Report> {

      private static final String REST_PATH = "reports/{reportId}";

      /**
       * Polls for the status of a report request.
       *
       * Create a request for the method "reports.get".
       *
       * This request holds the parameters needed by the the doubleclicksearch server.  After setting
       * any optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       * <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param reportId ID of the report request being polled.
       * @since 1.13
       */
      protected Get(java.lang.String reportId) {
        super(Doubleclicksearch.this, "GET", REST_PATH, null, com.google.api.services.doubleclicksearch.model.Report.class);
        this.reportId = com.google.api.client.util.Preconditions.checkNotNull(reportId, "Required parameter reportId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** ID of the report request being polled. */
      @com.google.api.client.util.Key
      private java.lang.String reportId;

      /** ID of the report request being polled.
       */
      public java.lang.String getReportId() {
        return reportId;
      }

      /** ID of the report request being polled. */
      public Get setReportId(java.lang.String reportId) {
        this.reportId = reportId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Downloads a report file encoded in UTF-8.
     *
     * Create a request for the method "reports.getFile".
     *
     * This request holds the parameters needed by the doubleclicksearch server.  After setting any
     * optional parameters, call the {@link GetFile#execute()} method to invoke the remote operation.
     *
     * @param reportId ID of the report.
     * @param reportFragment The index of the report fragment to download.
    [minimum: 0]
     * @return the request
     */
    public GetFile getFile(java.lang.String reportId, java.lang.Integer reportFragment) throws java.io.IOException {
      GetFile result = new GetFile(reportId, reportFragment);
      initialize(result);
      return result;
    }

    public class GetFile extends DoubleclicksearchRequest<Void> {

      private static final String REST_PATH = "reports/{reportId}/files/{reportFragment}";

      /**
       * Downloads a report file encoded in UTF-8.
       *
       * Create a request for the method "reports.getFile".
       *
       * This request holds the parameters needed by the the doubleclicksearch server.  After setting
       * any optional parameters, call the {@link GetFile#execute()} method to invoke the remote
       * operation. <p> {@link
       * GetFile#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param reportId ID of the report.
       * @param reportFragment The index of the report fragment to download.
    [minimum: 0]
       * @since 1.13
       */
      protected GetFile(java.lang.String reportId, java.lang.Integer reportFragment) {
        super(Doubleclicksearch.this, "GET", REST_PATH, null, Void.class);
        this.reportId = com.google.api.client.util.Preconditions.checkNotNull(reportId, "Required parameter reportId must be specified.");
        this.reportFragment = com.google.api.client.util.Preconditions.checkNotNull(reportFragment, "Required parameter reportFragment must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.GenericUrl buildHttpRequestUrl() {
        java.lang.String baseUrl = ("media".equals(get("alt")) && getMediaHttpUploader() == null)
            ? getRootUrl() + "download/" + getServicePath() : getBaseUrl();
        return new com.google.api.client.http.GenericUrl(
            com.google.api.client.http.UriTemplate.expand(baseUrl, getUriTemplate(), this, true));
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetFile setAlt(java.lang.String alt) {
        return (GetFile) super.setAlt(alt);
      }

      @Override
      public GetFile setFields(java.lang.String fields) {
        return (GetFile) super.setFields(fields);
      }

      @Override
      public GetFile setKey(java.lang.String key) {
        return (GetFile) super.setKey(key);
      }

      @Override
      public GetFile setOauthToken(java.lang.String oauthToken) {
        return (GetFile) super.setOauthToken(oauthToken);
      }

      @Override
      public GetFile setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetFile) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetFile setQuotaUser(java.lang.String quotaUser) {
        return (GetFile) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetFile setUserIp(java.lang.String userIp) {
        return (GetFile) super.setUserIp(userIp);
      }

      /** ID of the report. */
      @com.google.api.client.util.Key
      private java.lang.String reportId;

      /** ID of the report.
       */
      public java.lang.String getReportId() {
        return reportId;
      }

      /** ID of the report. */
      public GetFile setReportId(java.lang.String reportId) {
        this.reportId = reportId;
        return this;
      }

      /** The index of the report fragment to download. */
      @com.google.api.client.util.Key
      private java.lang.Integer reportFragment;

      /** The index of the report fragment to download.

     [minimum: 0]
       */
      public java.lang.Integer getReportFragment() {
        return reportFragment;
      }

      /** The index of the report fragment to download. */
      public GetFile setReportFragment(java.lang.Integer reportFragment) {
        this.reportFragment = reportFragment;
        return this;
      }

      @Override
      public GetFile set(String parameterName, Object value) {
        return (GetFile) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a report request into the reporting system.
     *
     * Create a request for the method "reports.request".
     *
     * This request holds the parameters needed by the doubleclicksearch server.  After setting any
     * optional parameters, call the {@link Request#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.doubleclicksearch.model.ReportRequest}
     * @return the request
     */
    public Request request(com.google.api.services.doubleclicksearch.model.ReportRequest content) throws java.io.IOException {
      Request result = new Request(content);
      initialize(result);
      return result;
    }

    public class Request extends DoubleclicksearchRequest<com.google.api.services.doubleclicksearch.model.Report> {

      private static final String REST_PATH = "reports";

      /**
       * Inserts a report request into the reporting system.
       *
       * Create a request for the method "reports.request".
       *
       * This request holds the parameters needed by the the doubleclicksearch server.  After setting
       * any optional parameters, call the {@link Request#execute()} method to invoke the remote
       * operation. <p> {@link
       * Request#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.doubleclicksearch.model.ReportRequest}
       * @since 1.13
       */
      protected Request(com.google.api.services.doubleclicksearch.model.ReportRequest content) {
        super(Doubleclicksearch.this, "POST", REST_PATH, content, com.google.api.services.doubleclicksearch.model.Report.class);
      }

      @Override
      public Request setAlt(java.lang.String alt) {
        return (Request) super.setAlt(alt);
      }

      @Override
      public Request setFields(java.lang.String fields) {
        return (Request) super.setFields(fields);
      }

      @Override
      public Request setKey(java.lang.String key) {
        return (Request) super.setKey(key);
      }

      @Override
      public Request setOauthToken(java.lang.String oauthToken) {
        return (Request) super.setOauthToken(oauthToken);
      }

      @Override
      public Request setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Request) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Request setQuotaUser(java.lang.String quotaUser) {
        return (Request) super.setQuotaUser(quotaUser);
      }

      @Override
      public Request setUserIp(java.lang.String userIp) {
        return (Request) super.setUserIp(userIp);
      }

      @Override
      public Request set(String parameterName, Object value) {
        return (Request) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the SavedColumns collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Doubleclicksearch doubleclicksearch = new Doubleclicksearch(...);}
   *   {@code Doubleclicksearch.SavedColumns.List request = doubleclicksearch.savedColumns().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public SavedColumns savedColumns() {
    return new SavedColumns();
  }

  /**
   * The "savedColumns" collection of methods.
   */
  public class SavedColumns {

    /**
     * Retrieve the list of saved columns for a specified advertiser.
     *
     * Create a request for the method "savedColumns.list".
     *
     * This request holds the parameters needed by the doubleclicksearch server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param agencyId DS ID of the agency.
     * @param advertiserId DS ID of the advertiser.
     * @return the request
     */
    public List list(java.lang.Long agencyId, java.lang.Long advertiserId) throws java.io.IOException {
      List result = new List(agencyId, advertiserId);
      initialize(result);
      return result;
    }

    public class List extends DoubleclicksearchRequest<com.google.api.services.doubleclicksearch.model.SavedColumnList> {

      private static final String REST_PATH = "agency/{agencyId}/advertiser/{advertiserId}/savedcolumns";

      /**
       * Retrieve the list of saved columns for a specified advertiser.
       *
       * Create a request for the method "savedColumns.list".
       *
       * This request holds the parameters needed by the the doubleclicksearch server.  After setting
       * any optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       * <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param agencyId DS ID of the agency.
       * @param advertiserId DS ID of the advertiser.
       * @since 1.13
       */
      protected List(java.lang.Long agencyId, java.lang.Long advertiserId) {
        super(Doubleclicksearch.this, "GET", REST_PATH, null, com.google.api.services.doubleclicksearch.model.SavedColumnList.class);
        this.agencyId = com.google.api.client.util.Preconditions.checkNotNull(agencyId, "Required parameter agencyId must be specified.");
        this.advertiserId = com.google.api.client.util.Preconditions.checkNotNull(advertiserId, "Required parameter advertiserId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** DS ID of the agency. */
      @com.google.api.client.util.Key
      private java.lang.Long agencyId;

      /** DS ID of the agency.
       */
      public java.lang.Long getAgencyId() {
        return agencyId;
      }

      /** DS ID of the agency. */
      public List setAgencyId(java.lang.Long agencyId) {
        this.agencyId = agencyId;
        return this;
      }

      /** DS ID of the advertiser. */
      @com.google.api.client.util.Key
      private java.lang.Long advertiserId;

      /** DS ID of the advertiser.
       */
      public java.lang.Long getAdvertiserId() {
        return advertiserId;
      }

      /** DS ID of the advertiser. */
      public List setAdvertiserId(java.lang.Long advertiserId) {
        this.advertiserId = advertiserId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Doubleclicksearch}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Doubleclicksearch}. */
    @Override
    public Doubleclicksearch build() {
      return new Doubleclicksearch(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link DoubleclicksearchRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setDoubleclicksearchRequestInitializer(
        DoubleclicksearchRequestInitializer doubleclicksearchRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(doubleclicksearchRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
