/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-19 at 05:31:48 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.doubleclicksearch.model;

/**
 * A list of saved columns. Advertisers create saved columns to report on Floodlight activities,
 * Google Analytics goals, or custom KPIs. To request reports with saved columns, you'll need the
 * saved column names that are available from this list.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Search Ads 360 API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SavedColumnList extends com.google.api.client.json.GenericJson {

  /**
   * The saved columns being requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SavedColumn> items;

  static {
    // hack to force ProGuard to consider SavedColumn used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(SavedColumn.class);
  }

  /**
   * Identifies this as a SavedColumnList resource. Value: the fixed string
   * doubleclicksearch#savedColumnList.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The saved columns being requested.
   * @return value or {@code null} for none
   */
  public java.util.List<SavedColumn> getItems() {
    return items;
  }

  /**
   * The saved columns being requested.
   * @param items items or {@code null} for none
   */
  public SavedColumnList setItems(java.util.List<SavedColumn> items) {
    this.items = items;
    return this;
  }

  /**
   * Identifies this as a SavedColumnList resource. Value: the fixed string
   * doubleclicksearch#savedColumnList.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies this as a SavedColumnList resource. Value: the fixed string
   * doubleclicksearch#savedColumnList.
   * @param kind kind or {@code null} for none
   */
  public SavedColumnList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public SavedColumnList set(String fieldName, Object value) {
    return (SavedColumnList) super.set(fieldName, value);
  }

  @Override
  public SavedColumnList clone() {
    return (SavedColumnList) super.clone();
  }

}
