/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.doubleclicksearch;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UriTemplate;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.doubleclicksearch.DoubleclicksearchRequest;
import com.google.api.services.doubleclicksearch.DoubleclicksearchRequestInitializer;
import com.google.api.services.doubleclicksearch.model.ConversionList;
import com.google.api.services.doubleclicksearch.model.Report;
import com.google.api.services.doubleclicksearch.model.ReportRequest;
import com.google.api.services.doubleclicksearch.model.SavedColumnList;
import com.google.api.services.doubleclicksearch.model.UpdateAvailabilityRequest;
import com.google.api.services.doubleclicksearch.model.UpdateAvailabilityResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doubleclicksearch
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "doubleclicksearch/v2/";
    public static final String DEFAULT_BATCH_PATH = "batch/doubleclicksearch/v2";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/doubleclicksearch/v2/";

    public Doubleclicksearch(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Doubleclicksearch(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Conversion conversion() {
        return new Conversion();
    }

    public Reports reports() {
        return new Reports();
    }

    public SavedColumns savedColumns() {
        return new SavedColumns();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Search Ads 360 API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Doubleclicksearch.DEFAULT_ROOT_URL, Doubleclicksearch.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Doubleclicksearch.DEFAULT_BATCH_PATH);
        }

        public Doubleclicksearch build() {
            return new Doubleclicksearch(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDoubleclicksearchRequestInitializer(DoubleclicksearchRequestInitializer doubleclicksearchRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)doubleclicksearchRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class SavedColumns {
        public List list(Long l, Long l2) throws IOException {
            List list = new List(l, l2);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DoubleclicksearchRequest<SavedColumnList> {
            private static final String REST_PATH = "agency/{agencyId}/advertiser/{advertiserId}/savedcolumns";
            @Key
            private Long agencyId;
            @Key
            private Long advertiserId;

            protected List(Long l, Long l2) {
                super(Doubleclicksearch.this, "GET", REST_PATH, null, SavedColumnList.class);
                this.agencyId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter agencyId must be specified.");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)l2, (Object)"Required parameter advertiserId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public Long getAgencyId() {
                return this.agencyId;
            }

            public List setAgencyId(Long l) {
                this.agencyId = l;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public List setAdvertiserId(Long l) {
                this.advertiserId = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Reports {
        public Generate generate(ReportRequest reportRequest) throws IOException {
            Generate generate = new Generate(reportRequest);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)generate);
            return generate;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetFile getFile(String string, Integer n) throws IOException {
            GetFile getFile = new GetFile(string, n);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)getFile);
            return getFile;
        }

        public Request request(ReportRequest reportRequest) throws IOException {
            Request request = new Request(reportRequest);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)request);
            return request;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Request
        extends DoubleclicksearchRequest<Report> {
            private static final String REST_PATH = "reports";

            protected Request(ReportRequest reportRequest) {
                super(Doubleclicksearch.this, "POST", REST_PATH, (Object)reportRequest, Report.class);
            }

            public Request setAlt(String string) {
                return (Request)super.setAlt(string);
            }

            public Request setFields(String string) {
                return (Request)super.setFields(string);
            }

            public Request setKey(String string) {
                return (Request)super.setKey(string);
            }

            public Request setOauthToken(String string) {
                return (Request)super.setOauthToken(string);
            }

            public Request setPrettyPrint(Boolean bl) {
                return (Request)super.setPrettyPrint(bl);
            }

            public Request setQuotaUser(String string) {
                return (Request)super.setQuotaUser(string);
            }

            public Request setUserIp(String string) {
                return (Request)super.setUserIp(string);
            }

            @Override
            public Request set(String string, Object object) {
                return (Request)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetFile
        extends DoubleclicksearchRequest<Void> {
            private static final String REST_PATH = "reports/{reportId}/files/{reportFragment}";
            @Key
            private String reportId;
            @Key
            private Integer reportFragment;

            protected GetFile(String string, Integer n) {
                super(Doubleclicksearch.this, "GET", REST_PATH, null, Void.class);
                this.reportId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter reportId must be specified.");
                this.reportFragment = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter reportFragment must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public GenericUrl buildHttpRequestUrl() {
                String string = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? Doubleclicksearch.this.getRootUrl() + "download/" + Doubleclicksearch.this.getServicePath() : Doubleclicksearch.this.getBaseUrl();
                return new GenericUrl(UriTemplate.expand((String)string, (String)this.getUriTemplate(), (Object)((Object)this), (boolean)true));
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetFile setAlt(String string) {
                return (GetFile)super.setAlt(string);
            }

            public GetFile setFields(String string) {
                return (GetFile)super.setFields(string);
            }

            public GetFile setKey(String string) {
                return (GetFile)super.setKey(string);
            }

            public GetFile setOauthToken(String string) {
                return (GetFile)super.setOauthToken(string);
            }

            public GetFile setPrettyPrint(Boolean bl) {
                return (GetFile)super.setPrettyPrint(bl);
            }

            public GetFile setQuotaUser(String string) {
                return (GetFile)super.setQuotaUser(string);
            }

            public GetFile setUserIp(String string) {
                return (GetFile)super.setUserIp(string);
            }

            public String getReportId() {
                return this.reportId;
            }

            public GetFile setReportId(String string) {
                this.reportId = string;
                return this;
            }

            public Integer getReportFragment() {
                return this.reportFragment;
            }

            public GetFile setReportFragment(Integer n) {
                this.reportFragment = n;
                return this;
            }

            @Override
            public GetFile set(String string, Object object) {
                return (GetFile)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DoubleclicksearchRequest<Report> {
            private static final String REST_PATH = "reports/{reportId}";
            @Key
            private String reportId;

            protected Get(String string) {
                super(Doubleclicksearch.this, "GET", REST_PATH, null, Report.class);
                this.reportId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter reportId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getReportId() {
                return this.reportId;
            }

            public Get setReportId(String string) {
                this.reportId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Generate
        extends DoubleclicksearchRequest<Report> {
            private static final String REST_PATH = "reports/generate";

            protected Generate(ReportRequest reportRequest) {
                super(Doubleclicksearch.this, "POST", REST_PATH, (Object)reportRequest, Report.class);
            }

            public Generate setAlt(String string) {
                return (Generate)super.setAlt(string);
            }

            public Generate setFields(String string) {
                return (Generate)super.setFields(string);
            }

            public Generate setKey(String string) {
                return (Generate)super.setKey(string);
            }

            public Generate setOauthToken(String string) {
                return (Generate)super.setOauthToken(string);
            }

            public Generate setPrettyPrint(Boolean bl) {
                return (Generate)super.setPrettyPrint(bl);
            }

            public Generate setQuotaUser(String string) {
                return (Generate)super.setQuotaUser(string);
            }

            public Generate setUserIp(String string) {
                return (Generate)super.setUserIp(string);
            }

            @Override
            public Generate set(String string, Object object) {
                return (Generate)super.set(string, object);
            }
        }
    }

    public class Conversion {
        public Get get(Long l, Long l2, Long l3, Integer n, Integer n2, Integer n3, Long l4) throws IOException {
            Get get = new Get(l, l2, l3, n, n2, n3, l4);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(ConversionList conversionList) throws IOException {
            Insert insert = new Insert(conversionList);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Patch patch(Long l, Long l2, Integer n, Long l3, Integer n2, Integer n3, Long l4, ConversionList conversionList) throws IOException {
            Patch patch = new Patch(l, l2, n, l3, n2, n3, l4, conversionList);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(ConversionList conversionList) throws IOException {
            Update update = new Update(conversionList);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public UpdateAvailability updateAvailability(UpdateAvailabilityRequest updateAvailabilityRequest) throws IOException {
            UpdateAvailability updateAvailability = new UpdateAvailability(updateAvailabilityRequest);
            Doubleclicksearch.this.initialize((AbstractGoogleClientRequest<?>)updateAvailability);
            return updateAvailability;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class UpdateAvailability
        extends DoubleclicksearchRequest<UpdateAvailabilityResponse> {
            private static final String REST_PATH = "conversion/updateAvailability";

            protected UpdateAvailability(UpdateAvailabilityRequest updateAvailabilityRequest) {
                super(Doubleclicksearch.this, "POST", REST_PATH, (Object)updateAvailabilityRequest, UpdateAvailabilityResponse.class);
            }

            public UpdateAvailability setAlt(String string) {
                return (UpdateAvailability)super.setAlt(string);
            }

            public UpdateAvailability setFields(String string) {
                return (UpdateAvailability)super.setFields(string);
            }

            public UpdateAvailability setKey(String string) {
                return (UpdateAvailability)super.setKey(string);
            }

            public UpdateAvailability setOauthToken(String string) {
                return (UpdateAvailability)super.setOauthToken(string);
            }

            public UpdateAvailability setPrettyPrint(Boolean bl) {
                return (UpdateAvailability)super.setPrettyPrint(bl);
            }

            public UpdateAvailability setQuotaUser(String string) {
                return (UpdateAvailability)super.setQuotaUser(string);
            }

            public UpdateAvailability setUserIp(String string) {
                return (UpdateAvailability)super.setUserIp(string);
            }

            @Override
            public UpdateAvailability set(String string, Object object) {
                return (UpdateAvailability)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DoubleclicksearchRequest<ConversionList> {
            private static final String REST_PATH = "conversion";

            protected Update(ConversionList conversionList) {
                super(Doubleclicksearch.this, "PUT", REST_PATH, (Object)conversionList, ConversionList.class);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DoubleclicksearchRequest<ConversionList> {
            private static final String REST_PATH = "conversion";
            @Key
            private Long advertiserId;
            @Key
            private Long agencyId;
            @Key
            private Integer endDate;
            @Key
            private Long engineAccountId;
            @Key
            private Integer rowCount;
            @Key
            private Integer startDate;
            @Key
            private Long startRow;

            protected Patch(Long l, Long l2, Integer n, Long l3, Integer n2, Integer n3, Long l4, ConversionList conversionList) {
                super(Doubleclicksearch.this, "PATCH", REST_PATH, (Object)conversionList, ConversionList.class);
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter advertiserId must be specified.");
                this.agencyId = (Long)Preconditions.checkNotNull((Object)l2, (Object)"Required parameter agencyId must be specified.");
                this.endDate = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter endDate must be specified.");
                this.engineAccountId = (Long)Preconditions.checkNotNull((Object)l3, (Object)"Required parameter engineAccountId must be specified.");
                this.rowCount = (Integer)Preconditions.checkNotNull((Object)n2, (Object)"Required parameter rowCount must be specified.");
                this.startDate = (Integer)Preconditions.checkNotNull((Object)n3, (Object)"Required parameter startDate must be specified.");
                this.startRow = (Long)Preconditions.checkNotNull((Object)l4, (Object)"Required parameter startRow must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Patch setAdvertiserId(Long l) {
                this.advertiserId = l;
                return this;
            }

            public Long getAgencyId() {
                return this.agencyId;
            }

            public Patch setAgencyId(Long l) {
                this.agencyId = l;
                return this;
            }

            public Integer getEndDate() {
                return this.endDate;
            }

            public Patch setEndDate(Integer n) {
                this.endDate = n;
                return this;
            }

            public Long getEngineAccountId() {
                return this.engineAccountId;
            }

            public Patch setEngineAccountId(Long l) {
                this.engineAccountId = l;
                return this;
            }

            public Integer getRowCount() {
                return this.rowCount;
            }

            public Patch setRowCount(Integer n) {
                this.rowCount = n;
                return this;
            }

            public Integer getStartDate() {
                return this.startDate;
            }

            public Patch setStartDate(Integer n) {
                this.startDate = n;
                return this;
            }

            public Long getStartRow() {
                return this.startRow;
            }

            public Patch setStartRow(Long l) {
                this.startRow = l;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DoubleclicksearchRequest<ConversionList> {
            private static final String REST_PATH = "conversion";

            protected Insert(ConversionList conversionList) {
                super(Doubleclicksearch.this, "POST", REST_PATH, (Object)conversionList, ConversionList.class);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DoubleclicksearchRequest<ConversionList> {
            private static final String REST_PATH = "agency/{agencyId}/advertiser/{advertiserId}/engine/{engineAccountId}/conversion";
            @Key
            private Long agencyId;
            @Key
            private Long advertiserId;
            @Key
            private Long engineAccountId;
            @Key
            private Integer endDate;
            @Key
            private Integer rowCount;
            @Key
            private Integer startDate;
            @Key
            private Long startRow;
            @Key
            private Long adGroupId;
            @Key
            private Long adId;
            @Key
            private Long campaignId;
            @Key
            private Long criterionId;

            protected Get(Long l, Long l2, Long l3, Integer n, Integer n2, Integer n3, Long l4) {
                super(Doubleclicksearch.this, "GET", REST_PATH, null, ConversionList.class);
                this.agencyId = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter agencyId must be specified.");
                this.advertiserId = (Long)Preconditions.checkNotNull((Object)l2, (Object)"Required parameter advertiserId must be specified.");
                this.engineAccountId = (Long)Preconditions.checkNotNull((Object)l3, (Object)"Required parameter engineAccountId must be specified.");
                this.endDate = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter endDate must be specified.");
                this.rowCount = (Integer)Preconditions.checkNotNull((Object)n2, (Object)"Required parameter rowCount must be specified.");
                this.startDate = (Integer)Preconditions.checkNotNull((Object)n3, (Object)"Required parameter startDate must be specified.");
                this.startRow = (Long)Preconditions.checkNotNull((Object)l4, (Object)"Required parameter startRow must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public Long getAgencyId() {
                return this.agencyId;
            }

            public Get setAgencyId(Long l) {
                this.agencyId = l;
                return this;
            }

            public Long getAdvertiserId() {
                return this.advertiserId;
            }

            public Get setAdvertiserId(Long l) {
                this.advertiserId = l;
                return this;
            }

            public Long getEngineAccountId() {
                return this.engineAccountId;
            }

            public Get setEngineAccountId(Long l) {
                this.engineAccountId = l;
                return this;
            }

            public Integer getEndDate() {
                return this.endDate;
            }

            public Get setEndDate(Integer n) {
                this.endDate = n;
                return this;
            }

            public Integer getRowCount() {
                return this.rowCount;
            }

            public Get setRowCount(Integer n) {
                this.rowCount = n;
                return this;
            }

            public Integer getStartDate() {
                return this.startDate;
            }

            public Get setStartDate(Integer n) {
                this.startDate = n;
                return this;
            }

            public Long getStartRow() {
                return this.startRow;
            }

            public Get setStartRow(Long l) {
                this.startRow = l;
                return this;
            }

            public Long getAdGroupId() {
                return this.adGroupId;
            }

            public Get setAdGroupId(Long l) {
                this.adGroupId = l;
                return this;
            }

            public Long getAdId() {
                return this.adId;
            }

            public Get setAdId(Long l) {
                this.adId = l;
                return this;
            }

            public Long getCampaignId() {
                return this.campaignId;
            }

            public Get setCampaignId(Long l) {
                this.campaignId = l;
                return this;
            }

            public Long getCriterionId() {
                return this.criterionId;
            }

            public Get setCriterionId(Long l) {
                this.criterionId = l;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

