/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-08-28 at 16:14:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * The metadata for a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class File extends com.google.api.client.json.GenericJson {

  /**
   * Create time for this file (formatted ISO8601 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdDate;

  /**
   * A short description of the file
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String downloadUrl;

  /**
   * ETag of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The file extension used when downloading this file. This field is read only. To set the
   * extension, include it on title when creating the file. This will only be populated on files
   * with content stored in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileExtension;

  /**
   * The size of the file in bytes. This will only be populated on files with content stored in
   * Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long fileSize;

  /**
   * The id of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Indexable text attributes for the file (can only be written)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IndexableText indexableText;

  /**
   * The type of file. This is always drive#file
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Labels for the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Labels labels;

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastViewedDate;

  /**
   * An MD5 checksum for the content of this file. This will only be populated on files with content
   * stored in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String md5Checksum;

  /**
   * The mimetype of the file
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedByMeDate;

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedDate;

  /**
   * Collection of parent folders which contain this file. On insert, setting this field will put
   * the file in all of the provided folders. If no folders are provided, the file will be placed in
   * the default root folder. On update, this field is ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ParentsCollection> parentsCollection;

  static {
    // hack to force ProGuard to consider ParentsCollection used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ParentsCollection.class);
  }

  /**
   * A link back to this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The title of this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The permissions for the authenticated user on this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Permission userPermission;

  /**
   * Create time for this file (formatted ISO8601 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedDate() {
    return createdDate;
  }

  /**
   * Create time for this file (formatted ISO8601 timestamp).
   * @param createdDate createdDate or {@code null} for none
   */
  public File setCreatedDate(com.google.api.client.util.DateTime createdDate) {
    this.createdDate = createdDate;
    return this;
  }

  /**
   * A short description of the file
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A short description of the file
   * @param description description or {@code null} for none
   */
  public File setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getDownloadUrl() {
    return downloadUrl;
  }

  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * @param downloadUrl downloadUrl or {@code null} for none
   */
  public File setDownloadUrl(java.lang.String downloadUrl) {
    this.downloadUrl = downloadUrl;
    return this;
  }

  /**
   * ETag of the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of the file.
   * @param etag etag or {@code null} for none
   */
  public File setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The file extension used when downloading this file. This field is read only. To set the
   * extension, include it on title when creating the file. This will only be populated on files
   * with content stored in Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileExtension() {
    return fileExtension;
  }

  /**
   * The file extension used when downloading this file. This field is read only. To set the
   * extension, include it on title when creating the file. This will only be populated on files
   * with content stored in Drive.
   * @param fileExtension fileExtension or {@code null} for none
   */
  public File setFileExtension(java.lang.String fileExtension) {
    this.fileExtension = fileExtension;
    return this;
  }

  /**
   * The size of the file in bytes. This will only be populated on files with content stored in
   * Drive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFileSize() {
    return fileSize;
  }

  /**
   * The size of the file in bytes. This will only be populated on files with content stored in
   * Drive.
   * @param fileSize fileSize or {@code null} for none
   */
  public File setFileSize(java.lang.Long fileSize) {
    this.fileSize = fileSize;
    return this;
  }

  /**
   * The id of the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The id of the file.
   * @param id id or {@code null} for none
   */
  public File setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Indexable text attributes for the file (can only be written)
   * @return value or {@code null} for none
   */
  public IndexableText getIndexableText() {
    return indexableText;
  }

  /**
   * Indexable text attributes for the file (can only be written)
   * @param indexableText indexableText or {@code null} for none
   */
  public File setIndexableText(IndexableText indexableText) {
    this.indexableText = indexableText;
    return this;
  }

  /**
   * The type of file. This is always drive#file
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The type of file. This is always drive#file
   * @param kind kind or {@code null} for none
   */
  public File setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Labels for the file.
   * @return value or {@code null} for none
   */
  public Labels getLabels() {
    return labels;
  }

  /**
   * Labels for the file.
   * @param labels labels or {@code null} for none
   */
  public File setLabels(Labels labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastViewedDate() {
    return lastViewedDate;
  }

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * @param lastViewedDate lastViewedDate or {@code null} for none
   */
  public File setLastViewedDate(com.google.api.client.util.DateTime lastViewedDate) {
    this.lastViewedDate = lastViewedDate;
    return this;
  }

  /**
   * An MD5 checksum for the content of this file. This will only be populated on files with content
   * stored in Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getMd5Checksum() {
    return md5Checksum;
  }

  /**
   * An MD5 checksum for the content of this file. This will only be populated on files with content
   * stored in Drive.
   * @param md5Checksum md5Checksum or {@code null} for none
   */
  public File setMd5Checksum(java.lang.String md5Checksum) {
    this.md5Checksum = md5Checksum;
    return this;
  }

  /**
   * The mimetype of the file
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * The mimetype of the file
   * @param mimeType mimeType or {@code null} for none
   */
  public File setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedByMeDate() {
    return modifiedByMeDate;
  }

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp).
   * @param modifiedByMeDate modifiedByMeDate or {@code null} for none
   */
  public File setModifiedByMeDate(com.google.api.client.util.DateTime modifiedByMeDate) {
    this.modifiedByMeDate = modifiedByMeDate;
    return this;
  }

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedDate() {
    return modifiedDate;
  }

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp).
   * @param modifiedDate modifiedDate or {@code null} for none
   */
  public File setModifiedDate(com.google.api.client.util.DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
    return this;
  }

  /**
   * Collection of parent folders which contain this file. On insert, setting this field will put
   * the file in all of the provided folders. If no folders are provided, the file will be placed in
   * the default root folder. On update, this field is ignored.
   * @return value or {@code null} for none
   */
  public java.util.List<ParentsCollection> getParentsCollection() {
    return parentsCollection;
  }

  /**
   * Collection of parent folders which contain this file. On insert, setting this field will put
   * the file in all of the provided folders. If no folders are provided, the file will be placed in
   * the default root folder. On update, this field is ignored.
   * @param parentsCollection parentsCollection or {@code null} for none
   */
  public File setParentsCollection(java.util.List<ParentsCollection> parentsCollection) {
    this.parentsCollection = parentsCollection;
    return this;
  }

  /**
   * A link back to this file.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * A link back to this file.
   * @param selfLink selfLink or {@code null} for none
   */
  public File setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The title of this file.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title of this file.
   * @param title title or {@code null} for none
   */
  public File setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * The permissions for the authenticated user on this file.
   * @return value or {@code null} for none
   */
  public Permission getUserPermission() {
    return userPermission;
  }

  /**
   * The permissions for the authenticated user on this file.
   * @param userPermission userPermission or {@code null} for none
   */
  public File setUserPermission(Permission userPermission) {
    this.userPermission = userPermission;
    return this;
  }

  @Override
  public File set(String fieldName, Object value) {
    return (File) super.set(fieldName, value);
  }

  @Override
  public File clone() {
    return (File) super.clone();
  }

  /**
   * Indexable text attributes for the file (can only be written)
   */
  public static final class IndexableText extends com.google.api.client.json.GenericJson {

    /**
     * The text to be indexed for this file
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String text;

    /**
     * The text to be indexed for this file
     * @return value or {@code null} for none
     */
    public java.lang.String getText() {
      return text;
    }

    /**
     * The text to be indexed for this file
     * @param text text or {@code null} for none
     */
    public IndexableText setText(java.lang.String text) {
      this.text = text;
      return this;
    }

    @Override
    public IndexableText set(String fieldName, Object value) {
      return (IndexableText) super.set(fieldName, value);
    }

    @Override
    public IndexableText clone() {
      return (IndexableText) super.clone();
    }

  }

  /**
   * Labels for the file.
   */
  public static final class Labels extends com.google.api.client.json.GenericJson {

    /**
     * Whether this file is hidden from the user
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean hidden;

    /**
     * Whether this file is starred by the user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean starred;

    /**
     * Whether this file has been trashed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean trashed;

    /**
     * Whether this file is hidden from the user
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getHidden() {
      return hidden;
    }

    /**
     * Whether this file is hidden from the user
     * @param hidden hidden or {@code null} for none
     */
    public Labels setHidden(java.lang.Boolean hidden) {
      this.hidden = hidden;
      return this;
    }

    /**
     * Whether this file is starred by the user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getStarred() {
      return starred;
    }

    /**
     * Whether this file is starred by the user.
     * @param starred starred or {@code null} for none
     */
    public Labels setStarred(java.lang.Boolean starred) {
      this.starred = starred;
      return this;
    }

    /**
     * Whether this file has been trashed.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getTrashed() {
      return trashed;
    }

    /**
     * Whether this file has been trashed.
     * @param trashed trashed or {@code null} for none
     */
    public Labels setTrashed(java.lang.Boolean trashed) {
      this.trashed = trashed;
      return this;
    }

    @Override
    public Labels set(String fieldName, Object value) {
      return (Labels) super.set(fieldName, value);
    }

    @Override
    public Labels clone() {
      return (Labels) super.clone();
    }

  }

  /**
   * Model definition for FileParentsCollection.
   */
  public static final class ParentsCollection extends com.google.api.client.json.GenericJson {

    /**
     * The id of this parent
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String id;

    /**
     * A link to get the metadata for this parent
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String parentLink;

    /**
     * The id of this parent
     * @return value or {@code null} for none
     */
    public java.lang.String getId() {
      return id;
    }

    /**
     * The id of this parent
     * @param id id or {@code null} for none
     */
    public ParentsCollection setId(java.lang.String id) {
      this.id = id;
      return this;
    }

    /**
     * A link to get the metadata for this parent
     * @return value or {@code null} for none
     */
    public java.lang.String getParentLink() {
      return parentLink;
    }

    /**
     * A link to get the metadata for this parent
     * @param parentLink parentLink or {@code null} for none
     */
    public ParentsCollection setParentLink(java.lang.String parentLink) {
      this.parentLink = parentLink;
      return this;
    }

    @Override
    public ParentsCollection set(String fieldName, Object value) {
      return (ParentsCollection) super.set(fieldName, value);
    }

    @Override
    public ParentsCollection clone() {
      return (ParentsCollection) super.clone();
    }

  }

}
