/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.drive;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.drive.DriveRequest;
import com.google.api.services.drive.DriveRequestInitializer;
import com.google.api.services.drive.model.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Drive
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "drive/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/drive/v1/";

    public Drive(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Drive(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Files files() {
        return new Files();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.16.0-rc of the Drive API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Drive.DEFAULT_ROOT_URL, Drive.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Drive build() {
            return new Drive(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDriveRequestInitializer(DriveRequestInitializer driveRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)driveRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Files {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(File file) throws IOException {
            Insert insert = new Insert(file);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Insert insert(File file, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(file, abstractInputStreamContent);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Patch patch(String string, File file) throws IOException {
            Patch patch = new Patch(string, file);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, File file) throws IOException {
            Update update = new Update(string, file);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Update update(String string, File file, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Update update = new Update(string, file, abstractInputStreamContent);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{id}";
            @Key
            private String id;
            @Key
            private Boolean updateViewedDate;
            @Key
            private Boolean updateModifiedDate;
            @Key
            private Boolean newRevision;

            protected Update(String string, File file) {
                super(Drive.this, "PUT", REST_PATH, (Object)file, File.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            protected Update(String string, File file, AbstractInputStreamContent abstractInputStreamContent) {
                super(Drive.this, "PUT", "/upload/" + Drive.this.getServicePath() + REST_PATH, (Object)file, File.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Update setId(String string) {
                this.id = string;
                return this;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Update setUpdateViewedDate(Boolean bl) {
                this.updateViewedDate = bl;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.updateViewedDate;
            }

            public Boolean getUpdateModifiedDate() {
                return this.updateModifiedDate;
            }

            public Update setUpdateModifiedDate(Boolean bl) {
                this.updateModifiedDate = bl;
                return this;
            }

            public boolean isUpdateModifiedDate() {
                if (this.updateModifiedDate == null || this.updateModifiedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.updateModifiedDate;
            }

            public Boolean getNewRevision() {
                return this.newRevision;
            }

            public Update setNewRevision(Boolean bl) {
                this.newRevision = bl;
                return this;
            }

            public boolean isNewRevision() {
                if (this.newRevision == null || this.newRevision == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.newRevision;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{id}";
            @Key
            private String id;
            @Key
            private Boolean updateViewedDate;
            @Key
            private Boolean updateModifiedDate;
            @Key
            private Boolean newRevision;

            protected Patch(String string, File file) {
                super(Drive.this, "PATCH", REST_PATH, (Object)file, File.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Patch setId(String string) {
                this.id = string;
                return this;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Patch setUpdateViewedDate(Boolean bl) {
                this.updateViewedDate = bl;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.updateViewedDate;
            }

            public Boolean getUpdateModifiedDate() {
                return this.updateModifiedDate;
            }

            public Patch setUpdateModifiedDate(Boolean bl) {
                this.updateModifiedDate = bl;
                return this;
            }

            public boolean isUpdateModifiedDate() {
                if (this.updateModifiedDate == null || this.updateModifiedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.updateModifiedDate;
            }

            public Boolean getNewRevision() {
                return this.newRevision;
            }

            public Patch setNewRevision(Boolean bl) {
                this.newRevision = bl;
                return this;
            }

            public boolean isNewRevision() {
                if (this.newRevision == null || this.newRevision == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.newRevision;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DriveRequest<File> {
            private static final String REST_PATH = "files";

            protected Insert(File file) {
                super(Drive.this, "POST", REST_PATH, (Object)file, File.class);
            }

            protected Insert(File file, AbstractInputStreamContent abstractInputStreamContent) {
                super(Drive.this, "POST", "/upload/" + Drive.this.getServicePath() + REST_PATH, (Object)file, File.class);
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{id}";
            @Key
            private String id;
            @Key
            private Boolean updateViewedDate;
            @Key
            private String projection;

            protected Get(String string) {
                super(Drive.this, "GET", REST_PATH, null, File.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Get setUpdateViewedDate(Boolean bl) {
                this.updateViewedDate = bl;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.updateViewedDate;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

