/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-07-16 18:28:29 UTC)
 * on 2015-07-24 at 16:02:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive;

/**
 * Service definition for Drive (v1).
 *
 * <p>
 * The API to interact with Drive.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/drive/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link DriveRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Drive extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.20.0 of the Drive API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "drive/v1/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Drive(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Drive(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Files collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Files.List request = drive.files().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Files files() {
    return new Files();
  }

  /**
   * The "files" collection of methods.
   */
  public class Files {

    /**
     * Gets a file's metadata by id.
     *
     * Create a request for the method "files.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param id The id for the file in question.
     * @return the request
     */
    public Get get(java.lang.String id) throws java.io.IOException {
      Get result = new Get(id);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{id}";

      /**
       * Gets a file's metadata by id.
       *
       * Create a request for the method "files.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id for the file in question.
       * @since 1.13
       */
      protected Get(java.lang.String id) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.File.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The id for the file in question. */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id for the file in question.
       */
      public java.lang.String getId() {
        return id;
      }

      /** The id for the file in question. */
      public Get setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** Whether to update the view date after successfully retrieving the file. */
      @com.google.api.client.util.Key
      private java.lang.Boolean updateViewedDate;

      /** Whether to update the view date after successfully retrieving the file. [default: true]
       */
      public java.lang.Boolean getUpdateViewedDate() {
        return updateViewedDate;
      }

      /** Whether to update the view date after successfully retrieving the file. */
      public Get setUpdateViewedDate(java.lang.Boolean updateViewedDate) {
        this.updateViewedDate = updateViewedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to update the view date after successfully retrieving the file.
       * </p>
       */
      public boolean isUpdateViewedDate() {
        if (updateViewedDate == null || updateViewedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return updateViewedDate;
      }

      /** This parameter is deprecated and has no function. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** This parameter is deprecated and has no function.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** This parameter is deprecated and has no function. */
      public Get setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a file, and any settable metadata or blob content sent with the request.
     *
     * Create a request for the method "files.insert".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Insert insert(com.google.api.services.drive.model.File content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    /**
     * Inserts a file, and any settable metadata or blob content sent with the request.
     *
     * Create a request for the method "files.insert".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     *
     * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files";

      /**
       * Inserts a file, and any settable metadata or blob content sent with the request.
       *
       * Create a request for the method "files.insert".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Insert(com.google.api.services.drive.model.File content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.File.class);
      }

      /**
       * Inserts a file, and any settable metadata or blob content sent with the request.
       *
       * Create a request for the method "files.insert".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       *
       * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Drive.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.drive.model.File.class);
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Updates file metadata and/or content. This method supports patch semantics.
     *
     * Create a request for the method "files.patch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param id The id for the file in question.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Patch patch(java.lang.String id, com.google.api.services.drive.model.File content) throws java.io.IOException {
      Patch result = new Patch(id, content);
      initialize(result);
      return result;
    }

    public class Patch extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{id}";

      /**
       * Updates file metadata and/or content. This method supports patch semantics.
       *
       * Create a request for the method "files.patch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id for the file in question.
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Patch(java.lang.String id, com.google.api.services.drive.model.File content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** The id for the file in question. */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id for the file in question.
       */
      public java.lang.String getId() {
        return id;
      }

      /** The id for the file in question. */
      public Patch setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** Whether to update the view date after successfully updating the file. */
      @com.google.api.client.util.Key
      private java.lang.Boolean updateViewedDate;

      /** Whether to update the view date after successfully updating the file. [default: true]
       */
      public java.lang.Boolean getUpdateViewedDate() {
        return updateViewedDate;
      }

      /** Whether to update the view date after successfully updating the file. */
      public Patch setUpdateViewedDate(java.lang.Boolean updateViewedDate) {
        this.updateViewedDate = updateViewedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to update the view date after successfully updating the file.
       * </p>
       */
      public boolean isUpdateViewedDate() {
        if (updateViewedDate == null || updateViewedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return updateViewedDate;
      }

      /**
       * Controls updating the modified date of the file. If true, the modified date will be updated
       * to the current time, regardless of whether other changes are being made. If false, the
       * modified date will only be updated to the current time if other changes are also being made
       * (changing the title, for example).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean updateModifiedDate;

      /** Controls updating the modified date of the file. If true, the modified date will be updated to the
     current time, regardless of whether other changes are being made. If false, the modified date will
     only be updated to the current time if other changes are also being made (changing the title, for
     example). [default: false]
       */
      public java.lang.Boolean getUpdateModifiedDate() {
        return updateModifiedDate;
      }

      /**
       * Controls updating the modified date of the file. If true, the modified date will be updated
       * to the current time, regardless of whether other changes are being made. If false, the
       * modified date will only be updated to the current time if other changes are also being made
       * (changing the title, for example).
       */
      public Patch setUpdateModifiedDate(java.lang.Boolean updateModifiedDate) {
        this.updateModifiedDate = updateModifiedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Controls updating the modified date of the file. If true, the modified date will be updated to the
     current time, regardless of whether other changes are being made. If false, the modified date will
     only be updated to the current time if other changes are also being made (changing the title, for
     example).
       * </p>
       */
      public boolean isUpdateModifiedDate() {
        if (updateModifiedDate == null || updateModifiedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return updateModifiedDate;
      }

      /**
       * Whether a blob upload should create a new revision. If false, the blob data in the current
       * head revision is replaced. If true or not set, a new blob is created as head revision, and
       * previous unpinned revisions are preserved for a short period of time. Pinned revisions are
       * stored indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean newRevision;

      /** Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision is replaced. If true or not set, a new blob is created as head revision, and previous
     unpinned revisions are preserved for a short period of time. Pinned revisions are stored
     indefinitely, using additional storage quota, up to a maximum of 200 revisions. [default: true]
       */
      public java.lang.Boolean getNewRevision() {
        return newRevision;
      }

      /**
       * Whether a blob upload should create a new revision. If false, the blob data in the current
       * head revision is replaced. If true or not set, a new blob is created as head revision, and
       * previous unpinned revisions are preserved for a short period of time. Pinned revisions are
       * stored indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       */
      public Patch setNewRevision(java.lang.Boolean newRevision) {
        this.newRevision = newRevision;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision is replaced. If true or not set, a new blob is created as head revision, and previous
     unpinned revisions are preserved for a short period of time. Pinned revisions are stored
     indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       * </p>
       */
      public boolean isNewRevision() {
        if (newRevision == null || newRevision == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return newRevision;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates file metadata and/or content
     *
     * Create a request for the method "files.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param id The id for the file in question.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Update update(java.lang.String id, com.google.api.services.drive.model.File content) throws java.io.IOException {
      Update result = new Update(id, content);
      initialize(result);
      return result;
    }

    /**
     * Updates file metadata and/or content
     *
     * Create a request for the method "files.update".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param id The id for the file in question.
     * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Update update(java.lang.String id, com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Update result = new Update(id, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{id}";

      /**
       * Updates file metadata and/or content
       *
       * Create a request for the method "files.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id for the file in question.
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Update(java.lang.String id, com.google.api.services.drive.model.File content) {
        super(Drive.this, "PUT", REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      /**
       * Updates file metadata and/or content
       *
       * Create a request for the method "files.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param id The id for the file in question.
       * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Update(java.lang.String id, com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Drive.this, "PUT", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The id for the file in question. */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id for the file in question.
       */
      public java.lang.String getId() {
        return id;
      }

      /** The id for the file in question. */
      public Update setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** Whether to update the view date after successfully updating the file. */
      @com.google.api.client.util.Key
      private java.lang.Boolean updateViewedDate;

      /** Whether to update the view date after successfully updating the file. [default: true]
       */
      public java.lang.Boolean getUpdateViewedDate() {
        return updateViewedDate;
      }

      /** Whether to update the view date after successfully updating the file. */
      public Update setUpdateViewedDate(java.lang.Boolean updateViewedDate) {
        this.updateViewedDate = updateViewedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to update the view date after successfully updating the file.
       * </p>
       */
      public boolean isUpdateViewedDate() {
        if (updateViewedDate == null || updateViewedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return updateViewedDate;
      }

      /**
       * Controls updating the modified date of the file. If true, the modified date will be updated
       * to the current time, regardless of whether other changes are being made. If false, the
       * modified date will only be updated to the current time if other changes are also being made
       * (changing the title, for example).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean updateModifiedDate;

      /** Controls updating the modified date of the file. If true, the modified date will be updated to the
     current time, regardless of whether other changes are being made. If false, the modified date will
     only be updated to the current time if other changes are also being made (changing the title, for
     example). [default: false]
       */
      public java.lang.Boolean getUpdateModifiedDate() {
        return updateModifiedDate;
      }

      /**
       * Controls updating the modified date of the file. If true, the modified date will be updated
       * to the current time, regardless of whether other changes are being made. If false, the
       * modified date will only be updated to the current time if other changes are also being made
       * (changing the title, for example).
       */
      public Update setUpdateModifiedDate(java.lang.Boolean updateModifiedDate) {
        this.updateModifiedDate = updateModifiedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Controls updating the modified date of the file. If true, the modified date will be updated to the
     current time, regardless of whether other changes are being made. If false, the modified date will
     only be updated to the current time if other changes are also being made (changing the title, for
     example).
       * </p>
       */
      public boolean isUpdateModifiedDate() {
        if (updateModifiedDate == null || updateModifiedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return updateModifiedDate;
      }

      /**
       * Whether a blob upload should create a new revision. If false, the blob data in the current
       * head revision is replaced. If true or not set, a new blob is created as head revision, and
       * previous unpinned revisions are preserved for a short period of time. Pinned revisions are
       * stored indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean newRevision;

      /** Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision is replaced. If true or not set, a new blob is created as head revision, and previous
     unpinned revisions are preserved for a short period of time. Pinned revisions are stored
     indefinitely, using additional storage quota, up to a maximum of 200 revisions. [default: true]
       */
      public java.lang.Boolean getNewRevision() {
        return newRevision;
      }

      /**
       * Whether a blob upload should create a new revision. If false, the blob data in the current
       * head revision is replaced. If true or not set, a new blob is created as head revision, and
       * previous unpinned revisions are preserved for a short period of time. Pinned revisions are
       * stored indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       */
      public Update setNewRevision(java.lang.Boolean newRevision) {
        this.newRevision = newRevision;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision is replaced. If true or not set, a new blob is created as head revision, and previous
     unpinned revisions are preserved for a short period of time. Pinned revisions are stored
     indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       * </p>
       */
      public boolean isNewRevision() {
        if (newRevision == null || newRevision == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return newRevision;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Drive}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Drive}. */
    @Override
    public Drive build() {
      return new Drive(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link DriveRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setDriveRequestInitializer(
        DriveRequestInitializer driveRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(driveRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
