/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-06-12 at 02:33:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive;

/**
 * Service definition for Drive (v2).
 *
 * <p>
 * The API to interact with Drive.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/drive/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link DriveRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Drive extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.19.1 of the Drive API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "drive/v2/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Drive(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Drive(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the About collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.About.List request = drive.about().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public About about() {
    return new About();
  }

  /**
   * The "about" collection of methods.
   */
  public class About {

    /**
     * Gets the information about the current user along with Drive API settings
     *
     * Create a request for the method "about.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public Get get() throws java.io.IOException {
      Get result = new Get();
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.About> {

      private static final String REST_PATH = "about";

      /**
       * Gets the information about the current user along with Drive API settings
       *
       * Create a request for the method "about.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected Get() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.About.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /**
       * When calculating the number of remaining change IDs, whether to include public files the
       * user has opened and shared files. When set to false, this counts only change IDs for owned
       * files and any shared or public files that the user has explicitly added to a folder they
       * own.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeSubscribed;

      /** When calculating the number of remaining change IDs, whether to include public files the user has
     opened and shared files. When set to false, this counts only change IDs for owned files and any
     shared or public files that the user has explicitly added to a folder they own. [default: true]
       */
      public java.lang.Boolean getIncludeSubscribed() {
        return includeSubscribed;
      }

      /**
       * When calculating the number of remaining change IDs, whether to include public files the
       * user has opened and shared files. When set to false, this counts only change IDs for owned
       * files and any shared or public files that the user has explicitly added to a folder they
       * own.
       */
      public Get setIncludeSubscribed(java.lang.Boolean includeSubscribed) {
        this.includeSubscribed = includeSubscribed;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * When calculating the number of remaining change IDs, whether to include public files the user has
     opened and shared files. When set to false, this counts only change IDs for owned files and any
     shared or public files that the user has explicitly added to a folder they own.
       * </p>
       */
      public boolean isIncludeSubscribed() {
        if (includeSubscribed == null || includeSubscribed == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeSubscribed;
      }

      /** Maximum number of remaining change IDs to count */
      @com.google.api.client.util.Key
      private java.lang.Long maxChangeIdCount;

      /** Maximum number of remaining change IDs to count [default: 1]
       */
      public java.lang.Long getMaxChangeIdCount() {
        return maxChangeIdCount;
      }

      /** Maximum number of remaining change IDs to count */
      public Get setMaxChangeIdCount(java.lang.Long maxChangeIdCount) {
        this.maxChangeIdCount = maxChangeIdCount;
        return this;
      }

      /** Change ID to start counting from when calculating number of remaining change IDs */
      @com.google.api.client.util.Key
      private java.lang.Long startChangeId;

      /** Change ID to start counting from when calculating number of remaining change IDs
       */
      public java.lang.Long getStartChangeId() {
        return startChangeId;
      }

      /** Change ID to start counting from when calculating number of remaining change IDs */
      public Get setStartChangeId(java.lang.Long startChangeId) {
        this.startChangeId = startChangeId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Apps collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Apps.List request = drive.apps().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Apps apps() {
    return new Apps();
  }

  /**
   * The "apps" collection of methods.
   */
  public class Apps {

    /**
     * Gets a specific app.
     *
     * Create a request for the method "apps.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param appId The ID of the app.
     * @return the request
     */
    public Get get(java.lang.String appId) throws java.io.IOException {
      Get result = new Get(appId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.App> {

      private static final String REST_PATH = "apps/{appId}";

      /**
       * Gets a specific app.
       *
       * Create a request for the method "apps.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param appId The ID of the app.
       * @since 1.13
       */
      protected Get(java.lang.String appId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.App.class);
        this.appId = com.google.api.client.util.Preconditions.checkNotNull(appId, "Required parameter appId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the app. */
      @com.google.api.client.util.Key
      private java.lang.String appId;

      /** The ID of the app.
       */
      public java.lang.String getAppId() {
        return appId;
      }

      /** The ID of the app. */
      public Get setAppId(java.lang.String appId) {
        this.appId = appId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists a user's installed apps.
     *
     * Create a request for the method "apps.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.AppList> {

      private static final String REST_PATH = "apps";

      /**
       * Lists a user's installed apps.
       *
       * Create a request for the method "apps.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.AppList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * A language or locale code, as defined by BCP 47, with some extensions from Unicode's LDML
       * format (http://www.unicode.org/reports/tr35/).
       */
      @com.google.api.client.util.Key
      private java.lang.String languageCode;

      /** A language or locale code, as defined by BCP 47, with some extensions from Unicode's LDML format
     (http://www.unicode.org/reports/tr35/).
       */
      public java.lang.String getLanguageCode() {
        return languageCode;
      }

      /**
       * A language or locale code, as defined by BCP 47, with some extensions from Unicode's LDML
       * format (http://www.unicode.org/reports/tr35/).
       */
      public List setLanguageCode(java.lang.String languageCode) {
        this.languageCode = languageCode;
        return this;
      }

      /**
       * A comma-separated list of file extensions for open with filtering. All apps within the
       * given app query scope which can open any of the given file extensions will be included in
       * the response. If appFilterMimeTypes are provided as well, the result is a union of the two
       * resulting app lists.
       */
      @com.google.api.client.util.Key
      private java.lang.String appFilterExtensions;

      /** A comma-separated list of file extensions for open with filtering. All apps within the given app
     query scope which can open any of the given file extensions will be included in the response. If
     appFilterMimeTypes are provided as well, the result is a union of the two resulting app lists.
       */
      public java.lang.String getAppFilterExtensions() {
        return appFilterExtensions;
      }

      /**
       * A comma-separated list of file extensions for open with filtering. All apps within the
       * given app query scope which can open any of the given file extensions will be included in
       * the response. If appFilterMimeTypes are provided as well, the result is a union of the two
       * resulting app lists.
       */
      public List setAppFilterExtensions(java.lang.String appFilterExtensions) {
        this.appFilterExtensions = appFilterExtensions;
        return this;
      }

      /**
       * A comma-separated list of MIME types for open with filtering. All apps within the given app
       * query scope which can open any of the given MIME types will be included in the response. If
       * appFilterExtensions are provided as well, the result is a union of the two resulting app
       * lists.
       */
      @com.google.api.client.util.Key
      private java.lang.String appFilterMimeTypes;

      /** A comma-separated list of MIME types for open with filtering. All apps within the given app query
     scope which can open any of the given MIME types will be included in the response. If
     appFilterExtensions are provided as well, the result is a union of the two resulting app lists.
       */
      public java.lang.String getAppFilterMimeTypes() {
        return appFilterMimeTypes;
      }

      /**
       * A comma-separated list of MIME types for open with filtering. All apps within the given app
       * query scope which can open any of the given MIME types will be included in the response. If
       * appFilterExtensions are provided as well, the result is a union of the two resulting app
       * lists.
       */
      public List setAppFilterMimeTypes(java.lang.String appFilterMimeTypes) {
        this.appFilterMimeTypes = appFilterMimeTypes;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Changes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Changes.List request = drive.changes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Changes changes() {
    return new Changes();
  }

  /**
   * The "changes" collection of methods.
   */
  public class Changes {

    /**
     * Gets a specific change.
     *
     * Create a request for the method "changes.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param changeId The ID of the change.
     * @return the request
     */
    public Get get(java.lang.String changeId) throws java.io.IOException {
      Get result = new Get(changeId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Change> {

      private static final String REST_PATH = "changes/{changeId}";

      /**
       * Gets a specific change.
       *
       * Create a request for the method "changes.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param changeId The ID of the change.
       * @since 1.13
       */
      protected Get(java.lang.String changeId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Change.class);
        this.changeId = com.google.api.client.util.Preconditions.checkNotNull(changeId, "Required parameter changeId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the change. */
      @com.google.api.client.util.Key
      private java.lang.String changeId;

      /** The ID of the change.
       */
      public java.lang.String getChangeId() {
        return changeId;
      }

      /** The ID of the change. */
      public Get setChangeId(java.lang.String changeId) {
        this.changeId = changeId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists the changes for a user.
     *
     * Create a request for the method "changes.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.ChangeList> {

      private static final String REST_PATH = "changes";

      /**
       * Lists the changes for a user.
       *
       * Create a request for the method "changes.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.ChangeList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * Whether to include public files the user has opened and shared files. When set to false,
       * the list only includes owned files plus any shared or public files the user has explicitly
       * added to a folder they own.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeSubscribed;

      /** Whether to include public files the user has opened and shared files. When set to false, the list
     only includes owned files plus any shared or public files the user has explicitly added to a folder
     they own. [default: true]
       */
      public java.lang.Boolean getIncludeSubscribed() {
        return includeSubscribed;
      }

      /**
       * Whether to include public files the user has opened and shared files. When set to false,
       * the list only includes owned files plus any shared or public files the user has explicitly
       * added to a folder they own.
       */
      public List setIncludeSubscribed(java.lang.Boolean includeSubscribed) {
        this.includeSubscribed = includeSubscribed;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include public files the user has opened and shared files. When set to false, the list
     only includes owned files plus any shared or public files the user has explicitly added to a folder
     they own.
       * </p>
       */
      public boolean isIncludeSubscribed() {
        if (includeSubscribed == null || includeSubscribed == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeSubscribed;
      }

      /** Whether to include deleted items. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** Whether to include deleted items. [default: true]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /** Whether to include deleted items. */
      public List setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include deleted items.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeDeleted;
      }

      /** Maximum number of changes to return. */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of changes to return. [default: 100] [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /** Maximum number of changes to return. */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token for changes. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token for changes.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token for changes. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * A comma-separated list of spaces to query. Supported values are 'drive' and
       * 'appDataFolder'.
       */
      @com.google.api.client.util.Key
      private java.lang.String spaces;

      /** A comma-separated list of spaces to query. Supported values are 'drive' and 'appDataFolder'.
       */
      public java.lang.String getSpaces() {
        return spaces;
      }

      /**
       * A comma-separated list of spaces to query. Supported values are 'drive' and
       * 'appDataFolder'.
       */
      public List setSpaces(java.lang.String spaces) {
        this.spaces = spaces;
        return this;
      }

      /** Change ID to start listing changes from. */
      @com.google.api.client.util.Key
      private java.lang.Long startChangeId;

      /** Change ID to start listing changes from.
       */
      public java.lang.Long getStartChangeId() {
        return startChangeId;
      }

      /** Change ID to start listing changes from. */
      public List setStartChangeId(java.lang.Long startChangeId) {
        this.startChangeId = startChangeId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Subscribe to changes for a user.
     *
     * Create a request for the method "changes.watch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Watch#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.drive.model.Channel}
     * @return the request
     */
    public Watch watch(com.google.api.services.drive.model.Channel content) throws java.io.IOException {
      Watch result = new Watch(content);
      initialize(result);
      return result;
    }

    public class Watch extends DriveRequest<com.google.api.services.drive.model.Channel> {

      private static final String REST_PATH = "changes/watch";

      /**
       * Subscribe to changes for a user.
       *
       * Create a request for the method "changes.watch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Watch#execute()} method to invoke the remote operation. <p> {@link
       * Watch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.drive.model.Channel}
       * @since 1.13
       */
      protected Watch(com.google.api.services.drive.model.Channel content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Channel.class);
      }

      @Override
      public Watch setAlt(java.lang.String alt) {
        return (Watch) super.setAlt(alt);
      }

      @Override
      public Watch setFields(java.lang.String fields) {
        return (Watch) super.setFields(fields);
      }

      @Override
      public Watch setKey(java.lang.String key) {
        return (Watch) super.setKey(key);
      }

      @Override
      public Watch setOauthToken(java.lang.String oauthToken) {
        return (Watch) super.setOauthToken(oauthToken);
      }

      @Override
      public Watch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Watch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Watch setQuotaUser(java.lang.String quotaUser) {
        return (Watch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Watch setUserIp(java.lang.String userIp) {
        return (Watch) super.setUserIp(userIp);
      }

      /**
       * Whether to include public files the user has opened and shared files. When set to false,
       * the list only includes owned files plus any shared or public files the user has explicitly
       * added to a folder they own.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeSubscribed;

      /** Whether to include public files the user has opened and shared files. When set to false, the list
     only includes owned files plus any shared or public files the user has explicitly added to a folder
     they own. [default: true]
       */
      public java.lang.Boolean getIncludeSubscribed() {
        return includeSubscribed;
      }

      /**
       * Whether to include public files the user has opened and shared files. When set to false,
       * the list only includes owned files plus any shared or public files the user has explicitly
       * added to a folder they own.
       */
      public Watch setIncludeSubscribed(java.lang.Boolean includeSubscribed) {
        this.includeSubscribed = includeSubscribed;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include public files the user has opened and shared files. When set to false, the list
     only includes owned files plus any shared or public files the user has explicitly added to a folder
     they own.
       * </p>
       */
      public boolean isIncludeSubscribed() {
        if (includeSubscribed == null || includeSubscribed == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeSubscribed;
      }

      /** Whether to include deleted items. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** Whether to include deleted items. [default: true]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /** Whether to include deleted items. */
      public Watch setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include deleted items.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeDeleted;
      }

      /** Maximum number of changes to return. */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of changes to return. [default: 100] [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /** Maximum number of changes to return. */
      public Watch setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token for changes. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token for changes.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token for changes. */
      public Watch setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * A comma-separated list of spaces to query. Supported values are 'drive' and
       * 'appDataFolder'.
       */
      @com.google.api.client.util.Key
      private java.lang.String spaces;

      /** A comma-separated list of spaces to query. Supported values are 'drive' and 'appDataFolder'.
       */
      public java.lang.String getSpaces() {
        return spaces;
      }

      /**
       * A comma-separated list of spaces to query. Supported values are 'drive' and
       * 'appDataFolder'.
       */
      public Watch setSpaces(java.lang.String spaces) {
        this.spaces = spaces;
        return this;
      }

      /** Change ID to start listing changes from. */
      @com.google.api.client.util.Key
      private java.lang.Long startChangeId;

      /** Change ID to start listing changes from.
       */
      public java.lang.Long getStartChangeId() {
        return startChangeId;
      }

      /** Change ID to start listing changes from. */
      public Watch setStartChangeId(java.lang.Long startChangeId) {
        this.startChangeId = startChangeId;
        return this;
      }

      @Override
      public Watch set(String parameterName, Object value) {
        return (Watch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Channels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Channels.List request = drive.channels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Channels channels() {
    return new Channels();
  }

  /**
   * The "channels" collection of methods.
   */
  public class Channels {

    /**
     * Stop watching resources through this channel
     *
     * Create a request for the method "channels.stop".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.drive.model.Channel}
     * @return the request
     */
    public Stop stop(com.google.api.services.drive.model.Channel content) throws java.io.IOException {
      Stop result = new Stop(content);
      initialize(result);
      return result;
    }

    public class Stop extends DriveRequest<Void> {

      private static final String REST_PATH = "channels/stop";

      /**
       * Stop watching resources through this channel
       *
       * Create a request for the method "channels.stop".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Stop#execute()} method to invoke the remote operation. <p> {@link
       * Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.drive.model.Channel}
       * @since 1.13
       */
      protected Stop(com.google.api.services.drive.model.Channel content) {
        super(Drive.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public Stop setAlt(java.lang.String alt) {
        return (Stop) super.setAlt(alt);
      }

      @Override
      public Stop setFields(java.lang.String fields) {
        return (Stop) super.setFields(fields);
      }

      @Override
      public Stop setKey(java.lang.String key) {
        return (Stop) super.setKey(key);
      }

      @Override
      public Stop setOauthToken(java.lang.String oauthToken) {
        return (Stop) super.setOauthToken(oauthToken);
      }

      @Override
      public Stop setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Stop) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Stop setQuotaUser(java.lang.String quotaUser) {
        return (Stop) super.setQuotaUser(quotaUser);
      }

      @Override
      public Stop setUserIp(java.lang.String userIp) {
        return (Stop) super.setUserIp(userIp);
      }

      @Override
      public Stop set(String parameterName, Object value) {
        return (Stop) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Children collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Children.List request = drive.children().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Children children() {
    return new Children();
  }

  /**
   * The "children" collection of methods.
   */
  public class Children {

    /**
     * Removes a child from a folder.
     *
     * Create a request for the method "children.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param folderId The ID of the folder.
     * @param childId The ID of the child.
     * @return the request
     */
    public Delete delete(java.lang.String folderId, java.lang.String childId) throws java.io.IOException {
      Delete result = new Delete(folderId, childId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{folderId}/children/{childId}";

      /**
       * Removes a child from a folder.
       *
       * Create a request for the method "children.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param folderId The ID of the folder.
       * @param childId The ID of the child.
       * @since 1.13
       */
      protected Delete(java.lang.String folderId, java.lang.String childId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.folderId = com.google.api.client.util.Preconditions.checkNotNull(folderId, "Required parameter folderId must be specified.");
        this.childId = com.google.api.client.util.Preconditions.checkNotNull(childId, "Required parameter childId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the folder. */
      @com.google.api.client.util.Key
      private java.lang.String folderId;

      /** The ID of the folder.
       */
      public java.lang.String getFolderId() {
        return folderId;
      }

      /** The ID of the folder. */
      public Delete setFolderId(java.lang.String folderId) {
        this.folderId = folderId;
        return this;
      }

      /** The ID of the child. */
      @com.google.api.client.util.Key
      private java.lang.String childId;

      /** The ID of the child.
       */
      public java.lang.String getChildId() {
        return childId;
      }

      /** The ID of the child. */
      public Delete setChildId(java.lang.String childId) {
        this.childId = childId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a specific child reference.
     *
     * Create a request for the method "children.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param folderId The ID of the folder.
     * @param childId The ID of the child.
     * @return the request
     */
    public Get get(java.lang.String folderId, java.lang.String childId) throws java.io.IOException {
      Get result = new Get(folderId, childId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.ChildReference> {

      private static final String REST_PATH = "files/{folderId}/children/{childId}";

      /**
       * Gets a specific child reference.
       *
       * Create a request for the method "children.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param folderId The ID of the folder.
       * @param childId The ID of the child.
       * @since 1.13
       */
      protected Get(java.lang.String folderId, java.lang.String childId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.ChildReference.class);
        this.folderId = com.google.api.client.util.Preconditions.checkNotNull(folderId, "Required parameter folderId must be specified.");
        this.childId = com.google.api.client.util.Preconditions.checkNotNull(childId, "Required parameter childId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the folder. */
      @com.google.api.client.util.Key
      private java.lang.String folderId;

      /** The ID of the folder.
       */
      public java.lang.String getFolderId() {
        return folderId;
      }

      /** The ID of the folder. */
      public Get setFolderId(java.lang.String folderId) {
        this.folderId = folderId;
        return this;
      }

      /** The ID of the child. */
      @com.google.api.client.util.Key
      private java.lang.String childId;

      /** The ID of the child.
       */
      public java.lang.String getChildId() {
        return childId;
      }

      /** The ID of the child. */
      public Get setChildId(java.lang.String childId) {
        this.childId = childId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a file into a folder.
     *
     * Create a request for the method "children.insert".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param folderId The ID of the folder.
     * @param content the {@link com.google.api.services.drive.model.ChildReference}
     * @return the request
     */
    public Insert insert(java.lang.String folderId, com.google.api.services.drive.model.ChildReference content) throws java.io.IOException {
      Insert result = new Insert(folderId, content);
      initialize(result);
      return result;
    }

    public class Insert extends DriveRequest<com.google.api.services.drive.model.ChildReference> {

      private static final String REST_PATH = "files/{folderId}/children";

      /**
       * Inserts a file into a folder.
       *
       * Create a request for the method "children.insert".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param folderId The ID of the folder.
       * @param content the {@link com.google.api.services.drive.model.ChildReference}
       * @since 1.13
       */
      protected Insert(java.lang.String folderId, com.google.api.services.drive.model.ChildReference content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.ChildReference.class);
        this.folderId = com.google.api.client.util.Preconditions.checkNotNull(folderId, "Required parameter folderId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "ChildReference.getId()");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** The ID of the folder. */
      @com.google.api.client.util.Key
      private java.lang.String folderId;

      /** The ID of the folder.
       */
      public java.lang.String getFolderId() {
        return folderId;
      }

      /** The ID of the folder. */
      public Insert setFolderId(java.lang.String folderId) {
        this.folderId = folderId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists a folder's children.
     *
     * Create a request for the method "children.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param folderId The ID of the folder.
     * @return the request
     */
    public List list(java.lang.String folderId) throws java.io.IOException {
      List result = new List(folderId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.ChildList> {

      private static final String REST_PATH = "files/{folderId}/children";

      /**
       * Lists a folder's children.
       *
       * Create a request for the method "children.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param folderId The ID of the folder.
       * @since 1.13
       */
      protected List(java.lang.String folderId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.ChildList.class);
        this.folderId = com.google.api.client.util.Preconditions.checkNotNull(folderId, "Required parameter folderId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the folder. */
      @com.google.api.client.util.Key
      private java.lang.String folderId;

      /** The ID of the folder.
       */
      public java.lang.String getFolderId() {
        return folderId;
      }

      /** The ID of the folder. */
      public List setFolderId(java.lang.String folderId) {
        this.folderId = folderId;
        return this;
      }

      /** Query string for searching children. */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** Query string for searching children.
       */
      public java.lang.String getQ() {
        return q;
      }

      /** Query string for searching children. */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /** Page token for children. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token for children.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token for children. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum number of children to return. */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of children to return. [default: 100] [minimum: 0]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /** Maximum number of children to return. */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Comments collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Comments.List request = drive.comments().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Comments comments() {
    return new Comments();
  }

  /**
   * The "comments" collection of methods.
   */
  public class Comments {

    /**
     * Deletes a comment.
     *
     * Create a request for the method "comments.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String commentId) throws java.io.IOException {
      Delete result = new Delete(fileId, commentId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}";

      /**
       * Deletes a comment.
       *
       * Create a request for the method "comments.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String commentId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Delete setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a comment by ID.
     *
     * Create a request for the method "comments.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String commentId) throws java.io.IOException {
      Get result = new Get(fileId, commentId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Comment> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}";

      /**
       * Gets a comment by ID.
       *
       * Create a request for the method "comments.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String commentId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Comment.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Get setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /**
       * If set, this will succeed when retrieving a deleted comment, and will include any deleted
       * replies.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** If set, this will succeed when retrieving a deleted comment, and will include any deleted replies.
     [default: false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /**
       * If set, this will succeed when retrieving a deleted comment, and will include any deleted
       * replies.
       */
      public Get setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * If set, this will succeed when retrieving a deleted comment, and will include any deleted replies.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new comment on the given file.
     *
     * Create a request for the method "comments.insert".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.Comment}
     * @return the request
     */
    public Insert insert(java.lang.String fileId, com.google.api.services.drive.model.Comment content) throws java.io.IOException {
      Insert result = new Insert(fileId, content);
      initialize(result);
      return result;
    }

    public class Insert extends DriveRequest<com.google.api.services.drive.model.Comment> {

      private static final String REST_PATH = "files/{fileId}/comments";

      /**
       * Creates a new comment on the given file.
       *
       * Create a request for the method "comments.insert".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.Comment}
       * @since 1.13
       */
      protected Insert(java.lang.String fileId, com.google.api.services.drive.model.Comment content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Comment.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getContent(), "Comment.getContent()");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Insert setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists a file's comments.
     *
     * Create a request for the method "comments.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.CommentList> {

      private static final String REST_PATH = "files/{fileId}/comments";

      /**
       * Lists a file's comments.
       *
       * Create a request for the method "comments.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.CommentList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * The continuation token, used to page through large result sets. To get the next page of
       * results, set this parameter to the value of "nextPageToken" from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The continuation token, used to page through large result sets. To get the next page of results,
     set this parameter to the value of "nextPageToken" from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The continuation token, used to page through large result sets. To get the next page of
       * results, set this parameter to the value of "nextPageToken" from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Only discussions that were updated after this timestamp will be returned. Formatted as an
       * RFC 3339 timestamp.
       */
      @com.google.api.client.util.Key
      private java.lang.String updatedMin;

      /** Only discussions that were updated after this timestamp will be returned. Formatted as an RFC 3339
     timestamp.
       */
      public java.lang.String getUpdatedMin() {
        return updatedMin;
      }

      /**
       * Only discussions that were updated after this timestamp will be returned. Formatted as an
       * RFC 3339 timestamp.
       */
      public List setUpdatedMin(java.lang.String updatedMin) {
        this.updatedMin = updatedMin;
        return this;
      }

      /**
       * If set, all comments and replies, including deleted comments and replies (with content
       * stripped) will be returned.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** If set, all comments and replies, including deleted comments and replies (with content stripped)
     will be returned. [default: false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /**
       * If set, all comments and replies, including deleted comments and replies (with content
       * stripped) will be returned.
       */
      public List setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * If set, all comments and replies, including deleted comments and replies (with content stripped)
     will be returned.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      /** The maximum number of discussions to include in the response, used for paging. */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** The maximum number of discussions to include in the response, used for paging. [default: 20]
     [minimum: 0] [maximum: 100]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /** The maximum number of discussions to include in the response, used for paging. */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing comment. This method supports patch semantics.
     *
     * Create a request for the method "comments.patch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param content the {@link com.google.api.services.drive.model.Comment}
     * @return the request
     */
    public Patch patch(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Comment content) throws java.io.IOException {
      Patch result = new Patch(fileId, commentId, content);
      initialize(result);
      return result;
    }

    public class Patch extends DriveRequest<com.google.api.services.drive.model.Comment> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}";

      /**
       * Updates an existing comment. This method supports patch semantics.
       *
       * Create a request for the method "comments.patch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param content the {@link com.google.api.services.drive.model.Comment}
       * @since 1.13
       */
      protected Patch(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Comment content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Comment.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Patch setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Patch setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing comment.
     *
     * Create a request for the method "comments.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param content the {@link com.google.api.services.drive.model.Comment}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Comment content) throws java.io.IOException {
      Update result = new Update(fileId, commentId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Comment> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}";

      /**
       * Updates an existing comment.
       *
       * Create a request for the method "comments.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param content the {@link com.google.api.services.drive.model.Comment}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Comment content) {
        super(Drive.this, "PUT", REST_PATH, content, com.google.api.services.drive.model.Comment.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getContent(), "Comment.getContent()");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Update setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Files collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Files.List request = drive.files().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Files files() {
    return new Files();
  }

  /**
   * The "files" collection of methods.
   */
  public class Files {

    /**
     * Creates a copy of the specified file.
     *
     * Create a request for the method "files.copy".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Copy#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to copy.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Copy copy(java.lang.String fileId, com.google.api.services.drive.model.File content) throws java.io.IOException {
      Copy result = new Copy(fileId, content);
      initialize(result);
      return result;
    }

    public class Copy extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}/copy";

      /**
       * Creates a copy of the specified file.
       *
       * Create a request for the method "files.copy".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Copy#execute()} method to invoke the remote operation. <p> {@link
       * Copy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file to copy.
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Copy(java.lang.String fileId, com.google.api.services.drive.model.File content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Copy setAlt(java.lang.String alt) {
        return (Copy) super.setAlt(alt);
      }

      @Override
      public Copy setFields(java.lang.String fields) {
        return (Copy) super.setFields(fields);
      }

      @Override
      public Copy setKey(java.lang.String key) {
        return (Copy) super.setKey(key);
      }

      @Override
      public Copy setOauthToken(java.lang.String oauthToken) {
        return (Copy) super.setOauthToken(oauthToken);
      }

      @Override
      public Copy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Copy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Copy setQuotaUser(java.lang.String quotaUser) {
        return (Copy) super.setQuotaUser(quotaUser);
      }

      @Override
      public Copy setUserIp(java.lang.String userIp) {
        return (Copy) super.setUserIp(userIp);
      }

      /** The ID of the file to copy. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file to copy.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file to copy. */
      public Copy setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      @com.google.api.client.util.Key
      private java.lang.Boolean convert;

      /** Whether to convert this file to the corresponding Google Docs format. [default: false]
       */
      public java.lang.Boolean getConvert() {
        return convert;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      public Copy setConvert(java.lang.Boolean convert) {
        this.convert = convert;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to convert this file to the corresponding Google Docs format.
       * </p>
       */
      public boolean isConvert() {
        if (convert == null || convert == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return convert;
      }

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes. */
      @com.google.api.client.util.Key
      private java.lang.String ocrLanguage;

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes.
       */
      public java.lang.String getOcrLanguage() {
        return ocrLanguage;
      }

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes. */
      public Copy setOcrLanguage(java.lang.String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /**
       * The visibility of the new file. This parameter is only relevant when the source is not a
       * native Google Doc and convert=false.
       */
      @com.google.api.client.util.Key
      private java.lang.String visibility;

      /** The visibility of the new file. This parameter is only relevant when the source is not a native
     Google Doc and convert=false. [default: DEFAULT]
       */
      public java.lang.String getVisibility() {
        return visibility;
      }

      /**
       * The visibility of the new file. This parameter is only relevant when the source is not a
       * native Google Doc and convert=false.
       */
      public Copy setVisibility(java.lang.String visibility) {
        this.visibility = visibility;
        return this;
      }

      /**
       * Whether to pin the head revision of the new copy. A file can have a maximum of 200 pinned
       * revisions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean pinned;

      /** Whether to pin the head revision of the new copy. A file can have a maximum of 200 pinned
     revisions. [default: false]
       */
      public java.lang.Boolean getPinned() {
        return pinned;
      }

      /**
       * Whether to pin the head revision of the new copy. A file can have a maximum of 200 pinned
       * revisions.
       */
      public Copy setPinned(java.lang.Boolean pinned) {
        this.pinned = pinned;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to pin the head revision of the new copy. A file can have a maximum of 200 pinned
     revisions.
       * </p>
       */
      public boolean isPinned() {
        if (pinned == null || pinned == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return pinned;
      }

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. */
      @com.google.api.client.util.Key
      private java.lang.Boolean ocr;

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. [default: false]
       */
      public java.lang.Boolean getOcr() {
        return ocr;
      }

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. */
      public Copy setOcr(java.lang.Boolean ocr) {
        this.ocr = ocr;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads.
       * </p>
       */
      public boolean isOcr() {
        if (ocr == null || ocr == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ocr;
      }

      /** The timed text track name. */
      @com.google.api.client.util.Key
      private java.lang.String timedTextTrackName;

      /** The timed text track name.
       */
      public java.lang.String getTimedTextTrackName() {
        return timedTextTrackName;
      }

      /** The timed text track name. */
      public Copy setTimedTextTrackName(java.lang.String timedTextTrackName) {
        this.timedTextTrackName = timedTextTrackName;
        return this;
      }

      /** The language of the timed text. */
      @com.google.api.client.util.Key
      private java.lang.String timedTextLanguage;

      /** The language of the timed text.
       */
      public java.lang.String getTimedTextLanguage() {
        return timedTextLanguage;
      }

      /** The language of the timed text. */
      public Copy setTimedTextLanguage(java.lang.String timedTextLanguage) {
        this.timedTextLanguage = timedTextLanguage;
        return this;
      }

      @Override
      public Copy set(String parameterName, Object value) {
        return (Copy) super.set(parameterName, value);
      }
    }
    /**
     * Permanently deletes a file by ID. Skips the trash. The currently authenticated user must own the
     * file.
     *
     * Create a request for the method "files.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to delete.
     * @return the request
     */
    public Delete delete(java.lang.String fileId) throws java.io.IOException {
      Delete result = new Delete(fileId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Permanently deletes a file by ID. Skips the trash. The currently authenticated user must own
       * the file.
       *
       * Create a request for the method "files.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the file to delete. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file to delete.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file to delete. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Permanently deletes all of the user's trashed files.
     *
     * Create a request for the method "files.emptyTrash".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link EmptyTrash#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public EmptyTrash emptyTrash() throws java.io.IOException {
      EmptyTrash result = new EmptyTrash();
      initialize(result);
      return result;
    }

    public class EmptyTrash extends DriveRequest<Void> {

      private static final String REST_PATH = "files/trash";

      /**
       * Permanently deletes all of the user's trashed files.
       *
       * Create a request for the method "files.emptyTrash".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link EmptyTrash#execute()} method to invoke the remote operation. <p>
       * {@link
       * EmptyTrash#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected EmptyTrash() {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
      }

      @Override
      public EmptyTrash setAlt(java.lang.String alt) {
        return (EmptyTrash) super.setAlt(alt);
      }

      @Override
      public EmptyTrash setFields(java.lang.String fields) {
        return (EmptyTrash) super.setFields(fields);
      }

      @Override
      public EmptyTrash setKey(java.lang.String key) {
        return (EmptyTrash) super.setKey(key);
      }

      @Override
      public EmptyTrash setOauthToken(java.lang.String oauthToken) {
        return (EmptyTrash) super.setOauthToken(oauthToken);
      }

      @Override
      public EmptyTrash setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (EmptyTrash) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public EmptyTrash setQuotaUser(java.lang.String quotaUser) {
        return (EmptyTrash) super.setQuotaUser(quotaUser);
      }

      @Override
      public EmptyTrash setUserIp(java.lang.String userIp) {
        return (EmptyTrash) super.setUserIp(userIp);
      }

      @Override
      public EmptyTrash set(String parameterName, Object value) {
        return (EmptyTrash) super.set(parameterName, value);
      }
    }
    /**
     * Gets a file's metadata by ID.
     *
     * Create a request for the method "files.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file in question.
     * @return the request
     */
    public Get get(java.lang.String fileId) throws java.io.IOException {
      Get result = new Get(fileId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Gets a file's metadata by ID.
       *
       * Create a request for the method "files.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID for the file in question.
       * @since 1.13
       */
      protected Get(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID for the file in question. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID for the file in question.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID for the file in question. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean acknowledgeAbuse;

      /** Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     [default: false]
       */
      public java.lang.Boolean getAcknowledgeAbuse() {
        return acknowledgeAbuse;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files.
       */
      public Get setAcknowledgeAbuse(java.lang.Boolean acknowledgeAbuse) {
        this.acknowledgeAbuse = acknowledgeAbuse;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the user is acknowledging the risk of downloading known malware or other abusive files.
       * </p>
       */
      public boolean isAcknowledgeAbuse() {
        if (acknowledgeAbuse == null || acknowledgeAbuse == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return acknowledgeAbuse;
      }

      /** Whether to update the view date after successfully retrieving the file. */
      @com.google.api.client.util.Key
      private java.lang.Boolean updateViewedDate;

      /** Whether to update the view date after successfully retrieving the file. [default: false]
       */
      public java.lang.Boolean getUpdateViewedDate() {
        return updateViewedDate;
      }

      /** Whether to update the view date after successfully retrieving the file. */
      public Get setUpdateViewedDate(java.lang.Boolean updateViewedDate) {
        this.updateViewedDate = updateViewedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to update the view date after successfully retrieving the file.
       * </p>
       */
      public boolean isUpdateViewedDate() {
        if (updateViewedDate == null || updateViewedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return updateViewedDate;
      }

      /**
       * Specifies the Revision ID that should be downloaded. Ignored unless alt=media is specified.
       */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** Specifies the Revision ID that should be downloaded. Ignored unless alt=media is specified.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /**
       * Specifies the Revision ID that should be downloaded. Ignored unless alt=media is specified.
       */
      public Get setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      /** This parameter is deprecated and has no function. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** This parameter is deprecated and has no function.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** This parameter is deprecated and has no function. */
      public Get setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Insert a new file.
     *
     * Create a request for the method "files.insert".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Insert insert(com.google.api.services.drive.model.File content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    /**
     * Insert a new file.
     *
     * Create a request for the method "files.insert".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     *
     * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files";

      /**
       * Insert a new file.
       *
       * Create a request for the method "files.insert".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Insert(com.google.api.services.drive.model.File content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.File.class);
      }

      /**
       * Insert a new file.
       *
       * Create a request for the method "files.insert".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       *
       * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Drive.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.drive.model.File.class);
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      @com.google.api.client.util.Key
      private java.lang.Boolean convert;

      /** Whether to convert this file to the corresponding Google Docs format. [default: false]
       */
      public java.lang.Boolean getConvert() {
        return convert;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      public Insert setConvert(java.lang.Boolean convert) {
        this.convert = convert;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to convert this file to the corresponding Google Docs format.
       * </p>
       */
      public boolean isConvert() {
        if (convert == null || convert == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return convert;
      }

      /** Whether to use the content as indexable text. */
      @com.google.api.client.util.Key
      private java.lang.Boolean useContentAsIndexableText;

      /** Whether to use the content as indexable text. [default: false]
       */
      public java.lang.Boolean getUseContentAsIndexableText() {
        return useContentAsIndexableText;
      }

      /** Whether to use the content as indexable text. */
      public Insert setUseContentAsIndexableText(java.lang.Boolean useContentAsIndexableText) {
        this.useContentAsIndexableText = useContentAsIndexableText;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to use the content as indexable text.
       * </p>
       */
      public boolean isUseContentAsIndexableText() {
        if (useContentAsIndexableText == null || useContentAsIndexableText == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useContentAsIndexableText;
      }

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes. */
      @com.google.api.client.util.Key
      private java.lang.String ocrLanguage;

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes.
       */
      public java.lang.String getOcrLanguage() {
        return ocrLanguage;
      }

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes. */
      public Insert setOcrLanguage(java.lang.String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** The visibility of the new file. This parameter is only relevant when convert=false. */
      @com.google.api.client.util.Key
      private java.lang.String visibility;

      /** The visibility of the new file. This parameter is only relevant when convert=false. [default:
     DEFAULT]
       */
      public java.lang.String getVisibility() {
        return visibility;
      }

      /** The visibility of the new file. This parameter is only relevant when convert=false. */
      public Insert setVisibility(java.lang.String visibility) {
        this.visibility = visibility;
        return this;
      }

      /**
       * Whether to pin the head revision of the uploaded file. A file can have a maximum of 200
       * pinned revisions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean pinned;

      /** Whether to pin the head revision of the uploaded file. A file can have a maximum of 200 pinned
     revisions. [default: false]
       */
      public java.lang.Boolean getPinned() {
        return pinned;
      }

      /**
       * Whether to pin the head revision of the uploaded file. A file can have a maximum of 200
       * pinned revisions.
       */
      public Insert setPinned(java.lang.Boolean pinned) {
        this.pinned = pinned;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to pin the head revision of the uploaded file. A file can have a maximum of 200 pinned
     revisions.
       * </p>
       */
      public boolean isPinned() {
        if (pinned == null || pinned == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return pinned;
      }

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. */
      @com.google.api.client.util.Key
      private java.lang.Boolean ocr;

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. [default: false]
       */
      public java.lang.Boolean getOcr() {
        return ocr;
      }

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. */
      public Insert setOcr(java.lang.Boolean ocr) {
        this.ocr = ocr;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads.
       * </p>
       */
      public boolean isOcr() {
        if (ocr == null || ocr == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ocr;
      }

      /** The timed text track name. */
      @com.google.api.client.util.Key
      private java.lang.String timedTextTrackName;

      /** The timed text track name.
       */
      public java.lang.String getTimedTextTrackName() {
        return timedTextTrackName;
      }

      /** The timed text track name. */
      public Insert setTimedTextTrackName(java.lang.String timedTextTrackName) {
        this.timedTextTrackName = timedTextTrackName;
        return this;
      }

      /** The language of the timed text. */
      @com.google.api.client.util.Key
      private java.lang.String timedTextLanguage;

      /** The language of the timed text.
       */
      public java.lang.String getTimedTextLanguage() {
        return timedTextLanguage;
      }

      /** The language of the timed text. */
      public Insert setTimedTextLanguage(java.lang.String timedTextLanguage) {
        this.timedTextLanguage = timedTextLanguage;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists the user's files.
     *
     * Create a request for the method "files.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.FileList> {

      private static final String REST_PATH = "files";

      /**
       * Lists the user's files.
       *
       * Create a request for the method "files.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.FileList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** This parameter is deprecated and has no function. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** This parameter is deprecated and has no function.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** This parameter is deprecated and has no function. */
      public List setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      /** Maximum number of files to return. */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of files to return. [default: 100] [minimum: 0]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /** Maximum number of files to return. */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Query string for searching files. */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** Query string for searching files.
       */
      public java.lang.String getQ() {
        return q;
      }

      /** Query string for searching files. */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /** Page token for files. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token for files.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token for files. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * A comma-separated list of spaces to query. Supported values are 'drive' and
       * 'appDataFolder'.
       */
      @com.google.api.client.util.Key
      private java.lang.String spaces;

      /** A comma-separated list of spaces to query. Supported values are 'drive' and 'appDataFolder'.
       */
      public java.lang.String getSpaces() {
        return spaces;
      }

      /**
       * A comma-separated list of spaces to query. Supported values are 'drive' and
       * 'appDataFolder'.
       */
      public List setSpaces(java.lang.String spaces) {
        this.spaces = spaces;
        return this;
      }

      /** The body of items (files/documents) to which the query applies. */
      @com.google.api.client.util.Key
      private java.lang.String corpus;

      /** The body of items (files/documents) to which the query applies.
       */
      public java.lang.String getCorpus() {
        return corpus;
      }

      /** The body of items (files/documents) to which the query applies. */
      public List setCorpus(java.lang.String corpus) {
        this.corpus = corpus;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates file metadata and/or content. This method supports patch semantics.
     *
     * Create a request for the method "files.patch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to update.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Patch patch(java.lang.String fileId, com.google.api.services.drive.model.File content) throws java.io.IOException {
      Patch result = new Patch(fileId, content);
      initialize(result);
      return result;
    }

    public class Patch extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Updates file metadata and/or content. This method supports patch semantics.
       *
       * Create a request for the method "files.patch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file to update.
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Patch(java.lang.String fileId, com.google.api.services.drive.model.File content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** The ID of the file to update. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file to update.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file to update. */
      public Patch setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Comma-separated list of parent IDs to add. */
      @com.google.api.client.util.Key
      private java.lang.String addParents;

      /** Comma-separated list of parent IDs to add.
       */
      public java.lang.String getAddParents() {
        return addParents;
      }

      /** Comma-separated list of parent IDs to add. */
      public Patch setAddParents(java.lang.String addParents) {
        this.addParents = addParents;
        return this;
      }

      /** Whether to update the view date after successfully updating the file. */
      @com.google.api.client.util.Key
      private java.lang.Boolean updateViewedDate;

      /** Whether to update the view date after successfully updating the file. [default: true]
       */
      public java.lang.Boolean getUpdateViewedDate() {
        return updateViewedDate;
      }

      /** Whether to update the view date after successfully updating the file. */
      public Patch setUpdateViewedDate(java.lang.Boolean updateViewedDate) {
        this.updateViewedDate = updateViewedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to update the view date after successfully updating the file.
       * </p>
       */
      public boolean isUpdateViewedDate() {
        if (updateViewedDate == null || updateViewedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return updateViewedDate;
      }

      /** Comma-separated list of parent IDs to remove. */
      @com.google.api.client.util.Key
      private java.lang.String removeParents;

      /** Comma-separated list of parent IDs to remove.
       */
      public java.lang.String getRemoveParents() {
        return removeParents;
      }

      /** Comma-separated list of parent IDs to remove. */
      public Patch setRemoveParents(java.lang.String removeParents) {
        this.removeParents = removeParents;
        return this;
      }

      /** Whether to set the modified date with the supplied modified date. */
      @com.google.api.client.util.Key
      private java.lang.Boolean setModifiedDate;

      /** Whether to set the modified date with the supplied modified date. [default: false]
       */
      public java.lang.Boolean getSetModifiedDate() {
        return setModifiedDate;
      }

      /** Whether to set the modified date with the supplied modified date. */
      public Patch setSetModifiedDate(java.lang.Boolean setModifiedDate) {
        this.setModifiedDate = setModifiedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to set the modified date with the supplied modified date.
       * </p>
       */
      public boolean isSetModifiedDate() {
        if (setModifiedDate == null || setModifiedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return setModifiedDate;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      @com.google.api.client.util.Key
      private java.lang.Boolean convert;

      /** Whether to convert this file to the corresponding Google Docs format. [default: false]
       */
      public java.lang.Boolean getConvert() {
        return convert;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      public Patch setConvert(java.lang.Boolean convert) {
        this.convert = convert;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to convert this file to the corresponding Google Docs format.
       * </p>
       */
      public boolean isConvert() {
        if (convert == null || convert == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return convert;
      }

      /** Whether to use the content as indexable text. */
      @com.google.api.client.util.Key
      private java.lang.Boolean useContentAsIndexableText;

      /** Whether to use the content as indexable text. [default: false]
       */
      public java.lang.Boolean getUseContentAsIndexableText() {
        return useContentAsIndexableText;
      }

      /** Whether to use the content as indexable text. */
      public Patch setUseContentAsIndexableText(java.lang.Boolean useContentAsIndexableText) {
        this.useContentAsIndexableText = useContentAsIndexableText;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to use the content as indexable text.
       * </p>
       */
      public boolean isUseContentAsIndexableText() {
        if (useContentAsIndexableText == null || useContentAsIndexableText == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useContentAsIndexableText;
      }

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes. */
      @com.google.api.client.util.Key
      private java.lang.String ocrLanguage;

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes.
       */
      public java.lang.String getOcrLanguage() {
        return ocrLanguage;
      }

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes. */
      public Patch setOcrLanguage(java.lang.String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** Whether to pin the new revision. A file can have a maximum of 200 pinned revisions. */
      @com.google.api.client.util.Key
      private java.lang.Boolean pinned;

      /** Whether to pin the new revision. A file can have a maximum of 200 pinned revisions. [default:
     false]
       */
      public java.lang.Boolean getPinned() {
        return pinned;
      }

      /** Whether to pin the new revision. A file can have a maximum of 200 pinned revisions. */
      public Patch setPinned(java.lang.Boolean pinned) {
        this.pinned = pinned;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to pin the new revision. A file can have a maximum of 200 pinned revisions.
       * </p>
       */
      public boolean isPinned() {
        if (pinned == null || pinned == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return pinned;
      }

      /**
       * Whether a blob upload should create a new revision. If false, the blob data in the current
       * head revision is replaced. If true or not set, a new blob is created as head revision, and
       * previous unpinned revisions are preserved for a short period of time. Pinned revisions are
       * stored indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean newRevision;

      /** Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision is replaced. If true or not set, a new blob is created as head revision, and previous
     unpinned revisions are preserved for a short period of time. Pinned revisions are stored
     indefinitely, using additional storage quota, up to a maximum of 200 revisions. [default: true]
       */
      public java.lang.Boolean getNewRevision() {
        return newRevision;
      }

      /**
       * Whether a blob upload should create a new revision. If false, the blob data in the current
       * head revision is replaced. If true or not set, a new blob is created as head revision, and
       * previous unpinned revisions are preserved for a short period of time. Pinned revisions are
       * stored indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       */
      public Patch setNewRevision(java.lang.Boolean newRevision) {
        this.newRevision = newRevision;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision is replaced. If true or not set, a new blob is created as head revision, and previous
     unpinned revisions are preserved for a short period of time. Pinned revisions are stored
     indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       * </p>
       */
      public boolean isNewRevision() {
        if (newRevision == null || newRevision == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return newRevision;
      }

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. */
      @com.google.api.client.util.Key
      private java.lang.Boolean ocr;

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. [default: false]
       */
      public java.lang.Boolean getOcr() {
        return ocr;
      }

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. */
      public Patch setOcr(java.lang.Boolean ocr) {
        this.ocr = ocr;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads.
       * </p>
       */
      public boolean isOcr() {
        if (ocr == null || ocr == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ocr;
      }

      /** The language of the timed text. */
      @com.google.api.client.util.Key
      private java.lang.String timedTextLanguage;

      /** The language of the timed text.
       */
      public java.lang.String getTimedTextLanguage() {
        return timedTextLanguage;
      }

      /** The language of the timed text. */
      public Patch setTimedTextLanguage(java.lang.String timedTextLanguage) {
        this.timedTextLanguage = timedTextLanguage;
        return this;
      }

      /** The timed text track name. */
      @com.google.api.client.util.Key
      private java.lang.String timedTextTrackName;

      /** The timed text track name.
       */
      public java.lang.String getTimedTextTrackName() {
        return timedTextTrackName;
      }

      /** The timed text track name. */
      public Patch setTimedTextTrackName(java.lang.String timedTextTrackName) {
        this.timedTextTrackName = timedTextTrackName;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Set the file's updated time to the current server time.
     *
     * Create a request for the method "files.touch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Touch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to update.
     * @return the request
     */
    public Touch touch(java.lang.String fileId) throws java.io.IOException {
      Touch result = new Touch(fileId);
      initialize(result);
      return result;
    }

    public class Touch extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}/touch";

      /**
       * Set the file's updated time to the current server time.
       *
       * Create a request for the method "files.touch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Touch#execute()} method to invoke the remote operation. <p> {@link
       * Touch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file to update.
       * @since 1.13
       */
      protected Touch(java.lang.String fileId) {
        super(Drive.this, "POST", REST_PATH, null, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Touch setAlt(java.lang.String alt) {
        return (Touch) super.setAlt(alt);
      }

      @Override
      public Touch setFields(java.lang.String fields) {
        return (Touch) super.setFields(fields);
      }

      @Override
      public Touch setKey(java.lang.String key) {
        return (Touch) super.setKey(key);
      }

      @Override
      public Touch setOauthToken(java.lang.String oauthToken) {
        return (Touch) super.setOauthToken(oauthToken);
      }

      @Override
      public Touch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Touch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Touch setQuotaUser(java.lang.String quotaUser) {
        return (Touch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Touch setUserIp(java.lang.String userIp) {
        return (Touch) super.setUserIp(userIp);
      }

      /** The ID of the file to update. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file to update.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file to update. */
      public Touch setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public Touch set(String parameterName, Object value) {
        return (Touch) super.set(parameterName, value);
      }
    }
    /**
     * Moves a file to the trash.
     *
     * Create a request for the method "files.trash".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Trash#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to trash.
     * @return the request
     */
    public Trash trash(java.lang.String fileId) throws java.io.IOException {
      Trash result = new Trash(fileId);
      initialize(result);
      return result;
    }

    public class Trash extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}/trash";

      /**
       * Moves a file to the trash.
       *
       * Create a request for the method "files.trash".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Trash#execute()} method to invoke the remote operation. <p> {@link
       * Trash#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file to trash.
       * @since 1.13
       */
      protected Trash(java.lang.String fileId) {
        super(Drive.this, "POST", REST_PATH, null, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Trash setAlt(java.lang.String alt) {
        return (Trash) super.setAlt(alt);
      }

      @Override
      public Trash setFields(java.lang.String fields) {
        return (Trash) super.setFields(fields);
      }

      @Override
      public Trash setKey(java.lang.String key) {
        return (Trash) super.setKey(key);
      }

      @Override
      public Trash setOauthToken(java.lang.String oauthToken) {
        return (Trash) super.setOauthToken(oauthToken);
      }

      @Override
      public Trash setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Trash) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Trash setQuotaUser(java.lang.String quotaUser) {
        return (Trash) super.setQuotaUser(quotaUser);
      }

      @Override
      public Trash setUserIp(java.lang.String userIp) {
        return (Trash) super.setUserIp(userIp);
      }

      /** The ID of the file to trash. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file to trash.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file to trash. */
      public Trash setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public Trash set(String parameterName, Object value) {
        return (Trash) super.set(parameterName, value);
      }
    }
    /**
     * Restores a file from the trash.
     *
     * Create a request for the method "files.untrash".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Untrash#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to untrash.
     * @return the request
     */
    public Untrash untrash(java.lang.String fileId) throws java.io.IOException {
      Untrash result = new Untrash(fileId);
      initialize(result);
      return result;
    }

    public class Untrash extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}/untrash";

      /**
       * Restores a file from the trash.
       *
       * Create a request for the method "files.untrash".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Untrash#execute()} method to invoke the remote operation. <p>
       * {@link
       * Untrash#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file to untrash.
       * @since 1.13
       */
      protected Untrash(java.lang.String fileId) {
        super(Drive.this, "POST", REST_PATH, null, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Untrash setAlt(java.lang.String alt) {
        return (Untrash) super.setAlt(alt);
      }

      @Override
      public Untrash setFields(java.lang.String fields) {
        return (Untrash) super.setFields(fields);
      }

      @Override
      public Untrash setKey(java.lang.String key) {
        return (Untrash) super.setKey(key);
      }

      @Override
      public Untrash setOauthToken(java.lang.String oauthToken) {
        return (Untrash) super.setOauthToken(oauthToken);
      }

      @Override
      public Untrash setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Untrash) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Untrash setQuotaUser(java.lang.String quotaUser) {
        return (Untrash) super.setQuotaUser(quotaUser);
      }

      @Override
      public Untrash setUserIp(java.lang.String userIp) {
        return (Untrash) super.setUserIp(userIp);
      }

      /** The ID of the file to untrash. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file to untrash.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file to untrash. */
      public Untrash setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public Untrash set(String parameterName, Object value) {
        return (Untrash) super.set(parameterName, value);
      }
    }
    /**
     * Updates file metadata and/or content.
     *
     * Create a request for the method "files.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to update.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Update update(java.lang.String fileId, com.google.api.services.drive.model.File content) throws java.io.IOException {
      Update result = new Update(fileId, content);
      initialize(result);
      return result;
    }

    /**
     * Updates file metadata and/or content.
     *
     * Create a request for the method "files.update".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param fileId The ID of the file to update.
     * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Update update(java.lang.String fileId, com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Update result = new Update(fileId, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Updates file metadata and/or content.
       *
       * Create a request for the method "files.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file to update.
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, com.google.api.services.drive.model.File content) {
        super(Drive.this, "PUT", REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      /**
       * Updates file metadata and/or content.
       *
       * Create a request for the method "files.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param fileId The ID of the file to update.
       * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Update(java.lang.String fileId, com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Drive.this, "PUT", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID of the file to update. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file to update.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file to update. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Comma-separated list of parent IDs to add. */
      @com.google.api.client.util.Key
      private java.lang.String addParents;

      /** Comma-separated list of parent IDs to add.
       */
      public java.lang.String getAddParents() {
        return addParents;
      }

      /** Comma-separated list of parent IDs to add. */
      public Update setAddParents(java.lang.String addParents) {
        this.addParents = addParents;
        return this;
      }

      /** Whether to update the view date after successfully updating the file. */
      @com.google.api.client.util.Key
      private java.lang.Boolean updateViewedDate;

      /** Whether to update the view date after successfully updating the file. [default: true]
       */
      public java.lang.Boolean getUpdateViewedDate() {
        return updateViewedDate;
      }

      /** Whether to update the view date after successfully updating the file. */
      public Update setUpdateViewedDate(java.lang.Boolean updateViewedDate) {
        this.updateViewedDate = updateViewedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to update the view date after successfully updating the file.
       * </p>
       */
      public boolean isUpdateViewedDate() {
        if (updateViewedDate == null || updateViewedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return updateViewedDate;
      }

      /** Comma-separated list of parent IDs to remove. */
      @com.google.api.client.util.Key
      private java.lang.String removeParents;

      /** Comma-separated list of parent IDs to remove.
       */
      public java.lang.String getRemoveParents() {
        return removeParents;
      }

      /** Comma-separated list of parent IDs to remove. */
      public Update setRemoveParents(java.lang.String removeParents) {
        this.removeParents = removeParents;
        return this;
      }

      /** Whether to set the modified date with the supplied modified date. */
      @com.google.api.client.util.Key
      private java.lang.Boolean setModifiedDate;

      /** Whether to set the modified date with the supplied modified date. [default: false]
       */
      public java.lang.Boolean getSetModifiedDate() {
        return setModifiedDate;
      }

      /** Whether to set the modified date with the supplied modified date. */
      public Update setSetModifiedDate(java.lang.Boolean setModifiedDate) {
        this.setModifiedDate = setModifiedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to set the modified date with the supplied modified date.
       * </p>
       */
      public boolean isSetModifiedDate() {
        if (setModifiedDate == null || setModifiedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return setModifiedDate;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      @com.google.api.client.util.Key
      private java.lang.Boolean convert;

      /** Whether to convert this file to the corresponding Google Docs format. [default: false]
       */
      public java.lang.Boolean getConvert() {
        return convert;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      public Update setConvert(java.lang.Boolean convert) {
        this.convert = convert;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to convert this file to the corresponding Google Docs format.
       * </p>
       */
      public boolean isConvert() {
        if (convert == null || convert == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return convert;
      }

      /** Whether to use the content as indexable text. */
      @com.google.api.client.util.Key
      private java.lang.Boolean useContentAsIndexableText;

      /** Whether to use the content as indexable text. [default: false]
       */
      public java.lang.Boolean getUseContentAsIndexableText() {
        return useContentAsIndexableText;
      }

      /** Whether to use the content as indexable text. */
      public Update setUseContentAsIndexableText(java.lang.Boolean useContentAsIndexableText) {
        this.useContentAsIndexableText = useContentAsIndexableText;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to use the content as indexable text.
       * </p>
       */
      public boolean isUseContentAsIndexableText() {
        if (useContentAsIndexableText == null || useContentAsIndexableText == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useContentAsIndexableText;
      }

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes. */
      @com.google.api.client.util.Key
      private java.lang.String ocrLanguage;

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes.
       */
      public java.lang.String getOcrLanguage() {
        return ocrLanguage;
      }

      /** If ocr is true, hints at the language to use. Valid values are BCP 47 codes. */
      public Update setOcrLanguage(java.lang.String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** Whether to pin the new revision. A file can have a maximum of 200 pinned revisions. */
      @com.google.api.client.util.Key
      private java.lang.Boolean pinned;

      /** Whether to pin the new revision. A file can have a maximum of 200 pinned revisions. [default:
     false]
       */
      public java.lang.Boolean getPinned() {
        return pinned;
      }

      /** Whether to pin the new revision. A file can have a maximum of 200 pinned revisions. */
      public Update setPinned(java.lang.Boolean pinned) {
        this.pinned = pinned;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to pin the new revision. A file can have a maximum of 200 pinned revisions.
       * </p>
       */
      public boolean isPinned() {
        if (pinned == null || pinned == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return pinned;
      }

      /**
       * Whether a blob upload should create a new revision. If false, the blob data in the current
       * head revision is replaced. If true or not set, a new blob is created as head revision, and
       * previous unpinned revisions are preserved for a short period of time. Pinned revisions are
       * stored indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean newRevision;

      /** Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision is replaced. If true or not set, a new blob is created as head revision, and previous
     unpinned revisions are preserved for a short period of time. Pinned revisions are stored
     indefinitely, using additional storage quota, up to a maximum of 200 revisions. [default: true]
       */
      public java.lang.Boolean getNewRevision() {
        return newRevision;
      }

      /**
       * Whether a blob upload should create a new revision. If false, the blob data in the current
       * head revision is replaced. If true or not set, a new blob is created as head revision, and
       * previous unpinned revisions are preserved for a short period of time. Pinned revisions are
       * stored indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       */
      public Update setNewRevision(java.lang.Boolean newRevision) {
        this.newRevision = newRevision;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision is replaced. If true or not set, a new blob is created as head revision, and previous
     unpinned revisions are preserved for a short period of time. Pinned revisions are stored
     indefinitely, using additional storage quota, up to a maximum of 200 revisions.
       * </p>
       */
      public boolean isNewRevision() {
        if (newRevision == null || newRevision == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return newRevision;
      }

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. */
      @com.google.api.client.util.Key
      private java.lang.Boolean ocr;

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. [default: false]
       */
      public java.lang.Boolean getOcr() {
        return ocr;
      }

      /** Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. */
      public Update setOcr(java.lang.Boolean ocr) {
        this.ocr = ocr;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads.
       * </p>
       */
      public boolean isOcr() {
        if (ocr == null || ocr == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ocr;
      }

      /** The language of the timed text. */
      @com.google.api.client.util.Key
      private java.lang.String timedTextLanguage;

      /** The language of the timed text.
       */
      public java.lang.String getTimedTextLanguage() {
        return timedTextLanguage;
      }

      /** The language of the timed text. */
      public Update setTimedTextLanguage(java.lang.String timedTextLanguage) {
        this.timedTextLanguage = timedTextLanguage;
        return this;
      }

      /** The timed text track name. */
      @com.google.api.client.util.Key
      private java.lang.String timedTextTrackName;

      /** The timed text track name.
       */
      public java.lang.String getTimedTextTrackName() {
        return timedTextTrackName;
      }

      /** The timed text track name. */
      public Update setTimedTextTrackName(java.lang.String timedTextTrackName) {
        this.timedTextTrackName = timedTextTrackName;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
    /**
     * Subscribe to changes on a file
     *
     * Create a request for the method "files.watch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Watch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file in question.
     * @param content the {@link com.google.api.services.drive.model.Channel}
     * @return the request
     */
    public Watch watch(java.lang.String fileId, com.google.api.services.drive.model.Channel content) throws java.io.IOException {
      Watch result = new Watch(fileId, content);
      initialize(result);
      return result;
    }

    public class Watch extends DriveRequest<com.google.api.services.drive.model.Channel> {

      private static final String REST_PATH = "files/{fileId}/watch";

      /**
       * Subscribe to changes on a file
       *
       * Create a request for the method "files.watch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Watch#execute()} method to invoke the remote operation. <p> {@link
       * Watch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID for the file in question.
       * @param content the {@link com.google.api.services.drive.model.Channel}
       * @since 1.13
       */
      protected Watch(java.lang.String fileId, com.google.api.services.drive.model.Channel content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Channel.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public Watch setAlt(java.lang.String alt) {
        return (Watch) super.setAlt(alt);
      }

      @Override
      public Watch setFields(java.lang.String fields) {
        return (Watch) super.setFields(fields);
      }

      @Override
      public Watch setKey(java.lang.String key) {
        return (Watch) super.setKey(key);
      }

      @Override
      public Watch setOauthToken(java.lang.String oauthToken) {
        return (Watch) super.setOauthToken(oauthToken);
      }

      @Override
      public Watch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Watch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Watch setQuotaUser(java.lang.String quotaUser) {
        return (Watch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Watch setUserIp(java.lang.String userIp) {
        return (Watch) super.setUserIp(userIp);
      }

      /** The ID for the file in question. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID for the file in question.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID for the file in question. */
      public Watch setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean acknowledgeAbuse;

      /** Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     [default: false]
       */
      public java.lang.Boolean getAcknowledgeAbuse() {
        return acknowledgeAbuse;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files.
       */
      public Watch setAcknowledgeAbuse(java.lang.Boolean acknowledgeAbuse) {
        this.acknowledgeAbuse = acknowledgeAbuse;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the user is acknowledging the risk of downloading known malware or other abusive files.
       * </p>
       */
      public boolean isAcknowledgeAbuse() {
        if (acknowledgeAbuse == null || acknowledgeAbuse == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return acknowledgeAbuse;
      }

      /** Whether to update the view date after successfully retrieving the file. */
      @com.google.api.client.util.Key
      private java.lang.Boolean updateViewedDate;

      /** Whether to update the view date after successfully retrieving the file. [default: false]
       */
      public java.lang.Boolean getUpdateViewedDate() {
        return updateViewedDate;
      }

      /** Whether to update the view date after successfully retrieving the file. */
      public Watch setUpdateViewedDate(java.lang.Boolean updateViewedDate) {
        this.updateViewedDate = updateViewedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to update the view date after successfully retrieving the file.
       * </p>
       */
      public boolean isUpdateViewedDate() {
        if (updateViewedDate == null || updateViewedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return updateViewedDate;
      }

      /**
       * Specifies the Revision ID that should be downloaded. Ignored unless alt=media is specified.
       */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** Specifies the Revision ID that should be downloaded. Ignored unless alt=media is specified.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /**
       * Specifies the Revision ID that should be downloaded. Ignored unless alt=media is specified.
       */
      public Watch setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      /** This parameter is deprecated and has no function. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** This parameter is deprecated and has no function.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** This parameter is deprecated and has no function. */
      public Watch setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      @Override
      public Watch set(String parameterName, Object value) {
        return (Watch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Parents collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Parents.List request = drive.parents().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Parents parents() {
    return new Parents();
  }

  /**
   * The "parents" collection of methods.
   */
  public class Parents {

    /**
     * Removes a parent from a file.
     *
     * Create a request for the method "parents.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param parentId The ID of the parent.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String parentId) throws java.io.IOException {
      Delete result = new Delete(fileId, parentId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/parents/{parentId}";

      /**
       * Removes a parent from a file.
       *
       * Create a request for the method "parents.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param parentId The ID of the parent.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String parentId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.parentId = com.google.api.client.util.Preconditions.checkNotNull(parentId, "Required parameter parentId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the parent. */
      @com.google.api.client.util.Key
      private java.lang.String parentId;

      /** The ID of the parent.
       */
      public java.lang.String getParentId() {
        return parentId;
      }

      /** The ID of the parent. */
      public Delete setParentId(java.lang.String parentId) {
        this.parentId = parentId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a specific parent reference.
     *
     * Create a request for the method "parents.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param parentId The ID of the parent.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String parentId) throws java.io.IOException {
      Get result = new Get(fileId, parentId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.ParentReference> {

      private static final String REST_PATH = "files/{fileId}/parents/{parentId}";

      /**
       * Gets a specific parent reference.
       *
       * Create a request for the method "parents.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param parentId The ID of the parent.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String parentId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.ParentReference.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.parentId = com.google.api.client.util.Preconditions.checkNotNull(parentId, "Required parameter parentId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the parent. */
      @com.google.api.client.util.Key
      private java.lang.String parentId;

      /** The ID of the parent.
       */
      public java.lang.String getParentId() {
        return parentId;
      }

      /** The ID of the parent. */
      public Get setParentId(java.lang.String parentId) {
        this.parentId = parentId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Adds a parent folder for a file.
     *
     * Create a request for the method "parents.insert".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.ParentReference}
     * @return the request
     */
    public Insert insert(java.lang.String fileId, com.google.api.services.drive.model.ParentReference content) throws java.io.IOException {
      Insert result = new Insert(fileId, content);
      initialize(result);
      return result;
    }

    public class Insert extends DriveRequest<com.google.api.services.drive.model.ParentReference> {

      private static final String REST_PATH = "files/{fileId}/parents";

      /**
       * Adds a parent folder for a file.
       *
       * Create a request for the method "parents.insert".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.ParentReference}
       * @since 1.13
       */
      protected Insert(java.lang.String fileId, com.google.api.services.drive.model.ParentReference content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.ParentReference.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "ParentReference.getId()");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Insert setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists a file's parents.
     *
     * Create a request for the method "parents.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.ParentList> {

      private static final String REST_PATH = "files/{fileId}/parents";

      /**
       * Lists a file's parents.
       *
       * Create a request for the method "parents.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.ParentList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Permissions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Permissions.List request = drive.permissions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Permissions permissions() {
    return new Permissions();
  }

  /**
   * The "permissions" collection of methods.
   */
  public class Permissions {

    /**
     * Deletes a permission from a file.
     *
     * Create a request for the method "permissions.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param permissionId The ID for the permission.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String permissionId) throws java.io.IOException {
      Delete result = new Delete(fileId, permissionId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Deletes a permission from a file.
       *
       * Create a request for the method "permissions.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID for the file.
       * @param permissionId The ID for the permission.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String permissionId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = com.google.api.client.util.Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID for the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the permission. */
      @com.google.api.client.util.Key
      private java.lang.String permissionId;

      /** The ID for the permission.
       */
      public java.lang.String getPermissionId() {
        return permissionId;
      }

      /** The ID for the permission. */
      public Delete setPermissionId(java.lang.String permissionId) {
        this.permissionId = permissionId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a permission by ID.
     *
     * Create a request for the method "permissions.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param permissionId The ID for the permission.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String permissionId) throws java.io.IOException {
      Get result = new Get(fileId, permissionId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Permission> {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Gets a permission by ID.
       *
       * Create a request for the method "permissions.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID for the file.
       * @param permissionId The ID for the permission.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String permissionId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Permission.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = com.google.api.client.util.Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID for the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the permission. */
      @com.google.api.client.util.Key
      private java.lang.String permissionId;

      /** The ID for the permission.
       */
      public java.lang.String getPermissionId() {
        return permissionId;
      }

      /** The ID for the permission. */
      public Get setPermissionId(java.lang.String permissionId) {
        this.permissionId = permissionId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns the permission ID for an email address.
     *
     * Create a request for the method "permissions.getIdForEmail".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link GetIdForEmail#execute()} method to invoke the remote operation.
     *
     * @param email The email address for which to return a permission ID
     * @return the request
     */
    public GetIdForEmail getIdForEmail(java.lang.String email) throws java.io.IOException {
      GetIdForEmail result = new GetIdForEmail(email);
      initialize(result);
      return result;
    }

    public class GetIdForEmail extends DriveRequest<com.google.api.services.drive.model.PermissionId> {

      private static final String REST_PATH = "permissionIds/{email}";

      /**
       * Returns the permission ID for an email address.
       *
       * Create a request for the method "permissions.getIdForEmail".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link GetIdForEmail#execute()} method to invoke the remote operation. <p>
       * {@link GetIdForEmail#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param email The email address for which to return a permission ID
       * @since 1.13
       */
      protected GetIdForEmail(java.lang.String email) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.PermissionId.class);
        this.email = com.google.api.client.util.Preconditions.checkNotNull(email, "Required parameter email must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetIdForEmail setAlt(java.lang.String alt) {
        return (GetIdForEmail) super.setAlt(alt);
      }

      @Override
      public GetIdForEmail setFields(java.lang.String fields) {
        return (GetIdForEmail) super.setFields(fields);
      }

      @Override
      public GetIdForEmail setKey(java.lang.String key) {
        return (GetIdForEmail) super.setKey(key);
      }

      @Override
      public GetIdForEmail setOauthToken(java.lang.String oauthToken) {
        return (GetIdForEmail) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIdForEmail setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIdForEmail) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIdForEmail setQuotaUser(java.lang.String quotaUser) {
        return (GetIdForEmail) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIdForEmail setUserIp(java.lang.String userIp) {
        return (GetIdForEmail) super.setUserIp(userIp);
      }

      /** The email address for which to return a permission ID */
      @com.google.api.client.util.Key
      private java.lang.String email;

      /** The email address for which to return a permission ID
       */
      public java.lang.String getEmail() {
        return email;
      }

      /** The email address for which to return a permission ID */
      public GetIdForEmail setEmail(java.lang.String email) {
        this.email = email;
        return this;
      }

      @Override
      public GetIdForEmail set(String parameterName, Object value) {
        return (GetIdForEmail) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a permission for a file.
     *
     * Create a request for the method "permissions.insert".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param content the {@link com.google.api.services.drive.model.Permission}
     * @return the request
     */
    public Insert insert(java.lang.String fileId, com.google.api.services.drive.model.Permission content) throws java.io.IOException {
      Insert result = new Insert(fileId, content);
      initialize(result);
      return result;
    }

    public class Insert extends DriveRequest<com.google.api.services.drive.model.Permission> {

      private static final String REST_PATH = "files/{fileId}/permissions";

      /**
       * Inserts a permission for a file.
       *
       * Create a request for the method "permissions.insert".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID for the file.
       * @param content the {@link com.google.api.services.drive.model.Permission}
       * @since 1.13
       */
      protected Insert(java.lang.String fileId, com.google.api.services.drive.model.Permission content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Permission.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getRole(), "Permission.getRole()");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getType(), "Permission.getType()");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID for the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Insert setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** A custom message to include in notification emails. */
      @com.google.api.client.util.Key
      private java.lang.String emailMessage;

      /** A custom message to include in notification emails.
       */
      public java.lang.String getEmailMessage() {
        return emailMessage;
      }

      /** A custom message to include in notification emails. */
      public Insert setEmailMessage(java.lang.String emailMessage) {
        this.emailMessage = emailMessage;
        return this;
      }

      /**
       * Whether to send notification emails when sharing to users or groups. This parameter is
       * ignored and an email is sent if the role is owner.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotificationEmails;

      /** Whether to send notification emails when sharing to users or groups. This parameter is ignored and
     an email is sent if the role is owner. [default: true]
       */
      public java.lang.Boolean getSendNotificationEmails() {
        return sendNotificationEmails;
      }

      /**
       * Whether to send notification emails when sharing to users or groups. This parameter is
       * ignored and an email is sent if the role is owner.
       */
      public Insert setSendNotificationEmails(java.lang.Boolean sendNotificationEmails) {
        this.sendNotificationEmails = sendNotificationEmails;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to send notification emails when sharing to users or groups. This parameter is ignored and
     an email is sent if the role is owner.
       * </p>
       */
      public boolean isSendNotificationEmails() {
        if (sendNotificationEmails == null || sendNotificationEmails == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return sendNotificationEmails;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists a file's permissions.
     *
     * Create a request for the method "permissions.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.PermissionList> {

      private static final String REST_PATH = "files/{fileId}/permissions";

      /**
       * Lists a file's permissions.
       *
       * Create a request for the method "permissions.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID for the file.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.PermissionList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID for the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a permission. This method supports patch semantics.
     *
     * Create a request for the method "permissions.patch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param permissionId The ID for the permission.
     * @param content the {@link com.google.api.services.drive.model.Permission}
     * @return the request
     */
    public Patch patch(java.lang.String fileId, java.lang.String permissionId, com.google.api.services.drive.model.Permission content) throws java.io.IOException {
      Patch result = new Patch(fileId, permissionId, content);
      initialize(result);
      return result;
    }

    public class Patch extends DriveRequest<com.google.api.services.drive.model.Permission> {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Updates a permission. This method supports patch semantics.
       *
       * Create a request for the method "permissions.patch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID for the file.
       * @param permissionId The ID for the permission.
       * @param content the {@link com.google.api.services.drive.model.Permission}
       * @since 1.13
       */
      protected Patch(java.lang.String fileId, java.lang.String permissionId, com.google.api.services.drive.model.Permission content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Permission.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = com.google.api.client.util.Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID for the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Patch setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the permission. */
      @com.google.api.client.util.Key
      private java.lang.String permissionId;

      /** The ID for the permission.
       */
      public java.lang.String getPermissionId() {
        return permissionId;
      }

      /** The ID for the permission. */
      public Patch setPermissionId(java.lang.String permissionId) {
        this.permissionId = permissionId;
        return this;
      }

      /**
       * Whether changing a role to 'owner' downgrades the current owners to writers. Does nothing
       * if the specified role is not 'owner'.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean transferOwnership;

      /** Whether changing a role to 'owner' downgrades the current owners to writers. Does nothing if the
     specified role is not 'owner'. [default: false]
       */
      public java.lang.Boolean getTransferOwnership() {
        return transferOwnership;
      }

      /**
       * Whether changing a role to 'owner' downgrades the current owners to writers. Does nothing
       * if the specified role is not 'owner'.
       */
      public Patch setTransferOwnership(java.lang.Boolean transferOwnership) {
        this.transferOwnership = transferOwnership;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether changing a role to 'owner' downgrades the current owners to writers. Does nothing if the
     specified role is not 'owner'.
       * </p>
       */
      public boolean isTransferOwnership() {
        if (transferOwnership == null || transferOwnership == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return transferOwnership;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a permission.
     *
     * Create a request for the method "permissions.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param permissionId The ID for the permission.
     * @param content the {@link com.google.api.services.drive.model.Permission}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String permissionId, com.google.api.services.drive.model.Permission content) throws java.io.IOException {
      Update result = new Update(fileId, permissionId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Permission> {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Updates a permission.
       *
       * Create a request for the method "permissions.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID for the file.
       * @param permissionId The ID for the permission.
       * @param content the {@link com.google.api.services.drive.model.Permission}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String permissionId, com.google.api.services.drive.model.Permission content) {
        super(Drive.this, "PUT", REST_PATH, content, com.google.api.services.drive.model.Permission.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = com.google.api.client.util.Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID for the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the permission. */
      @com.google.api.client.util.Key
      private java.lang.String permissionId;

      /** The ID for the permission.
       */
      public java.lang.String getPermissionId() {
        return permissionId;
      }

      /** The ID for the permission. */
      public Update setPermissionId(java.lang.String permissionId) {
        this.permissionId = permissionId;
        return this;
      }

      /**
       * Whether changing a role to 'owner' downgrades the current owners to writers. Does nothing
       * if the specified role is not 'owner'.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean transferOwnership;

      /** Whether changing a role to 'owner' downgrades the current owners to writers. Does nothing if the
     specified role is not 'owner'. [default: false]
       */
      public java.lang.Boolean getTransferOwnership() {
        return transferOwnership;
      }

      /**
       * Whether changing a role to 'owner' downgrades the current owners to writers. Does nothing
       * if the specified role is not 'owner'.
       */
      public Update setTransferOwnership(java.lang.Boolean transferOwnership) {
        this.transferOwnership = transferOwnership;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether changing a role to 'owner' downgrades the current owners to writers. Does nothing if the
     specified role is not 'owner'.
       * </p>
       */
      public boolean isTransferOwnership() {
        if (transferOwnership == null || transferOwnership == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return transferOwnership;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Properties collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Properties.List request = drive.properties().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Properties properties() {
    return new Properties();
  }

  /**
   * The "properties" collection of methods.
   */
  public class Properties {

    /**
     * Deletes a property.
     *
     * Create a request for the method "properties.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param propertyKey The key of the property.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String propertyKey) throws java.io.IOException {
      Delete result = new Delete(fileId, propertyKey);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";

      /**
       * Deletes a property.
       *
       * Create a request for the method "properties.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param propertyKey The key of the property.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String propertyKey) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.propertyKey = com.google.api.client.util.Preconditions.checkNotNull(propertyKey, "Required parameter propertyKey must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The key of the property. */
      @com.google.api.client.util.Key
      private java.lang.String propertyKey;

      /** The key of the property.
       */
      public java.lang.String getPropertyKey() {
        return propertyKey;
      }

      /** The key of the property. */
      public Delete setPropertyKey(java.lang.String propertyKey) {
        this.propertyKey = propertyKey;
        return this;
      }

      /** The visibility of the property. */
      @com.google.api.client.util.Key
      private java.lang.String visibility;

      /** The visibility of the property. [default: private]
       */
      public java.lang.String getVisibility() {
        return visibility;
      }

      /** The visibility of the property. */
      public Delete setVisibility(java.lang.String visibility) {
        this.visibility = visibility;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a property by its key.
     *
     * Create a request for the method "properties.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param propertyKey The key of the property.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String propertyKey) throws java.io.IOException {
      Get result = new Get(fileId, propertyKey);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Property> {

      private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";

      /**
       * Gets a property by its key.
       *
       * Create a request for the method "properties.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param propertyKey The key of the property.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String propertyKey) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Property.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.propertyKey = com.google.api.client.util.Preconditions.checkNotNull(propertyKey, "Required parameter propertyKey must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The key of the property. */
      @com.google.api.client.util.Key
      private java.lang.String propertyKey;

      /** The key of the property.
       */
      public java.lang.String getPropertyKey() {
        return propertyKey;
      }

      /** The key of the property. */
      public Get setPropertyKey(java.lang.String propertyKey) {
        this.propertyKey = propertyKey;
        return this;
      }

      /** The visibility of the property. */
      @com.google.api.client.util.Key
      private java.lang.String visibility;

      /** The visibility of the property. [default: private]
       */
      public java.lang.String getVisibility() {
        return visibility;
      }

      /** The visibility of the property. */
      public Get setVisibility(java.lang.String visibility) {
        this.visibility = visibility;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Adds a property to a file.
     *
     * Create a request for the method "properties.insert".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.Property}
     * @return the request
     */
    public Insert insert(java.lang.String fileId, com.google.api.services.drive.model.Property content) throws java.io.IOException {
      Insert result = new Insert(fileId, content);
      initialize(result);
      return result;
    }

    public class Insert extends DriveRequest<com.google.api.services.drive.model.Property> {

      private static final String REST_PATH = "files/{fileId}/properties";

      /**
       * Adds a property to a file.
       *
       * Create a request for the method "properties.insert".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.Property}
       * @since 1.13
       */
      protected Insert(java.lang.String fileId, com.google.api.services.drive.model.Property content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Property.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Insert setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists a file's properties.
     *
     * Create a request for the method "properties.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.PropertyList> {

      private static final String REST_PATH = "files/{fileId}/properties";

      /**
       * Lists a file's properties.
       *
       * Create a request for the method "properties.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.PropertyList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a property. This method supports patch semantics.
     *
     * Create a request for the method "properties.patch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param propertyKey The key of the property.
     * @param content the {@link com.google.api.services.drive.model.Property}
     * @return the request
     */
    public Patch patch(java.lang.String fileId, java.lang.String propertyKey, com.google.api.services.drive.model.Property content) throws java.io.IOException {
      Patch result = new Patch(fileId, propertyKey, content);
      initialize(result);
      return result;
    }

    public class Patch extends DriveRequest<com.google.api.services.drive.model.Property> {

      private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";

      /**
       * Updates a property. This method supports patch semantics.
       *
       * Create a request for the method "properties.patch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param propertyKey The key of the property.
       * @param content the {@link com.google.api.services.drive.model.Property}
       * @since 1.13
       */
      protected Patch(java.lang.String fileId, java.lang.String propertyKey, com.google.api.services.drive.model.Property content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Property.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.propertyKey = com.google.api.client.util.Preconditions.checkNotNull(propertyKey, "Required parameter propertyKey must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Patch setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The key of the property. */
      @com.google.api.client.util.Key
      private java.lang.String propertyKey;

      /** The key of the property.
       */
      public java.lang.String getPropertyKey() {
        return propertyKey;
      }

      /** The key of the property. */
      public Patch setPropertyKey(java.lang.String propertyKey) {
        this.propertyKey = propertyKey;
        return this;
      }

      /** The visibility of the property. */
      @com.google.api.client.util.Key
      private java.lang.String visibility;

      /** The visibility of the property. [default: private]
       */
      public java.lang.String getVisibility() {
        return visibility;
      }

      /** The visibility of the property. */
      public Patch setVisibility(java.lang.String visibility) {
        this.visibility = visibility;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a property.
     *
     * Create a request for the method "properties.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param propertyKey The key of the property.
     * @param content the {@link com.google.api.services.drive.model.Property}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String propertyKey, com.google.api.services.drive.model.Property content) throws java.io.IOException {
      Update result = new Update(fileId, propertyKey, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Property> {

      private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";

      /**
       * Updates a property.
       *
       * Create a request for the method "properties.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param propertyKey The key of the property.
       * @param content the {@link com.google.api.services.drive.model.Property}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String propertyKey, com.google.api.services.drive.model.Property content) {
        super(Drive.this, "PUT", REST_PATH, content, com.google.api.services.drive.model.Property.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.propertyKey = com.google.api.client.util.Preconditions.checkNotNull(propertyKey, "Required parameter propertyKey must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The key of the property. */
      @com.google.api.client.util.Key
      private java.lang.String propertyKey;

      /** The key of the property.
       */
      public java.lang.String getPropertyKey() {
        return propertyKey;
      }

      /** The key of the property. */
      public Update setPropertyKey(java.lang.String propertyKey) {
        this.propertyKey = propertyKey;
        return this;
      }

      /** The visibility of the property. */
      @com.google.api.client.util.Key
      private java.lang.String visibility;

      /** The visibility of the property. [default: private]
       */
      public java.lang.String getVisibility() {
        return visibility;
      }

      /** The visibility of the property. */
      public Update setVisibility(java.lang.String visibility) {
        this.visibility = visibility;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Realtime collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Realtime.List request = drive.realtime().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Realtime realtime() {
    return new Realtime();
  }

  /**
   * The "realtime" collection of methods.
   */
  public class Realtime {

    /**
     * Exports the contents of the Realtime API data model associated with this file as JSON.
     *
     * Create a request for the method "realtime.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file that the Realtime API data model is associated with.
     * @return the request
     */
    public Get get(java.lang.String fileId) throws java.io.IOException {
      Get result = new Get(fileId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/realtime";

      /**
       * Exports the contents of the Realtime API data model associated with this file as JSON.
       *
       * Create a request for the method "realtime.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file that the Realtime API data model is associated with.
       * @since 1.13
       */
      protected Get(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the file that the Realtime API data model is associated with. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file that the Realtime API data model is associated with.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file that the Realtime API data model is associated with. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * The revision of the Realtime API data model to export. Revisions start at 1 (the initial
       * empty data model) and are incremented with each change. If this parameter is excluded, the
       * most recent data model will be returned.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer revision;

      /** The revision of the Realtime API data model to export. Revisions start at 1 (the initial empty data
     model) and are incremented with each change. If this parameter is excluded, the most recent data
     model will be returned.

     [minimum: 1]
       */
      public java.lang.Integer getRevision() {
        return revision;
      }

      /**
       * The revision of the Realtime API data model to export. Revisions start at 1 (the initial
       * empty data model) and are incremented with each change. If this parameter is excluded, the
       * most recent data model will be returned.
       */
      public Get setRevision(java.lang.Integer revision) {
        this.revision = revision;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Overwrites the Realtime API data model associated with this file with the provided JSON data
     * model.
     *
     * Create a request for the method "realtime.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file that the Realtime API data model is associated with.
     * @return the request
     */
    public Update update(java.lang.String fileId) throws java.io.IOException {
      Update result = new Update(fileId);
      initialize(result);
      return result;
    }

    /**
     * Overwrites the Realtime API data model associated with this file with the provided JSON data
     * model.
     *
     * Create a request for the method "realtime.update".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param fileId The ID of the file that the Realtime API data model is associated with.
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Update update(java.lang.String fileId, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Update result = new Update(fileId, mediaContent);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/realtime";

      /**
       * Overwrites the Realtime API data model associated with this file with the provided JSON data
       * model.
       *
       * Create a request for the method "realtime.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file that the Realtime API data model is associated with.
       * @since 1.13
       */
      protected Update(java.lang.String fileId) {
        super(Drive.this, "PUT", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      /**
       * Overwrites the Realtime API data model associated with this file with the provided JSON data
       * model.
       *
       * Create a request for the method "realtime.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param fileId The ID of the file that the Realtime API data model is associated with.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Update(java.lang.String fileId, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Drive.this, "PUT", "/upload/" + getServicePath() + REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID of the file that the Realtime API data model is associated with. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file that the Realtime API data model is associated with.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file that the Realtime API data model is associated with. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * The revision of the model to diff the uploaded model against. If set, the uploaded model is
       * diffed against the provided revision and those differences are merged with any changes made
       * to the model after the provided revision. If not set, the uploaded model replaces the
       * current model on the server.
       */
      @com.google.api.client.util.Key
      private java.lang.String baseRevision;

      /** The revision of the model to diff the uploaded model against. If set, the uploaded model is diffed
     against the provided revision and those differences are merged with any changes made to the model
     after the provided revision. If not set, the uploaded model replaces the current model on the
     server.
       */
      public java.lang.String getBaseRevision() {
        return baseRevision;
      }

      /**
       * The revision of the model to diff the uploaded model against. If set, the uploaded model is
       * diffed against the provided revision and those differences are merged with any changes made
       * to the model after the provided revision. If not set, the uploaded model replaces the
       * current model on the server.
       */
      public Update setBaseRevision(java.lang.String baseRevision) {
        this.baseRevision = baseRevision;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Replies collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Replies.List request = drive.replies().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Replies replies() {
    return new Replies();
  }

  /**
   * The "replies" collection of methods.
   */
  public class Replies {

    /**
     * Deletes a reply.
     *
     * Create a request for the method "replies.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param replyId The ID of the reply.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) throws java.io.IOException {
      Delete result = new Delete(fileId, commentId, replyId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";

      /**
       * Deletes a reply.
       *
       * Create a request for the method "replies.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param replyId The ID of the reply.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        this.replyId = com.google.api.client.util.Preconditions.checkNotNull(replyId, "Required parameter replyId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Delete setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /** The ID of the reply. */
      @com.google.api.client.util.Key
      private java.lang.String replyId;

      /** The ID of the reply.
       */
      public java.lang.String getReplyId() {
        return replyId;
      }

      /** The ID of the reply. */
      public Delete setReplyId(java.lang.String replyId) {
        this.replyId = replyId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a reply.
     *
     * Create a request for the method "replies.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param replyId The ID of the reply.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) throws java.io.IOException {
      Get result = new Get(fileId, commentId, replyId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.CommentReply> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";

      /**
       * Gets a reply.
       *
       * Create a request for the method "replies.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param replyId The ID of the reply.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.CommentReply.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        this.replyId = com.google.api.client.util.Preconditions.checkNotNull(replyId, "Required parameter replyId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Get setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /** The ID of the reply. */
      @com.google.api.client.util.Key
      private java.lang.String replyId;

      /** The ID of the reply.
       */
      public java.lang.String getReplyId() {
        return replyId;
      }

      /** The ID of the reply. */
      public Get setReplyId(java.lang.String replyId) {
        this.replyId = replyId;
        return this;
      }

      /** If set, this will succeed when retrieving a deleted reply. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** If set, this will succeed when retrieving a deleted reply. [default: false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /** If set, this will succeed when retrieving a deleted reply. */
      public Get setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * If set, this will succeed when retrieving a deleted reply.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new reply to the given comment.
     *
     * Create a request for the method "replies.insert".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param content the {@link com.google.api.services.drive.model.CommentReply}
     * @return the request
     */
    public Insert insert(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.CommentReply content) throws java.io.IOException {
      Insert result = new Insert(fileId, commentId, content);
      initialize(result);
      return result;
    }

    public class Insert extends DriveRequest<com.google.api.services.drive.model.CommentReply> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";

      /**
       * Creates a new reply to the given comment.
       *
       * Create a request for the method "replies.insert".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param content the {@link com.google.api.services.drive.model.CommentReply}
       * @since 1.13
       */
      protected Insert(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.CommentReply content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.CommentReply.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Insert setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Insert setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all of the replies to a comment.
     *
     * Create a request for the method "replies.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @return the request
     */
    public List list(java.lang.String fileId, java.lang.String commentId) throws java.io.IOException {
      List result = new List(fileId, commentId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.CommentReplyList> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";

      /**
       * Lists all of the replies to a comment.
       *
       * Create a request for the method "replies.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @since 1.13
       */
      protected List(java.lang.String fileId, java.lang.String commentId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.CommentReplyList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public List setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /**
       * The continuation token, used to page through large result sets. To get the next page of
       * results, set this parameter to the value of "nextPageToken" from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The continuation token, used to page through large result sets. To get the next page of results,
     set this parameter to the value of "nextPageToken" from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The continuation token, used to page through large result sets. To get the next page of
       * results, set this parameter to the value of "nextPageToken" from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * If set, all replies, including deleted replies (with content stripped) will be returned.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** If set, all replies, including deleted replies (with content stripped) will be returned. [default:
     false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /**
       * If set, all replies, including deleted replies (with content stripped) will be returned.
       */
      public List setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * If set, all replies, including deleted replies (with content stripped) will be returned.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      /** The maximum number of replies to include in the response, used for paging. */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** The maximum number of replies to include in the response, used for paging. [default: 20] [minimum:
     0] [maximum: 100]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /** The maximum number of replies to include in the response, used for paging. */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing reply. This method supports patch semantics.
     *
     * Create a request for the method "replies.patch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param replyId The ID of the reply.
     * @param content the {@link com.google.api.services.drive.model.CommentReply}
     * @return the request
     */
    public Patch patch(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId, com.google.api.services.drive.model.CommentReply content) throws java.io.IOException {
      Patch result = new Patch(fileId, commentId, replyId, content);
      initialize(result);
      return result;
    }

    public class Patch extends DriveRequest<com.google.api.services.drive.model.CommentReply> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";

      /**
       * Updates an existing reply. This method supports patch semantics.
       *
       * Create a request for the method "replies.patch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param replyId The ID of the reply.
       * @param content the {@link com.google.api.services.drive.model.CommentReply}
       * @since 1.13
       */
      protected Patch(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId, com.google.api.services.drive.model.CommentReply content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.CommentReply.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        this.replyId = com.google.api.client.util.Preconditions.checkNotNull(replyId, "Required parameter replyId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Patch setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Patch setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /** The ID of the reply. */
      @com.google.api.client.util.Key
      private java.lang.String replyId;

      /** The ID of the reply.
       */
      public java.lang.String getReplyId() {
        return replyId;
      }

      /** The ID of the reply. */
      public Patch setReplyId(java.lang.String replyId) {
        this.replyId = replyId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing reply.
     *
     * Create a request for the method "replies.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param replyId The ID of the reply.
     * @param content the {@link com.google.api.services.drive.model.CommentReply}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId, com.google.api.services.drive.model.CommentReply content) throws java.io.IOException {
      Update result = new Update(fileId, commentId, replyId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.CommentReply> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";

      /**
       * Updates an existing reply.
       *
       * Create a request for the method "replies.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param replyId The ID of the reply.
       * @param content the {@link com.google.api.services.drive.model.CommentReply}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId, com.google.api.services.drive.model.CommentReply content) {
        super(Drive.this, "PUT", REST_PATH, content, com.google.api.services.drive.model.CommentReply.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        this.replyId = com.google.api.client.util.Preconditions.checkNotNull(replyId, "Required parameter replyId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getContent(), "CommentReply.getContent()");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Update setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /** The ID of the reply. */
      @com.google.api.client.util.Key
      private java.lang.String replyId;

      /** The ID of the reply.
       */
      public java.lang.String getReplyId() {
        return replyId;
      }

      /** The ID of the reply. */
      public Update setReplyId(java.lang.String replyId) {
        this.replyId = replyId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Revisions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Revisions.List request = drive.revisions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Revisions revisions() {
    return new Revisions();
  }

  /**
   * The "revisions" collection of methods.
   */
  public class Revisions {

    /**
     * Removes a revision.
     *
     * Create a request for the method "revisions.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param revisionId The ID of the revision.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String revisionId) throws java.io.IOException {
      Delete result = new Delete(fileId, revisionId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Removes a revision.
       *
       * Create a request for the method "revisions.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param revisionId The ID of the revision.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String revisionId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = com.google.api.client.util.Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the revision. */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** The ID of the revision.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /** The ID of the revision. */
      public Delete setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a specific revision.
     *
     * Create a request for the method "revisions.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param revisionId The ID of the revision.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String revisionId) throws java.io.IOException {
      Get result = new Get(fileId, revisionId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Revision> {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Gets a specific revision.
       *
       * Create a request for the method "revisions.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param revisionId The ID of the revision.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String revisionId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Revision.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = com.google.api.client.util.Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the revision. */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** The ID of the revision.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /** The ID of the revision. */
      public Get setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists a file's revisions.
     *
     * Create a request for the method "revisions.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.RevisionList> {

      private static final String REST_PATH = "files/{fileId}/revisions";

      /**
       * Lists a file's revisions.
       *
       * Create a request for the method "revisions.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.RevisionList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a revision. This method supports patch semantics.
     *
     * Create a request for the method "revisions.patch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param revisionId The ID for the revision.
     * @param content the {@link com.google.api.services.drive.model.Revision}
     * @return the request
     */
    public Patch patch(java.lang.String fileId, java.lang.String revisionId, com.google.api.services.drive.model.Revision content) throws java.io.IOException {
      Patch result = new Patch(fileId, revisionId, content);
      initialize(result);
      return result;
    }

    public class Patch extends DriveRequest<com.google.api.services.drive.model.Revision> {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Updates a revision. This method supports patch semantics.
       *
       * Create a request for the method "revisions.patch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID for the file.
       * @param revisionId The ID for the revision.
       * @param content the {@link com.google.api.services.drive.model.Revision}
       * @since 1.13
       */
      protected Patch(java.lang.String fileId, java.lang.String revisionId, com.google.api.services.drive.model.Revision content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Revision.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = com.google.api.client.util.Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID for the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Patch setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the revision. */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** The ID for the revision.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /** The ID for the revision. */
      public Patch setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a revision.
     *
     * Create a request for the method "revisions.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param revisionId The ID for the revision.
     * @param content the {@link com.google.api.services.drive.model.Revision}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String revisionId, com.google.api.services.drive.model.Revision content) throws java.io.IOException {
      Update result = new Update(fileId, revisionId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Revision> {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Updates a revision.
       *
       * Create a request for the method "revisions.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID for the file.
       * @param revisionId The ID for the revision.
       * @param content the {@link com.google.api.services.drive.model.Revision}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String revisionId, com.google.api.services.drive.model.Revision content) {
        super(Drive.this, "PUT", REST_PATH, content, com.google.api.services.drive.model.Revision.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = com.google.api.client.util.Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID for the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the revision. */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** The ID for the revision.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /** The ID for the revision. */
      public Update setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Drive}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Drive}. */
    @Override
    public Drive build() {
      return new Drive(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link DriveRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setDriveRequestInitializer(
        DriveRequestInitializer driveRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(driveRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
