/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.drive;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UriTemplate;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.drive.DriveRequest;
import com.google.api.services.drive.DriveRequestInitializer;
import com.google.api.services.drive.model.App;
import com.google.api.services.drive.model.AppList;
import com.google.api.services.drive.model.Change;
import com.google.api.services.drive.model.ChangeList;
import com.google.api.services.drive.model.Channel;
import com.google.api.services.drive.model.ChildList;
import com.google.api.services.drive.model.ChildReference;
import com.google.api.services.drive.model.Comment;
import com.google.api.services.drive.model.CommentList;
import com.google.api.services.drive.model.CommentReply;
import com.google.api.services.drive.model.CommentReplyList;
import com.google.api.services.drive.model.DriveList;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.drive.model.GeneratedIds;
import com.google.api.services.drive.model.ParentList;
import com.google.api.services.drive.model.ParentReference;
import com.google.api.services.drive.model.Permission;
import com.google.api.services.drive.model.PermissionId;
import com.google.api.services.drive.model.PermissionList;
import com.google.api.services.drive.model.Property;
import com.google.api.services.drive.model.PropertyList;
import com.google.api.services.drive.model.Revision;
import com.google.api.services.drive.model.RevisionList;
import com.google.api.services.drive.model.StartPageToken;
import com.google.api.services.drive.model.TeamDrive;
import com.google.api.services.drive.model.TeamDriveList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Drive
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://www.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "drive/v2/";
    public static final String DEFAULT_BATCH_PATH = "batch/drive/v2";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/drive/v2/";

    public Drive(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Drive(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public About about() {
        return new About();
    }

    public Apps apps() {
        return new Apps();
    }

    public Changes changes() {
        return new Changes();
    }

    public Channels channels() {
        return new Channels();
    }

    public Children children() {
        return new Children();
    }

    public Comments comments() {
        return new Comments();
    }

    public Drives drives() {
        return new Drives();
    }

    public Files files() {
        return new Files();
    }

    public Parents parents() {
        return new Parents();
    }

    public Permissions permissions() {
        return new Permissions();
    }

    public Properties properties() {
        return new Properties();
    }

    public Replies replies() {
        return new Replies();
    }

    public Revisions revisions() {
        return new Revisions();
    }

    public Teamdrives teamdrives() {
        return new Teamdrives();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Drive API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Drive.DEFAULT_MTLS_ROOT_URL;
            }
            return Drive.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Drive.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Drive.DEFAULT_BATCH_PATH);
        }

        public Drive build() {
            return new Drive(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDriveRequestInitializer(DriveRequestInitializer driveRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)driveRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Teamdrives {
        public Delete delete(String teamDriveId) throws IOException {
            Delete result = new Delete(teamDriveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String teamDriveId) throws IOException {
            Get result = new Get(teamDriveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String requestId, TeamDrive content) throws IOException {
            Insert result = new Insert(requestId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String teamDriveId, TeamDrive content) throws IOException {
            Update result = new Update(teamDriveId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<TeamDrive> {
            private static final String REST_PATH = "teamdrives/{teamDriveId}";
            @Key
            private String teamDriveId;
            @Key
            private Boolean useDomainAdminAccess;

            protected Update(String teamDriveId, TeamDrive content) {
                super(Drive.this, "PUT", REST_PATH, (Object)content, TeamDrive.class);
                this.teamDriveId = (String)Preconditions.checkNotNull((Object)teamDriveId, (Object)"Required parameter teamDriveId must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Update setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Update setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<TeamDriveList> {
            private static final String REST_PATH = "teamdrives";
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String q;
            @Key
            private Boolean useDomainAdminAccess;

            protected List() {
                super(Drive.this, "GET", REST_PATH, null, TeamDriveList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public List setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DriveRequest<TeamDrive> {
            private static final String REST_PATH = "teamdrives";
            @Key
            private String requestId;

            protected Insert(String requestId, TeamDrive content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, TeamDrive.class);
                this.requestId = (String)Preconditions.checkNotNull((Object)requestId, (Object)"Required parameter requestId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getName(), "TeamDrive.getName()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<TeamDrive> {
            private static final String REST_PATH = "teamdrives/{teamDriveId}";
            @Key
            private String teamDriveId;
            @Key
            private Boolean useDomainAdminAccess;

            protected Get(String teamDriveId) {
                super(Drive.this, "GET", REST_PATH, null, TeamDrive.class);
                this.teamDriveId = (String)Preconditions.checkNotNull((Object)teamDriveId, (Object)"Required parameter teamDriveId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Get setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Get setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "teamdrives/{teamDriveId}";
            @Key
            private String teamDriveId;

            protected Delete(String teamDriveId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.teamDriveId = (String)Preconditions.checkNotNull((Object)teamDriveId, (Object)"Required parameter teamDriveId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Delete setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Revisions {
        public Delete delete(String fileId, String revisionId) throws IOException {
            Delete result = new Delete(fileId, revisionId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId, String revisionId) throws IOException {
            Get result = new Get(fileId, revisionId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String fileId) throws IOException {
            List result = new List(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String fileId, String revisionId, Revision content) throws IOException {
            Patch result = new Patch(fileId, revisionId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, String revisionId, Revision content) throws IOException {
            Update result = new Update(fileId, revisionId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<Revision> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Update(String fileId, String revisionId, Revision content) {
                super(Drive.this, "PUT", REST_PATH, (Object)content, Revision.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.revisionId = (String)Preconditions.checkNotNull((Object)revisionId, (Object)"Required parameter revisionId must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Update setRevisionId(String revisionId) {
                this.revisionId = revisionId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DriveRequest<Revision> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Patch(String fileId, String revisionId, Revision content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, Revision.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.revisionId = (String)Preconditions.checkNotNull((Object)revisionId, (Object)"Required parameter revisionId must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Patch setRevisionId(String revisionId) {
                this.revisionId = revisionId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<RevisionList> {
            private static final String REST_PATH = "files/{fileId}/revisions";
            @Key
            private String fileId;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String fileId) {
                super(Drive.this, "GET", REST_PATH, null, RevisionList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<Revision> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Get(String fileId, String revisionId) {
                super(Drive.this, "GET", REST_PATH, null, Revision.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.revisionId = (String)Preconditions.checkNotNull((Object)revisionId, (Object)"Required parameter revisionId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Get setRevisionId(String revisionId) {
                this.revisionId = revisionId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Delete(String fileId, String revisionId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.revisionId = (String)Preconditions.checkNotNull((Object)revisionId, (Object)"Required parameter revisionId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Delete setRevisionId(String revisionId) {
                this.revisionId = revisionId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Replies {
        public Delete delete(String fileId, String commentId, String replyId) throws IOException {
            Delete result = new Delete(fileId, commentId, replyId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId, String commentId, String replyId) throws IOException {
            Get result = new Get(fileId, commentId, replyId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String fileId, String commentId, CommentReply content) throws IOException {
            Insert result = new Insert(fileId, commentId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String fileId, String commentId) throws IOException {
            List result = new List(fileId, commentId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String fileId, String commentId, String replyId, CommentReply content) throws IOException {
            Patch result = new Patch(fileId, commentId, replyId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, String commentId, String replyId, CommentReply content) throws IOException {
            Update result = new Update(fileId, commentId, replyId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<CommentReply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;

            protected Update(String fileId, String commentId, String replyId, CommentReply content) {
                super(Drive.this, "PUT", REST_PATH, (Object)content, CommentReply.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
                this.replyId = (String)Preconditions.checkNotNull((Object)replyId, (Object)"Required parameter replyId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getContent(), "CommentReply.getContent()");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Update setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Update setReplyId(String replyId) {
                this.replyId = replyId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DriveRequest<CommentReply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;

            protected Patch(String fileId, String commentId, String replyId, CommentReply content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, CommentReply.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
                this.replyId = (String)Preconditions.checkNotNull((Object)replyId, (Object)"Required parameter replyId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getContent(), "CommentReply.getContent()");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Patch setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Patch setReplyId(String replyId) {
                this.replyId = replyId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<CommentReplyList> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private Boolean includeDeleted;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String fileId, String commentId) {
                super(Drive.this, "GET", REST_PATH, null, CommentReplyList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public List setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public List setIncludeDeleted(Boolean includeDeleted) {
                this.includeDeleted = includeDeleted;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DriveRequest<CommentReply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Insert(String fileId, String commentId, CommentReply content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, CommentReply.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Insert setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Insert setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<CommentReply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;
            @Key
            private Boolean includeDeleted;

            protected Get(String fileId, String commentId, String replyId) {
                super(Drive.this, "GET", REST_PATH, null, CommentReply.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
                this.replyId = (String)Preconditions.checkNotNull((Object)replyId, (Object)"Required parameter replyId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Get setReplyId(String replyId) {
                this.replyId = replyId;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public Get setIncludeDeleted(Boolean includeDeleted) {
                this.includeDeleted = includeDeleted;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;

            protected Delete(String fileId, String commentId, String replyId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
                this.replyId = (String)Preconditions.checkNotNull((Object)replyId, (Object)"Required parameter replyId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Delete setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Delete setReplyId(String replyId) {
                this.replyId = replyId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Properties {
        public Delete delete(String fileId, String propertyKey) throws IOException {
            Delete result = new Delete(fileId, propertyKey);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId, String propertyKey) throws IOException {
            Get result = new Get(fileId, propertyKey);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String fileId, Property content) throws IOException {
            Insert result = new Insert(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String fileId) throws IOException {
            List result = new List(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String fileId, String propertyKey, Property content) throws IOException {
            Patch result = new Patch(fileId, propertyKey, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, String propertyKey, Property content) throws IOException {
            Update result = new Update(fileId, propertyKey, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<Property> {
            private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";
            @Key
            private String fileId;
            @Key
            private String propertyKey;
            @Key
            private String visibility;

            protected Update(String fileId, String propertyKey, Property content) {
                super(Drive.this, "PUT", REST_PATH, (Object)content, Property.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.propertyKey = (String)Preconditions.checkNotNull((Object)propertyKey, (Object)"Required parameter propertyKey must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getPropertyKey() {
                return this.propertyKey;
            }

            public Update setPropertyKey(String propertyKey) {
                this.propertyKey = propertyKey;
                return this;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Update setVisibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DriveRequest<Property> {
            private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";
            @Key
            private String fileId;
            @Key
            private String propertyKey;
            @Key
            private String visibility;

            protected Patch(String fileId, String propertyKey, Property content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, Property.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.propertyKey = (String)Preconditions.checkNotNull((Object)propertyKey, (Object)"Required parameter propertyKey must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getPropertyKey() {
                return this.propertyKey;
            }

            public Patch setPropertyKey(String propertyKey) {
                this.propertyKey = propertyKey;
                return this;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Patch setVisibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<PropertyList> {
            private static final String REST_PATH = "files/{fileId}/properties";
            @Key
            private String fileId;

            protected List(String fileId) {
                super(Drive.this, "GET", REST_PATH, null, PropertyList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DriveRequest<Property> {
            private static final String REST_PATH = "files/{fileId}/properties";
            @Key
            private String fileId;

            protected Insert(String fileId, Property content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Property.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getKey(), "Property.getKey()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Insert setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<Property> {
            private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";
            @Key
            private String fileId;
            @Key
            private String propertyKey;
            @Key
            private String visibility;

            protected Get(String fileId, String propertyKey) {
                super(Drive.this, "GET", REST_PATH, null, Property.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.propertyKey = (String)Preconditions.checkNotNull((Object)propertyKey, (Object)"Required parameter propertyKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getPropertyKey() {
                return this.propertyKey;
            }

            public Get setPropertyKey(String propertyKey) {
                this.propertyKey = propertyKey;
                return this;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Get setVisibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";
            @Key
            private String fileId;
            @Key
            private String propertyKey;
            @Key
            private String visibility;

            protected Delete(String fileId, String propertyKey) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.propertyKey = (String)Preconditions.checkNotNull((Object)propertyKey, (Object)"Required parameter propertyKey must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getPropertyKey() {
                return this.propertyKey;
            }

            public Delete setPropertyKey(String propertyKey) {
                this.propertyKey = propertyKey;
                return this;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Delete setVisibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Permissions {
        public Delete delete(String fileId, String permissionId) throws IOException {
            Delete result = new Delete(fileId, permissionId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId, String permissionId) throws IOException {
            Get result = new Get(fileId, permissionId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIdForEmail getIdForEmail(String email) throws IOException {
            GetIdForEmail result = new GetIdForEmail(email);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String fileId, Permission content) throws IOException {
            Insert result = new Insert(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String fileId) throws IOException {
            List result = new List(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String fileId, String permissionId, Permission content) throws IOException {
            Patch result = new Patch(fileId, permissionId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, String permissionId, Permission content) throws IOException {
            Update result = new Update(fileId, permissionId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean removeExpiration;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean transferOwnership;
            @Key
            private Boolean useDomainAdminAccess;

            protected Update(String fileId, String permissionId, Permission content) {
                super(Drive.this, "PUT", REST_PATH, (Object)content, Permission.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.permissionId = (String)Preconditions.checkNotNull((Object)permissionId, (Object)"Required parameter permissionId must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Update setPermissionId(String permissionId) {
                this.permissionId = permissionId;
                return this;
            }

            public Boolean getRemoveExpiration() {
                return this.removeExpiration;
            }

            public Update setRemoveExpiration(Boolean removeExpiration) {
                this.removeExpiration = removeExpiration;
                return this;
            }

            public boolean isRemoveExpiration() {
                if (this.removeExpiration == null || this.removeExpiration == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.removeExpiration;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Update setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Update setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getTransferOwnership() {
                return this.transferOwnership;
            }

            public Update setTransferOwnership(Boolean transferOwnership) {
                this.transferOwnership = transferOwnership;
                return this;
            }

            public boolean isTransferOwnership() {
                if (this.transferOwnership == null || this.transferOwnership == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.transferOwnership;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Update setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean removeExpiration;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean transferOwnership;
            @Key
            private Boolean useDomainAdminAccess;

            protected Patch(String fileId, String permissionId, Permission content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, Permission.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.permissionId = (String)Preconditions.checkNotNull((Object)permissionId, (Object)"Required parameter permissionId must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Patch setPermissionId(String permissionId) {
                this.permissionId = permissionId;
                return this;
            }

            public Boolean getRemoveExpiration() {
                return this.removeExpiration;
            }

            public Patch setRemoveExpiration(Boolean removeExpiration) {
                this.removeExpiration = removeExpiration;
                return this;
            }

            public boolean isRemoveExpiration() {
                if (this.removeExpiration == null || this.removeExpiration == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.removeExpiration;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Patch setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Patch setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getTransferOwnership() {
                return this.transferOwnership;
            }

            public Patch setTransferOwnership(Boolean transferOwnership) {
                this.transferOwnership = transferOwnership;
                return this;
            }

            public boolean isTransferOwnership() {
                if (this.transferOwnership == null || this.transferOwnership == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.transferOwnership;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Patch setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<PermissionList> {
            private static final String REST_PATH = "files/{fileId}/permissions";
            @Key
            private String fileId;
            @Key
            private String includePermissionsForView;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean useDomainAdminAccess;

            protected List(String fileId) {
                super(Drive.this, "GET", REST_PATH, null, PermissionList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public List setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public List setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public List setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public List setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions";
            @Key
            private String fileId;
            @Key
            private String emailMessage;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private Boolean moveToNewOwnersRoot;
            @Key
            private Boolean sendNotificationEmails;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean useDomainAdminAccess;

            protected Insert(String fileId, Permission content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Permission.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getRole(), "Permission.getRole()");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getType(), "Permission.getType()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Insert setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getEmailMessage() {
                return this.emailMessage;
            }

            public Insert setEmailMessage(String emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Insert setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public Boolean getMoveToNewOwnersRoot() {
                return this.moveToNewOwnersRoot;
            }

            public Insert setMoveToNewOwnersRoot(Boolean moveToNewOwnersRoot) {
                this.moveToNewOwnersRoot = moveToNewOwnersRoot;
                return this;
            }

            public boolean isMoveToNewOwnersRoot() {
                if (this.moveToNewOwnersRoot == null || this.moveToNewOwnersRoot == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.moveToNewOwnersRoot;
            }

            public Boolean getSendNotificationEmails() {
                return this.sendNotificationEmails;
            }

            public Insert setSendNotificationEmails(Boolean sendNotificationEmails) {
                this.sendNotificationEmails = sendNotificationEmails;
                return this;
            }

            public boolean isSendNotificationEmails() {
                if (this.sendNotificationEmails == null || this.sendNotificationEmails == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.sendNotificationEmails;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Insert setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Insert setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Insert setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetIdForEmail
        extends DriveRequest<PermissionId> {
            private static final String REST_PATH = "permissionIds/{email}";
            @Key
            private String email;

            protected GetIdForEmail(String email) {
                super(Drive.this, "GET", REST_PATH, null, PermissionId.class);
                this.email = (String)Preconditions.checkNotNull((Object)email, (Object)"Required parameter email must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIdForEmail setAlt(String alt) {
                return (GetIdForEmail)super.setAlt(alt);
            }

            public GetIdForEmail setFields(String fields) {
                return (GetIdForEmail)super.setFields(fields);
            }

            public GetIdForEmail setKey(String key) {
                return (GetIdForEmail)super.setKey(key);
            }

            public GetIdForEmail setOauthToken(String oauthToken) {
                return (GetIdForEmail)super.setOauthToken(oauthToken);
            }

            public GetIdForEmail setPrettyPrint(Boolean prettyPrint) {
                return (GetIdForEmail)super.setPrettyPrint(prettyPrint);
            }

            public GetIdForEmail setQuotaUser(String quotaUser) {
                return (GetIdForEmail)super.setQuotaUser(quotaUser);
            }

            public GetIdForEmail setUserIp(String userIp) {
                return (GetIdForEmail)super.setUserIp(userIp);
            }

            public String getEmail() {
                return this.email;
            }

            public GetIdForEmail setEmail(String email) {
                this.email = email;
                return this;
            }

            @Override
            public GetIdForEmail set(String parameterName, Object value) {
                return (GetIdForEmail)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean useDomainAdminAccess;

            protected Get(String fileId, String permissionId) {
                super(Drive.this, "GET", REST_PATH, null, Permission.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.permissionId = (String)Preconditions.checkNotNull((Object)permissionId, (Object)"Required parameter permissionId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Get setPermissionId(String permissionId) {
                this.permissionId = permissionId;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Get setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Get setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Get setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean useDomainAdminAccess;

            protected Delete(String fileId, String permissionId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.permissionId = (String)Preconditions.checkNotNull((Object)permissionId, (Object)"Required parameter permissionId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Delete setPermissionId(String permissionId) {
                this.permissionId = permissionId;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Delete setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Delete setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Delete setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Parents {
        public Delete delete(String fileId, String parentId) throws IOException {
            Delete result = new Delete(fileId, parentId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId, String parentId) throws IOException {
            Get result = new Get(fileId, parentId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String fileId, ParentReference content) throws IOException {
            Insert result = new Insert(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String fileId) throws IOException {
            List result = new List(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DriveRequest<ParentList> {
            private static final String REST_PATH = "files/{fileId}/parents";
            @Key
            private String fileId;

            protected List(String fileId) {
                super(Drive.this, "GET", REST_PATH, null, ParentList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DriveRequest<ParentReference> {
            private static final String REST_PATH = "files/{fileId}/parents";
            @Key
            private String fileId;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;

            protected Insert(String fileId, ParentReference content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, ParentReference.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getId(), "ParentReference.getId()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Insert setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Insert setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Insert setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Insert setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<ParentReference> {
            private static final String REST_PATH = "files/{fileId}/parents/{parentId}";
            @Key
            private String fileId;
            @Key
            private String parentId;

            protected Get(String fileId, String parentId) {
                super(Drive.this, "GET", REST_PATH, null, ParentReference.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.parentId = (String)Preconditions.checkNotNull((Object)parentId, (Object)"Required parameter parentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getParentId() {
                return this.parentId;
            }

            public Get setParentId(String parentId) {
                this.parentId = parentId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/parents/{parentId}";
            @Key
            private String fileId;
            @Key
            private String parentId;
            @Key
            private Boolean enforceSingleParent;

            protected Delete(String fileId, String parentId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.parentId = (String)Preconditions.checkNotNull((Object)parentId, (Object)"Required parameter parentId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getParentId() {
                return this.parentId;
            }

            public Delete setParentId(String parentId) {
                this.parentId = parentId;
                return this;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Delete setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Files {
        public Copy copy(String fileId, File content) throws IOException {
            Copy result = new Copy(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String fileId) throws IOException {
            Delete result = new Delete(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public EmptyTrash emptyTrash() throws IOException {
            EmptyTrash result = new EmptyTrash();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Export export(String fileId, String mimeType) throws IOException {
            Export result = new Export(fileId, mimeType);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GenerateIds generateIds() throws IOException {
            GenerateIds result = new GenerateIds();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId) throws IOException {
            Get result = new Get(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(File content) throws IOException {
            Insert result = new Insert(content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(File content, AbstractInputStreamContent mediaContent) throws IOException {
            Insert result = new Insert(content, mediaContent);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String fileId, File content) throws IOException {
            Patch result = new Patch(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Touch touch(String fileId) throws IOException {
            Touch result = new Touch(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Trash trash(String fileId) throws IOException {
            Trash result = new Trash(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Untrash untrash(String fileId) throws IOException {
            Untrash result = new Untrash(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, File content) throws IOException {
            Update result = new Update(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, File content, AbstractInputStreamContent mediaContent) throws IOException {
            Update result = new Update(fileId, content, mediaContent);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Watch watch(String fileId, Channel content) throws IOException {
            Watch result = new Watch(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Watch
        extends DriveRequest<Channel> {
            private static final String REST_PATH = "files/{fileId}/watch";
            @Key
            private String fileId;
            @Key
            private Boolean acknowledgeAbuse;
            @Key
            private String includePermissionsForView;
            @Key
            private String projection;
            @Key
            private String revisionId;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean updateViewedDate;

            protected Watch(String fileId, Channel content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Channel.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public GenericUrl buildHttpRequestUrl() {
                String baseUrl = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? Drive.this.getRootUrl() + "download/" + Drive.this.getServicePath() : Drive.this.getBaseUrl();
                return new GenericUrl(UriTemplate.expand((String)baseUrl, (String)this.getUriTemplate(), (Object)((Object)this), (boolean)true));
            }

            public Watch setAlt(String alt) {
                return (Watch)super.setAlt(alt);
            }

            public Watch setFields(String fields) {
                return (Watch)super.setFields(fields);
            }

            public Watch setKey(String key) {
                return (Watch)super.setKey(key);
            }

            public Watch setOauthToken(String oauthToken) {
                return (Watch)super.setOauthToken(oauthToken);
            }

            public Watch setPrettyPrint(Boolean prettyPrint) {
                return (Watch)super.setPrettyPrint(prettyPrint);
            }

            public Watch setQuotaUser(String quotaUser) {
                return (Watch)super.setQuotaUser(quotaUser);
            }

            public Watch setUserIp(String userIp) {
                return (Watch)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Watch setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Boolean getAcknowledgeAbuse() {
                return this.acknowledgeAbuse;
            }

            public Watch setAcknowledgeAbuse(Boolean acknowledgeAbuse) {
                this.acknowledgeAbuse = acknowledgeAbuse;
                return this;
            }

            public boolean isAcknowledgeAbuse() {
                if (this.acknowledgeAbuse == null || this.acknowledgeAbuse == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.acknowledgeAbuse;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Watch setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Watch setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Watch setRevisionId(String revisionId) {
                this.revisionId = revisionId;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Watch setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Watch setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Watch setUpdateViewedDate(Boolean updateViewedDate) {
                this.updateViewedDate = updateViewedDate;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.updateViewedDate;
            }

            @Override
            public Watch set(String parameterName, Object value) {
                return (Watch)super.set(parameterName, value);
            }
        }

        public class Update
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private String addParents;
            @Key
            private Boolean convert;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private String includePermissionsForView;
            @Key
            private String modifiedDateBehavior;
            @Key
            private Boolean newRevision;
            @Key
            private Boolean ocr;
            @Key
            private String ocrLanguage;
            @Key
            private Boolean pinned;
            @Key
            private String removeParents;
            @Key
            private Boolean setModifiedDate;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String timedTextLanguage;
            @Key
            private String timedTextTrackName;
            @Key
            private Boolean updateViewedDate;
            @Key
            private Boolean useContentAsIndexableText;

            protected Update(String fileId, File content) {
                super(Drive.this, "PUT", REST_PATH, (Object)content, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            protected Update(String fileId, File content, AbstractInputStreamContent mediaContent) {
                super(Drive.this, "PUT", "/upload/" + Drive.this.getServicePath() + REST_PATH, (Object)content, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getAddParents() {
                return this.addParents;
            }

            public Update setAddParents(String addParents) {
                this.addParents = addParents;
                return this;
            }

            public Boolean getConvert() {
                return this.convert;
            }

            public Update setConvert(Boolean convert) {
                this.convert = convert;
                return this;
            }

            public boolean isConvert() {
                if (this.convert == null || this.convert == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.convert;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Update setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Update setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public String getModifiedDateBehavior() {
                return this.modifiedDateBehavior;
            }

            public Update setModifiedDateBehavior(String modifiedDateBehavior) {
                this.modifiedDateBehavior = modifiedDateBehavior;
                return this;
            }

            public Boolean getNewRevision() {
                return this.newRevision;
            }

            public Update setNewRevision(Boolean newRevision) {
                this.newRevision = newRevision;
                return this;
            }

            public boolean isNewRevision() {
                if (this.newRevision == null || this.newRevision == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.newRevision;
            }

            public Boolean getOcr() {
                return this.ocr;
            }

            public Update setOcr(Boolean ocr) {
                this.ocr = ocr;
                return this;
            }

            public boolean isOcr() {
                if (this.ocr == null || this.ocr == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ocr;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Update setOcrLanguage(String ocrLanguage) {
                this.ocrLanguage = ocrLanguage;
                return this;
            }

            public Boolean getPinned() {
                return this.pinned;
            }

            public Update setPinned(Boolean pinned) {
                this.pinned = pinned;
                return this;
            }

            public boolean isPinned() {
                if (this.pinned == null || this.pinned == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.pinned;
            }

            public String getRemoveParents() {
                return this.removeParents;
            }

            public Update setRemoveParents(String removeParents) {
                this.removeParents = removeParents;
                return this;
            }

            public Boolean getSetModifiedDate() {
                return this.setModifiedDate;
            }

            public Update setSetModifiedDate(Boolean setModifiedDate) {
                this.setModifiedDate = setModifiedDate;
                return this;
            }

            public boolean isSetModifiedDate() {
                if (this.setModifiedDate == null || this.setModifiedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.setModifiedDate;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Update setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Update setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTimedTextLanguage() {
                return this.timedTextLanguage;
            }

            public Update setTimedTextLanguage(String timedTextLanguage) {
                this.timedTextLanguage = timedTextLanguage;
                return this;
            }

            public String getTimedTextTrackName() {
                return this.timedTextTrackName;
            }

            public Update setTimedTextTrackName(String timedTextTrackName) {
                this.timedTextTrackName = timedTextTrackName;
                return this;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Update setUpdateViewedDate(Boolean updateViewedDate) {
                this.updateViewedDate = updateViewedDate;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.updateViewedDate;
            }

            public Boolean getUseContentAsIndexableText() {
                return this.useContentAsIndexableText;
            }

            public Update setUseContentAsIndexableText(Boolean useContentAsIndexableText) {
                this.useContentAsIndexableText = useContentAsIndexableText;
                return this;
            }

            public boolean isUseContentAsIndexableText() {
                if (this.useContentAsIndexableText == null || this.useContentAsIndexableText == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useContentAsIndexableText;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Untrash
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}/untrash";
            @Key
            private String fileId;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;

            protected Untrash(String fileId) {
                super(Drive.this, "POST", REST_PATH, null, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public Untrash setAlt(String alt) {
                return (Untrash)super.setAlt(alt);
            }

            public Untrash setFields(String fields) {
                return (Untrash)super.setFields(fields);
            }

            public Untrash setKey(String key) {
                return (Untrash)super.setKey(key);
            }

            public Untrash setOauthToken(String oauthToken) {
                return (Untrash)super.setOauthToken(oauthToken);
            }

            public Untrash setPrettyPrint(Boolean prettyPrint) {
                return (Untrash)super.setPrettyPrint(prettyPrint);
            }

            public Untrash setQuotaUser(String quotaUser) {
                return (Untrash)super.setQuotaUser(quotaUser);
            }

            public Untrash setUserIp(String userIp) {
                return (Untrash)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Untrash setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Untrash setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Untrash setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Untrash setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Untrash set(String parameterName, Object value) {
                return (Untrash)super.set(parameterName, value);
            }
        }

        public class Trash
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}/trash";
            @Key
            private String fileId;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;

            protected Trash(String fileId) {
                super(Drive.this, "POST", REST_PATH, null, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public Trash setAlt(String alt) {
                return (Trash)super.setAlt(alt);
            }

            public Trash setFields(String fields) {
                return (Trash)super.setFields(fields);
            }

            public Trash setKey(String key) {
                return (Trash)super.setKey(key);
            }

            public Trash setOauthToken(String oauthToken) {
                return (Trash)super.setOauthToken(oauthToken);
            }

            public Trash setPrettyPrint(Boolean prettyPrint) {
                return (Trash)super.setPrettyPrint(prettyPrint);
            }

            public Trash setQuotaUser(String quotaUser) {
                return (Trash)super.setQuotaUser(quotaUser);
            }

            public Trash setUserIp(String userIp) {
                return (Trash)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Trash setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Trash setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Trash setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Trash setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Trash set(String parameterName, Object value) {
                return (Trash)super.set(parameterName, value);
            }
        }

        public class Touch
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}/touch";
            @Key
            private String fileId;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;

            protected Touch(String fileId) {
                super(Drive.this, "POST", REST_PATH, null, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public Touch setAlt(String alt) {
                return (Touch)super.setAlt(alt);
            }

            public Touch setFields(String fields) {
                return (Touch)super.setFields(fields);
            }

            public Touch setKey(String key) {
                return (Touch)super.setKey(key);
            }

            public Touch setOauthToken(String oauthToken) {
                return (Touch)super.setOauthToken(oauthToken);
            }

            public Touch setPrettyPrint(Boolean prettyPrint) {
                return (Touch)super.setPrettyPrint(prettyPrint);
            }

            public Touch setQuotaUser(String quotaUser) {
                return (Touch)super.setQuotaUser(quotaUser);
            }

            public Touch setUserIp(String userIp) {
                return (Touch)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Touch setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Touch setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Touch setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Touch setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Touch set(String parameterName, Object value) {
                return (Touch)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private String addParents;
            @Key
            private Boolean convert;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private String includePermissionsForView;
            @Key
            private String modifiedDateBehavior;
            @Key
            private Boolean newRevision;
            @Key
            private Boolean ocr;
            @Key
            private String ocrLanguage;
            @Key
            private Boolean pinned;
            @Key
            private String removeParents;
            @Key
            private Boolean setModifiedDate;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String timedTextLanguage;
            @Key
            private String timedTextTrackName;
            @Key
            private Boolean updateViewedDate;
            @Key
            private Boolean useContentAsIndexableText;

            protected Patch(String fileId, File content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getAddParents() {
                return this.addParents;
            }

            public Patch setAddParents(String addParents) {
                this.addParents = addParents;
                return this;
            }

            public Boolean getConvert() {
                return this.convert;
            }

            public Patch setConvert(Boolean convert) {
                this.convert = convert;
                return this;
            }

            public boolean isConvert() {
                if (this.convert == null || this.convert == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.convert;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Patch setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Patch setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public String getModifiedDateBehavior() {
                return this.modifiedDateBehavior;
            }

            public Patch setModifiedDateBehavior(String modifiedDateBehavior) {
                this.modifiedDateBehavior = modifiedDateBehavior;
                return this;
            }

            public Boolean getNewRevision() {
                return this.newRevision;
            }

            public Patch setNewRevision(Boolean newRevision) {
                this.newRevision = newRevision;
                return this;
            }

            public boolean isNewRevision() {
                if (this.newRevision == null || this.newRevision == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.newRevision;
            }

            public Boolean getOcr() {
                return this.ocr;
            }

            public Patch setOcr(Boolean ocr) {
                this.ocr = ocr;
                return this;
            }

            public boolean isOcr() {
                if (this.ocr == null || this.ocr == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ocr;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Patch setOcrLanguage(String ocrLanguage) {
                this.ocrLanguage = ocrLanguage;
                return this;
            }

            public Boolean getPinned() {
                return this.pinned;
            }

            public Patch setPinned(Boolean pinned) {
                this.pinned = pinned;
                return this;
            }

            public boolean isPinned() {
                if (this.pinned == null || this.pinned == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.pinned;
            }

            public String getRemoveParents() {
                return this.removeParents;
            }

            public Patch setRemoveParents(String removeParents) {
                this.removeParents = removeParents;
                return this;
            }

            public Boolean getSetModifiedDate() {
                return this.setModifiedDate;
            }

            public Patch setSetModifiedDate(Boolean setModifiedDate) {
                this.setModifiedDate = setModifiedDate;
                return this;
            }

            public boolean isSetModifiedDate() {
                if (this.setModifiedDate == null || this.setModifiedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.setModifiedDate;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Patch setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Patch setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTimedTextLanguage() {
                return this.timedTextLanguage;
            }

            public Patch setTimedTextLanguage(String timedTextLanguage) {
                this.timedTextLanguage = timedTextLanguage;
                return this;
            }

            public String getTimedTextTrackName() {
                return this.timedTextTrackName;
            }

            public Patch setTimedTextTrackName(String timedTextTrackName) {
                this.timedTextTrackName = timedTextTrackName;
                return this;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Patch setUpdateViewedDate(Boolean updateViewedDate) {
                this.updateViewedDate = updateViewedDate;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.updateViewedDate;
            }

            public Boolean getUseContentAsIndexableText() {
                return this.useContentAsIndexableText;
            }

            public Patch setUseContentAsIndexableText(Boolean useContentAsIndexableText) {
                this.useContentAsIndexableText = useContentAsIndexableText;
                return this;
            }

            public boolean isUseContentAsIndexableText() {
                if (this.useContentAsIndexableText == null || this.useContentAsIndexableText == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useContentAsIndexableText;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<FileList> {
            private static final String REST_PATH = "files";
            @Key
            private String corpora;
            @Key
            private String corpus;
            @Key
            private String driveId;
            @Key
            private Boolean includeItemsFromAllDrives;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean includeTeamDriveItems;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String projection;
            @Key
            private String q;
            @Key
            private String spaces;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected List() {
                super(Drive.this, "GET", REST_PATH, null, FileList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getCorpora() {
                return this.corpora;
            }

            public List setCorpora(String corpora) {
                this.corpora = corpora;
                return this;
            }

            public String getCorpus() {
                return this.corpus;
            }

            public List setCorpus(String corpus) {
                this.corpus = corpus;
                return this;
            }

            public String getDriveId() {
                return this.driveId;
            }

            public List setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getIncludeItemsFromAllDrives() {
                return this.includeItemsFromAllDrives;
            }

            public List setIncludeItemsFromAllDrives(Boolean includeItemsFromAllDrives) {
                this.includeItemsFromAllDrives = includeItemsFromAllDrives;
                return this;
            }

            public boolean isIncludeItemsFromAllDrives() {
                if (this.includeItemsFromAllDrives == null || this.includeItemsFromAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeItemsFromAllDrives;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public List setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getIncludeTeamDriveItems() {
                return this.includeTeamDriveItems;
            }

            public List setIncludeTeamDriveItems(Boolean includeTeamDriveItems) {
                this.includeTeamDriveItems = includeTeamDriveItems;
                return this;
            }

            public boolean isIncludeTeamDriveItems() {
                if (this.includeTeamDriveItems == null || this.includeTeamDriveItems == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeTeamDriveItems;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public List setSpaces(String spaces) {
                this.spaces = spaces;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public List setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public List setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public List setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DriveRequest<File> {
            private static final String REST_PATH = "files";
            @Key
            private Boolean convert;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean ocr;
            @Key
            private String ocrLanguage;
            @Key
            private Boolean pinned;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String timedTextLanguage;
            @Key
            private String timedTextTrackName;
            @Key
            private Boolean useContentAsIndexableText;
            @Key
            private String visibility;

            protected Insert(File content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, File.class);
            }

            protected Insert(File content, AbstractInputStreamContent mediaContent) {
                super(Drive.this, "POST", "/upload/" + Drive.this.getServicePath() + REST_PATH, (Object)content, File.class);
                this.initializeMediaUpload(mediaContent);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public Boolean getConvert() {
                return this.convert;
            }

            public Insert setConvert(Boolean convert) {
                this.convert = convert;
                return this;
            }

            public boolean isConvert() {
                if (this.convert == null || this.convert == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.convert;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Insert setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Insert setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getOcr() {
                return this.ocr;
            }

            public Insert setOcr(Boolean ocr) {
                this.ocr = ocr;
                return this;
            }

            public boolean isOcr() {
                if (this.ocr == null || this.ocr == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ocr;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Insert setOcrLanguage(String ocrLanguage) {
                this.ocrLanguage = ocrLanguage;
                return this;
            }

            public Boolean getPinned() {
                return this.pinned;
            }

            public Insert setPinned(Boolean pinned) {
                this.pinned = pinned;
                return this;
            }

            public boolean isPinned() {
                if (this.pinned == null || this.pinned == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.pinned;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Insert setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Insert setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTimedTextLanguage() {
                return this.timedTextLanguage;
            }

            public Insert setTimedTextLanguage(String timedTextLanguage) {
                this.timedTextLanguage = timedTextLanguage;
                return this;
            }

            public String getTimedTextTrackName() {
                return this.timedTextTrackName;
            }

            public Insert setTimedTextTrackName(String timedTextTrackName) {
                this.timedTextTrackName = timedTextTrackName;
                return this;
            }

            public Boolean getUseContentAsIndexableText() {
                return this.useContentAsIndexableText;
            }

            public Insert setUseContentAsIndexableText(Boolean useContentAsIndexableText) {
                this.useContentAsIndexableText = useContentAsIndexableText;
                return this;
            }

            public boolean isUseContentAsIndexableText() {
                if (this.useContentAsIndexableText == null || this.useContentAsIndexableText == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useContentAsIndexableText;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Insert setVisibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private Boolean acknowledgeAbuse;
            @Key
            private String includePermissionsForView;
            @Key
            private String projection;
            @Key
            private String revisionId;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean updateViewedDate;

            protected Get(String fileId) {
                super(Drive.this, "GET", REST_PATH, null, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public GenericUrl buildHttpRequestUrl() {
                String baseUrl = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? Drive.this.getRootUrl() + "download/" + Drive.this.getServicePath() : Drive.this.getBaseUrl();
                return new GenericUrl(UriTemplate.expand((String)baseUrl, (String)this.getUriTemplate(), (Object)((Object)this), (boolean)true));
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Boolean getAcknowledgeAbuse() {
                return this.acknowledgeAbuse;
            }

            public Get setAcknowledgeAbuse(Boolean acknowledgeAbuse) {
                this.acknowledgeAbuse = acknowledgeAbuse;
                return this;
            }

            public boolean isAcknowledgeAbuse() {
                if (this.acknowledgeAbuse == null || this.acknowledgeAbuse == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.acknowledgeAbuse;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Get setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Get setRevisionId(String revisionId) {
                this.revisionId = revisionId;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Get setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Get setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Get setUpdateViewedDate(Boolean updateViewedDate) {
                this.updateViewedDate = updateViewedDate;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.updateViewedDate;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class GenerateIds
        extends DriveRequest<GeneratedIds> {
            private static final String REST_PATH = "files/generateIds";
            @Key
            private Integer maxResults;
            @Key
            private String space;
            @Key
            private String type;

            protected GenerateIds() {
                super(Drive.this, "GET", REST_PATH, null, GeneratedIds.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GenerateIds setAlt(String alt) {
                return (GenerateIds)super.setAlt(alt);
            }

            public GenerateIds setFields(String fields) {
                return (GenerateIds)super.setFields(fields);
            }

            public GenerateIds setKey(String key) {
                return (GenerateIds)super.setKey(key);
            }

            public GenerateIds setOauthToken(String oauthToken) {
                return (GenerateIds)super.setOauthToken(oauthToken);
            }

            public GenerateIds setPrettyPrint(Boolean prettyPrint) {
                return (GenerateIds)super.setPrettyPrint(prettyPrint);
            }

            public GenerateIds setQuotaUser(String quotaUser) {
                return (GenerateIds)super.setQuotaUser(quotaUser);
            }

            public GenerateIds setUserIp(String userIp) {
                return (GenerateIds)super.setUserIp(userIp);
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public GenerateIds setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getSpace() {
                return this.space;
            }

            public GenerateIds setSpace(String space) {
                this.space = space;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public GenerateIds setType(String type) {
                this.type = type;
                return this;
            }

            @Override
            public GenerateIds set(String parameterName, Object value) {
                return (GenerateIds)super.set(parameterName, value);
            }
        }

        public class Export
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/export";
            @Key
            private String fileId;
            @Key
            private String mimeType;

            protected Export(String fileId, String mimeType) {
                super(Drive.this, "GET", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.mimeType = (String)Preconditions.checkNotNull((Object)mimeType, (Object)"Required parameter mimeType must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Export setAlt(String alt) {
                return (Export)super.setAlt(alt);
            }

            public Export setFields(String fields) {
                return (Export)super.setFields(fields);
            }

            public Export setKey(String key) {
                return (Export)super.setKey(key);
            }

            public Export setOauthToken(String oauthToken) {
                return (Export)super.setOauthToken(oauthToken);
            }

            public Export setPrettyPrint(Boolean prettyPrint) {
                return (Export)super.setPrettyPrint(prettyPrint);
            }

            public Export setQuotaUser(String quotaUser) {
                return (Export)super.setQuotaUser(quotaUser);
            }

            public Export setUserIp(String userIp) {
                return (Export)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Export setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public Export setMimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            @Override
            public Export set(String parameterName, Object value) {
                return (Export)super.set(parameterName, value);
            }
        }

        public class EmptyTrash
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/trash";
            @Key
            private Boolean enforceSingleParent;

            protected EmptyTrash() {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
            }

            public EmptyTrash setAlt(String alt) {
                return (EmptyTrash)super.setAlt(alt);
            }

            public EmptyTrash setFields(String fields) {
                return (EmptyTrash)super.setFields(fields);
            }

            public EmptyTrash setKey(String key) {
                return (EmptyTrash)super.setKey(key);
            }

            public EmptyTrash setOauthToken(String oauthToken) {
                return (EmptyTrash)super.setOauthToken(oauthToken);
            }

            public EmptyTrash setPrettyPrint(Boolean prettyPrint) {
                return (EmptyTrash)super.setPrettyPrint(prettyPrint);
            }

            public EmptyTrash setQuotaUser(String quotaUser) {
                return (EmptyTrash)super.setQuotaUser(quotaUser);
            }

            public EmptyTrash setUserIp(String userIp) {
                return (EmptyTrash)super.setUserIp(userIp);
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public EmptyTrash setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            @Override
            public EmptyTrash set(String parameterName, Object value) {
                return (EmptyTrash)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;

            protected Delete(String fileId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Delete setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Delete setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Delete setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Copy
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}/copy";
            @Key
            private String fileId;
            @Key
            private Boolean convert;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean ocr;
            @Key
            private String ocrLanguage;
            @Key
            private Boolean pinned;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String timedTextLanguage;
            @Key
            private String timedTextTrackName;
            @Key
            private String visibility;

            protected Copy(String fileId, File content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public Copy setAlt(String alt) {
                return (Copy)super.setAlt(alt);
            }

            public Copy setFields(String fields) {
                return (Copy)super.setFields(fields);
            }

            public Copy setKey(String key) {
                return (Copy)super.setKey(key);
            }

            public Copy setOauthToken(String oauthToken) {
                return (Copy)super.setOauthToken(oauthToken);
            }

            public Copy setPrettyPrint(Boolean prettyPrint) {
                return (Copy)super.setPrettyPrint(prettyPrint);
            }

            public Copy setQuotaUser(String quotaUser) {
                return (Copy)super.setQuotaUser(quotaUser);
            }

            public Copy setUserIp(String userIp) {
                return (Copy)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Copy setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Boolean getConvert() {
                return this.convert;
            }

            public Copy setConvert(Boolean convert) {
                this.convert = convert;
                return this;
            }

            public boolean isConvert() {
                if (this.convert == null || this.convert == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.convert;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Copy setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Copy setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getOcr() {
                return this.ocr;
            }

            public Copy setOcr(Boolean ocr) {
                this.ocr = ocr;
                return this;
            }

            public boolean isOcr() {
                if (this.ocr == null || this.ocr == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ocr;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Copy setOcrLanguage(String ocrLanguage) {
                this.ocrLanguage = ocrLanguage;
                return this;
            }

            public Boolean getPinned() {
                return this.pinned;
            }

            public Copy setPinned(Boolean pinned) {
                this.pinned = pinned;
                return this;
            }

            public boolean isPinned() {
                if (this.pinned == null || this.pinned == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.pinned;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Copy setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Copy setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTimedTextLanguage() {
                return this.timedTextLanguage;
            }

            public Copy setTimedTextLanguage(String timedTextLanguage) {
                this.timedTextLanguage = timedTextLanguage;
                return this;
            }

            public String getTimedTextTrackName() {
                return this.timedTextTrackName;
            }

            public Copy setTimedTextTrackName(String timedTextTrackName) {
                this.timedTextTrackName = timedTextTrackName;
                return this;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Copy setVisibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            @Override
            public Copy set(String parameterName, Object value) {
                return (Copy)super.set(parameterName, value);
            }
        }
    }

    public class Drives {
        public Delete delete(String driveId) throws IOException {
            Delete result = new Delete(driveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String driveId) throws IOException {
            Get result = new Get(driveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Hide hide(String driveId) throws IOException {
            Hide result = new Hide(driveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String requestId, com.google.api.services.drive.model.Drive content) throws IOException {
            Insert result = new Insert(requestId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Unhide unhide(String driveId) throws IOException {
            Unhide result = new Unhide(driveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String driveId, com.google.api.services.drive.model.Drive content) throws IOException {
            Update result = new Update(driveId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<com.google.api.services.drive.model.Drive> {
            private static final String REST_PATH = "drives/{driveId}";
            @Key
            private String driveId;
            @Key
            private Boolean useDomainAdminAccess;

            protected Update(String driveId, com.google.api.services.drive.model.Drive content) {
                super(Drive.this, "PUT", REST_PATH, (Object)content, com.google.api.services.drive.model.Drive.class);
                this.driveId = (String)Preconditions.checkNotNull((Object)driveId, (Object)"Required parameter driveId must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Update setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Update setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Unhide
        extends DriveRequest<com.google.api.services.drive.model.Drive> {
            private static final String REST_PATH = "drives/{driveId}/unhide";
            @Key
            private String driveId;

            protected Unhide(String driveId) {
                super(Drive.this, "POST", REST_PATH, null, com.google.api.services.drive.model.Drive.class);
                this.driveId = (String)Preconditions.checkNotNull((Object)driveId, (Object)"Required parameter driveId must be specified.");
            }

            public Unhide setAlt(String alt) {
                return (Unhide)super.setAlt(alt);
            }

            public Unhide setFields(String fields) {
                return (Unhide)super.setFields(fields);
            }

            public Unhide setKey(String key) {
                return (Unhide)super.setKey(key);
            }

            public Unhide setOauthToken(String oauthToken) {
                return (Unhide)super.setOauthToken(oauthToken);
            }

            public Unhide setPrettyPrint(Boolean prettyPrint) {
                return (Unhide)super.setPrettyPrint(prettyPrint);
            }

            public Unhide setQuotaUser(String quotaUser) {
                return (Unhide)super.setQuotaUser(quotaUser);
            }

            public Unhide setUserIp(String userIp) {
                return (Unhide)super.setUserIp(userIp);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Unhide setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            @Override
            public Unhide set(String parameterName, Object value) {
                return (Unhide)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<DriveList> {
            private static final String REST_PATH = "drives";
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String q;
            @Key
            private Boolean useDomainAdminAccess;

            protected List() {
                super(Drive.this, "GET", REST_PATH, null, DriveList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public List setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DriveRequest<com.google.api.services.drive.model.Drive> {
            private static final String REST_PATH = "drives";
            @Key
            private String requestId;

            protected Insert(String requestId, com.google.api.services.drive.model.Drive content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, com.google.api.services.drive.model.Drive.class);
                this.requestId = (String)Preconditions.checkNotNull((Object)requestId, (Object)"Required parameter requestId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getName(), "Drive.getName()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Hide
        extends DriveRequest<com.google.api.services.drive.model.Drive> {
            private static final String REST_PATH = "drives/{driveId}/hide";
            @Key
            private String driveId;

            protected Hide(String driveId) {
                super(Drive.this, "POST", REST_PATH, null, com.google.api.services.drive.model.Drive.class);
                this.driveId = (String)Preconditions.checkNotNull((Object)driveId, (Object)"Required parameter driveId must be specified.");
            }

            public Hide setAlt(String alt) {
                return (Hide)super.setAlt(alt);
            }

            public Hide setFields(String fields) {
                return (Hide)super.setFields(fields);
            }

            public Hide setKey(String key) {
                return (Hide)super.setKey(key);
            }

            public Hide setOauthToken(String oauthToken) {
                return (Hide)super.setOauthToken(oauthToken);
            }

            public Hide setPrettyPrint(Boolean prettyPrint) {
                return (Hide)super.setPrettyPrint(prettyPrint);
            }

            public Hide setQuotaUser(String quotaUser) {
                return (Hide)super.setQuotaUser(quotaUser);
            }

            public Hide setUserIp(String userIp) {
                return (Hide)super.setUserIp(userIp);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Hide setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            @Override
            public Hide set(String parameterName, Object value) {
                return (Hide)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<com.google.api.services.drive.model.Drive> {
            private static final String REST_PATH = "drives/{driveId}";
            @Key
            private String driveId;
            @Key
            private Boolean useDomainAdminAccess;

            protected Get(String driveId) {
                super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Drive.class);
                this.driveId = (String)Preconditions.checkNotNull((Object)driveId, (Object)"Required parameter driveId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Get setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Get setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "drives/{driveId}";
            @Key
            private String driveId;

            protected Delete(String driveId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.driveId = (String)Preconditions.checkNotNull((Object)driveId, (Object)"Required parameter driveId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Delete setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Comments {
        public Delete delete(String fileId, String commentId) throws IOException {
            Delete result = new Delete(fileId, commentId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId, String commentId) throws IOException {
            Get result = new Get(fileId, commentId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String fileId, Comment content) throws IOException {
            Insert result = new Insert(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String fileId) throws IOException {
            List result = new List(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String fileId, String commentId, Comment content) throws IOException {
            Patch result = new Patch(fileId, commentId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, String commentId, Comment content) throws IOException {
            Update result = new Update(fileId, commentId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Update(String fileId, String commentId, Comment content) {
                super(Drive.this, "PUT", REST_PATH, (Object)content, Comment.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getContent(), "Comment.getContent()");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Update setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Patch(String fileId, String commentId, Comment content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, Comment.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getContent(), "Comment.getContent()");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Patch setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<CommentList> {
            private static final String REST_PATH = "files/{fileId}/comments";
            @Key
            private String fileId;
            @Key
            private Boolean includeDeleted;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String updatedMin;

            protected List(String fileId) {
                super(Drive.this, "GET", REST_PATH, null, CommentList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public List setIncludeDeleted(Boolean includeDeleted) {
                this.includeDeleted = includeDeleted;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getUpdatedMin() {
                return this.updatedMin;
            }

            public List setUpdatedMin(String updatedMin) {
                this.updatedMin = updatedMin;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments";
            @Key
            private String fileId;

            protected Insert(String fileId, Comment content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Comment.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getContent(), "Comment.getContent()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Insert setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private Boolean includeDeleted;

            protected Get(String fileId, String commentId) {
                super(Drive.this, "GET", REST_PATH, null, Comment.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public Get setIncludeDeleted(Boolean includeDeleted) {
                this.includeDeleted = includeDeleted;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Delete(String fileId, String commentId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Delete setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Children {
        public Delete delete(String folderId, String childId) throws IOException {
            Delete result = new Delete(folderId, childId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String folderId, String childId) throws IOException {
            Get result = new Get(folderId, childId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String folderId, ChildReference content) throws IOException {
            Insert result = new Insert(folderId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String folderId) throws IOException {
            List result = new List(folderId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DriveRequest<ChildList> {
            private static final String REST_PATH = "files/{folderId}/children";
            @Key
            private String folderId;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String q;

            protected List(String folderId) {
                super(Drive.this, "GET", REST_PATH, null, ChildList.class);
                this.folderId = (String)Preconditions.checkNotNull((Object)folderId, (Object)"Required parameter folderId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getFolderId() {
                return this.folderId;
            }

            public List setFolderId(String folderId) {
                this.folderId = folderId;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DriveRequest<ChildReference> {
            private static final String REST_PATH = "files/{folderId}/children";
            @Key
            private String folderId;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;

            protected Insert(String folderId, ChildReference content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, ChildReference.class);
                this.folderId = (String)Preconditions.checkNotNull((Object)folderId, (Object)"Required parameter folderId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getId(), "ChildReference.getId()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getFolderId() {
                return this.folderId;
            }

            public Insert setFolderId(String folderId) {
                this.folderId = folderId;
                return this;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Insert setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Insert setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Insert setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<ChildReference> {
            private static final String REST_PATH = "files/{folderId}/children/{childId}";
            @Key
            private String folderId;
            @Key
            private String childId;

            protected Get(String folderId, String childId) {
                super(Drive.this, "GET", REST_PATH, null, ChildReference.class);
                this.folderId = (String)Preconditions.checkNotNull((Object)folderId, (Object)"Required parameter folderId must be specified.");
                this.childId = (String)Preconditions.checkNotNull((Object)childId, (Object)"Required parameter childId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getFolderId() {
                return this.folderId;
            }

            public Get setFolderId(String folderId) {
                this.folderId = folderId;
                return this;
            }

            public String getChildId() {
                return this.childId;
            }

            public Get setChildId(String childId) {
                this.childId = childId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{folderId}/children/{childId}";
            @Key
            private String folderId;
            @Key
            private String childId;
            @Key
            private Boolean enforceSingleParent;

            protected Delete(String folderId, String childId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.folderId = (String)Preconditions.checkNotNull((Object)folderId, (Object)"Required parameter folderId must be specified.");
                this.childId = (String)Preconditions.checkNotNull((Object)childId, (Object)"Required parameter childId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getFolderId() {
                return this.folderId;
            }

            public Delete setFolderId(String folderId) {
                this.folderId = folderId;
                return this;
            }

            public String getChildId() {
                return this.childId;
            }

            public Delete setChildId(String childId) {
                this.childId = childId;
                return this;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Delete setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel content) throws IOException {
            Stop result = new Stop(content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Stop
        extends DriveRequest<Void> {
            private static final String REST_PATH = "channels/stop";

            protected Stop(Channel content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Void.class);
            }

            public Stop setAlt(String alt) {
                return (Stop)super.setAlt(alt);
            }

            public Stop setFields(String fields) {
                return (Stop)super.setFields(fields);
            }

            public Stop setKey(String key) {
                return (Stop)super.setKey(key);
            }

            public Stop setOauthToken(String oauthToken) {
                return (Stop)super.setOauthToken(oauthToken);
            }

            public Stop setPrettyPrint(Boolean prettyPrint) {
                return (Stop)super.setPrettyPrint(prettyPrint);
            }

            public Stop setQuotaUser(String quotaUser) {
                return (Stop)super.setQuotaUser(quotaUser);
            }

            public Stop setUserIp(String userIp) {
                return (Stop)super.setUserIp(userIp);
            }

            @Override
            public Stop set(String parameterName, Object value) {
                return (Stop)super.set(parameterName, value);
            }
        }
    }

    public class Changes {
        public Get get(String changeId) throws IOException {
            Get result = new Get(changeId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetStartPageToken getStartPageToken() throws IOException {
            GetStartPageToken result = new GetStartPageToken();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Watch watch(Channel content) throws IOException {
            Watch result = new Watch(content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Watch
        extends DriveRequest<Channel> {
            private static final String REST_PATH = "changes/watch";
            @Key
            private String driveId;
            @Key
            private Boolean includeCorpusRemovals;
            @Key
            private Boolean includeDeleted;
            @Key
            private Boolean includeItemsFromAllDrives;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean includeSubscribed;
            @Key
            private Boolean includeTeamDriveItems;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String spaces;
            @Key
            private Long startChangeId;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected Watch(Channel content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Channel.class);
            }

            public Watch setAlt(String alt) {
                return (Watch)super.setAlt(alt);
            }

            public Watch setFields(String fields) {
                return (Watch)super.setFields(fields);
            }

            public Watch setKey(String key) {
                return (Watch)super.setKey(key);
            }

            public Watch setOauthToken(String oauthToken) {
                return (Watch)super.setOauthToken(oauthToken);
            }

            public Watch setPrettyPrint(Boolean prettyPrint) {
                return (Watch)super.setPrettyPrint(prettyPrint);
            }

            public Watch setQuotaUser(String quotaUser) {
                return (Watch)super.setQuotaUser(quotaUser);
            }

            public Watch setUserIp(String userIp) {
                return (Watch)super.setUserIp(userIp);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Watch setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getIncludeCorpusRemovals() {
                return this.includeCorpusRemovals;
            }

            public Watch setIncludeCorpusRemovals(Boolean includeCorpusRemovals) {
                this.includeCorpusRemovals = includeCorpusRemovals;
                return this;
            }

            public boolean isIncludeCorpusRemovals() {
                if (this.includeCorpusRemovals == null || this.includeCorpusRemovals == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeCorpusRemovals;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public Watch setIncludeDeleted(Boolean includeDeleted) {
                this.includeDeleted = includeDeleted;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeDeleted;
            }

            public Boolean getIncludeItemsFromAllDrives() {
                return this.includeItemsFromAllDrives;
            }

            public Watch setIncludeItemsFromAllDrives(Boolean includeItemsFromAllDrives) {
                this.includeItemsFromAllDrives = includeItemsFromAllDrives;
                return this;
            }

            public boolean isIncludeItemsFromAllDrives() {
                if (this.includeItemsFromAllDrives == null || this.includeItemsFromAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeItemsFromAllDrives;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Watch setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getIncludeSubscribed() {
                return this.includeSubscribed;
            }

            public Watch setIncludeSubscribed(Boolean includeSubscribed) {
                this.includeSubscribed = includeSubscribed;
                return this;
            }

            public boolean isIncludeSubscribed() {
                if (this.includeSubscribed == null || this.includeSubscribed == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeSubscribed;
            }

            public Boolean getIncludeTeamDriveItems() {
                return this.includeTeamDriveItems;
            }

            public Watch setIncludeTeamDriveItems(Boolean includeTeamDriveItems) {
                this.includeTeamDriveItems = includeTeamDriveItems;
                return this;
            }

            public boolean isIncludeTeamDriveItems() {
                if (this.includeTeamDriveItems == null || this.includeTeamDriveItems == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeTeamDriveItems;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Watch setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public Watch setSpaces(String spaces) {
                this.spaces = spaces;
                return this;
            }

            public Long getStartChangeId() {
                return this.startChangeId;
            }

            public Watch setStartChangeId(Long startChangeId) {
                this.startChangeId = startChangeId;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Watch setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Watch setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Watch setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            @Override
            public Watch set(String parameterName, Object value) {
                return (Watch)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<ChangeList> {
            private static final String REST_PATH = "changes";
            @Key
            private String driveId;
            @Key
            private Boolean includeCorpusRemovals;
            @Key
            private Boolean includeDeleted;
            @Key
            private Boolean includeItemsFromAllDrives;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean includeSubscribed;
            @Key
            private Boolean includeTeamDriveItems;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String spaces;
            @Key
            private Long startChangeId;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected List() {
                super(Drive.this, "GET", REST_PATH, null, ChangeList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public List setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getIncludeCorpusRemovals() {
                return this.includeCorpusRemovals;
            }

            public List setIncludeCorpusRemovals(Boolean includeCorpusRemovals) {
                this.includeCorpusRemovals = includeCorpusRemovals;
                return this;
            }

            public boolean isIncludeCorpusRemovals() {
                if (this.includeCorpusRemovals == null || this.includeCorpusRemovals == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeCorpusRemovals;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public List setIncludeDeleted(Boolean includeDeleted) {
                this.includeDeleted = includeDeleted;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeDeleted;
            }

            public Boolean getIncludeItemsFromAllDrives() {
                return this.includeItemsFromAllDrives;
            }

            public List setIncludeItemsFromAllDrives(Boolean includeItemsFromAllDrives) {
                this.includeItemsFromAllDrives = includeItemsFromAllDrives;
                return this;
            }

            public boolean isIncludeItemsFromAllDrives() {
                if (this.includeItemsFromAllDrives == null || this.includeItemsFromAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeItemsFromAllDrives;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public List setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getIncludeSubscribed() {
                return this.includeSubscribed;
            }

            public List setIncludeSubscribed(Boolean includeSubscribed) {
                this.includeSubscribed = includeSubscribed;
                return this;
            }

            public boolean isIncludeSubscribed() {
                if (this.includeSubscribed == null || this.includeSubscribed == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeSubscribed;
            }

            public Boolean getIncludeTeamDriveItems() {
                return this.includeTeamDriveItems;
            }

            public List setIncludeTeamDriveItems(Boolean includeTeamDriveItems) {
                this.includeTeamDriveItems = includeTeamDriveItems;
                return this;
            }

            public boolean isIncludeTeamDriveItems() {
                if (this.includeTeamDriveItems == null || this.includeTeamDriveItems == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeTeamDriveItems;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public List setSpaces(String spaces) {
                this.spaces = spaces;
                return this;
            }

            public Long getStartChangeId() {
                return this.startChangeId;
            }

            public List setStartChangeId(Long startChangeId) {
                this.startChangeId = startChangeId;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public List setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public List setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public List setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetStartPageToken
        extends DriveRequest<StartPageToken> {
            private static final String REST_PATH = "changes/startPageToken";
            @Key
            private String driveId;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected GetStartPageToken() {
                super(Drive.this, "GET", REST_PATH, null, StartPageToken.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetStartPageToken setAlt(String alt) {
                return (GetStartPageToken)super.setAlt(alt);
            }

            public GetStartPageToken setFields(String fields) {
                return (GetStartPageToken)super.setFields(fields);
            }

            public GetStartPageToken setKey(String key) {
                return (GetStartPageToken)super.setKey(key);
            }

            public GetStartPageToken setOauthToken(String oauthToken) {
                return (GetStartPageToken)super.setOauthToken(oauthToken);
            }

            public GetStartPageToken setPrettyPrint(Boolean prettyPrint) {
                return (GetStartPageToken)super.setPrettyPrint(prettyPrint);
            }

            public GetStartPageToken setQuotaUser(String quotaUser) {
                return (GetStartPageToken)super.setQuotaUser(quotaUser);
            }

            public GetStartPageToken setUserIp(String userIp) {
                return (GetStartPageToken)super.setUserIp(userIp);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public GetStartPageToken setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public GetStartPageToken setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public GetStartPageToken setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public GetStartPageToken setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            @Override
            public GetStartPageToken set(String parameterName, Object value) {
                return (GetStartPageToken)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<Change> {
            private static final String REST_PATH = "changes/{changeId}";
            @Key
            private String changeId;
            @Key
            private String driveId;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected Get(String changeId) {
                super(Drive.this, "GET", REST_PATH, null, Change.class);
                this.changeId = (String)Preconditions.checkNotNull((Object)changeId, (Object)"Required parameter changeId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getChangeId() {
                return this.changeId;
            }

            public Get setChangeId(String changeId) {
                this.changeId = changeId;
                return this;
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Get setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Get setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Get setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Get setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Apps {
        public Get get(String appId) throws IOException {
            Get result = new Get(appId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DriveRequest<AppList> {
            private static final String REST_PATH = "apps";
            @Key
            private String appFilterExtensions;
            @Key
            private String appFilterMimeTypes;
            @Key
            private String languageCode;

            protected List() {
                super(Drive.this, "GET", REST_PATH, null, AppList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getAppFilterExtensions() {
                return this.appFilterExtensions;
            }

            public List setAppFilterExtensions(String appFilterExtensions) {
                this.appFilterExtensions = appFilterExtensions;
                return this;
            }

            public String getAppFilterMimeTypes() {
                return this.appFilterMimeTypes;
            }

            public List setAppFilterMimeTypes(String appFilterMimeTypes) {
                this.appFilterMimeTypes = appFilterMimeTypes;
                return this;
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public List setLanguageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<App> {
            private static final String REST_PATH = "apps/{appId}";
            @Key
            private String appId;

            protected Get(String appId) {
                super(Drive.this, "GET", REST_PATH, null, App.class);
                this.appId = (String)Preconditions.checkNotNull((Object)appId, (Object)"Required parameter appId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getAppId() {
                return this.appId;
            }

            public Get setAppId(String appId) {
                this.appId = appId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class About {
        public Get get() throws IOException {
            Get result = new Get();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends DriveRequest<com.google.api.services.drive.model.About> {
            private static final String REST_PATH = "about";
            @Key
            private Boolean includeSubscribed;
            @Key
            private Long maxChangeIdCount;
            @Key
            private Long startChangeId;

            protected Get() {
                super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.About.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public Boolean getIncludeSubscribed() {
                return this.includeSubscribed;
            }

            public Get setIncludeSubscribed(Boolean includeSubscribed) {
                this.includeSubscribed = includeSubscribed;
                return this;
            }

            public boolean isIncludeSubscribed() {
                if (this.includeSubscribed == null || this.includeSubscribed == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeSubscribed;
            }

            public Long getMaxChangeIdCount() {
                return this.maxChangeIdCount;
            }

            public Get setMaxChangeIdCount(Long maxChangeIdCount) {
                this.maxChangeIdCount = maxChangeIdCount;
                return this;
            }

            public Long getStartChangeId() {
                return this.startChangeId;
            }

            public Get setStartChangeId(Long startChangeId) {
                this.startChangeId = startChangeId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

