/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * The metadata for a file. Some resource methods (such as `files.update`) require a `fileId`. Use
 * the `files.list` method to retrieve the ID for a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class File extends com.google.api.client.json.GenericJson {

  /**
   * Output only. A link for opening the file in a relevant Google editor or viewer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String alternateLink;

  /**
   * Output only. Whether this file is in the Application Data folder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean appDataContents;

  /**
   * Output only. Deprecated: Use `capabilities/canComment` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canComment;

  /**
   * Output only. Deprecated: Use `capabilities/canReadRevisions` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canReadRevisions;

  /**
   * Output only. Capabilities the current user has on this file. Each capability corresponds to a
   * fine-grained action that a user may take.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Capabilities capabilities;

  /**
   * Restrictions for accessing the content of the file. Only populated if such a restriction
   * exists.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ContentRestriction> contentRestrictions;

  static {
    // hack to force ProGuard to consider ContentRestriction used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ContentRestriction.class);
  }

  /**
   * Whether the options to copy, print, or download this file, should be disabled for readers and
   * commenters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean copyRequiresWriterPermission;

  /**
   * Output only. Deprecated: Use `capabilities/canCopy` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean copyable;

  /**
   * Create time for this file (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdDate;

  /**
   * Output only. A link to open this file with the user's default app for this file. Only populated
   * when the drive.apps.readonly scope is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultOpenWithLink;

  /**
   * A short description of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Output only. Short lived download URL for the file. This field is only populated for files with
   * content stored in Google Drive; it is not populated for Google Docs or shortcut files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String downloadUrl;

  /**
   * Output only. ID of the shared drive the file resides in. Only populated for items in shared
   * drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String driveId;

  /**
   * Output only. Deprecated: Use `capabilities/canEdit` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean editable;

  /**
   * Output only. A link for embedding the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String embedLink;

  /**
   * Output only. ETag of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Output only. Whether this file has been explicitly trashed, as opposed to recursively trashed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean explicitlyTrashed;

  /**
   * Output only. Links for exporting Docs Editors files to specific formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> exportLinks;

  /**
   * Output only. The final component of `fullFileExtension` with trailing text that does not appear
   * to be part of the extension removed. This field is only populated for files with content stored
   * in Google Drive; it is not populated for Docs Editors or shortcut files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileExtension;

  /**
   * Output only. Size in bytes of blobs and first party editor files. Won't be populated for files
   * that have no size, like shortcuts and folders.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long fileSize;

  /**
   * Folder color as an RGB hex string if the file is a folder or a shortcut to a folder. The list
   * of supported colors is available in the folderColorPalette field of the About resource. If an
   * unsupported color is specified, it will be changed to the closest color in the palette.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String folderColorRgb;

  /**
   * Output only. The full file extension; extracted from the title. May contain multiple
   * concatenated extensions, such as "tar.gz". Removing an extension from the title does not clear
   * this field; however, changing the extension on the title does update this field. This field is
   * only populated for files with content stored in Google Drive; it is not populated for Docs
   * Editors or shortcut files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fullFileExtension;

  /**
   * Output only. Whether there are permissions directly on this file. This field is only populated
   * for items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasAugmentedPermissions;

  /**
   * Output only. Whether this file has a thumbnail. This does not indicate whether the requesting
   * app has access to the thumbnail. To check access, look for the presence of the thumbnailLink
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasThumbnail;

  /**
   * Output only. The ID of the file's head revision. This field is only populated for files with
   * content stored in Google Drive; it is not populated for Docs Editors or shortcut files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String headRevisionId;

  /**
   * Output only. A link to the file's icon.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iconLink;

  /**
   * The ID of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Output only. Metadata about image media. This will only be present for image types, and its
   * contents will depend on what can be parsed from the image content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ImageMediaMetadata imageMediaMetadata;

  /**
   * Indexable text attributes for the file (can only be written)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IndexableText indexableText;

  /**
   * Output only. Whether the file was created or opened by the requesting app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isAppAuthorized;

  /**
   * Output only. The type of file. This is always `drive#file`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Output only. An overview of the labels on the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LabelInfo labelInfo;

  /**
   * A group of labels for the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Labels labels;

  /**
   * Output only. The last user to modify this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User lastModifyingUser;

  /**
   * Output only. Name of the last user to modify this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastModifyingUserName;

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastViewedByMeDate;

  /**
   * Contains details about the link URLs that clients are using to refer to this item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinkShareMetadata linkShareMetadata;

  /**
   * Deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime markedViewedByMeDate;

  /**
   * Output only. An MD5 checksum for the content of this file. This field is only populated for
   * files with content stored in Google Drive; it is not populated for Docs Editors or shortcut
   * files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String md5Checksum;

  /**
   * The MIME type of the file. This is only mutable on update when uploading new content. This
   * field can be left blank, and the mimetype will be determined from the uploaded content's MIME
   * type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp). Note that setting
   * modifiedDate will also update the modifiedByMe date for the user which set the date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedByMeDate;

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp). This is only mutable
   * on update when the setModifiedDate parameter is set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedDate;

  /**
   * Output only. A map of the id of each of the user's apps to a link to open this file with that
   * app. Only populated when the drive.apps.readonly scope is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> openWithLinks;

  /**
   * The original filename of the uploaded content if available, or else the original value of the
   * `title` field. This is only available for files with binary content in Google Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originalFilename;

  /**
   * Output only. Whether the file is owned by the current user. Not populated for items in shared
   * drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ownedByMe;

  /**
   * Output only. Name(s) of the owner(s) of this file. Not populated for items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> ownerNames;

  /**
   * Output only. The owner of this file. Only certain legacy files may have more than one owner.
   * This field isn't populated for items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<User> owners;

  /**
   * Collection of parent folders which contain this file. If not specified as part of an insert
   * request, the file will be placed directly in the user's My Drive folder. If not specified as
   * part of a copy request, the file will inherit any discoverable parents of the source file.
   * Update requests can also use the `addParents` and `removeParents` parameters to modify the
   * parents list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ParentReference> parents;

  /**
   * Output only. List of permission IDs for users with access to this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> permissionIds;

  /**
   * Output only. The list of permissions for users with access to this file. Not populated for
   * items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Permission> permissions;

  /**
   * The list of properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Property> properties;

  /**
   * Output only. The number of quota bytes used by this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long quotaBytesUsed;

  /**
   * Output only. A key needed to access the item via a shared link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourceKey;

  /**
   * Output only. A link back to this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Output only. The SHA1 checksum associated with this file, if available. This field is only
   * populated for files with content stored in Google Drive; it is not populated for Docs Editors
   * or shortcut files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha1Checksum;

  /**
   * Output only. The SHA256 checksum associated with this file, if available. This field is only
   * populated for files with content stored in Google Drive; it is not populated for Docs Editors
   * or shortcut files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha256Checksum;

  /**
   * Output only. Deprecated: Use `capabilities/canShare` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean shareable;

  /**
   * Output only. Whether the file has been shared. Not populated for items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean shared;

  /**
   * Time at which this file was shared with the user (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime sharedWithMeDate;

  /**
   * Output only. User that shared the item with the current user, if available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User sharingUser;

  /**
   * Shortcut file details. Only populated for shortcut files, which have the mimeType field set to
   * `application/vnd.google-apps.shortcut`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ShortcutDetails shortcutDetails;

  /**
   * Output only. The list of spaces which contain the file. Supported values are `drive`,
   * `appDataFolder` and `photos`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> spaces;

  /**
   * Output only. Deprecated: Use `driveId` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String teamDriveId;

  /**
   * A thumbnail for the file. This will only be used if a standard thumbnail cannot be generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Thumbnail thumbnail;

  /**
   * Output only. A short-lived link to the file's thumbnail, if available. Typically lasts on the
   * order of hours. Only populated when the requesting app can access the file's content. If the
   * file isn't shared publicly, the URL returned in `Files.thumbnailLink` must be fetched using a
   * credentialed request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String thumbnailLink;

  /**
   * Output only. The thumbnail version for use in thumbnail cache invalidation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long thumbnailVersion;

  /**
   * The title of this file. Note that for immutable items such as the top level folders of shared
   * drives, My Drive root folder, and Application Data folder the title is constant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The time that the item was trashed (formatted RFC 3339 timestamp). Only populated for items in
   * shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime trashedDate;

  /**
   * Output only. If the file has been explicitly trashed, the user who trashed it. Only populated
   * for items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User trashingUser;

  /**
   * Output only. The permissions for the authenticated user on this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Permission userPermission;

  /**
   * Output only. A monotonically increasing version number for the file. This reflects every change
   * made to the file on the server, even those not visible to the requesting user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long version;

  /**
   * Output only. Metadata about video media. This will only be present for video types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoMediaMetadata videoMediaMetadata;

  /**
   * Output only. A link for downloading the content of the file in a browser using cookie based
   * authentication. In cases where the content is shared publicly, the content can be downloaded
   * without any credentials.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webContentLink;

  /**
   * Output only. A link only available on public folders for viewing their static web assets (HTML,
   * CSS, JS, etc) via Google Drive's Website Hosting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webViewLink;

  /**
   * Whether writers can share the document with other users. Not populated for items in shared
   * drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean writersCanShare;

  /**
   * Output only. A link for opening the file in a relevant Google editor or viewer.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlternateLink() {
    return alternateLink;
  }

  /**
   * Output only. A link for opening the file in a relevant Google editor or viewer.
   * @param alternateLink alternateLink or {@code null} for none
   */
  public File setAlternateLink(java.lang.String alternateLink) {
    this.alternateLink = alternateLink;
    return this;
  }

  /**
   * Output only. Whether this file is in the Application Data folder.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAppDataContents() {
    return appDataContents;
  }

  /**
   * Output only. Whether this file is in the Application Data folder.
   * @param appDataContents appDataContents or {@code null} for none
   */
  public File setAppDataContents(java.lang.Boolean appDataContents) {
    this.appDataContents = appDataContents;
    return this;
  }

  /**
   * Output only. Deprecated: Use `capabilities/canComment` instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanComment() {
    return canComment;
  }

  /**
   * Output only. Deprecated: Use `capabilities/canComment` instead.
   * @param canComment canComment or {@code null} for none
   */
  public File setCanComment(java.lang.Boolean canComment) {
    this.canComment = canComment;
    return this;
  }

  /**
   * Output only. Deprecated: Use `capabilities/canReadRevisions` instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanReadRevisions() {
    return canReadRevisions;
  }

  /**
   * Output only. Deprecated: Use `capabilities/canReadRevisions` instead.
   * @param canReadRevisions canReadRevisions or {@code null} for none
   */
  public File setCanReadRevisions(java.lang.Boolean canReadRevisions) {
    this.canReadRevisions = canReadRevisions;
    return this;
  }

  /**
   * Output only. Capabilities the current user has on this file. Each capability corresponds to a
   * fine-grained action that a user may take.
   * @return value or {@code null} for none
   */
  public Capabilities getCapabilities() {
    return capabilities;
  }

  /**
   * Output only. Capabilities the current user has on this file. Each capability corresponds to a
   * fine-grained action that a user may take.
   * @param capabilities capabilities or {@code null} for none
   */
  public File setCapabilities(Capabilities capabilities) {
    this.capabilities = capabilities;
    return this;
  }

  /**
   * Restrictions for accessing the content of the file. Only populated if such a restriction
   * exists.
   * @return value or {@code null} for none
   */
  public java.util.List<ContentRestriction> getContentRestrictions() {
    return contentRestrictions;
  }

  /**
   * Restrictions for accessing the content of the file. Only populated if such a restriction
   * exists.
   * @param contentRestrictions contentRestrictions or {@code null} for none
   */
  public File setContentRestrictions(java.util.List<ContentRestriction> contentRestrictions) {
    this.contentRestrictions = contentRestrictions;
    return this;
  }

  /**
   * Whether the options to copy, print, or download this file, should be disabled for readers and
   * commenters.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCopyRequiresWriterPermission() {
    return copyRequiresWriterPermission;
  }

  /**
   * Whether the options to copy, print, or download this file, should be disabled for readers and
   * commenters.
   * @param copyRequiresWriterPermission copyRequiresWriterPermission or {@code null} for none
   */
  public File setCopyRequiresWriterPermission(java.lang.Boolean copyRequiresWriterPermission) {
    this.copyRequiresWriterPermission = copyRequiresWriterPermission;
    return this;
  }

  /**
   * Output only. Deprecated: Use `capabilities/canCopy` instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCopyable() {
    return copyable;
  }

  /**
   * Output only. Deprecated: Use `capabilities/canCopy` instead.
   * @param copyable copyable or {@code null} for none
   */
  public File setCopyable(java.lang.Boolean copyable) {
    this.copyable = copyable;
    return this;
  }

  /**
   * Create time for this file (formatted RFC 3339 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedDate() {
    return createdDate;
  }

  /**
   * Create time for this file (formatted RFC 3339 timestamp).
   * @param createdDate createdDate or {@code null} for none
   */
  public File setCreatedDate(com.google.api.client.util.DateTime createdDate) {
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Output only. A link to open this file with the user's default app for this file. Only populated
   * when the drive.apps.readonly scope is used.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultOpenWithLink() {
    return defaultOpenWithLink;
  }

  /**
   * Output only. A link to open this file with the user's default app for this file. Only populated
   * when the drive.apps.readonly scope is used.
   * @param defaultOpenWithLink defaultOpenWithLink or {@code null} for none
   */
  public File setDefaultOpenWithLink(java.lang.String defaultOpenWithLink) {
    this.defaultOpenWithLink = defaultOpenWithLink;
    return this;
  }

  /**
   * A short description of the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A short description of the file.
   * @param description description or {@code null} for none
   */
  public File setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Output only. Short lived download URL for the file. This field is only populated for files with
   * content stored in Google Drive; it is not populated for Google Docs or shortcut files.
   * @return value or {@code null} for none
   */
  public java.lang.String getDownloadUrl() {
    return downloadUrl;
  }

  /**
   * Output only. Short lived download URL for the file. This field is only populated for files with
   * content stored in Google Drive; it is not populated for Google Docs or shortcut files.
   * @param downloadUrl downloadUrl or {@code null} for none
   */
  public File setDownloadUrl(java.lang.String downloadUrl) {
    this.downloadUrl = downloadUrl;
    return this;
  }

  /**
   * Output only. ID of the shared drive the file resides in. Only populated for items in shared
   * drives.
   * @return value or {@code null} for none
   */
  public java.lang.String getDriveId() {
    return driveId;
  }

  /**
   * Output only. ID of the shared drive the file resides in. Only populated for items in shared
   * drives.
   * @param driveId driveId or {@code null} for none
   */
  public File setDriveId(java.lang.String driveId) {
    this.driveId = driveId;
    return this;
  }

  /**
   * Output only. Deprecated: Use `capabilities/canEdit` instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEditable() {
    return editable;
  }

  /**
   * Output only. Deprecated: Use `capabilities/canEdit` instead.
   * @param editable editable or {@code null} for none
   */
  public File setEditable(java.lang.Boolean editable) {
    this.editable = editable;
    return this;
  }

  /**
   * Output only. A link for embedding the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmbedLink() {
    return embedLink;
  }

  /**
   * Output only. A link for embedding the file.
   * @param embedLink embedLink or {@code null} for none
   */
  public File setEmbedLink(java.lang.String embedLink) {
    this.embedLink = embedLink;
    return this;
  }

  /**
   * Output only. ETag of the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Output only. ETag of the file.
   * @param etag etag or {@code null} for none
   */
  public File setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Output only. Whether this file has been explicitly trashed, as opposed to recursively trashed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExplicitlyTrashed() {
    return explicitlyTrashed;
  }

  /**
   * Output only. Whether this file has been explicitly trashed, as opposed to recursively trashed.
   * @param explicitlyTrashed explicitlyTrashed or {@code null} for none
   */
  public File setExplicitlyTrashed(java.lang.Boolean explicitlyTrashed) {
    this.explicitlyTrashed = explicitlyTrashed;
    return this;
  }

  /**
   * Output only. Links for exporting Docs Editors files to specific formats.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getExportLinks() {
    return exportLinks;
  }

  /**
   * Output only. Links for exporting Docs Editors files to specific formats.
   * @param exportLinks exportLinks or {@code null} for none
   */
  public File setExportLinks(java.util.Map<String, java.lang.String> exportLinks) {
    this.exportLinks = exportLinks;
    return this;
  }

  /**
   * Output only. The final component of `fullFileExtension` with trailing text that does not appear
   * to be part of the extension removed. This field is only populated for files with content stored
   * in Google Drive; it is not populated for Docs Editors or shortcut files.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileExtension() {
    return fileExtension;
  }

  /**
   * Output only. The final component of `fullFileExtension` with trailing text that does not appear
   * to be part of the extension removed. This field is only populated for files with content stored
   * in Google Drive; it is not populated for Docs Editors or shortcut files.
   * @param fileExtension fileExtension or {@code null} for none
   */
  public File setFileExtension(java.lang.String fileExtension) {
    this.fileExtension = fileExtension;
    return this;
  }

  /**
   * Output only. Size in bytes of blobs and first party editor files. Won't be populated for files
   * that have no size, like shortcuts and folders.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFileSize() {
    return fileSize;
  }

  /**
   * Output only. Size in bytes of blobs and first party editor files. Won't be populated for files
   * that have no size, like shortcuts and folders.
   * @param fileSize fileSize or {@code null} for none
   */
  public File setFileSize(java.lang.Long fileSize) {
    this.fileSize = fileSize;
    return this;
  }

  /**
   * Folder color as an RGB hex string if the file is a folder or a shortcut to a folder. The list
   * of supported colors is available in the folderColorPalette field of the About resource. If an
   * unsupported color is specified, it will be changed to the closest color in the palette.
   * @return value or {@code null} for none
   */
  public java.lang.String getFolderColorRgb() {
    return folderColorRgb;
  }

  /**
   * Folder color as an RGB hex string if the file is a folder or a shortcut to a folder. The list
   * of supported colors is available in the folderColorPalette field of the About resource. If an
   * unsupported color is specified, it will be changed to the closest color in the palette.
   * @param folderColorRgb folderColorRgb or {@code null} for none
   */
  public File setFolderColorRgb(java.lang.String folderColorRgb) {
    this.folderColorRgb = folderColorRgb;
    return this;
  }

  /**
   * Output only. The full file extension; extracted from the title. May contain multiple
   * concatenated extensions, such as "tar.gz". Removing an extension from the title does not clear
   * this field; however, changing the extension on the title does update this field. This field is
   * only populated for files with content stored in Google Drive; it is not populated for Docs
   * Editors or shortcut files.
   * @return value or {@code null} for none
   */
  public java.lang.String getFullFileExtension() {
    return fullFileExtension;
  }

  /**
   * Output only. The full file extension; extracted from the title. May contain multiple
   * concatenated extensions, such as "tar.gz". Removing an extension from the title does not clear
   * this field; however, changing the extension on the title does update this field. This field is
   * only populated for files with content stored in Google Drive; it is not populated for Docs
   * Editors or shortcut files.
   * @param fullFileExtension fullFileExtension or {@code null} for none
   */
  public File setFullFileExtension(java.lang.String fullFileExtension) {
    this.fullFileExtension = fullFileExtension;
    return this;
  }

  /**
   * Output only. Whether there are permissions directly on this file. This field is only populated
   * for items in shared drives.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasAugmentedPermissions() {
    return hasAugmentedPermissions;
  }

  /**
   * Output only. Whether there are permissions directly on this file. This field is only populated
   * for items in shared drives.
   * @param hasAugmentedPermissions hasAugmentedPermissions or {@code null} for none
   */
  public File setHasAugmentedPermissions(java.lang.Boolean hasAugmentedPermissions) {
    this.hasAugmentedPermissions = hasAugmentedPermissions;
    return this;
  }

  /**
   * Output only. Whether this file has a thumbnail. This does not indicate whether the requesting
   * app has access to the thumbnail. To check access, look for the presence of the thumbnailLink
   * field.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasThumbnail() {
    return hasThumbnail;
  }

  /**
   * Output only. Whether this file has a thumbnail. This does not indicate whether the requesting
   * app has access to the thumbnail. To check access, look for the presence of the thumbnailLink
   * field.
   * @param hasThumbnail hasThumbnail or {@code null} for none
   */
  public File setHasThumbnail(java.lang.Boolean hasThumbnail) {
    this.hasThumbnail = hasThumbnail;
    return this;
  }

  /**
   * Output only. The ID of the file's head revision. This field is only populated for files with
   * content stored in Google Drive; it is not populated for Docs Editors or shortcut files.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeadRevisionId() {
    return headRevisionId;
  }

  /**
   * Output only. The ID of the file's head revision. This field is only populated for files with
   * content stored in Google Drive; it is not populated for Docs Editors or shortcut files.
   * @param headRevisionId headRevisionId or {@code null} for none
   */
  public File setHeadRevisionId(java.lang.String headRevisionId) {
    this.headRevisionId = headRevisionId;
    return this;
  }

  /**
   * Output only. A link to the file's icon.
   * @return value or {@code null} for none
   */
  public java.lang.String getIconLink() {
    return iconLink;
  }

  /**
   * Output only. A link to the file's icon.
   * @param iconLink iconLink or {@code null} for none
   */
  public File setIconLink(java.lang.String iconLink) {
    this.iconLink = iconLink;
    return this;
  }

  /**
   * The ID of the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the file.
   * @param id id or {@code null} for none
   */
  public File setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Output only. Metadata about image media. This will only be present for image types, and its
   * contents will depend on what can be parsed from the image content.
   * @return value or {@code null} for none
   */
  public ImageMediaMetadata getImageMediaMetadata() {
    return imageMediaMetadata;
  }

  /**
   * Output only. Metadata about image media. This will only be present for image types, and its
   * contents will depend on what can be parsed from the image content.
   * @param imageMediaMetadata imageMediaMetadata or {@code null} for none
   */
  public File setImageMediaMetadata(ImageMediaMetadata imageMediaMetadata) {
    this.imageMediaMetadata = imageMediaMetadata;
    return this;
  }

  /**
   * Indexable text attributes for the file (can only be written)
   * @return value or {@code null} for none
   */
  public IndexableText getIndexableText() {
    return indexableText;
  }

  /**
   * Indexable text attributes for the file (can only be written)
   * @param indexableText indexableText or {@code null} for none
   */
  public File setIndexableText(IndexableText indexableText) {
    this.indexableText = indexableText;
    return this;
  }

  /**
   * Output only. Whether the file was created or opened by the requesting app.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsAppAuthorized() {
    return isAppAuthorized;
  }

  /**
   * Output only. Whether the file was created or opened by the requesting app.
   * @param isAppAuthorized isAppAuthorized or {@code null} for none
   */
  public File setIsAppAuthorized(java.lang.Boolean isAppAuthorized) {
    this.isAppAuthorized = isAppAuthorized;
    return this;
  }

  /**
   * Output only. The type of file. This is always `drive#file`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Output only. The type of file. This is always `drive#file`.
   * @param kind kind or {@code null} for none
   */
  public File setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Output only. An overview of the labels on the file.
   * @return value or {@code null} for none
   */
  public LabelInfo getLabelInfo() {
    return labelInfo;
  }

  /**
   * Output only. An overview of the labels on the file.
   * @param labelInfo labelInfo or {@code null} for none
   */
  public File setLabelInfo(LabelInfo labelInfo) {
    this.labelInfo = labelInfo;
    return this;
  }

  /**
   * A group of labels for the file.
   * @return value or {@code null} for none
   */
  public Labels getLabels() {
    return labels;
  }

  /**
   * A group of labels for the file.
   * @param labels labels or {@code null} for none
   */
  public File setLabels(Labels labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Output only. The last user to modify this file.
   * @return value or {@code null} for none
   */
  public User getLastModifyingUser() {
    return lastModifyingUser;
  }

  /**
   * Output only. The last user to modify this file.
   * @param lastModifyingUser lastModifyingUser or {@code null} for none
   */
  public File setLastModifyingUser(User lastModifyingUser) {
    this.lastModifyingUser = lastModifyingUser;
    return this;
  }

  /**
   * Output only. Name of the last user to modify this file.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastModifyingUserName() {
    return lastModifyingUserName;
  }

  /**
   * Output only. Name of the last user to modify this file.
   * @param lastModifyingUserName lastModifyingUserName or {@code null} for none
   */
  public File setLastModifyingUserName(java.lang.String lastModifyingUserName) {
    this.lastModifyingUserName = lastModifyingUserName;
    return this;
  }

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastViewedByMeDate() {
    return lastViewedByMeDate;
  }

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * @param lastViewedByMeDate lastViewedByMeDate or {@code null} for none
   */
  public File setLastViewedByMeDate(com.google.api.client.util.DateTime lastViewedByMeDate) {
    this.lastViewedByMeDate = lastViewedByMeDate;
    return this;
  }

  /**
   * Contains details about the link URLs that clients are using to refer to this item.
   * @return value or {@code null} for none
   */
  public LinkShareMetadata getLinkShareMetadata() {
    return linkShareMetadata;
  }

  /**
   * Contains details about the link URLs that clients are using to refer to this item.
   * @param linkShareMetadata linkShareMetadata or {@code null} for none
   */
  public File setLinkShareMetadata(LinkShareMetadata linkShareMetadata) {
    this.linkShareMetadata = linkShareMetadata;
    return this;
  }

  /**
   * Deprecated.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getMarkedViewedByMeDate() {
    return markedViewedByMeDate;
  }

  /**
   * Deprecated.
   * @param markedViewedByMeDate markedViewedByMeDate or {@code null} for none
   */
  public File setMarkedViewedByMeDate(com.google.api.client.util.DateTime markedViewedByMeDate) {
    this.markedViewedByMeDate = markedViewedByMeDate;
    return this;
  }

  /**
   * Output only. An MD5 checksum for the content of this file. This field is only populated for
   * files with content stored in Google Drive; it is not populated for Docs Editors or shortcut
   * files.
   * @return value or {@code null} for none
   */
  public java.lang.String getMd5Checksum() {
    return md5Checksum;
  }

  /**
   * Output only. An MD5 checksum for the content of this file. This field is only populated for
   * files with content stored in Google Drive; it is not populated for Docs Editors or shortcut
   * files.
   * @param md5Checksum md5Checksum or {@code null} for none
   */
  public File setMd5Checksum(java.lang.String md5Checksum) {
    this.md5Checksum = md5Checksum;
    return this;
  }

  /**
   * The MIME type of the file. This is only mutable on update when uploading new content. This
   * field can be left blank, and the mimetype will be determined from the uploaded content's MIME
   * type.
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * The MIME type of the file. This is only mutable on update when uploading new content. This
   * field can be left blank, and the mimetype will be determined from the uploaded content's MIME
   * type.
   * @param mimeType mimeType or {@code null} for none
   */
  public File setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp). Note that setting
   * modifiedDate will also update the modifiedByMe date for the user which set the date.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedByMeDate() {
    return modifiedByMeDate;
  }

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp). Note that setting
   * modifiedDate will also update the modifiedByMe date for the user which set the date.
   * @param modifiedByMeDate modifiedByMeDate or {@code null} for none
   */
  public File setModifiedByMeDate(com.google.api.client.util.DateTime modifiedByMeDate) {
    this.modifiedByMeDate = modifiedByMeDate;
    return this;
  }

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp). This is only mutable
   * on update when the setModifiedDate parameter is set.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedDate() {
    return modifiedDate;
  }

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp). This is only mutable
   * on update when the setModifiedDate parameter is set.
   * @param modifiedDate modifiedDate or {@code null} for none
   */
  public File setModifiedDate(com.google.api.client.util.DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
    return this;
  }

  /**
   * Output only. A map of the id of each of the user's apps to a link to open this file with that
   * app. Only populated when the drive.apps.readonly scope is used.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getOpenWithLinks() {
    return openWithLinks;
  }

  /**
   * Output only. A map of the id of each of the user's apps to a link to open this file with that
   * app. Only populated when the drive.apps.readonly scope is used.
   * @param openWithLinks openWithLinks or {@code null} for none
   */
  public File setOpenWithLinks(java.util.Map<String, java.lang.String> openWithLinks) {
    this.openWithLinks = openWithLinks;
    return this;
  }

  /**
   * The original filename of the uploaded content if available, or else the original value of the
   * `title` field. This is only available for files with binary content in Google Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginalFilename() {
    return originalFilename;
  }

  /**
   * The original filename of the uploaded content if available, or else the original value of the
   * `title` field. This is only available for files with binary content in Google Drive.
   * @param originalFilename originalFilename or {@code null} for none
   */
  public File setOriginalFilename(java.lang.String originalFilename) {
    this.originalFilename = originalFilename;
    return this;
  }

  /**
   * Output only. Whether the file is owned by the current user. Not populated for items in shared
   * drives.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOwnedByMe() {
    return ownedByMe;
  }

  /**
   * Output only. Whether the file is owned by the current user. Not populated for items in shared
   * drives.
   * @param ownedByMe ownedByMe or {@code null} for none
   */
  public File setOwnedByMe(java.lang.Boolean ownedByMe) {
    this.ownedByMe = ownedByMe;
    return this;
  }

  /**
   * Output only. Name(s) of the owner(s) of this file. Not populated for items in shared drives.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getOwnerNames() {
    return ownerNames;
  }

  /**
   * Output only. Name(s) of the owner(s) of this file. Not populated for items in shared drives.
   * @param ownerNames ownerNames or {@code null} for none
   */
  public File setOwnerNames(java.util.List<java.lang.String> ownerNames) {
    this.ownerNames = ownerNames;
    return this;
  }

  /**
   * Output only. The owner of this file. Only certain legacy files may have more than one owner.
   * This field isn't populated for items in shared drives.
   * @return value or {@code null} for none
   */
  public java.util.List<User> getOwners() {
    return owners;
  }

  /**
   * Output only. The owner of this file. Only certain legacy files may have more than one owner.
   * This field isn't populated for items in shared drives.
   * @param owners owners or {@code null} for none
   */
  public File setOwners(java.util.List<User> owners) {
    this.owners = owners;
    return this;
  }

  /**
   * Collection of parent folders which contain this file. If not specified as part of an insert
   * request, the file will be placed directly in the user's My Drive folder. If not specified as
   * part of a copy request, the file will inherit any discoverable parents of the source file.
   * Update requests can also use the `addParents` and `removeParents` parameters to modify the
   * parents list.
   * @return value or {@code null} for none
   */
  public java.util.List<ParentReference> getParents() {
    return parents;
  }

  /**
   * Collection of parent folders which contain this file. If not specified as part of an insert
   * request, the file will be placed directly in the user's My Drive folder. If not specified as
   * part of a copy request, the file will inherit any discoverable parents of the source file.
   * Update requests can also use the `addParents` and `removeParents` parameters to modify the
   * parents list.
   * @param parents parents or {@code null} for none
   */
  public File setParents(java.util.List<ParentReference> parents) {
    this.parents = parents;
    return this;
  }

  /**
   * Output only. List of permission IDs for users with access to this file.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPermissionIds() {
    return permissionIds;
  }

  /**
   * Output only. List of permission IDs for users with access to this file.
   * @param permissionIds permissionIds or {@code null} for none
   */
  public File setPermissionIds(java.util.List<java.lang.String> permissionIds) {
    this.permissionIds = permissionIds;
    return this;
  }

  /**
   * Output only. The list of permissions for users with access to this file. Not populated for
   * items in shared drives.
   * @return value or {@code null} for none
   */
  public java.util.List<Permission> getPermissions() {
    return permissions;
  }

  /**
   * Output only. The list of permissions for users with access to this file. Not populated for
   * items in shared drives.
   * @param permissions permissions or {@code null} for none
   */
  public File setPermissions(java.util.List<Permission> permissions) {
    this.permissions = permissions;
    return this;
  }

  /**
   * The list of properties.
   * @return value or {@code null} for none
   */
  public java.util.List<Property> getProperties() {
    return properties;
  }

  /**
   * The list of properties.
   * @param properties properties or {@code null} for none
   */
  public File setProperties(java.util.List<Property> properties) {
    this.properties = properties;
    return this;
  }

  /**
   * Output only. The number of quota bytes used by this file.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuotaBytesUsed() {
    return quotaBytesUsed;
  }

  /**
   * Output only. The number of quota bytes used by this file.
   * @param quotaBytesUsed quotaBytesUsed or {@code null} for none
   */
  public File setQuotaBytesUsed(java.lang.Long quotaBytesUsed) {
    this.quotaBytesUsed = quotaBytesUsed;
    return this;
  }

  /**
   * Output only. A key needed to access the item via a shared link.
   * @return value or {@code null} for none
   */
  public java.lang.String getResourceKey() {
    return resourceKey;
  }

  /**
   * Output only. A key needed to access the item via a shared link.
   * @param resourceKey resourceKey or {@code null} for none
   */
  public File setResourceKey(java.lang.String resourceKey) {
    this.resourceKey = resourceKey;
    return this;
  }

  /**
   * Output only. A link back to this file.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Output only. A link back to this file.
   * @param selfLink selfLink or {@code null} for none
   */
  public File setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Output only. The SHA1 checksum associated with this file, if available. This field is only
   * populated for files with content stored in Google Drive; it is not populated for Docs Editors
   * or shortcut files.
   * @return value or {@code null} for none
   */
  public java.lang.String getSha1Checksum() {
    return sha1Checksum;
  }

  /**
   * Output only. The SHA1 checksum associated with this file, if available. This field is only
   * populated for files with content stored in Google Drive; it is not populated for Docs Editors
   * or shortcut files.
   * @param sha1Checksum sha1Checksum or {@code null} for none
   */
  public File setSha1Checksum(java.lang.String sha1Checksum) {
    this.sha1Checksum = sha1Checksum;
    return this;
  }

  /**
   * Output only. The SHA256 checksum associated with this file, if available. This field is only
   * populated for files with content stored in Google Drive; it is not populated for Docs Editors
   * or shortcut files.
   * @return value or {@code null} for none
   */
  public java.lang.String getSha256Checksum() {
    return sha256Checksum;
  }

  /**
   * Output only. The SHA256 checksum associated with this file, if available. This field is only
   * populated for files with content stored in Google Drive; it is not populated for Docs Editors
   * or shortcut files.
   * @param sha256Checksum sha256Checksum or {@code null} for none
   */
  public File setSha256Checksum(java.lang.String sha256Checksum) {
    this.sha256Checksum = sha256Checksum;
    return this;
  }

  /**
   * Output only. Deprecated: Use `capabilities/canShare` instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShareable() {
    return shareable;
  }

  /**
   * Output only. Deprecated: Use `capabilities/canShare` instead.
   * @param shareable shareable or {@code null} for none
   */
  public File setShareable(java.lang.Boolean shareable) {
    this.shareable = shareable;
    return this;
  }

  /**
   * Output only. Whether the file has been shared. Not populated for items in shared drives.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShared() {
    return shared;
  }

  /**
   * Output only. Whether the file has been shared. Not populated for items in shared drives.
   * @param shared shared or {@code null} for none
   */
  public File setShared(java.lang.Boolean shared) {
    this.shared = shared;
    return this;
  }

  /**
   * Time at which this file was shared with the user (formatted RFC 3339 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getSharedWithMeDate() {
    return sharedWithMeDate;
  }

  /**
   * Time at which this file was shared with the user (formatted RFC 3339 timestamp).
   * @param sharedWithMeDate sharedWithMeDate or {@code null} for none
   */
  public File setSharedWithMeDate(com.google.api.client.util.DateTime sharedWithMeDate) {
    this.sharedWithMeDate = sharedWithMeDate;
    return this;
  }

  /**
   * Output only. User that shared the item with the current user, if available.
   * @return value or {@code null} for none
   */
  public User getSharingUser() {
    return sharingUser;
  }

  /**
   * Output only. User that shared the item with the current user, if available.
   * @param sharingUser sharingUser or {@code null} for none
   */
  public File setSharingUser(User sharingUser) {
    this.sharingUser = sharingUser;
    return this;
  }

  /**
   * Shortcut file details. Only populated for shortcut files, which have the mimeType field set to
   * `application/vnd.google-apps.shortcut`.
   * @return value or {@code null} for none
   */
  public ShortcutDetails getShortcutDetails() {
    return shortcutDetails;
  }

  /**
   * Shortcut file details. Only populated for shortcut files, which have the mimeType field set to
   * `application/vnd.google-apps.shortcut`.
   * @param shortcutDetails shortcutDetails or {@code null} for none
   */
  public File setShortcutDetails(ShortcutDetails shortcutDetails) {
    this.shortcutDetails = shortcutDetails;
    return this;
  }

  /**
   * Output only. The list of spaces which contain the file. Supported values are `drive`,
   * `appDataFolder` and `photos`.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSpaces() {
    return spaces;
  }

  /**
   * Output only. The list of spaces which contain the file. Supported values are `drive`,
   * `appDataFolder` and `photos`.
   * @param spaces spaces or {@code null} for none
   */
  public File setSpaces(java.util.List<java.lang.String> spaces) {
    this.spaces = spaces;
    return this;
  }

  /**
   * Output only. Deprecated: Use `driveId` instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getTeamDriveId() {
    return teamDriveId;
  }

  /**
   * Output only. Deprecated: Use `driveId` instead.
   * @param teamDriveId teamDriveId or {@code null} for none
   */
  public File setTeamDriveId(java.lang.String teamDriveId) {
    this.teamDriveId = teamDriveId;
    return this;
  }

  /**
   * A thumbnail for the file. This will only be used if a standard thumbnail cannot be generated.
   * @return value or {@code null} for none
   */
  public Thumbnail getThumbnail() {
    return thumbnail;
  }

  /**
   * A thumbnail for the file. This will only be used if a standard thumbnail cannot be generated.
   * @param thumbnail thumbnail or {@code null} for none
   */
  public File setThumbnail(Thumbnail thumbnail) {
    this.thumbnail = thumbnail;
    return this;
  }

  /**
   * Output only. A short-lived link to the file's thumbnail, if available. Typically lasts on the
   * order of hours. Only populated when the requesting app can access the file's content. If the
   * file isn't shared publicly, the URL returned in `Files.thumbnailLink` must be fetched using a
   * credentialed request.
   * @return value or {@code null} for none
   */
  public java.lang.String getThumbnailLink() {
    return thumbnailLink;
  }

  /**
   * Output only. A short-lived link to the file's thumbnail, if available. Typically lasts on the
   * order of hours. Only populated when the requesting app can access the file's content. If the
   * file isn't shared publicly, the URL returned in `Files.thumbnailLink` must be fetched using a
   * credentialed request.
   * @param thumbnailLink thumbnailLink or {@code null} for none
   */
  public File setThumbnailLink(java.lang.String thumbnailLink) {
    this.thumbnailLink = thumbnailLink;
    return this;
  }

  /**
   * Output only. The thumbnail version for use in thumbnail cache invalidation.
   * @return value or {@code null} for none
   */
  public java.lang.Long getThumbnailVersion() {
    return thumbnailVersion;
  }

  /**
   * Output only. The thumbnail version for use in thumbnail cache invalidation.
   * @param thumbnailVersion thumbnailVersion or {@code null} for none
   */
  public File setThumbnailVersion(java.lang.Long thumbnailVersion) {
    this.thumbnailVersion = thumbnailVersion;
    return this;
  }

  /**
   * The title of this file. Note that for immutable items such as the top level folders of shared
   * drives, My Drive root folder, and Application Data folder the title is constant.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title of this file. Note that for immutable items such as the top level folders of shared
   * drives, My Drive root folder, and Application Data folder the title is constant.
   * @param title title or {@code null} for none
   */
  public File setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * The time that the item was trashed (formatted RFC 3339 timestamp). Only populated for items in
   * shared drives.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTrashedDate() {
    return trashedDate;
  }

  /**
   * The time that the item was trashed (formatted RFC 3339 timestamp). Only populated for items in
   * shared drives.
   * @param trashedDate trashedDate or {@code null} for none
   */
  public File setTrashedDate(com.google.api.client.util.DateTime trashedDate) {
    this.trashedDate = trashedDate;
    return this;
  }

  /**
   * Output only. If the file has been explicitly trashed, the user who trashed it. Only populated
   * for items in shared drives.
   * @return value or {@code null} for none
   */
  public User getTrashingUser() {
    return trashingUser;
  }

  /**
   * Output only. If the file has been explicitly trashed, the user who trashed it. Only populated
   * for items in shared drives.
   * @param trashingUser trashingUser or {@code null} for none
   */
  public File setTrashingUser(User trashingUser) {
    this.trashingUser = trashingUser;
    return this;
  }

  /**
   * Output only. The permissions for the authenticated user on this file.
   * @return value or {@code null} for none
   */
  public Permission getUserPermission() {
    return userPermission;
  }

  /**
   * Output only. The permissions for the authenticated user on this file.
   * @param userPermission userPermission or {@code null} for none
   */
  public File setUserPermission(Permission userPermission) {
    this.userPermission = userPermission;
    return this;
  }

  /**
   * Output only. A monotonically increasing version number for the file. This reflects every change
   * made to the file on the server, even those not visible to the requesting user.
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersion() {
    return version;
  }

  /**
   * Output only. A monotonically increasing version number for the file. This reflects every change
   * made to the file on the server, even those not visible to the requesting user.
   * @param version version or {@code null} for none
   */
  public File setVersion(java.lang.Long version) {
    this.version = version;
    return this;
  }

  /**
   * Output only. Metadata about video media. This will only be present for video types.
   * @return value or {@code null} for none
   */
  public VideoMediaMetadata getVideoMediaMetadata() {
    return videoMediaMetadata;
  }

  /**
   * Output only. Metadata about video media. This will only be present for video types.
   * @param videoMediaMetadata videoMediaMetadata or {@code null} for none
   */
  public File setVideoMediaMetadata(VideoMediaMetadata videoMediaMetadata) {
    this.videoMediaMetadata = videoMediaMetadata;
    return this;
  }

  /**
   * Output only. A link for downloading the content of the file in a browser using cookie based
   * authentication. In cases where the content is shared publicly, the content can be downloaded
   * without any credentials.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebContentLink() {
    return webContentLink;
  }

  /**
   * Output only. A link for downloading the content of the file in a browser using cookie based
   * authentication. In cases where the content is shared publicly, the content can be downloaded
   * without any credentials.
   * @param webContentLink webContentLink or {@code null} for none
   */
  public File setWebContentLink(java.lang.String webContentLink) {
    this.webContentLink = webContentLink;
    return this;
  }

  /**
   * Output only. A link only available on public folders for viewing their static web assets (HTML,
   * CSS, JS, etc) via Google Drive's Website Hosting.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebViewLink() {
    return webViewLink;
  }

  /**
   * Output only. A link only available on public folders for viewing their static web assets (HTML,
   * CSS, JS, etc) via Google Drive's Website Hosting.
   * @param webViewLink webViewLink or {@code null} for none
   */
  public File setWebViewLink(java.lang.String webViewLink) {
    this.webViewLink = webViewLink;
    return this;
  }

  /**
   * Whether writers can share the document with other users. Not populated for items in shared
   * drives.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWritersCanShare() {
    return writersCanShare;
  }

  /**
   * Whether writers can share the document with other users. Not populated for items in shared
   * drives.
   * @param writersCanShare writersCanShare or {@code null} for none
   */
  public File setWritersCanShare(java.lang.Boolean writersCanShare) {
    this.writersCanShare = writersCanShare;
    return this;
  }

  @Override
  public File set(String fieldName, Object value) {
    return (File) super.set(fieldName, value);
  }

  @Override
  public File clone() {
    return (File) super.clone();
  }

  /**
   * Output only. Capabilities the current user has on this file. Each capability corresponds to a
   * fine-grained action that a user may take.
   */
  public static final class Capabilities extends com.google.api.client.json.GenericJson {

    /**
     * Output only. Whether the current user is the pending owner of the file. Not populated for
     * shared drive files.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canAcceptOwnership;

    /**
     * Output only. Whether the current user can add children to this folder. This is always false
     * when the item is not a folder.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canAddChildren;

    /**
     * Output only. Whether the current user can add a folder from another drive (different shared
     * drive or My Drive) to this folder. This is false when the item is not a folder. Only populated
     * for items in shared drives.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canAddFolderFromAnotherDrive;

    /**
     * Output only. Whether the current user can add a parent for the item without removing an
     * existing parent in the same request. Not populated for shared drive files.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canAddMyDriveParent;

    /**
     * Output only. Whether the current user can change the `copyRequiresWriterPermission` restriction
     * of this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canChangeCopyRequiresWriterPermission;

    /**
     * Output only. Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canChangeRestrictedDownload;

    /**
     * Output only. Whether the current user can change the securityUpdateEnabled field on link share
     * metadata.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canChangeSecurityUpdateEnabled;

    /**
     * Output only. Whether the current user can comment on this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canComment;

    /**
     * Output only. Whether the current user can copy this file. For an item in a shared drive,
     * whether the current user can copy non-folder descendants of this item, or this item itself if
     * it is not a folder.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canCopy;

    /**
     * Output only. Whether the current user can delete this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canDelete;

    /**
     * Output only. Whether the current user can delete children of this folder. This is false when
     * the item is not a folder. Only populated for items in shared drives.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canDeleteChildren;

    /**
     * Output only. Whether the current user can download this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canDownload;

    /**
     * Output only. Whether the current user can edit this file. Other factors may limit the type of
     * changes a user can make to a file. For example, see `canChangeCopyRequiresWriterPermission` or
     * `canModifyContent`.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canEdit;

    /**
     * Output only. Whether the current user can list the children of this folder. This is always
     * false when the item is not a folder.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canListChildren;

    /**
     * Output only. Whether the current user can modify the content of this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canModifyContent;

    /**
     * Deprecated: Output only. Use one of `canModifyEditorContentRestriction`,
     * `canModifyOwnerContentRestriction` or `canRemoveContentRestriction`.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canModifyContentRestriction;

    /**
     * Output only. Whether the current user can add or modify content restrictions on the file which
     * are editor restricted.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canModifyEditorContentRestriction;

    /**
     * Output only. Whether the current user can modify the labels on the file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canModifyLabels;

    /**
     * Output only. Whether the current user can add or modify content restrictions which are owner
     * restricted.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canModifyOwnerContentRestriction;

    /**
     * Output only. Whether the current user can move children of this folder outside of the shared
     * drive. This is false when the item is not a folder. Only populated for items in shared drives.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveChildrenOutOfDrive;

    /**
     * Output only. Deprecated: Use `canMoveChildrenOutOfDrive` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveChildrenOutOfTeamDrive;

    /**
     * Output only. Whether the current user can move children of this folder within this drive. This
     * is false when the item is not a folder. Note that a request to move the child may still fail
     * depending on the current user's access to the child and to the destination folder.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveChildrenWithinDrive;

    /**
     * Output only. Deprecated: Use `canMoveChildrenWithinDrive` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveChildrenWithinTeamDrive;

    /**
     * Output only. Deprecated: Use `canMoveItemOutOfDrive` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveItemIntoTeamDrive;

    /**
     * Output only. Whether the current user can move this item outside of this drive by changing its
     * parent. Note that a request to change the parent of the item may still fail depending on the
     * new parent that is being added.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveItemOutOfDrive;

    /**
     * Output only. Deprecated: Use `canMoveItemOutOfDrive` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveItemOutOfTeamDrive;

    /**
     * Output only. Whether the current user can move this item within this drive. Note that a request
     * to change the parent of the item may still fail depending on the new parent that is being added
     * and the parent that is being removed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveItemWithinDrive;

    /**
     * Output only. Deprecated: Use `canMoveItemWithinDrive` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveItemWithinTeamDrive;

    /**
     * Output only. Deprecated: Use `canMoveItemWithinDrive` or `canMoveItemOutOfDrive` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveTeamDriveItem;

    /**
     * Output only. Whether the current user can read the shared drive to which this file belongs.
     * Only populated for items in shared drives.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canReadDrive;

    /**
     * Output only. Whether the current user can read the labels on the file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canReadLabels;

    /**
     * Output only. Whether the current user can read the revisions resource of this file. For a
     * shared drive item, whether revisions of non-folder descendants of this item, or this item
     * itself if it is not a folder, can be read.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canReadRevisions;

    /**
     * Output only. Deprecated: Use `canReadDrive` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canReadTeamDrive;

    /**
     * Output only. Whether the current user can remove children from this folder. This is always
     * false when the item is not a folder. For a folder in a shared drive, use `canDeleteChildren` or
     * `canTrashChildren` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canRemoveChildren;

    /**
     * Output only. Whether there is a content restriction on the file that can be removed by the
     * current user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canRemoveContentRestriction;

    /**
     * Output only. Whether the current user can remove a parent from the item without adding another
     * parent in the same request. Not populated for shared drive files.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canRemoveMyDriveParent;

    /**
     * Output only. Whether the current user can rename this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canRename;

    /**
     * Output only. Whether the current user can modify the sharing settings for this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canShare;

    /**
     * Output only. Whether the current user can move this file to trash.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canTrash;

    /**
     * Output only. Whether the current user can trash children of this folder. This is false when the
     * item is not a folder. Only populated for items in shared drives.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canTrashChildren;

    /**
     * Output only. Whether the current user can restore this file from trash.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canUntrash;

    /**
     * Output only. Whether the current user is the pending owner of the file. Not populated for
     * shared drive files.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanAcceptOwnership() {
      return canAcceptOwnership;
    }

    /**
     * Output only. Whether the current user is the pending owner of the file. Not populated for
     * shared drive files.
     * @param canAcceptOwnership canAcceptOwnership or {@code null} for none
     */
    public Capabilities setCanAcceptOwnership(java.lang.Boolean canAcceptOwnership) {
      this.canAcceptOwnership = canAcceptOwnership;
      return this;
    }

    /**
     * Output only. Whether the current user can add children to this folder. This is always false
     * when the item is not a folder.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanAddChildren() {
      return canAddChildren;
    }

    /**
     * Output only. Whether the current user can add children to this folder. This is always false
     * when the item is not a folder.
     * @param canAddChildren canAddChildren or {@code null} for none
     */
    public Capabilities setCanAddChildren(java.lang.Boolean canAddChildren) {
      this.canAddChildren = canAddChildren;
      return this;
    }

    /**
     * Output only. Whether the current user can add a folder from another drive (different shared
     * drive or My Drive) to this folder. This is false when the item is not a folder. Only populated
     * for items in shared drives.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanAddFolderFromAnotherDrive() {
      return canAddFolderFromAnotherDrive;
    }

    /**
     * Output only. Whether the current user can add a folder from another drive (different shared
     * drive or My Drive) to this folder. This is false when the item is not a folder. Only populated
     * for items in shared drives.
     * @param canAddFolderFromAnotherDrive canAddFolderFromAnotherDrive or {@code null} for none
     */
    public Capabilities setCanAddFolderFromAnotherDrive(java.lang.Boolean canAddFolderFromAnotherDrive) {
      this.canAddFolderFromAnotherDrive = canAddFolderFromAnotherDrive;
      return this;
    }

    /**
     * Output only. Whether the current user can add a parent for the item without removing an
     * existing parent in the same request. Not populated for shared drive files.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanAddMyDriveParent() {
      return canAddMyDriveParent;
    }

    /**
     * Output only. Whether the current user can add a parent for the item without removing an
     * existing parent in the same request. Not populated for shared drive files.
     * @param canAddMyDriveParent canAddMyDriveParent or {@code null} for none
     */
    public Capabilities setCanAddMyDriveParent(java.lang.Boolean canAddMyDriveParent) {
      this.canAddMyDriveParent = canAddMyDriveParent;
      return this;
    }

    /**
     * Output only. Whether the current user can change the `copyRequiresWriterPermission` restriction
     * of this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanChangeCopyRequiresWriterPermission() {
      return canChangeCopyRequiresWriterPermission;
    }

    /**
     * Output only. Whether the current user can change the `copyRequiresWriterPermission` restriction
     * of this file.
     * @param canChangeCopyRequiresWriterPermission canChangeCopyRequiresWriterPermission or {@code null} for none
     */
    public Capabilities setCanChangeCopyRequiresWriterPermission(java.lang.Boolean canChangeCopyRequiresWriterPermission) {
      this.canChangeCopyRequiresWriterPermission = canChangeCopyRequiresWriterPermission;
      return this;
    }

    /**
     * Output only. Deprecated.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanChangeRestrictedDownload() {
      return canChangeRestrictedDownload;
    }

    /**
     * Output only. Deprecated.
     * @param canChangeRestrictedDownload canChangeRestrictedDownload or {@code null} for none
     */
    public Capabilities setCanChangeRestrictedDownload(java.lang.Boolean canChangeRestrictedDownload) {
      this.canChangeRestrictedDownload = canChangeRestrictedDownload;
      return this;
    }

    /**
     * Output only. Whether the current user can change the securityUpdateEnabled field on link share
     * metadata.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanChangeSecurityUpdateEnabled() {
      return canChangeSecurityUpdateEnabled;
    }

    /**
     * Output only. Whether the current user can change the securityUpdateEnabled field on link share
     * metadata.
     * @param canChangeSecurityUpdateEnabled canChangeSecurityUpdateEnabled or {@code null} for none
     */
    public Capabilities setCanChangeSecurityUpdateEnabled(java.lang.Boolean canChangeSecurityUpdateEnabled) {
      this.canChangeSecurityUpdateEnabled = canChangeSecurityUpdateEnabled;
      return this;
    }

    /**
     * Output only. Whether the current user can comment on this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanComment() {
      return canComment;
    }

    /**
     * Output only. Whether the current user can comment on this file.
     * @param canComment canComment or {@code null} for none
     */
    public Capabilities setCanComment(java.lang.Boolean canComment) {
      this.canComment = canComment;
      return this;
    }

    /**
     * Output only. Whether the current user can copy this file. For an item in a shared drive,
     * whether the current user can copy non-folder descendants of this item, or this item itself if
     * it is not a folder.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanCopy() {
      return canCopy;
    }

    /**
     * Output only. Whether the current user can copy this file. For an item in a shared drive,
     * whether the current user can copy non-folder descendants of this item, or this item itself if
     * it is not a folder.
     * @param canCopy canCopy or {@code null} for none
     */
    public Capabilities setCanCopy(java.lang.Boolean canCopy) {
      this.canCopy = canCopy;
      return this;
    }

    /**
     * Output only. Whether the current user can delete this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanDelete() {
      return canDelete;
    }

    /**
     * Output only. Whether the current user can delete this file.
     * @param canDelete canDelete or {@code null} for none
     */
    public Capabilities setCanDelete(java.lang.Boolean canDelete) {
      this.canDelete = canDelete;
      return this;
    }

    /**
     * Output only. Whether the current user can delete children of this folder. This is false when
     * the item is not a folder. Only populated for items in shared drives.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanDeleteChildren() {
      return canDeleteChildren;
    }

    /**
     * Output only. Whether the current user can delete children of this folder. This is false when
     * the item is not a folder. Only populated for items in shared drives.
     * @param canDeleteChildren canDeleteChildren or {@code null} for none
     */
    public Capabilities setCanDeleteChildren(java.lang.Boolean canDeleteChildren) {
      this.canDeleteChildren = canDeleteChildren;
      return this;
    }

    /**
     * Output only. Whether the current user can download this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanDownload() {
      return canDownload;
    }

    /**
     * Output only. Whether the current user can download this file.
     * @param canDownload canDownload or {@code null} for none
     */
    public Capabilities setCanDownload(java.lang.Boolean canDownload) {
      this.canDownload = canDownload;
      return this;
    }

    /**
     * Output only. Whether the current user can edit this file. Other factors may limit the type of
     * changes a user can make to a file. For example, see `canChangeCopyRequiresWriterPermission` or
     * `canModifyContent`.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanEdit() {
      return canEdit;
    }

    /**
     * Output only. Whether the current user can edit this file. Other factors may limit the type of
     * changes a user can make to a file. For example, see `canChangeCopyRequiresWriterPermission` or
     * `canModifyContent`.
     * @param canEdit canEdit or {@code null} for none
     */
    public Capabilities setCanEdit(java.lang.Boolean canEdit) {
      this.canEdit = canEdit;
      return this;
    }

    /**
     * Output only. Whether the current user can list the children of this folder. This is always
     * false when the item is not a folder.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanListChildren() {
      return canListChildren;
    }

    /**
     * Output only. Whether the current user can list the children of this folder. This is always
     * false when the item is not a folder.
     * @param canListChildren canListChildren or {@code null} for none
     */
    public Capabilities setCanListChildren(java.lang.Boolean canListChildren) {
      this.canListChildren = canListChildren;
      return this;
    }

    /**
     * Output only. Whether the current user can modify the content of this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanModifyContent() {
      return canModifyContent;
    }

    /**
     * Output only. Whether the current user can modify the content of this file.
     * @param canModifyContent canModifyContent or {@code null} for none
     */
    public Capabilities setCanModifyContent(java.lang.Boolean canModifyContent) {
      this.canModifyContent = canModifyContent;
      return this;
    }

    /**
     * Deprecated: Output only. Use one of `canModifyEditorContentRestriction`,
     * `canModifyOwnerContentRestriction` or `canRemoveContentRestriction`.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanModifyContentRestriction() {
      return canModifyContentRestriction;
    }

    /**
     * Deprecated: Output only. Use one of `canModifyEditorContentRestriction`,
     * `canModifyOwnerContentRestriction` or `canRemoveContentRestriction`.
     * @param canModifyContentRestriction canModifyContentRestriction or {@code null} for none
     */
    public Capabilities setCanModifyContentRestriction(java.lang.Boolean canModifyContentRestriction) {
      this.canModifyContentRestriction = canModifyContentRestriction;
      return this;
    }

    /**
     * Output only. Whether the current user can add or modify content restrictions on the file which
     * are editor restricted.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanModifyEditorContentRestriction() {
      return canModifyEditorContentRestriction;
    }

    /**
     * Output only. Whether the current user can add or modify content restrictions on the file which
     * are editor restricted.
     * @param canModifyEditorContentRestriction canModifyEditorContentRestriction or {@code null} for none
     */
    public Capabilities setCanModifyEditorContentRestriction(java.lang.Boolean canModifyEditorContentRestriction) {
      this.canModifyEditorContentRestriction = canModifyEditorContentRestriction;
      return this;
    }

    /**
     * Output only. Whether the current user can modify the labels on the file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanModifyLabels() {
      return canModifyLabels;
    }

    /**
     * Output only. Whether the current user can modify the labels on the file.
     * @param canModifyLabels canModifyLabels or {@code null} for none
     */
    public Capabilities setCanModifyLabels(java.lang.Boolean canModifyLabels) {
      this.canModifyLabels = canModifyLabels;
      return this;
    }

    /**
     * Output only. Whether the current user can add or modify content restrictions which are owner
     * restricted.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanModifyOwnerContentRestriction() {
      return canModifyOwnerContentRestriction;
    }

    /**
     * Output only. Whether the current user can add or modify content restrictions which are owner
     * restricted.
     * @param canModifyOwnerContentRestriction canModifyOwnerContentRestriction or {@code null} for none
     */
    public Capabilities setCanModifyOwnerContentRestriction(java.lang.Boolean canModifyOwnerContentRestriction) {
      this.canModifyOwnerContentRestriction = canModifyOwnerContentRestriction;
      return this;
    }

    /**
     * Output only. Whether the current user can move children of this folder outside of the shared
     * drive. This is false when the item is not a folder. Only populated for items in shared drives.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveChildrenOutOfDrive() {
      return canMoveChildrenOutOfDrive;
    }

    /**
     * Output only. Whether the current user can move children of this folder outside of the shared
     * drive. This is false when the item is not a folder. Only populated for items in shared drives.
     * @param canMoveChildrenOutOfDrive canMoveChildrenOutOfDrive or {@code null} for none
     */
    public Capabilities setCanMoveChildrenOutOfDrive(java.lang.Boolean canMoveChildrenOutOfDrive) {
      this.canMoveChildrenOutOfDrive = canMoveChildrenOutOfDrive;
      return this;
    }

    /**
     * Output only. Deprecated: Use `canMoveChildrenOutOfDrive` instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveChildrenOutOfTeamDrive() {
      return canMoveChildrenOutOfTeamDrive;
    }

    /**
     * Output only. Deprecated: Use `canMoveChildrenOutOfDrive` instead.
     * @param canMoveChildrenOutOfTeamDrive canMoveChildrenOutOfTeamDrive or {@code null} for none
     */
    public Capabilities setCanMoveChildrenOutOfTeamDrive(java.lang.Boolean canMoveChildrenOutOfTeamDrive) {
      this.canMoveChildrenOutOfTeamDrive = canMoveChildrenOutOfTeamDrive;
      return this;
    }

    /**
     * Output only. Whether the current user can move children of this folder within this drive. This
     * is false when the item is not a folder. Note that a request to move the child may still fail
     * depending on the current user's access to the child and to the destination folder.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveChildrenWithinDrive() {
      return canMoveChildrenWithinDrive;
    }

    /**
     * Output only. Whether the current user can move children of this folder within this drive. This
     * is false when the item is not a folder. Note that a request to move the child may still fail
     * depending on the current user's access to the child and to the destination folder.
     * @param canMoveChildrenWithinDrive canMoveChildrenWithinDrive or {@code null} for none
     */
    public Capabilities setCanMoveChildrenWithinDrive(java.lang.Boolean canMoveChildrenWithinDrive) {
      this.canMoveChildrenWithinDrive = canMoveChildrenWithinDrive;
      return this;
    }

    /**
     * Output only. Deprecated: Use `canMoveChildrenWithinDrive` instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveChildrenWithinTeamDrive() {
      return canMoveChildrenWithinTeamDrive;
    }

    /**
     * Output only. Deprecated: Use `canMoveChildrenWithinDrive` instead.
     * @param canMoveChildrenWithinTeamDrive canMoveChildrenWithinTeamDrive or {@code null} for none
     */
    public Capabilities setCanMoveChildrenWithinTeamDrive(java.lang.Boolean canMoveChildrenWithinTeamDrive) {
      this.canMoveChildrenWithinTeamDrive = canMoveChildrenWithinTeamDrive;
      return this;
    }

    /**
     * Output only. Deprecated: Use `canMoveItemOutOfDrive` instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveItemIntoTeamDrive() {
      return canMoveItemIntoTeamDrive;
    }

    /**
     * Output only. Deprecated: Use `canMoveItemOutOfDrive` instead.
     * @param canMoveItemIntoTeamDrive canMoveItemIntoTeamDrive or {@code null} for none
     */
    public Capabilities setCanMoveItemIntoTeamDrive(java.lang.Boolean canMoveItemIntoTeamDrive) {
      this.canMoveItemIntoTeamDrive = canMoveItemIntoTeamDrive;
      return this;
    }

    /**
     * Output only. Whether the current user can move this item outside of this drive by changing its
     * parent. Note that a request to change the parent of the item may still fail depending on the
     * new parent that is being added.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveItemOutOfDrive() {
      return canMoveItemOutOfDrive;
    }

    /**
     * Output only. Whether the current user can move this item outside of this drive by changing its
     * parent. Note that a request to change the parent of the item may still fail depending on the
     * new parent that is being added.
     * @param canMoveItemOutOfDrive canMoveItemOutOfDrive or {@code null} for none
     */
    public Capabilities setCanMoveItemOutOfDrive(java.lang.Boolean canMoveItemOutOfDrive) {
      this.canMoveItemOutOfDrive = canMoveItemOutOfDrive;
      return this;
    }

    /**
     * Output only. Deprecated: Use `canMoveItemOutOfDrive` instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveItemOutOfTeamDrive() {
      return canMoveItemOutOfTeamDrive;
    }

    /**
     * Output only. Deprecated: Use `canMoveItemOutOfDrive` instead.
     * @param canMoveItemOutOfTeamDrive canMoveItemOutOfTeamDrive or {@code null} for none
     */
    public Capabilities setCanMoveItemOutOfTeamDrive(java.lang.Boolean canMoveItemOutOfTeamDrive) {
      this.canMoveItemOutOfTeamDrive = canMoveItemOutOfTeamDrive;
      return this;
    }

    /**
     * Output only. Whether the current user can move this item within this drive. Note that a request
     * to change the parent of the item may still fail depending on the new parent that is being added
     * and the parent that is being removed.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveItemWithinDrive() {
      return canMoveItemWithinDrive;
    }

    /**
     * Output only. Whether the current user can move this item within this drive. Note that a request
     * to change the parent of the item may still fail depending on the new parent that is being added
     * and the parent that is being removed.
     * @param canMoveItemWithinDrive canMoveItemWithinDrive or {@code null} for none
     */
    public Capabilities setCanMoveItemWithinDrive(java.lang.Boolean canMoveItemWithinDrive) {
      this.canMoveItemWithinDrive = canMoveItemWithinDrive;
      return this;
    }

    /**
     * Output only. Deprecated: Use `canMoveItemWithinDrive` instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveItemWithinTeamDrive() {
      return canMoveItemWithinTeamDrive;
    }

    /**
     * Output only. Deprecated: Use `canMoveItemWithinDrive` instead.
     * @param canMoveItemWithinTeamDrive canMoveItemWithinTeamDrive or {@code null} for none
     */
    public Capabilities setCanMoveItemWithinTeamDrive(java.lang.Boolean canMoveItemWithinTeamDrive) {
      this.canMoveItemWithinTeamDrive = canMoveItemWithinTeamDrive;
      return this;
    }

    /**
     * Output only. Deprecated: Use `canMoveItemWithinDrive` or `canMoveItemOutOfDrive` instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveTeamDriveItem() {
      return canMoveTeamDriveItem;
    }

    /**
     * Output only. Deprecated: Use `canMoveItemWithinDrive` or `canMoveItemOutOfDrive` instead.
     * @param canMoveTeamDriveItem canMoveTeamDriveItem or {@code null} for none
     */
    public Capabilities setCanMoveTeamDriveItem(java.lang.Boolean canMoveTeamDriveItem) {
      this.canMoveTeamDriveItem = canMoveTeamDriveItem;
      return this;
    }

    /**
     * Output only. Whether the current user can read the shared drive to which this file belongs.
     * Only populated for items in shared drives.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanReadDrive() {
      return canReadDrive;
    }

    /**
     * Output only. Whether the current user can read the shared drive to which this file belongs.
     * Only populated for items in shared drives.
     * @param canReadDrive canReadDrive or {@code null} for none
     */
    public Capabilities setCanReadDrive(java.lang.Boolean canReadDrive) {
      this.canReadDrive = canReadDrive;
      return this;
    }

    /**
     * Output only. Whether the current user can read the labels on the file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanReadLabels() {
      return canReadLabels;
    }

    /**
     * Output only. Whether the current user can read the labels on the file.
     * @param canReadLabels canReadLabels or {@code null} for none
     */
    public Capabilities setCanReadLabels(java.lang.Boolean canReadLabels) {
      this.canReadLabels = canReadLabels;
      return this;
    }

    /**
     * Output only. Whether the current user can read the revisions resource of this file. For a
     * shared drive item, whether revisions of non-folder descendants of this item, or this item
     * itself if it is not a folder, can be read.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanReadRevisions() {
      return canReadRevisions;
    }

    /**
     * Output only. Whether the current user can read the revisions resource of this file. For a
     * shared drive item, whether revisions of non-folder descendants of this item, or this item
     * itself if it is not a folder, can be read.
     * @param canReadRevisions canReadRevisions or {@code null} for none
     */
    public Capabilities setCanReadRevisions(java.lang.Boolean canReadRevisions) {
      this.canReadRevisions = canReadRevisions;
      return this;
    }

    /**
     * Output only. Deprecated: Use `canReadDrive` instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanReadTeamDrive() {
      return canReadTeamDrive;
    }

    /**
     * Output only. Deprecated: Use `canReadDrive` instead.
     * @param canReadTeamDrive canReadTeamDrive or {@code null} for none
     */
    public Capabilities setCanReadTeamDrive(java.lang.Boolean canReadTeamDrive) {
      this.canReadTeamDrive = canReadTeamDrive;
      return this;
    }

    /**
     * Output only. Whether the current user can remove children from this folder. This is always
     * false when the item is not a folder. For a folder in a shared drive, use `canDeleteChildren` or
     * `canTrashChildren` instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanRemoveChildren() {
      return canRemoveChildren;
    }

    /**
     * Output only. Whether the current user can remove children from this folder. This is always
     * false when the item is not a folder. For a folder in a shared drive, use `canDeleteChildren` or
     * `canTrashChildren` instead.
     * @param canRemoveChildren canRemoveChildren or {@code null} for none
     */
    public Capabilities setCanRemoveChildren(java.lang.Boolean canRemoveChildren) {
      this.canRemoveChildren = canRemoveChildren;
      return this;
    }

    /**
     * Output only. Whether there is a content restriction on the file that can be removed by the
     * current user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanRemoveContentRestriction() {
      return canRemoveContentRestriction;
    }

    /**
     * Output only. Whether there is a content restriction on the file that can be removed by the
     * current user.
     * @param canRemoveContentRestriction canRemoveContentRestriction or {@code null} for none
     */
    public Capabilities setCanRemoveContentRestriction(java.lang.Boolean canRemoveContentRestriction) {
      this.canRemoveContentRestriction = canRemoveContentRestriction;
      return this;
    }

    /**
     * Output only. Whether the current user can remove a parent from the item without adding another
     * parent in the same request. Not populated for shared drive files.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanRemoveMyDriveParent() {
      return canRemoveMyDriveParent;
    }

    /**
     * Output only. Whether the current user can remove a parent from the item without adding another
     * parent in the same request. Not populated for shared drive files.
     * @param canRemoveMyDriveParent canRemoveMyDriveParent or {@code null} for none
     */
    public Capabilities setCanRemoveMyDriveParent(java.lang.Boolean canRemoveMyDriveParent) {
      this.canRemoveMyDriveParent = canRemoveMyDriveParent;
      return this;
    }

    /**
     * Output only. Whether the current user can rename this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanRename() {
      return canRename;
    }

    /**
     * Output only. Whether the current user can rename this file.
     * @param canRename canRename or {@code null} for none
     */
    public Capabilities setCanRename(java.lang.Boolean canRename) {
      this.canRename = canRename;
      return this;
    }

    /**
     * Output only. Whether the current user can modify the sharing settings for this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanShare() {
      return canShare;
    }

    /**
     * Output only. Whether the current user can modify the sharing settings for this file.
     * @param canShare canShare or {@code null} for none
     */
    public Capabilities setCanShare(java.lang.Boolean canShare) {
      this.canShare = canShare;
      return this;
    }

    /**
     * Output only. Whether the current user can move this file to trash.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanTrash() {
      return canTrash;
    }

    /**
     * Output only. Whether the current user can move this file to trash.
     * @param canTrash canTrash or {@code null} for none
     */
    public Capabilities setCanTrash(java.lang.Boolean canTrash) {
      this.canTrash = canTrash;
      return this;
    }

    /**
     * Output only. Whether the current user can trash children of this folder. This is false when the
     * item is not a folder. Only populated for items in shared drives.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanTrashChildren() {
      return canTrashChildren;
    }

    /**
     * Output only. Whether the current user can trash children of this folder. This is false when the
     * item is not a folder. Only populated for items in shared drives.
     * @param canTrashChildren canTrashChildren or {@code null} for none
     */
    public Capabilities setCanTrashChildren(java.lang.Boolean canTrashChildren) {
      this.canTrashChildren = canTrashChildren;
      return this;
    }

    /**
     * Output only. Whether the current user can restore this file from trash.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanUntrash() {
      return canUntrash;
    }

    /**
     * Output only. Whether the current user can restore this file from trash.
     * @param canUntrash canUntrash or {@code null} for none
     */
    public Capabilities setCanUntrash(java.lang.Boolean canUntrash) {
      this.canUntrash = canUntrash;
      return this;
    }

    @Override
    public Capabilities set(String fieldName, Object value) {
      return (Capabilities) super.set(fieldName, value);
    }

    @Override
    public Capabilities clone() {
      return (Capabilities) super.clone();
    }

  }

  /**
   * Output only. Metadata about image media. This will only be present for image types, and its
   * contents will depend on what can be parsed from the image content.
   */
  public static final class ImageMediaMetadata extends com.google.api.client.json.GenericJson {

    /**
     * Output only. The aperture used to create the photo (f-number).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float aperture;

    /**
     * Output only. The make of the camera used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String cameraMake;

    /**
     * Output only. The model of the camera used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String cameraModel;

    /**
     * Output only. The color space of the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String colorSpace;

    /**
     * Output only. The date and time the photo was taken (EXIF format timestamp).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String date;

    /**
     * Output only. The exposure bias of the photo (APEX value).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float exposureBias;

    /**
     * Output only. The exposure mode used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String exposureMode;

    /**
     * Output only. The length of the exposure, in seconds.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float exposureTime;

    /**
     * Output only. Whether a flash was used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean flashUsed;

    /**
     * Output only. The focal length used to create the photo, in millimeters.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float focalLength;

    /**
     * Output only. The height of the image in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer height;

    /**
     * Output only. The ISO speed used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer isoSpeed;

    /**
     * Output only. The lens used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String lens;

    /**
     * Output only. Geographic location information stored in the image.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Location location;

    /**
     * Output only. The smallest f-number of the lens at the focal length used to create the photo
     * (APEX value).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float maxApertureValue;

    /**
     * Output only. The metering mode used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String meteringMode;

    /**
     * Output only. The number of clockwise 90 degree rotations applied from the image's original
     * orientation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer rotation;

    /**
     * Output only. The type of sensor used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String sensor;

    /**
     * Output only. The distance to the subject of the photo, in meters.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer subjectDistance;

    /**
     * Output only. The white balance mode used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String whiteBalance;

    /**
     * Output only. The width of the image in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer width;

    /**
     * Output only. The aperture used to create the photo (f-number).
     * @return value or {@code null} for none
     */
    public java.lang.Float getAperture() {
      return aperture;
    }

    /**
     * Output only. The aperture used to create the photo (f-number).
     * @param aperture aperture or {@code null} for none
     */
    public ImageMediaMetadata setAperture(java.lang.Float aperture) {
      this.aperture = aperture;
      return this;
    }

    /**
     * Output only. The make of the camera used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getCameraMake() {
      return cameraMake;
    }

    /**
     * Output only. The make of the camera used to create the photo.
     * @param cameraMake cameraMake or {@code null} for none
     */
    public ImageMediaMetadata setCameraMake(java.lang.String cameraMake) {
      this.cameraMake = cameraMake;
      return this;
    }

    /**
     * Output only. The model of the camera used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getCameraModel() {
      return cameraModel;
    }

    /**
     * Output only. The model of the camera used to create the photo.
     * @param cameraModel cameraModel or {@code null} for none
     */
    public ImageMediaMetadata setCameraModel(java.lang.String cameraModel) {
      this.cameraModel = cameraModel;
      return this;
    }

    /**
     * Output only. The color space of the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getColorSpace() {
      return colorSpace;
    }

    /**
     * Output only. The color space of the photo.
     * @param colorSpace colorSpace or {@code null} for none
     */
    public ImageMediaMetadata setColorSpace(java.lang.String colorSpace) {
      this.colorSpace = colorSpace;
      return this;
    }

    /**
     * Output only. The date and time the photo was taken (EXIF format timestamp).
     * @return value or {@code null} for none
     */
    public java.lang.String getDate() {
      return date;
    }

    /**
     * Output only. The date and time the photo was taken (EXIF format timestamp).
     * @param date date or {@code null} for none
     */
    public ImageMediaMetadata setDate(java.lang.String date) {
      this.date = date;
      return this;
    }

    /**
     * Output only. The exposure bias of the photo (APEX value).
     * @return value or {@code null} for none
     */
    public java.lang.Float getExposureBias() {
      return exposureBias;
    }

    /**
     * Output only. The exposure bias of the photo (APEX value).
     * @param exposureBias exposureBias or {@code null} for none
     */
    public ImageMediaMetadata setExposureBias(java.lang.Float exposureBias) {
      this.exposureBias = exposureBias;
      return this;
    }

    /**
     * Output only. The exposure mode used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getExposureMode() {
      return exposureMode;
    }

    /**
     * Output only. The exposure mode used to create the photo.
     * @param exposureMode exposureMode or {@code null} for none
     */
    public ImageMediaMetadata setExposureMode(java.lang.String exposureMode) {
      this.exposureMode = exposureMode;
      return this;
    }

    /**
     * Output only. The length of the exposure, in seconds.
     * @return value or {@code null} for none
     */
    public java.lang.Float getExposureTime() {
      return exposureTime;
    }

    /**
     * Output only. The length of the exposure, in seconds.
     * @param exposureTime exposureTime or {@code null} for none
     */
    public ImageMediaMetadata setExposureTime(java.lang.Float exposureTime) {
      this.exposureTime = exposureTime;
      return this;
    }

    /**
     * Output only. Whether a flash was used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getFlashUsed() {
      return flashUsed;
    }

    /**
     * Output only. Whether a flash was used to create the photo.
     * @param flashUsed flashUsed or {@code null} for none
     */
    public ImageMediaMetadata setFlashUsed(java.lang.Boolean flashUsed) {
      this.flashUsed = flashUsed;
      return this;
    }

    /**
     * Output only. The focal length used to create the photo, in millimeters.
     * @return value or {@code null} for none
     */
    public java.lang.Float getFocalLength() {
      return focalLength;
    }

    /**
     * Output only. The focal length used to create the photo, in millimeters.
     * @param focalLength focalLength or {@code null} for none
     */
    public ImageMediaMetadata setFocalLength(java.lang.Float focalLength) {
      this.focalLength = focalLength;
      return this;
    }

    /**
     * Output only. The height of the image in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getHeight() {
      return height;
    }

    /**
     * Output only. The height of the image in pixels.
     * @param height height or {@code null} for none
     */
    public ImageMediaMetadata setHeight(java.lang.Integer height) {
      this.height = height;
      return this;
    }

    /**
     * Output only. The ISO speed used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getIsoSpeed() {
      return isoSpeed;
    }

    /**
     * Output only. The ISO speed used to create the photo.
     * @param isoSpeed isoSpeed or {@code null} for none
     */
    public ImageMediaMetadata setIsoSpeed(java.lang.Integer isoSpeed) {
      this.isoSpeed = isoSpeed;
      return this;
    }

    /**
     * Output only. The lens used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getLens() {
      return lens;
    }

    /**
     * Output only. The lens used to create the photo.
     * @param lens lens or {@code null} for none
     */
    public ImageMediaMetadata setLens(java.lang.String lens) {
      this.lens = lens;
      return this;
    }

    /**
     * Output only. Geographic location information stored in the image.
     * @return value or {@code null} for none
     */
    public Location getLocation() {
      return location;
    }

    /**
     * Output only. Geographic location information stored in the image.
     * @param location location or {@code null} for none
     */
    public ImageMediaMetadata setLocation(Location location) {
      this.location = location;
      return this;
    }

    /**
     * Output only. The smallest f-number of the lens at the focal length used to create the photo
     * (APEX value).
     * @return value or {@code null} for none
     */
    public java.lang.Float getMaxApertureValue() {
      return maxApertureValue;
    }

    /**
     * Output only. The smallest f-number of the lens at the focal length used to create the photo
     * (APEX value).
     * @param maxApertureValue maxApertureValue or {@code null} for none
     */
    public ImageMediaMetadata setMaxApertureValue(java.lang.Float maxApertureValue) {
      this.maxApertureValue = maxApertureValue;
      return this;
    }

    /**
     * Output only. The metering mode used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getMeteringMode() {
      return meteringMode;
    }

    /**
     * Output only. The metering mode used to create the photo.
     * @param meteringMode meteringMode or {@code null} for none
     */
    public ImageMediaMetadata setMeteringMode(java.lang.String meteringMode) {
      this.meteringMode = meteringMode;
      return this;
    }

    /**
     * Output only. The number of clockwise 90 degree rotations applied from the image's original
     * orientation.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getRotation() {
      return rotation;
    }

    /**
     * Output only. The number of clockwise 90 degree rotations applied from the image's original
     * orientation.
     * @param rotation rotation or {@code null} for none
     */
    public ImageMediaMetadata setRotation(java.lang.Integer rotation) {
      this.rotation = rotation;
      return this;
    }

    /**
     * Output only. The type of sensor used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getSensor() {
      return sensor;
    }

    /**
     * Output only. The type of sensor used to create the photo.
     * @param sensor sensor or {@code null} for none
     */
    public ImageMediaMetadata setSensor(java.lang.String sensor) {
      this.sensor = sensor;
      return this;
    }

    /**
     * Output only. The distance to the subject of the photo, in meters.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getSubjectDistance() {
      return subjectDistance;
    }

    /**
     * Output only. The distance to the subject of the photo, in meters.
     * @param subjectDistance subjectDistance or {@code null} for none
     */
    public ImageMediaMetadata setSubjectDistance(java.lang.Integer subjectDistance) {
      this.subjectDistance = subjectDistance;
      return this;
    }

    /**
     * Output only. The white balance mode used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getWhiteBalance() {
      return whiteBalance;
    }

    /**
     * Output only. The white balance mode used to create the photo.
     * @param whiteBalance whiteBalance or {@code null} for none
     */
    public ImageMediaMetadata setWhiteBalance(java.lang.String whiteBalance) {
      this.whiteBalance = whiteBalance;
      return this;
    }

    /**
     * Output only. The width of the image in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getWidth() {
      return width;
    }

    /**
     * Output only. The width of the image in pixels.
     * @param width width or {@code null} for none
     */
    public ImageMediaMetadata setWidth(java.lang.Integer width) {
      this.width = width;
      return this;
    }

    @Override
    public ImageMediaMetadata set(String fieldName, Object value) {
      return (ImageMediaMetadata) super.set(fieldName, value);
    }

    @Override
    public ImageMediaMetadata clone() {
      return (ImageMediaMetadata) super.clone();
    }

    /**
     * Output only. Geographic location information stored in the image.
     */
    public static final class Location extends com.google.api.client.json.GenericJson {

      /**
       * Output only. The altitude stored in the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Double altitude;

      /**
       * Output only. The latitude stored in the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Double latitude;

      /**
       * Output only. The longitude stored in the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Double longitude;

      /**
       * Output only. The altitude stored in the image.
       * @return value or {@code null} for none
       */
      public java.lang.Double getAltitude() {
        return altitude;
      }

      /**
       * Output only. The altitude stored in the image.
       * @param altitude altitude or {@code null} for none
       */
      public Location setAltitude(java.lang.Double altitude) {
        this.altitude = altitude;
        return this;
      }

      /**
       * Output only. The latitude stored in the image.
       * @return value or {@code null} for none
       */
      public java.lang.Double getLatitude() {
        return latitude;
      }

      /**
       * Output only. The latitude stored in the image.
       * @param latitude latitude or {@code null} for none
       */
      public Location setLatitude(java.lang.Double latitude) {
        this.latitude = latitude;
        return this;
      }

      /**
       * Output only. The longitude stored in the image.
       * @return value or {@code null} for none
       */
      public java.lang.Double getLongitude() {
        return longitude;
      }

      /**
       * Output only. The longitude stored in the image.
       * @param longitude longitude or {@code null} for none
       */
      public Location setLongitude(java.lang.Double longitude) {
        this.longitude = longitude;
        return this;
      }

      @Override
      public Location set(String fieldName, Object value) {
        return (Location) super.set(fieldName, value);
      }

      @Override
      public Location clone() {
        return (Location) super.clone();
      }

    }
  }

  /**
   * Indexable text attributes for the file (can only be written)
   */
  public static final class IndexableText extends com.google.api.client.json.GenericJson {

    /**
     * The text to be indexed for this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String text;

    /**
     * The text to be indexed for this file.
     * @return value or {@code null} for none
     */
    public java.lang.String getText() {
      return text;
    }

    /**
     * The text to be indexed for this file.
     * @param text text or {@code null} for none
     */
    public IndexableText setText(java.lang.String text) {
      this.text = text;
      return this;
    }

    @Override
    public IndexableText set(String fieldName, Object value) {
      return (IndexableText) super.set(fieldName, value);
    }

    @Override
    public IndexableText clone() {
      return (IndexableText) super.clone();
    }

  }

  /**
   * Output only. An overview of the labels on the file.
   */
  public static final class LabelInfo extends com.google.api.client.json.GenericJson {

    /**
     * Output only. The set of labels on the file as requested by the label IDs in the `includeLabels`
     * parameter. By default, no labels are returned.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Label> labels;

    /**
     * Output only. The set of labels on the file as requested by the label IDs in the `includeLabels`
     * parameter. By default, no labels are returned.
     * @return value or {@code null} for none
     */
    public java.util.List<Label> getLabels() {
      return labels;
    }

    /**
     * Output only. The set of labels on the file as requested by the label IDs in the `includeLabels`
     * parameter. By default, no labels are returned.
     * @param labels labels or {@code null} for none
     */
    public LabelInfo setLabels(java.util.List<Label> labels) {
      this.labels = labels;
      return this;
    }

    @Override
    public LabelInfo set(String fieldName, Object value) {
      return (LabelInfo) super.set(fieldName, value);
    }

    @Override
    public LabelInfo clone() {
      return (LabelInfo) super.clone();
    }

  }

  /**
   * A group of labels for the file.
   */
  public static final class Labels extends com.google.api.client.json.GenericJson {

    /**
     * Output only. Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean hidden;

    /**
     * Output only. Whether the file has been modified by this user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean modified;

    /**
     * Output only. Deprecated: Use `copyRequiresWriterPermission` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean restricted;

    /**
     * Whether this file is starred by the user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean starred;

    /**
     * Whether this file has been trashed. This label applies to all users accessing the file;
     * however, only owners are allowed to see and untrash files.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean trashed;

    /**
     * Whether this file has been viewed by this user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean viewed;

    /**
     * Output only. Deprecated.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getHidden() {
      return hidden;
    }

    /**
     * Output only. Deprecated.
     * @param hidden hidden or {@code null} for none
     */
    public Labels setHidden(java.lang.Boolean hidden) {
      this.hidden = hidden;
      return this;
    }

    /**
     * Output only. Whether the file has been modified by this user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getModified() {
      return modified;
    }

    /**
     * Output only. Whether the file has been modified by this user.
     * @param modified modified or {@code null} for none
     */
    public Labels setModified(java.lang.Boolean modified) {
      this.modified = modified;
      return this;
    }

    /**
     * Output only. Deprecated: Use `copyRequiresWriterPermission` instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getRestricted() {
      return restricted;
    }

    /**
     * Output only. Deprecated: Use `copyRequiresWriterPermission` instead.
     * @param restricted restricted or {@code null} for none
     */
    public Labels setRestricted(java.lang.Boolean restricted) {
      this.restricted = restricted;
      return this;
    }

    /**
     * Whether this file is starred by the user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getStarred() {
      return starred;
    }

    /**
     * Whether this file is starred by the user.
     * @param starred starred or {@code null} for none
     */
    public Labels setStarred(java.lang.Boolean starred) {
      this.starred = starred;
      return this;
    }

    /**
     * Whether this file has been trashed. This label applies to all users accessing the file;
     * however, only owners are allowed to see and untrash files.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getTrashed() {
      return trashed;
    }

    /**
     * Whether this file has been trashed. This label applies to all users accessing the file;
     * however, only owners are allowed to see and untrash files.
     * @param trashed trashed or {@code null} for none
     */
    public Labels setTrashed(java.lang.Boolean trashed) {
      this.trashed = trashed;
      return this;
    }

    /**
     * Whether this file has been viewed by this user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getViewed() {
      return viewed;
    }

    /**
     * Whether this file has been viewed by this user.
     * @param viewed viewed or {@code null} for none
     */
    public Labels setViewed(java.lang.Boolean viewed) {
      this.viewed = viewed;
      return this;
    }

    @Override
    public Labels set(String fieldName, Object value) {
      return (Labels) super.set(fieldName, value);
    }

    @Override
    public Labels clone() {
      return (Labels) super.clone();
    }

  }

  /**
   * Contains details about the link URLs that clients are using to refer to this item.
   */
  public static final class LinkShareMetadata extends com.google.api.client.json.GenericJson {

    /**
     * Output only. Whether the file is eligible for security update.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean securityUpdateEligible;

    /**
     * Output only. Whether the security update is enabled for this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean securityUpdateEnabled;

    /**
     * Output only. Whether the file is eligible for security update.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getSecurityUpdateEligible() {
      return securityUpdateEligible;
    }

    /**
     * Output only. Whether the file is eligible for security update.
     * @param securityUpdateEligible securityUpdateEligible or {@code null} for none
     */
    public LinkShareMetadata setSecurityUpdateEligible(java.lang.Boolean securityUpdateEligible) {
      this.securityUpdateEligible = securityUpdateEligible;
      return this;
    }

    /**
     * Output only. Whether the security update is enabled for this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getSecurityUpdateEnabled() {
      return securityUpdateEnabled;
    }

    /**
     * Output only. Whether the security update is enabled for this file.
     * @param securityUpdateEnabled securityUpdateEnabled or {@code null} for none
     */
    public LinkShareMetadata setSecurityUpdateEnabled(java.lang.Boolean securityUpdateEnabled) {
      this.securityUpdateEnabled = securityUpdateEnabled;
      return this;
    }

    @Override
    public LinkShareMetadata set(String fieldName, Object value) {
      return (LinkShareMetadata) super.set(fieldName, value);
    }

    @Override
    public LinkShareMetadata clone() {
      return (LinkShareMetadata) super.clone();
    }

  }

  /**
   * Shortcut file details. Only populated for shortcut files, which have the mimeType field set to
   * `application/vnd.google-apps.shortcut`.
   */
  public static final class ShortcutDetails extends com.google.api.client.json.GenericJson {

    /**
     * The ID of the file that this shortcut points to.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String targetId;

    /**
     * Output only. The MIME type of the file that this shortcut points to. The value of this field is
     * a snapshot of the target's MIME type, captured when the shortcut is created.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String targetMimeType;

    /**
     * Output only. The ResourceKey for the target file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String targetResourceKey;

    /**
     * The ID of the file that this shortcut points to.
     * @return value or {@code null} for none
     */
    public java.lang.String getTargetId() {
      return targetId;
    }

    /**
     * The ID of the file that this shortcut points to.
     * @param targetId targetId or {@code null} for none
     */
    public ShortcutDetails setTargetId(java.lang.String targetId) {
      this.targetId = targetId;
      return this;
    }

    /**
     * Output only. The MIME type of the file that this shortcut points to. The value of this field is
     * a snapshot of the target's MIME type, captured when the shortcut is created.
     * @return value or {@code null} for none
     */
    public java.lang.String getTargetMimeType() {
      return targetMimeType;
    }

    /**
     * Output only. The MIME type of the file that this shortcut points to. The value of this field is
     * a snapshot of the target's MIME type, captured when the shortcut is created.
     * @param targetMimeType targetMimeType or {@code null} for none
     */
    public ShortcutDetails setTargetMimeType(java.lang.String targetMimeType) {
      this.targetMimeType = targetMimeType;
      return this;
    }

    /**
     * Output only. The ResourceKey for the target file.
     * @return value or {@code null} for none
     */
    public java.lang.String getTargetResourceKey() {
      return targetResourceKey;
    }

    /**
     * Output only. The ResourceKey for the target file.
     * @param targetResourceKey targetResourceKey or {@code null} for none
     */
    public ShortcutDetails setTargetResourceKey(java.lang.String targetResourceKey) {
      this.targetResourceKey = targetResourceKey;
      return this;
    }

    @Override
    public ShortcutDetails set(String fieldName, Object value) {
      return (ShortcutDetails) super.set(fieldName, value);
    }

    @Override
    public ShortcutDetails clone() {
      return (ShortcutDetails) super.clone();
    }

  }

  /**
   * A thumbnail for the file. This will only be used if a standard thumbnail cannot be generated.
   */
  public static final class Thumbnail extends com.google.api.client.json.GenericJson {

    /**
     * The URL-safe Base64 encoded bytes of the thumbnail image. It should conform to RFC 4648 section
     * 5.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String image;

    /**
     * The MIME type of the thumbnail.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String mimeType;

    /**
     * The URL-safe Base64 encoded bytes of the thumbnail image. It should conform to RFC 4648 section
     * 5.
     * @see #decodeImage()
     * @return value or {@code null} for none
     */
    public java.lang.String getImage() {
      return image;
    }

    /**
     * The URL-safe Base64 encoded bytes of the thumbnail image. It should conform to RFC 4648 section
     * 5.
     * @see #getImage()
     * @return Base64 decoded value or {@code null} for none
     *
     * @since 1.14
     */
    public byte[] decodeImage() {
      return com.google.api.client.util.Base64.decodeBase64(image);
    }

    /**
     * The URL-safe Base64 encoded bytes of the thumbnail image. It should conform to RFC 4648 section
     * 5.
     * @see #encodeImage()
     * @param image image or {@code null} for none
     */
    public Thumbnail setImage(java.lang.String image) {
      this.image = image;
      return this;
    }

    /**
     * The URL-safe Base64 encoded bytes of the thumbnail image. It should conform to RFC 4648 section
     * 5.
     * @see #setImage()
     *
     * <p>
     * The value is encoded Base64 or {@code null} for none.
     * </p>
     *
     * @since 1.14
     */
    public Thumbnail encodeImage(byte[] image) {
      this.image = com.google.api.client.util.Base64.encodeBase64URLSafeString(image);
      return this;
    }

    /**
     * The MIME type of the thumbnail.
     * @return value or {@code null} for none
     */
    public java.lang.String getMimeType() {
      return mimeType;
    }

    /**
     * The MIME type of the thumbnail.
     * @param mimeType mimeType or {@code null} for none
     */
    public Thumbnail setMimeType(java.lang.String mimeType) {
      this.mimeType = mimeType;
      return this;
    }

    @Override
    public Thumbnail set(String fieldName, Object value) {
      return (Thumbnail) super.set(fieldName, value);
    }

    @Override
    public Thumbnail clone() {
      return (Thumbnail) super.clone();
    }

  }

  /**
   * Output only. Metadata about video media. This will only be present for video types.
   */
  public static final class VideoMediaMetadata extends com.google.api.client.json.GenericJson {

    /**
     * Output only. The duration of the video in milliseconds.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long durationMillis;

    /**
     * Output only. The height of the video in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer height;

    /**
     * Output only. The width of the video in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer width;

    /**
     * Output only. The duration of the video in milliseconds.
     * @return value or {@code null} for none
     */
    public java.lang.Long getDurationMillis() {
      return durationMillis;
    }

    /**
     * Output only. The duration of the video in milliseconds.
     * @param durationMillis durationMillis or {@code null} for none
     */
    public VideoMediaMetadata setDurationMillis(java.lang.Long durationMillis) {
      this.durationMillis = durationMillis;
      return this;
    }

    /**
     * Output only. The height of the video in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getHeight() {
      return height;
    }

    /**
     * Output only. The height of the video in pixels.
     * @param height height or {@code null} for none
     */
    public VideoMediaMetadata setHeight(java.lang.Integer height) {
      this.height = height;
      return this;
    }

    /**
     * Output only. The width of the video in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getWidth() {
      return width;
    }

    /**
     * Output only. The width of the video in pixels.
     * @param width width or {@code null} for none
     */
    public VideoMediaMetadata setWidth(java.lang.Integer width) {
      this.width = width;
      return this;
    }

    @Override
    public VideoMediaMetadata set(String fieldName, Object value) {
      return (VideoMediaMetadata) super.set(fieldName, value);
    }

    @Override
    public VideoMediaMetadata clone() {
      return (VideoMediaMetadata) super.clone();
    }

  }

}
