/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Next ID: 5
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DomainSharingSettings extends com.google.api.client.json.GenericJson {

  /**
   * Maximum allowed role when sharing with all users
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxAllUsersRole;

  /**
   * Maximum allowed role when sharing with all users inside the domain
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxDomainRole;

  /**
   * Deprecated - See b/13414050
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shareInPolicy;

  /**
   * Policy for sharing with a user outside the domain
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shareOutPolicy;

  /**
   * Maximum allowed role when sharing with all users
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxAllUsersRole() {
    return maxAllUsersRole;
  }

  /**
   * Maximum allowed role when sharing with all users
   * @param maxAllUsersRole maxAllUsersRole or {@code null} for none
   */
  public DomainSharingSettings setMaxAllUsersRole(java.lang.String maxAllUsersRole) {
    this.maxAllUsersRole = maxAllUsersRole;
    return this;
  }

  /**
   * Maximum allowed role when sharing with all users inside the domain
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxDomainRole() {
    return maxDomainRole;
  }

  /**
   * Maximum allowed role when sharing with all users inside the domain
   * @param maxDomainRole maxDomainRole or {@code null} for none
   */
  public DomainSharingSettings setMaxDomainRole(java.lang.String maxDomainRole) {
    this.maxDomainRole = maxDomainRole;
    return this;
  }

  /**
   * Deprecated - See b/13414050
   * @return value or {@code null} for none
   */
  public java.lang.String getShareInPolicy() {
    return shareInPolicy;
  }

  /**
   * Deprecated - See b/13414050
   * @param shareInPolicy shareInPolicy or {@code null} for none
   */
  public DomainSharingSettings setShareInPolicy(java.lang.String shareInPolicy) {
    this.shareInPolicy = shareInPolicy;
    return this;
  }

  /**
   * Policy for sharing with a user outside the domain
   * @return value or {@code null} for none
   */
  public java.lang.String getShareOutPolicy() {
    return shareOutPolicy;
  }

  /**
   * Policy for sharing with a user outside the domain
   * @param shareOutPolicy shareOutPolicy or {@code null} for none
   */
  public DomainSharingSettings setShareOutPolicy(java.lang.String shareOutPolicy) {
    this.shareOutPolicy = shareOutPolicy;
    return this;
  }

  @Override
  public DomainSharingSettings set(String fieldName, Object value) {
    return (DomainSharingSettings) super.set(fieldName, value);
  }

  @Override
  public DomainSharingSettings clone() {
    return (DomainSharingSettings) super.clone();
  }

}
