/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Next ID: 13
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GenoaUser extends com.google.api.client.json.GenericJson {

  /**
   * The customer id which the user belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customerId;

  /**
   * The domain name of this user or group. As per FlexOrgs M2 compliance, usage of domain is not
   * allowed. This field will continue to exist/be populated with the organization's display name
   * (which is not necessarily the domain) to support mobile clients that use this field for display
   * purposes. For more information please see: b/133505341
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String domain;

  /**
   * The sharing settings for the domain of this user or group. Deprecated, see go/trust-rules-api-
   * surface
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DomainSharingSettings domainSharingSettings;

  /**
   * The email address of the user
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String emailAddress;

  /**
   * The primary email address of the user from GAIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String emailAddressFromGaia;

  /**
   * The user's obfuscated Gaia ID as visible throughout Google APIs
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Whether this user is the same as the user making the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isRequestingUser;

  /**
   * A displayable name for the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The name of the organization that the user belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String organizationDisplayName;

  /**
   * The user's ID as visible in the permissions collection
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String permissionId;

  /**
   * A photo of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Photo photo;

  /**
   * A URL to get more information about the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * The customer id which the user belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomerId() {
    return customerId;
  }

  /**
   * The customer id which the user belongs to.
   * @param customerId customerId or {@code null} for none
   */
  public GenoaUser setCustomerId(java.lang.String customerId) {
    this.customerId = customerId;
    return this;
  }

  /**
   * The domain name of this user or group. As per FlexOrgs M2 compliance, usage of domain is not
   * allowed. This field will continue to exist/be populated with the organization's display name
   * (which is not necessarily the domain) to support mobile clients that use this field for display
   * purposes. For more information please see: b/133505341
   * @return value or {@code null} for none
   */
  public java.lang.String getDomain() {
    return domain;
  }

  /**
   * The domain name of this user or group. As per FlexOrgs M2 compliance, usage of domain is not
   * allowed. This field will continue to exist/be populated with the organization's display name
   * (which is not necessarily the domain) to support mobile clients that use this field for display
   * purposes. For more information please see: b/133505341
   * @param domain domain or {@code null} for none
   */
  public GenoaUser setDomain(java.lang.String domain) {
    this.domain = domain;
    return this;
  }

  /**
   * The sharing settings for the domain of this user or group. Deprecated, see go/trust-rules-api-
   * surface
   * @return value or {@code null} for none
   */
  public DomainSharingSettings getDomainSharingSettings() {
    return domainSharingSettings;
  }

  /**
   * The sharing settings for the domain of this user or group. Deprecated, see go/trust-rules-api-
   * surface
   * @param domainSharingSettings domainSharingSettings or {@code null} for none
   */
  public GenoaUser setDomainSharingSettings(DomainSharingSettings domainSharingSettings) {
    this.domainSharingSettings = domainSharingSettings;
    return this;
  }

  /**
   * The email address of the user
   * @return value or {@code null} for none
   */
  public java.lang.String getEmailAddress() {
    return emailAddress;
  }

  /**
   * The email address of the user
   * @param emailAddress emailAddress or {@code null} for none
   */
  public GenoaUser setEmailAddress(java.lang.String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

  /**
   * The primary email address of the user from GAIA.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmailAddressFromGaia() {
    return emailAddressFromGaia;
  }

  /**
   * The primary email address of the user from GAIA.
   * @param emailAddressFromGaia emailAddressFromGaia or {@code null} for none
   */
  public GenoaUser setEmailAddressFromGaia(java.lang.String emailAddressFromGaia) {
    this.emailAddressFromGaia = emailAddressFromGaia;
    return this;
  }

  /**
   * The user's obfuscated Gaia ID as visible throughout Google APIs
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The user's obfuscated Gaia ID as visible throughout Google APIs
   * @param id id or {@code null} for none
   */
  public GenoaUser setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Whether this user is the same as the user making the request.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsRequestingUser() {
    return isRequestingUser;
  }

  /**
   * Whether this user is the same as the user making the request.
   * @param isRequestingUser isRequestingUser or {@code null} for none
   */
  public GenoaUser setIsRequestingUser(java.lang.Boolean isRequestingUser) {
    this.isRequestingUser = isRequestingUser;
    return this;
  }

  /**
   * A displayable name for the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * A displayable name for the user.
   * @param name name or {@code null} for none
   */
  public GenoaUser setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the organization that the user belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrganizationDisplayName() {
    return organizationDisplayName;
  }

  /**
   * The name of the organization that the user belongs to.
   * @param organizationDisplayName organizationDisplayName or {@code null} for none
   */
  public GenoaUser setOrganizationDisplayName(java.lang.String organizationDisplayName) {
    this.organizationDisplayName = organizationDisplayName;
    return this;
  }

  /**
   * The user's ID as visible in the permissions collection
   * @return value or {@code null} for none
   */
  public java.lang.String getPermissionId() {
    return permissionId;
  }

  /**
   * The user's ID as visible in the permissions collection
   * @param permissionId permissionId or {@code null} for none
   */
  public GenoaUser setPermissionId(java.lang.String permissionId) {
    this.permissionId = permissionId;
    return this;
  }

  /**
   * A photo of the user.
   * @return value or {@code null} for none
   */
  public Photo getPhoto() {
    return photo;
  }

  /**
   * A photo of the user.
   * @param photo photo or {@code null} for none
   */
  public GenoaUser setPhoto(Photo photo) {
    this.photo = photo;
    return this;
  }

  /**
   * A URL to get more information about the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * A URL to get more information about the user.
   * @param url url or {@code null} for none
   */
  public GenoaUser setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  @Override
  public GenoaUser set(String fieldName, Object value) {
    return (GenoaUser) super.set(fieldName, value);
  }

  @Override
  public GenoaUser clone() {
    return (GenoaUser) super.clone();
  }

}
