/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-24 at 02:38:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Information about a Drive user.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class User extends com.google.api.client.json.GenericJson {

  /**
   * A plain text displayable name for this user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The email address of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String emailAddress;

  /**
   * Whether this user is the same as the authenticated user for whom the request was made.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isAuthenticatedUser;

  /**
   * This is always drive#user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The user's ID as visible in the permissions collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String permissionId;

  /**
   * The user's profile picture.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Picture picture;

  /**
   * A plain text displayable name for this user.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * A plain text displayable name for this user.
   * @param displayName displayName or {@code null} for none
   */
  public User setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The email address of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmailAddress() {
    return emailAddress;
  }

  /**
   * The email address of the user.
   * @param emailAddress emailAddress or {@code null} for none
   */
  public User setEmailAddress(java.lang.String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

  /**
   * Whether this user is the same as the authenticated user for whom the request was made.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsAuthenticatedUser() {
    return isAuthenticatedUser;
  }

  /**
   * Whether this user is the same as the authenticated user for whom the request was made.
   * @param isAuthenticatedUser isAuthenticatedUser or {@code null} for none
   */
  public User setIsAuthenticatedUser(java.lang.Boolean isAuthenticatedUser) {
    this.isAuthenticatedUser = isAuthenticatedUser;
    return this;
  }

  /**
   * This is always drive#user.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#user.
   * @param kind kind or {@code null} for none
   */
  public User setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The user's ID as visible in the permissions collection.
   * @return value or {@code null} for none
   */
  public java.lang.String getPermissionId() {
    return permissionId;
  }

  /**
   * The user's ID as visible in the permissions collection.
   * @param permissionId permissionId or {@code null} for none
   */
  public User setPermissionId(java.lang.String permissionId) {
    this.permissionId = permissionId;
    return this;
  }

  /**
   * The user's profile picture.
   * @return value or {@code null} for none
   */
  public Picture getPicture() {
    return picture;
  }

  /**
   * The user's profile picture.
   * @param picture picture or {@code null} for none
   */
  public User setPicture(Picture picture) {
    this.picture = picture;
    return this;
  }

  @Override
  public User set(String fieldName, Object value) {
    return (User) super.set(fieldName, value);
  }

  @Override
  public User clone() {
    return (User) super.clone();
  }

  /**
   * The user's profile picture.
   */
  public static final class Picture extends com.google.api.client.json.GenericJson {

    /**
     * A URL that points to a profile picture of this user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String url;

    /**
     * A URL that points to a profile picture of this user.
     * @return value or {@code null} for none
     */
    public java.lang.String getUrl() {
      return url;
    }

    /**
     * A URL that points to a profile picture of this user.
     * @param url url or {@code null} for none
     */
    public Picture setUrl(java.lang.String url) {
      this.url = url;
      return this;
    }

    @Override
    public Picture set(String fieldName, Object value) {
      return (Picture) super.set(fieldName, value);
    }

    @Override
    public Picture clone() {
      return (Picture) super.clone();
    }

  }
}
