/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-06-05 16:09:48 UTC)
 * on 2013-06-18 at 13:47:28 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * An item with user information and settings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class About extends com.google.api.client.json.GenericJson {

  /**
   * Information about supported additional roles per file type. The most specific type takes
   * precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AdditionalRoleInfo> additionalRoleInfo;

  static {
    // hack to force ProGuard to consider AdditionalRoleInfo used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(AdditionalRoleInfo.class);
  }

  /**
   * The domain sharing policy for the current user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String domainSharingPolicy;

  /**
   * The ETag of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The allowable export formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ExportFormats> exportFormats;

  static {
    // hack to force ProGuard to consider ExportFormats used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ExportFormats.class);
  }

  /**
   * List of additional features enabled on this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Features> features;

  static {
    // hack to force ProGuard to consider Features used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Features.class);
  }

  /**
   * The allowable import formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ImportFormats> importFormats;

  static {
    // hack to force ProGuard to consider ImportFormats used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ImportFormats.class);
  }

  /**
   * A boolean indicating whether the authenticated app is installed by the authenticated user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isCurrentAppInstalled;

  /**
   * This is always drive#about.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The largest change id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long largestChangeId;

  /**
   * List of max upload sizes for each file type. The most specific type takes precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MaxUploadSizes> maxUploadSizes;

  static {
    // hack to force ProGuard to consider MaxUploadSizes used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(MaxUploadSizes.class);
  }

  /**
   * The name of the current user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The current user's ID as visible in the permissions collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String permissionId;

  /**
   * The total number of quota bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long quotaBytesTotal;

  /**
   * The number of quota bytes used by Google Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long quotaBytesUsed;

  /**
   * The number of quota bytes used by all Google apps (Drive, Picasa, etc.).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long quotaBytesUsedAggregate;

  /**
   * The number of quota bytes used by trashed items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long quotaBytesUsedInTrash;

  /**
   * The number of remaining change ids.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long remainingChangeIds;

  /**
   * The id of the root folder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rootFolderId;

  /**
   * A link back to this item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The authenticated user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User user;

  /**
   * Information about supported additional roles per file type. The most specific type takes
   * precedence.
   * @return value or {@code null} for none
   */
  public java.util.List<AdditionalRoleInfo> getAdditionalRoleInfo() {
    return additionalRoleInfo;
  }

  /**
   * Information about supported additional roles per file type. The most specific type takes
   * precedence.
   * @param additionalRoleInfo additionalRoleInfo or {@code null} for none
   */
  public About setAdditionalRoleInfo(java.util.List<AdditionalRoleInfo> additionalRoleInfo) {
    this.additionalRoleInfo = additionalRoleInfo;
    return this;
  }

  /**
   * The domain sharing policy for the current user.
   * @return value or {@code null} for none
   */
  public java.lang.String getDomainSharingPolicy() {
    return domainSharingPolicy;
  }

  /**
   * The domain sharing policy for the current user.
   * @param domainSharingPolicy domainSharingPolicy or {@code null} for none
   */
  public About setDomainSharingPolicy(java.lang.String domainSharingPolicy) {
    this.domainSharingPolicy = domainSharingPolicy;
    return this;
  }

  /**
   * The ETag of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The ETag of the item.
   * @param etag etag or {@code null} for none
   */
  public About setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The allowable export formats.
   * @return value or {@code null} for none
   */
  public java.util.List<ExportFormats> getExportFormats() {
    return exportFormats;
  }

  /**
   * The allowable export formats.
   * @param exportFormats exportFormats or {@code null} for none
   */
  public About setExportFormats(java.util.List<ExportFormats> exportFormats) {
    this.exportFormats = exportFormats;
    return this;
  }

  /**
   * List of additional features enabled on this account.
   * @return value or {@code null} for none
   */
  public java.util.List<Features> getFeatures() {
    return features;
  }

  /**
   * List of additional features enabled on this account.
   * @param features features or {@code null} for none
   */
  public About setFeatures(java.util.List<Features> features) {
    this.features = features;
    return this;
  }

  /**
   * The allowable import formats.
   * @return value or {@code null} for none
   */
  public java.util.List<ImportFormats> getImportFormats() {
    return importFormats;
  }

  /**
   * The allowable import formats.
   * @param importFormats importFormats or {@code null} for none
   */
  public About setImportFormats(java.util.List<ImportFormats> importFormats) {
    this.importFormats = importFormats;
    return this;
  }

  /**
   * A boolean indicating whether the authenticated app is installed by the authenticated user.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsCurrentAppInstalled() {
    return isCurrentAppInstalled;
  }

  /**
   * A boolean indicating whether the authenticated app is installed by the authenticated user.
   * @param isCurrentAppInstalled isCurrentAppInstalled or {@code null} for none
   */
  public About setIsCurrentAppInstalled(java.lang.Boolean isCurrentAppInstalled) {
    this.isCurrentAppInstalled = isCurrentAppInstalled;
    return this;
  }

  /**
   * This is always drive#about.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#about.
   * @param kind kind or {@code null} for none
   */
  public About setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The largest change id.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLargestChangeId() {
    return largestChangeId;
  }

  /**
   * The largest change id.
   * @param largestChangeId largestChangeId or {@code null} for none
   */
  public About setLargestChangeId(java.lang.Long largestChangeId) {
    this.largestChangeId = largestChangeId;
    return this;
  }

  /**
   * List of max upload sizes for each file type. The most specific type takes precedence.
   * @return value or {@code null} for none
   */
  public java.util.List<MaxUploadSizes> getMaxUploadSizes() {
    return maxUploadSizes;
  }

  /**
   * List of max upload sizes for each file type. The most specific type takes precedence.
   * @param maxUploadSizes maxUploadSizes or {@code null} for none
   */
  public About setMaxUploadSizes(java.util.List<MaxUploadSizes> maxUploadSizes) {
    this.maxUploadSizes = maxUploadSizes;
    return this;
  }

  /**
   * The name of the current user.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the current user.
   * @param name name or {@code null} for none
   */
  public About setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The current user's ID as visible in the permissions collection.
   * @return value or {@code null} for none
   */
  public java.lang.String getPermissionId() {
    return permissionId;
  }

  /**
   * The current user's ID as visible in the permissions collection.
   * @param permissionId permissionId or {@code null} for none
   */
  public About setPermissionId(java.lang.String permissionId) {
    this.permissionId = permissionId;
    return this;
  }

  /**
   * The total number of quota bytes.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuotaBytesTotal() {
    return quotaBytesTotal;
  }

  /**
   * The total number of quota bytes.
   * @param quotaBytesTotal quotaBytesTotal or {@code null} for none
   */
  public About setQuotaBytesTotal(java.lang.Long quotaBytesTotal) {
    this.quotaBytesTotal = quotaBytesTotal;
    return this;
  }

  /**
   * The number of quota bytes used by Google Drive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuotaBytesUsed() {
    return quotaBytesUsed;
  }

  /**
   * The number of quota bytes used by Google Drive.
   * @param quotaBytesUsed quotaBytesUsed or {@code null} for none
   */
  public About setQuotaBytesUsed(java.lang.Long quotaBytesUsed) {
    this.quotaBytesUsed = quotaBytesUsed;
    return this;
  }

  /**
   * The number of quota bytes used by all Google apps (Drive, Picasa, etc.).
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuotaBytesUsedAggregate() {
    return quotaBytesUsedAggregate;
  }

  /**
   * The number of quota bytes used by all Google apps (Drive, Picasa, etc.).
   * @param quotaBytesUsedAggregate quotaBytesUsedAggregate or {@code null} for none
   */
  public About setQuotaBytesUsedAggregate(java.lang.Long quotaBytesUsedAggregate) {
    this.quotaBytesUsedAggregate = quotaBytesUsedAggregate;
    return this;
  }

  /**
   * The number of quota bytes used by trashed items.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuotaBytesUsedInTrash() {
    return quotaBytesUsedInTrash;
  }

  /**
   * The number of quota bytes used by trashed items.
   * @param quotaBytesUsedInTrash quotaBytesUsedInTrash or {@code null} for none
   */
  public About setQuotaBytesUsedInTrash(java.lang.Long quotaBytesUsedInTrash) {
    this.quotaBytesUsedInTrash = quotaBytesUsedInTrash;
    return this;
  }

  /**
   * The number of remaining change ids.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRemainingChangeIds() {
    return remainingChangeIds;
  }

  /**
   * The number of remaining change ids.
   * @param remainingChangeIds remainingChangeIds or {@code null} for none
   */
  public About setRemainingChangeIds(java.lang.Long remainingChangeIds) {
    this.remainingChangeIds = remainingChangeIds;
    return this;
  }

  /**
   * The id of the root folder.
   * @return value or {@code null} for none
   */
  public java.lang.String getRootFolderId() {
    return rootFolderId;
  }

  /**
   * The id of the root folder.
   * @param rootFolderId rootFolderId or {@code null} for none
   */
  public About setRootFolderId(java.lang.String rootFolderId) {
    this.rootFolderId = rootFolderId;
    return this;
  }

  /**
   * A link back to this item.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * A link back to this item.
   * @param selfLink selfLink or {@code null} for none
   */
  public About setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The authenticated user.
   * @return value or {@code null} for none
   */
  public User getUser() {
    return user;
  }

  /**
   * The authenticated user.
   * @param user user or {@code null} for none
   */
  public About setUser(User user) {
    this.user = user;
    return this;
  }

  @Override
  public About set(String fieldName, Object value) {
    return (About) super.set(fieldName, value);
  }

  @Override
  public About clone() {
    return (About) super.clone();
  }

  /**
   * Model definition for AboutAdditionalRoleInfo.
   */
  public static final class AdditionalRoleInfo extends com.google.api.client.json.GenericJson {

    /**
     * The supported additional roles per primary role.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<RoleSets> roleSets;

    static {
      // hack to force ProGuard to consider RoleSets used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(RoleSets.class);
    }

    /**
     * The content type that this additional role info applies to.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * The supported additional roles per primary role.
     * @return value or {@code null} for none
     */
    public java.util.List<RoleSets> getRoleSets() {
      return roleSets;
    }

    /**
     * The supported additional roles per primary role.
     * @param roleSets roleSets or {@code null} for none
     */
    public AdditionalRoleInfo setRoleSets(java.util.List<RoleSets> roleSets) {
      this.roleSets = roleSets;
      return this;
    }

    /**
     * The content type that this additional role info applies to.
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * The content type that this additional role info applies to.
     * @param type type or {@code null} for none
     */
    public AdditionalRoleInfo setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public AdditionalRoleInfo set(String fieldName, Object value) {
      return (AdditionalRoleInfo) super.set(fieldName, value);
    }

    @Override
    public AdditionalRoleInfo clone() {
      return (AdditionalRoleInfo) super.clone();
    }

    /**
     * Model definition for AboutAdditionalRoleInfoRoleSets.
     */
    public static final class RoleSets extends com.google.api.client.json.GenericJson {

      /**
       * The supported additional roles with the primary role.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> additionalRoles;

      /**
       * A primary permission role.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String primaryRole;

      /**
       * The supported additional roles with the primary role.
       * @return value or {@code null} for none
       */
      public java.util.List<java.lang.String> getAdditionalRoles() {
        return additionalRoles;
      }

      /**
       * The supported additional roles with the primary role.
       * @param additionalRoles additionalRoles or {@code null} for none
       */
      public RoleSets setAdditionalRoles(java.util.List<java.lang.String> additionalRoles) {
        this.additionalRoles = additionalRoles;
        return this;
      }

      /**
       * A primary permission role.
       * @return value or {@code null} for none
       */
      public java.lang.String getPrimaryRole() {
        return primaryRole;
      }

      /**
       * A primary permission role.
       * @param primaryRole primaryRole or {@code null} for none
       */
      public RoleSets setPrimaryRole(java.lang.String primaryRole) {
        this.primaryRole = primaryRole;
        return this;
      }

      @Override
      public RoleSets set(String fieldName, Object value) {
        return (RoleSets) super.set(fieldName, value);
      }

      @Override
      public RoleSets clone() {
        return (RoleSets) super.clone();
      }

    }
  }

  /**
   * Model definition for AboutExportFormats.
   */
  public static final class ExportFormats extends com.google.api.client.json.GenericJson {

    /**
     * The content type to convert from.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String source;

    /**
     * The possible content types to convert to.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> targets;

    /**
     * The content type to convert from.
     * @return value or {@code null} for none
     */
    public java.lang.String getSource() {
      return source;
    }

    /**
     * The content type to convert from.
     * @param source source or {@code null} for none
     */
    public ExportFormats setSource(java.lang.String source) {
      this.source = source;
      return this;
    }

    /**
     * The possible content types to convert to.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getTargets() {
      return targets;
    }

    /**
     * The possible content types to convert to.
     * @param targets targets or {@code null} for none
     */
    public ExportFormats setTargets(java.util.List<java.lang.String> targets) {
      this.targets = targets;
      return this;
    }

    @Override
    public ExportFormats set(String fieldName, Object value) {
      return (ExportFormats) super.set(fieldName, value);
    }

    @Override
    public ExportFormats clone() {
      return (ExportFormats) super.clone();
    }

  }

  /**
   * Model definition for AboutFeatures.
   */
  public static final class Features extends com.google.api.client.json.GenericJson {

    /**
     * The name of the feature.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String featureName;

    /**
     * The request limit rate for this feature, in queries per second.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double featureRate;

    /**
     * The name of the feature.
     * @return value or {@code null} for none
     */
    public java.lang.String getFeatureName() {
      return featureName;
    }

    /**
     * The name of the feature.
     * @param featureName featureName or {@code null} for none
     */
    public Features setFeatureName(java.lang.String featureName) {
      this.featureName = featureName;
      return this;
    }

    /**
     * The request limit rate for this feature, in queries per second.
     * @return value or {@code null} for none
     */
    public java.lang.Double getFeatureRate() {
      return featureRate;
    }

    /**
     * The request limit rate for this feature, in queries per second.
     * @param featureRate featureRate or {@code null} for none
     */
    public Features setFeatureRate(java.lang.Double featureRate) {
      this.featureRate = featureRate;
      return this;
    }

    @Override
    public Features set(String fieldName, Object value) {
      return (Features) super.set(fieldName, value);
    }

    @Override
    public Features clone() {
      return (Features) super.clone();
    }

  }

  /**
   * Model definition for AboutImportFormats.
   */
  public static final class ImportFormats extends com.google.api.client.json.GenericJson {

    /**
     * The imported file's content type to convert from.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String source;

    /**
     * The possible content types to convert to.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> targets;

    /**
     * The imported file's content type to convert from.
     * @return value or {@code null} for none
     */
    public java.lang.String getSource() {
      return source;
    }

    /**
     * The imported file's content type to convert from.
     * @param source source or {@code null} for none
     */
    public ImportFormats setSource(java.lang.String source) {
      this.source = source;
      return this;
    }

    /**
     * The possible content types to convert to.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getTargets() {
      return targets;
    }

    /**
     * The possible content types to convert to.
     * @param targets targets or {@code null} for none
     */
    public ImportFormats setTargets(java.util.List<java.lang.String> targets) {
      this.targets = targets;
      return this;
    }

    @Override
    public ImportFormats set(String fieldName, Object value) {
      return (ImportFormats) super.set(fieldName, value);
    }

    @Override
    public ImportFormats clone() {
      return (ImportFormats) super.clone();
    }

  }

  /**
   * Model definition for AboutMaxUploadSizes.
   */
  public static final class MaxUploadSizes extends com.google.api.client.json.GenericJson {

    /**
     * The max upload size for this type.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long size;

    /**
     * The file type.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * The max upload size for this type.
     * @return value or {@code null} for none
     */
    public java.lang.Long getSize() {
      return size;
    }

    /**
     * The max upload size for this type.
     * @param size size or {@code null} for none
     */
    public MaxUploadSizes setSize(java.lang.Long size) {
      this.size = size;
      return this;
    }

    /**
     * The file type.
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * The file type.
     * @param type type or {@code null} for none
     */
    public MaxUploadSizes setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public MaxUploadSizes set(String fieldName, Object value) {
      return (MaxUploadSizes) super.set(fieldName, value);
    }

    @Override
    public MaxUploadSizes clone() {
      return (MaxUploadSizes) super.clone();
    }

  }

}
