/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-01 at 04:53:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * The metadata for a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class File extends com.google.api.client.json.GenericJson {

  /**
   * A collection of arbitrary key-value pairs which are private to the requesting app. Entries with
   * null values are cleared in update and copy requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> appProperties;

  /**
   * Capabilities the current user has on this file. Each capability corresponds to a fine-grained
   * action that a user may take.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Capabilities capabilities;

  /**
   * Additional information about the content of the file. These fields are never populated in
   * responses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ContentHints contentHints;

  /**
   * Whether the options to copy, print, or download this file, should be disabled for readers and
   * commenters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean copyRequiresWriterPermission;

  /**
   * The time at which the file was created (RFC 3339 date-time).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdTime;

  /**
   * A short description of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * ID of the shared drive the file resides in. Only populated for items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String driveId;

  /**
   * Whether the file has been explicitly trashed, as opposed to recursively trashed from a parent
   * folder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean explicitlyTrashed;

  /**
   * Links for exporting Google Docs to specific formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> exportLinks;

  /**
   * The final component of fullFileExtension. This is only available for files with binary content
   * in Google Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileExtension;

  /**
   * The color for a folder as an RGB hex string. The supported colors are published in the
   * folderColorPalette field of the About resource. If an unsupported color is specified, the
   * closest color in the palette will be used instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String folderColorRgb;

  /**
   * The full file extension extracted from the name field. May contain multiple concatenated
   * extensions, such as "tar.gz". This is only available for files with binary content in Google
   * Drive. This is automatically updated when the name field changes, however it is not cleared if
   * the new name does not contain a valid extension.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fullFileExtension;

  /**
   * Whether there are permissions directly on this file. This field is only populated for items in
   * shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasAugmentedPermissions;

  /**
   * Whether this file has a thumbnail. This does not indicate whether the requesting app has access
   * to the thumbnail. To check access, look for the presence of the thumbnailLink field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasThumbnail;

  /**
   * The ID of the file's head revision. This is currently only available for files with binary
   * content in Google Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String headRevisionId;

  /**
   * A static, unauthenticated link to the file's icon.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iconLink;

  /**
   * The ID of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Additional metadata about image media, if available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ImageMediaMetadata imageMediaMetadata;

  /**
   * Whether the file was created or opened by the requesting app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isAppAuthorized;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#file".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The last user to modify the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User lastModifyingUser;

  /**
   * The MD5 checksum for the content of the file. This is only applicable to files with binary
   * content in Google Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String md5Checksum;

  /**
   * The MIME type of the file. Google Drive will attempt to automatically detect an appropriate
   * value from uploaded content if no value is provided. The value cannot be changed unless a new
   * revision is uploaded. If a file is created with a Google Doc MIME type, the uploaded content
   * will be imported if possible. The supported import formats are published in the About resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * Whether the file has been modified by this user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean modifiedByMe;

  /**
   * The last time the file was modified by the user (RFC 3339 date-time).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedByMeTime;

  /**
   * The last time the file was modified by anyone (RFC 3339 date-time). Note that setting
   * modifiedTime will also update modifiedByMeTime for the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedTime;

  /**
   * The name of the file. This is not necessarily unique within a folder. Note that for immutable
   * items such as the top level folders of shared drives, My Drive root folder, and Application
   * Data folder the name is constant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The original filename of the uploaded content if available, or else the original value of the
   * name field. This is only available for files with binary content in Google Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originalFilename;

  /**
   * Whether the user owns the file. Not populated for items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ownedByMe;

  /**
   * The owners of the file. Currently, only certain legacy files may have more than one owner. Not
   * populated for items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<User> owners;

  /**
   * The IDs of the parent folders which contain the file. If not specified as part of a create
   * request, the file will be placed directly in the user's My Drive folder. If not specified as
   * part of a copy request, the file will inherit any discoverable parents of the source file.
   * Update requests must use the addParents and removeParents parameters to modify the parents
   * list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> parents;

  /**
   * List of permission IDs for users with access to this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> permissionIds;

  /**
   * The full list of permissions for the file. This is only available if the requesting user can
   * share the file. Not populated for items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Permission> permissions;

  /**
   * A collection of arbitrary key-value pairs which are visible to all apps. Entries with null
   * values are cleared in update and copy requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> properties;

  /**
   * The number of storage quota bytes used by the file. This includes the head revision as well as
   * previous revisions with keepForever enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long quotaBytesUsed;

  /**
   * Whether the file has been shared. Not populated for items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean shared;

  /**
   * The time at which the file was shared with the user, if applicable (RFC 3339 date-time).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime sharedWithMeTime;

  /**
   * The user who shared the file with the requesting user, if applicable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User sharingUser;

  /**
   * The size of the file's content in bytes. This is only applicable to files with binary content
   * in Google Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long size;

  /**
   * The list of spaces which contain the file. The currently supported values are 'drive',
   * 'appDataFolder' and 'photos'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> spaces;

  /**
   * Whether the user has starred the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean starred;

  /**
   * Deprecated - use driveId instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String teamDriveId;

  /**
   * A short-lived link to the file's thumbnail, if available. Typically lasts on the order of
   * hours. Only populated when the requesting app can access the file's content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String thumbnailLink;

  /**
   * The thumbnail version for use in thumbnail cache invalidation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long thumbnailVersion;

  /**
   * Whether the file has been trashed, either explicitly or from a trashed parent folder. Only the
   * owner may trash a file, and other users cannot see files in the owner's trash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean trashed;

  /**
   * The time that the item was trashed (RFC 3339 date-time). Only populated for items in shared
   * drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime trashedTime;

  /**
   * If the file has been explicitly trashed, the user who trashed it. Only populated for items in
   * shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User trashingUser;

  /**
   * A monotonically increasing version number for the file. This reflects every change made to the
   * file on the server, even those not visible to the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long version;

  /**
   * Additional metadata about video media. This may not be available immediately upon upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoMediaMetadata videoMediaMetadata;

  /**
   * Whether the file has been viewed by this user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean viewedByMe;

  /**
   * The last time the file was viewed by the user (RFC 3339 date-time).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime viewedByMeTime;

  /**
   * Deprecated - use copyRequiresWriterPermission instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean viewersCanCopyContent;

  /**
   * A link for downloading the content of the file in a browser. This is only available for files
   * with binary content in Google Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webContentLink;

  /**
   * A link for opening the file in a relevant Google editor or viewer in a browser.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webViewLink;

  /**
   * Whether users with only writer permission can modify the file's permissions. Not populated for
   * items in shared drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean writersCanShare;

  /**
   * A collection of arbitrary key-value pairs which are private to the requesting app. Entries with
   * null values are cleared in update and copy requests.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getAppProperties() {
    return appProperties;
  }

  /**
   * A collection of arbitrary key-value pairs which are private to the requesting app. Entries with
   * null values are cleared in update and copy requests.
   * @param appProperties appProperties or {@code null} for none
   */
  public File setAppProperties(java.util.Map<String, java.lang.String> appProperties) {
    this.appProperties = appProperties;
    return this;
  }

  /**
   * Capabilities the current user has on this file. Each capability corresponds to a fine-grained
   * action that a user may take.
   * @return value or {@code null} for none
   */
  public Capabilities getCapabilities() {
    return capabilities;
  }

  /**
   * Capabilities the current user has on this file. Each capability corresponds to a fine-grained
   * action that a user may take.
   * @param capabilities capabilities or {@code null} for none
   */
  public File setCapabilities(Capabilities capabilities) {
    this.capabilities = capabilities;
    return this;
  }

  /**
   * Additional information about the content of the file. These fields are never populated in
   * responses.
   * @return value or {@code null} for none
   */
  public ContentHints getContentHints() {
    return contentHints;
  }

  /**
   * Additional information about the content of the file. These fields are never populated in
   * responses.
   * @param contentHints contentHints or {@code null} for none
   */
  public File setContentHints(ContentHints contentHints) {
    this.contentHints = contentHints;
    return this;
  }

  /**
   * Whether the options to copy, print, or download this file, should be disabled for readers and
   * commenters.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCopyRequiresWriterPermission() {
    return copyRequiresWriterPermission;
  }

  /**
   * Whether the options to copy, print, or download this file, should be disabled for readers and
   * commenters.
   * @param copyRequiresWriterPermission copyRequiresWriterPermission or {@code null} for none
   */
  public File setCopyRequiresWriterPermission(java.lang.Boolean copyRequiresWriterPermission) {
    this.copyRequiresWriterPermission = copyRequiresWriterPermission;
    return this;
  }

  /**
   * The time at which the file was created (RFC 3339 date-time).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedTime() {
    return createdTime;
  }

  /**
   * The time at which the file was created (RFC 3339 date-time).
   * @param createdTime createdTime or {@code null} for none
   */
  public File setCreatedTime(com.google.api.client.util.DateTime createdTime) {
    this.createdTime = createdTime;
    return this;
  }

  /**
   * A short description of the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A short description of the file.
   * @param description description or {@code null} for none
   */
  public File setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * ID of the shared drive the file resides in. Only populated for items in shared drives.
   * @return value or {@code null} for none
   */
  public java.lang.String getDriveId() {
    return driveId;
  }

  /**
   * ID of the shared drive the file resides in. Only populated for items in shared drives.
   * @param driveId driveId or {@code null} for none
   */
  public File setDriveId(java.lang.String driveId) {
    this.driveId = driveId;
    return this;
  }

  /**
   * Whether the file has been explicitly trashed, as opposed to recursively trashed from a parent
   * folder.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExplicitlyTrashed() {
    return explicitlyTrashed;
  }

  /**
   * Whether the file has been explicitly trashed, as opposed to recursively trashed from a parent
   * folder.
   * @param explicitlyTrashed explicitlyTrashed or {@code null} for none
   */
  public File setExplicitlyTrashed(java.lang.Boolean explicitlyTrashed) {
    this.explicitlyTrashed = explicitlyTrashed;
    return this;
  }

  /**
   * Links for exporting Google Docs to specific formats.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getExportLinks() {
    return exportLinks;
  }

  /**
   * Links for exporting Google Docs to specific formats.
   * @param exportLinks exportLinks or {@code null} for none
   */
  public File setExportLinks(java.util.Map<String, java.lang.String> exportLinks) {
    this.exportLinks = exportLinks;
    return this;
  }

  /**
   * The final component of fullFileExtension. This is only available for files with binary content
   * in Google Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileExtension() {
    return fileExtension;
  }

  /**
   * The final component of fullFileExtension. This is only available for files with binary content
   * in Google Drive.
   * @param fileExtension fileExtension or {@code null} for none
   */
  public File setFileExtension(java.lang.String fileExtension) {
    this.fileExtension = fileExtension;
    return this;
  }

  /**
   * The color for a folder as an RGB hex string. The supported colors are published in the
   * folderColorPalette field of the About resource. If an unsupported color is specified, the
   * closest color in the palette will be used instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getFolderColorRgb() {
    return folderColorRgb;
  }

  /**
   * The color for a folder as an RGB hex string. The supported colors are published in the
   * folderColorPalette field of the About resource. If an unsupported color is specified, the
   * closest color in the palette will be used instead.
   * @param folderColorRgb folderColorRgb or {@code null} for none
   */
  public File setFolderColorRgb(java.lang.String folderColorRgb) {
    this.folderColorRgb = folderColorRgb;
    return this;
  }

  /**
   * The full file extension extracted from the name field. May contain multiple concatenated
   * extensions, such as "tar.gz". This is only available for files with binary content in Google
   * Drive. This is automatically updated when the name field changes, however it is not cleared if
   * the new name does not contain a valid extension.
   * @return value or {@code null} for none
   */
  public java.lang.String getFullFileExtension() {
    return fullFileExtension;
  }

  /**
   * The full file extension extracted from the name field. May contain multiple concatenated
   * extensions, such as "tar.gz". This is only available for files with binary content in Google
   * Drive. This is automatically updated when the name field changes, however it is not cleared if
   * the new name does not contain a valid extension.
   * @param fullFileExtension fullFileExtension or {@code null} for none
   */
  public File setFullFileExtension(java.lang.String fullFileExtension) {
    this.fullFileExtension = fullFileExtension;
    return this;
  }

  /**
   * Whether there are permissions directly on this file. This field is only populated for items in
   * shared drives.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasAugmentedPermissions() {
    return hasAugmentedPermissions;
  }

  /**
   * Whether there are permissions directly on this file. This field is only populated for items in
   * shared drives.
   * @param hasAugmentedPermissions hasAugmentedPermissions or {@code null} for none
   */
  public File setHasAugmentedPermissions(java.lang.Boolean hasAugmentedPermissions) {
    this.hasAugmentedPermissions = hasAugmentedPermissions;
    return this;
  }

  /**
   * Whether this file has a thumbnail. This does not indicate whether the requesting app has access
   * to the thumbnail. To check access, look for the presence of the thumbnailLink field.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasThumbnail() {
    return hasThumbnail;
  }

  /**
   * Whether this file has a thumbnail. This does not indicate whether the requesting app has access
   * to the thumbnail. To check access, look for the presence of the thumbnailLink field.
   * @param hasThumbnail hasThumbnail or {@code null} for none
   */
  public File setHasThumbnail(java.lang.Boolean hasThumbnail) {
    this.hasThumbnail = hasThumbnail;
    return this;
  }

  /**
   * The ID of the file's head revision. This is currently only available for files with binary
   * content in Google Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeadRevisionId() {
    return headRevisionId;
  }

  /**
   * The ID of the file's head revision. This is currently only available for files with binary
   * content in Google Drive.
   * @param headRevisionId headRevisionId or {@code null} for none
   */
  public File setHeadRevisionId(java.lang.String headRevisionId) {
    this.headRevisionId = headRevisionId;
    return this;
  }

  /**
   * A static, unauthenticated link to the file's icon.
   * @return value or {@code null} for none
   */
  public java.lang.String getIconLink() {
    return iconLink;
  }

  /**
   * A static, unauthenticated link to the file's icon.
   * @param iconLink iconLink or {@code null} for none
   */
  public File setIconLink(java.lang.String iconLink) {
    this.iconLink = iconLink;
    return this;
  }

  /**
   * The ID of the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the file.
   * @param id id or {@code null} for none
   */
  public File setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Additional metadata about image media, if available.
   * @return value or {@code null} for none
   */
  public ImageMediaMetadata getImageMediaMetadata() {
    return imageMediaMetadata;
  }

  /**
   * Additional metadata about image media, if available.
   * @param imageMediaMetadata imageMediaMetadata or {@code null} for none
   */
  public File setImageMediaMetadata(ImageMediaMetadata imageMediaMetadata) {
    this.imageMediaMetadata = imageMediaMetadata;
    return this;
  }

  /**
   * Whether the file was created or opened by the requesting app.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsAppAuthorized() {
    return isAppAuthorized;
  }

  /**
   * Whether the file was created or opened by the requesting app.
   * @param isAppAuthorized isAppAuthorized or {@code null} for none
   */
  public File setIsAppAuthorized(java.lang.Boolean isAppAuthorized) {
    this.isAppAuthorized = isAppAuthorized;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#file".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#file".
   * @param kind kind or {@code null} for none
   */
  public File setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The last user to modify the file.
   * @return value or {@code null} for none
   */
  public User getLastModifyingUser() {
    return lastModifyingUser;
  }

  /**
   * The last user to modify the file.
   * @param lastModifyingUser lastModifyingUser or {@code null} for none
   */
  public File setLastModifyingUser(User lastModifyingUser) {
    this.lastModifyingUser = lastModifyingUser;
    return this;
  }

  /**
   * The MD5 checksum for the content of the file. This is only applicable to files with binary
   * content in Google Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getMd5Checksum() {
    return md5Checksum;
  }

  /**
   * The MD5 checksum for the content of the file. This is only applicable to files with binary
   * content in Google Drive.
   * @param md5Checksum md5Checksum or {@code null} for none
   */
  public File setMd5Checksum(java.lang.String md5Checksum) {
    this.md5Checksum = md5Checksum;
    return this;
  }

  /**
   * The MIME type of the file. Google Drive will attempt to automatically detect an appropriate
   * value from uploaded content if no value is provided. The value cannot be changed unless a new
   * revision is uploaded. If a file is created with a Google Doc MIME type, the uploaded content
   * will be imported if possible. The supported import formats are published in the About resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * The MIME type of the file. Google Drive will attempt to automatically detect an appropriate
   * value from uploaded content if no value is provided. The value cannot be changed unless a new
   * revision is uploaded. If a file is created with a Google Doc MIME type, the uploaded content
   * will be imported if possible. The supported import formats are published in the About resource.
   * @param mimeType mimeType or {@code null} for none
   */
  public File setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Whether the file has been modified by this user.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getModifiedByMe() {
    return modifiedByMe;
  }

  /**
   * Whether the file has been modified by this user.
   * @param modifiedByMe modifiedByMe or {@code null} for none
   */
  public File setModifiedByMe(java.lang.Boolean modifiedByMe) {
    this.modifiedByMe = modifiedByMe;
    return this;
  }

  /**
   * The last time the file was modified by the user (RFC 3339 date-time).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedByMeTime() {
    return modifiedByMeTime;
  }

  /**
   * The last time the file was modified by the user (RFC 3339 date-time).
   * @param modifiedByMeTime modifiedByMeTime or {@code null} for none
   */
  public File setModifiedByMeTime(com.google.api.client.util.DateTime modifiedByMeTime) {
    this.modifiedByMeTime = modifiedByMeTime;
    return this;
  }

  /**
   * The last time the file was modified by anyone (RFC 3339 date-time). Note that setting
   * modifiedTime will also update modifiedByMeTime for the user.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedTime() {
    return modifiedTime;
  }

  /**
   * The last time the file was modified by anyone (RFC 3339 date-time). Note that setting
   * modifiedTime will also update modifiedByMeTime for the user.
   * @param modifiedTime modifiedTime or {@code null} for none
   */
  public File setModifiedTime(com.google.api.client.util.DateTime modifiedTime) {
    this.modifiedTime = modifiedTime;
    return this;
  }

  /**
   * The name of the file. This is not necessarily unique within a folder. Note that for immutable
   * items such as the top level folders of shared drives, My Drive root folder, and Application
   * Data folder the name is constant.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the file. This is not necessarily unique within a folder. Note that for immutable
   * items such as the top level folders of shared drives, My Drive root folder, and Application
   * Data folder the name is constant.
   * @param name name or {@code null} for none
   */
  public File setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The original filename of the uploaded content if available, or else the original value of the
   * name field. This is only available for files with binary content in Google Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginalFilename() {
    return originalFilename;
  }

  /**
   * The original filename of the uploaded content if available, or else the original value of the
   * name field. This is only available for files with binary content in Google Drive.
   * @param originalFilename originalFilename or {@code null} for none
   */
  public File setOriginalFilename(java.lang.String originalFilename) {
    this.originalFilename = originalFilename;
    return this;
  }

  /**
   * Whether the user owns the file. Not populated for items in shared drives.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOwnedByMe() {
    return ownedByMe;
  }

  /**
   * Whether the user owns the file. Not populated for items in shared drives.
   * @param ownedByMe ownedByMe or {@code null} for none
   */
  public File setOwnedByMe(java.lang.Boolean ownedByMe) {
    this.ownedByMe = ownedByMe;
    return this;
  }

  /**
   * The owners of the file. Currently, only certain legacy files may have more than one owner. Not
   * populated for items in shared drives.
   * @return value or {@code null} for none
   */
  public java.util.List<User> getOwners() {
    return owners;
  }

  /**
   * The owners of the file. Currently, only certain legacy files may have more than one owner. Not
   * populated for items in shared drives.
   * @param owners owners or {@code null} for none
   */
  public File setOwners(java.util.List<User> owners) {
    this.owners = owners;
    return this;
  }

  /**
   * The IDs of the parent folders which contain the file. If not specified as part of a create
   * request, the file will be placed directly in the user's My Drive folder. If not specified as
   * part of a copy request, the file will inherit any discoverable parents of the source file.
   * Update requests must use the addParents and removeParents parameters to modify the parents
   * list.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getParents() {
    return parents;
  }

  /**
   * The IDs of the parent folders which contain the file. If not specified as part of a create
   * request, the file will be placed directly in the user's My Drive folder. If not specified as
   * part of a copy request, the file will inherit any discoverable parents of the source file.
   * Update requests must use the addParents and removeParents parameters to modify the parents
   * list.
   * @param parents parents or {@code null} for none
   */
  public File setParents(java.util.List<java.lang.String> parents) {
    this.parents = parents;
    return this;
  }

  /**
   * List of permission IDs for users with access to this file.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPermissionIds() {
    return permissionIds;
  }

  /**
   * List of permission IDs for users with access to this file.
   * @param permissionIds permissionIds or {@code null} for none
   */
  public File setPermissionIds(java.util.List<java.lang.String> permissionIds) {
    this.permissionIds = permissionIds;
    return this;
  }

  /**
   * The full list of permissions for the file. This is only available if the requesting user can
   * share the file. Not populated for items in shared drives.
   * @return value or {@code null} for none
   */
  public java.util.List<Permission> getPermissions() {
    return permissions;
  }

  /**
   * The full list of permissions for the file. This is only available if the requesting user can
   * share the file. Not populated for items in shared drives.
   * @param permissions permissions or {@code null} for none
   */
  public File setPermissions(java.util.List<Permission> permissions) {
    this.permissions = permissions;
    return this;
  }

  /**
   * A collection of arbitrary key-value pairs which are visible to all apps. Entries with null
   * values are cleared in update and copy requests.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getProperties() {
    return properties;
  }

  /**
   * A collection of arbitrary key-value pairs which are visible to all apps. Entries with null
   * values are cleared in update and copy requests.
   * @param properties properties or {@code null} for none
   */
  public File setProperties(java.util.Map<String, java.lang.String> properties) {
    this.properties = properties;
    return this;
  }

  /**
   * The number of storage quota bytes used by the file. This includes the head revision as well as
   * previous revisions with keepForever enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuotaBytesUsed() {
    return quotaBytesUsed;
  }

  /**
   * The number of storage quota bytes used by the file. This includes the head revision as well as
   * previous revisions with keepForever enabled.
   * @param quotaBytesUsed quotaBytesUsed or {@code null} for none
   */
  public File setQuotaBytesUsed(java.lang.Long quotaBytesUsed) {
    this.quotaBytesUsed = quotaBytesUsed;
    return this;
  }

  /**
   * Whether the file has been shared. Not populated for items in shared drives.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShared() {
    return shared;
  }

  /**
   * Whether the file has been shared. Not populated for items in shared drives.
   * @param shared shared or {@code null} for none
   */
  public File setShared(java.lang.Boolean shared) {
    this.shared = shared;
    return this;
  }

  /**
   * The time at which the file was shared with the user, if applicable (RFC 3339 date-time).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getSharedWithMeTime() {
    return sharedWithMeTime;
  }

  /**
   * The time at which the file was shared with the user, if applicable (RFC 3339 date-time).
   * @param sharedWithMeTime sharedWithMeTime or {@code null} for none
   */
  public File setSharedWithMeTime(com.google.api.client.util.DateTime sharedWithMeTime) {
    this.sharedWithMeTime = sharedWithMeTime;
    return this;
  }

  /**
   * The user who shared the file with the requesting user, if applicable.
   * @return value or {@code null} for none
   */
  public User getSharingUser() {
    return sharingUser;
  }

  /**
   * The user who shared the file with the requesting user, if applicable.
   * @param sharingUser sharingUser or {@code null} for none
   */
  public File setSharingUser(User sharingUser) {
    this.sharingUser = sharingUser;
    return this;
  }

  /**
   * The size of the file's content in bytes. This is only applicable to files with binary content
   * in Google Drive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSize() {
    return size;
  }

  /**
   * The size of the file's content in bytes. This is only applicable to files with binary content
   * in Google Drive.
   * @param size size or {@code null} for none
   */
  public File setSize(java.lang.Long size) {
    this.size = size;
    return this;
  }

  /**
   * The list of spaces which contain the file. The currently supported values are 'drive',
   * 'appDataFolder' and 'photos'.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSpaces() {
    return spaces;
  }

  /**
   * The list of spaces which contain the file. The currently supported values are 'drive',
   * 'appDataFolder' and 'photos'.
   * @param spaces spaces or {@code null} for none
   */
  public File setSpaces(java.util.List<java.lang.String> spaces) {
    this.spaces = spaces;
    return this;
  }

  /**
   * Whether the user has starred the file.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getStarred() {
    return starred;
  }

  /**
   * Whether the user has starred the file.
   * @param starred starred or {@code null} for none
   */
  public File setStarred(java.lang.Boolean starred) {
    this.starred = starred;
    return this;
  }

  /**
   * Deprecated - use driveId instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getTeamDriveId() {
    return teamDriveId;
  }

  /**
   * Deprecated - use driveId instead.
   * @param teamDriveId teamDriveId or {@code null} for none
   */
  public File setTeamDriveId(java.lang.String teamDriveId) {
    this.teamDriveId = teamDriveId;
    return this;
  }

  /**
   * A short-lived link to the file's thumbnail, if available. Typically lasts on the order of
   * hours. Only populated when the requesting app can access the file's content.
   * @return value or {@code null} for none
   */
  public java.lang.String getThumbnailLink() {
    return thumbnailLink;
  }

  /**
   * A short-lived link to the file's thumbnail, if available. Typically lasts on the order of
   * hours. Only populated when the requesting app can access the file's content.
   * @param thumbnailLink thumbnailLink or {@code null} for none
   */
  public File setThumbnailLink(java.lang.String thumbnailLink) {
    this.thumbnailLink = thumbnailLink;
    return this;
  }

  /**
   * The thumbnail version for use in thumbnail cache invalidation.
   * @return value or {@code null} for none
   */
  public java.lang.Long getThumbnailVersion() {
    return thumbnailVersion;
  }

  /**
   * The thumbnail version for use in thumbnail cache invalidation.
   * @param thumbnailVersion thumbnailVersion or {@code null} for none
   */
  public File setThumbnailVersion(java.lang.Long thumbnailVersion) {
    this.thumbnailVersion = thumbnailVersion;
    return this;
  }

  /**
   * Whether the file has been trashed, either explicitly or from a trashed parent folder. Only the
   * owner may trash a file, and other users cannot see files in the owner's trash.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTrashed() {
    return trashed;
  }

  /**
   * Whether the file has been trashed, either explicitly or from a trashed parent folder. Only the
   * owner may trash a file, and other users cannot see files in the owner's trash.
   * @param trashed trashed or {@code null} for none
   */
  public File setTrashed(java.lang.Boolean trashed) {
    this.trashed = trashed;
    return this;
  }

  /**
   * The time that the item was trashed (RFC 3339 date-time). Only populated for items in shared
   * drives.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTrashedTime() {
    return trashedTime;
  }

  /**
   * The time that the item was trashed (RFC 3339 date-time). Only populated for items in shared
   * drives.
   * @param trashedTime trashedTime or {@code null} for none
   */
  public File setTrashedTime(com.google.api.client.util.DateTime trashedTime) {
    this.trashedTime = trashedTime;
    return this;
  }

  /**
   * If the file has been explicitly trashed, the user who trashed it. Only populated for items in
   * shared drives.
   * @return value or {@code null} for none
   */
  public User getTrashingUser() {
    return trashingUser;
  }

  /**
   * If the file has been explicitly trashed, the user who trashed it. Only populated for items in
   * shared drives.
   * @param trashingUser trashingUser or {@code null} for none
   */
  public File setTrashingUser(User trashingUser) {
    this.trashingUser = trashingUser;
    return this;
  }

  /**
   * A monotonically increasing version number for the file. This reflects every change made to the
   * file on the server, even those not visible to the user.
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersion() {
    return version;
  }

  /**
   * A monotonically increasing version number for the file. This reflects every change made to the
   * file on the server, even those not visible to the user.
   * @param version version or {@code null} for none
   */
  public File setVersion(java.lang.Long version) {
    this.version = version;
    return this;
  }

  /**
   * Additional metadata about video media. This may not be available immediately upon upload.
   * @return value or {@code null} for none
   */
  public VideoMediaMetadata getVideoMediaMetadata() {
    return videoMediaMetadata;
  }

  /**
   * Additional metadata about video media. This may not be available immediately upon upload.
   * @param videoMediaMetadata videoMediaMetadata or {@code null} for none
   */
  public File setVideoMediaMetadata(VideoMediaMetadata videoMediaMetadata) {
    this.videoMediaMetadata = videoMediaMetadata;
    return this;
  }

  /**
   * Whether the file has been viewed by this user.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getViewedByMe() {
    return viewedByMe;
  }

  /**
   * Whether the file has been viewed by this user.
   * @param viewedByMe viewedByMe or {@code null} for none
   */
  public File setViewedByMe(java.lang.Boolean viewedByMe) {
    this.viewedByMe = viewedByMe;
    return this;
  }

  /**
   * The last time the file was viewed by the user (RFC 3339 date-time).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getViewedByMeTime() {
    return viewedByMeTime;
  }

  /**
   * The last time the file was viewed by the user (RFC 3339 date-time).
   * @param viewedByMeTime viewedByMeTime or {@code null} for none
   */
  public File setViewedByMeTime(com.google.api.client.util.DateTime viewedByMeTime) {
    this.viewedByMeTime = viewedByMeTime;
    return this;
  }

  /**
   * Deprecated - use copyRequiresWriterPermission instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getViewersCanCopyContent() {
    return viewersCanCopyContent;
  }

  /**
   * Deprecated - use copyRequiresWriterPermission instead.
   * @param viewersCanCopyContent viewersCanCopyContent or {@code null} for none
   */
  public File setViewersCanCopyContent(java.lang.Boolean viewersCanCopyContent) {
    this.viewersCanCopyContent = viewersCanCopyContent;
    return this;
  }

  /**
   * A link for downloading the content of the file in a browser. This is only available for files
   * with binary content in Google Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebContentLink() {
    return webContentLink;
  }

  /**
   * A link for downloading the content of the file in a browser. This is only available for files
   * with binary content in Google Drive.
   * @param webContentLink webContentLink or {@code null} for none
   */
  public File setWebContentLink(java.lang.String webContentLink) {
    this.webContentLink = webContentLink;
    return this;
  }

  /**
   * A link for opening the file in a relevant Google editor or viewer in a browser.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebViewLink() {
    return webViewLink;
  }

  /**
   * A link for opening the file in a relevant Google editor or viewer in a browser.
   * @param webViewLink webViewLink or {@code null} for none
   */
  public File setWebViewLink(java.lang.String webViewLink) {
    this.webViewLink = webViewLink;
    return this;
  }

  /**
   * Whether users with only writer permission can modify the file's permissions. Not populated for
   * items in shared drives.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWritersCanShare() {
    return writersCanShare;
  }

  /**
   * Whether users with only writer permission can modify the file's permissions. Not populated for
   * items in shared drives.
   * @param writersCanShare writersCanShare or {@code null} for none
   */
  public File setWritersCanShare(java.lang.Boolean writersCanShare) {
    this.writersCanShare = writersCanShare;
    return this;
  }

  @Override
  public File set(String fieldName, Object value) {
    return (File) super.set(fieldName, value);
  }

  @Override
  public File clone() {
    return (File) super.clone();
  }

  /**
   * Capabilities the current user has on this file. Each capability corresponds to a fine-grained
   * action that a user may take.
   */
  public static final class Capabilities extends com.google.api.client.json.GenericJson {

    /**
     * Whether the current user can add children to this folder. This is always false when the item is
     * not a folder.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canAddChildren;

    /**
     * Whether the current user can change the copyRequiresWriterPermission restriction of this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canChangeCopyRequiresWriterPermission;

    /**
     * Deprecated
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canChangeViewersCanCopyContent;

    /**
     * Whether the current user can comment on this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canComment;

    /**
     * Whether the current user can copy this file. For an item in a shared drive, whether the current
     * user can copy non-folder descendants of this item, or this item itself if it is not a folder.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canCopy;

    /**
     * Whether the current user can delete this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canDelete;

    /**
     * Whether the current user can delete children of this folder. This is false when the item is not
     * a folder. Only populated for items in shared drives.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canDeleteChildren;

    /**
     * Whether the current user can download this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canDownload;

    /**
     * Whether the current user can edit this file. Other factors may limit the type of changes a user
     * can make to a file. For example, see canChangeCopyRequiresWriterPermission or canModifyContent.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canEdit;

    /**
     * Whether the current user can list the children of this folder. This is always false when the
     * item is not a folder.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canListChildren;

    /**
     * Whether the current user can modify the content of this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canModifyContent;

    /**
     * Whether the current user can move children of this folder outside of the shared drive. This is
     * false when the item is not a folder. Only populated for items in shared drives.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveChildrenOutOfDrive;

    /**
     * Deprecated - use canMoveChildrenOutOfDrive instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveChildrenOutOfTeamDrive;

    /**
     * Whether the current user can move children of this folder within the shared drive. This is
     * false when the item is not a folder. Only populated for items in shared drives.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveChildrenWithinDrive;

    /**
     * Deprecated - use canMoveChildrenWithinDrive instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveChildrenWithinTeamDrive;

    /**
     * Deprecated - use canMoveItemOutOfDrive instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveItemIntoTeamDrive;

    /**
     * Whether the current user can move this item outside of this drive by changing its parent. Note
     * that a request to change the parent of the item may still fail depending on the new parent that
     * is being added.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveItemOutOfDrive;

    /**
     * Deprecated - use canMoveItemOutOfDrive instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveItemOutOfTeamDrive;

    /**
     * Whether the current user can move this item within this shared drive. Note that a request to
     * change the parent of the item may still fail depending on the new parent that is being added.
     * Only populated for items in shared drives.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveItemWithinDrive;

    /**
     * Deprecated - use canMoveItemWithinDrive instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveItemWithinTeamDrive;

    /**
     * Deprecated - use canMoveItemWithinDrive or canMoveItemOutOfDrive instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveTeamDriveItem;

    /**
     * Whether the current user can read the shared drive to which this file belongs. Only populated
     * for items in shared drives.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canReadDrive;

    /**
     * Whether the current user can read the revisions resource of this file. For a shared drive item,
     * whether revisions of non-folder descendants of this item, or this item itself if it is not a
     * folder, can be read.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canReadRevisions;

    /**
     * Deprecated - use canReadDrive instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canReadTeamDrive;

    /**
     * Whether the current user can remove children from this folder. This is always false when the
     * item is not a folder. For a folder in a shared drive, use canDeleteChildren or canTrashChildren
     * instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canRemoveChildren;

    /**
     * Whether the current user can rename this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canRename;

    /**
     * Whether the current user can modify the sharing settings for this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canShare;

    /**
     * Whether the current user can move this file to trash.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canTrash;

    /**
     * Whether the current user can trash children of this folder. This is false when the item is not
     * a folder. Only populated for items in shared drives.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canTrashChildren;

    /**
     * Whether the current user can restore this file from trash.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canUntrash;

    /**
     * Whether the current user can add children to this folder. This is always false when the item is
     * not a folder.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanAddChildren() {
      return canAddChildren;
    }

    /**
     * Whether the current user can add children to this folder. This is always false when the item is
     * not a folder.
     * @param canAddChildren canAddChildren or {@code null} for none
     */
    public Capabilities setCanAddChildren(java.lang.Boolean canAddChildren) {
      this.canAddChildren = canAddChildren;
      return this;
    }

    /**
     * Whether the current user can change the copyRequiresWriterPermission restriction of this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanChangeCopyRequiresWriterPermission() {
      return canChangeCopyRequiresWriterPermission;
    }

    /**
     * Whether the current user can change the copyRequiresWriterPermission restriction of this file.
     * @param canChangeCopyRequiresWriterPermission canChangeCopyRequiresWriterPermission or {@code null} for none
     */
    public Capabilities setCanChangeCopyRequiresWriterPermission(java.lang.Boolean canChangeCopyRequiresWriterPermission) {
      this.canChangeCopyRequiresWriterPermission = canChangeCopyRequiresWriterPermission;
      return this;
    }

    /**
     * Deprecated
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanChangeViewersCanCopyContent() {
      return canChangeViewersCanCopyContent;
    }

    /**
     * Deprecated
     * @param canChangeViewersCanCopyContent canChangeViewersCanCopyContent or {@code null} for none
     */
    public Capabilities setCanChangeViewersCanCopyContent(java.lang.Boolean canChangeViewersCanCopyContent) {
      this.canChangeViewersCanCopyContent = canChangeViewersCanCopyContent;
      return this;
    }

    /**
     * Whether the current user can comment on this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanComment() {
      return canComment;
    }

    /**
     * Whether the current user can comment on this file.
     * @param canComment canComment or {@code null} for none
     */
    public Capabilities setCanComment(java.lang.Boolean canComment) {
      this.canComment = canComment;
      return this;
    }

    /**
     * Whether the current user can copy this file. For an item in a shared drive, whether the current
     * user can copy non-folder descendants of this item, or this item itself if it is not a folder.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanCopy() {
      return canCopy;
    }

    /**
     * Whether the current user can copy this file. For an item in a shared drive, whether the current
     * user can copy non-folder descendants of this item, or this item itself if it is not a folder.
     * @param canCopy canCopy or {@code null} for none
     */
    public Capabilities setCanCopy(java.lang.Boolean canCopy) {
      this.canCopy = canCopy;
      return this;
    }

    /**
     * Whether the current user can delete this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanDelete() {
      return canDelete;
    }

    /**
     * Whether the current user can delete this file.
     * @param canDelete canDelete or {@code null} for none
     */
    public Capabilities setCanDelete(java.lang.Boolean canDelete) {
      this.canDelete = canDelete;
      return this;
    }

    /**
     * Whether the current user can delete children of this folder. This is false when the item is not
     * a folder. Only populated for items in shared drives.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanDeleteChildren() {
      return canDeleteChildren;
    }

    /**
     * Whether the current user can delete children of this folder. This is false when the item is not
     * a folder. Only populated for items in shared drives.
     * @param canDeleteChildren canDeleteChildren or {@code null} for none
     */
    public Capabilities setCanDeleteChildren(java.lang.Boolean canDeleteChildren) {
      this.canDeleteChildren = canDeleteChildren;
      return this;
    }

    /**
     * Whether the current user can download this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanDownload() {
      return canDownload;
    }

    /**
     * Whether the current user can download this file.
     * @param canDownload canDownload or {@code null} for none
     */
    public Capabilities setCanDownload(java.lang.Boolean canDownload) {
      this.canDownload = canDownload;
      return this;
    }

    /**
     * Whether the current user can edit this file. Other factors may limit the type of changes a user
     * can make to a file. For example, see canChangeCopyRequiresWriterPermission or canModifyContent.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanEdit() {
      return canEdit;
    }

    /**
     * Whether the current user can edit this file. Other factors may limit the type of changes a user
     * can make to a file. For example, see canChangeCopyRequiresWriterPermission or canModifyContent.
     * @param canEdit canEdit or {@code null} for none
     */
    public Capabilities setCanEdit(java.lang.Boolean canEdit) {
      this.canEdit = canEdit;
      return this;
    }

    /**
     * Whether the current user can list the children of this folder. This is always false when the
     * item is not a folder.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanListChildren() {
      return canListChildren;
    }

    /**
     * Whether the current user can list the children of this folder. This is always false when the
     * item is not a folder.
     * @param canListChildren canListChildren or {@code null} for none
     */
    public Capabilities setCanListChildren(java.lang.Boolean canListChildren) {
      this.canListChildren = canListChildren;
      return this;
    }

    /**
     * Whether the current user can modify the content of this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanModifyContent() {
      return canModifyContent;
    }

    /**
     * Whether the current user can modify the content of this file.
     * @param canModifyContent canModifyContent or {@code null} for none
     */
    public Capabilities setCanModifyContent(java.lang.Boolean canModifyContent) {
      this.canModifyContent = canModifyContent;
      return this;
    }

    /**
     * Whether the current user can move children of this folder outside of the shared drive. This is
     * false when the item is not a folder. Only populated for items in shared drives.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveChildrenOutOfDrive() {
      return canMoveChildrenOutOfDrive;
    }

    /**
     * Whether the current user can move children of this folder outside of the shared drive. This is
     * false when the item is not a folder. Only populated for items in shared drives.
     * @param canMoveChildrenOutOfDrive canMoveChildrenOutOfDrive or {@code null} for none
     */
    public Capabilities setCanMoveChildrenOutOfDrive(java.lang.Boolean canMoveChildrenOutOfDrive) {
      this.canMoveChildrenOutOfDrive = canMoveChildrenOutOfDrive;
      return this;
    }

    /**
     * Deprecated - use canMoveChildrenOutOfDrive instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveChildrenOutOfTeamDrive() {
      return canMoveChildrenOutOfTeamDrive;
    }

    /**
     * Deprecated - use canMoveChildrenOutOfDrive instead.
     * @param canMoveChildrenOutOfTeamDrive canMoveChildrenOutOfTeamDrive or {@code null} for none
     */
    public Capabilities setCanMoveChildrenOutOfTeamDrive(java.lang.Boolean canMoveChildrenOutOfTeamDrive) {
      this.canMoveChildrenOutOfTeamDrive = canMoveChildrenOutOfTeamDrive;
      return this;
    }

    /**
     * Whether the current user can move children of this folder within the shared drive. This is
     * false when the item is not a folder. Only populated for items in shared drives.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveChildrenWithinDrive() {
      return canMoveChildrenWithinDrive;
    }

    /**
     * Whether the current user can move children of this folder within the shared drive. This is
     * false when the item is not a folder. Only populated for items in shared drives.
     * @param canMoveChildrenWithinDrive canMoveChildrenWithinDrive or {@code null} for none
     */
    public Capabilities setCanMoveChildrenWithinDrive(java.lang.Boolean canMoveChildrenWithinDrive) {
      this.canMoveChildrenWithinDrive = canMoveChildrenWithinDrive;
      return this;
    }

    /**
     * Deprecated - use canMoveChildrenWithinDrive instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveChildrenWithinTeamDrive() {
      return canMoveChildrenWithinTeamDrive;
    }

    /**
     * Deprecated - use canMoveChildrenWithinDrive instead.
     * @param canMoveChildrenWithinTeamDrive canMoveChildrenWithinTeamDrive or {@code null} for none
     */
    public Capabilities setCanMoveChildrenWithinTeamDrive(java.lang.Boolean canMoveChildrenWithinTeamDrive) {
      this.canMoveChildrenWithinTeamDrive = canMoveChildrenWithinTeamDrive;
      return this;
    }

    /**
     * Deprecated - use canMoveItemOutOfDrive instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveItemIntoTeamDrive() {
      return canMoveItemIntoTeamDrive;
    }

    /**
     * Deprecated - use canMoveItemOutOfDrive instead.
     * @param canMoveItemIntoTeamDrive canMoveItemIntoTeamDrive or {@code null} for none
     */
    public Capabilities setCanMoveItemIntoTeamDrive(java.lang.Boolean canMoveItemIntoTeamDrive) {
      this.canMoveItemIntoTeamDrive = canMoveItemIntoTeamDrive;
      return this;
    }

    /**
     * Whether the current user can move this item outside of this drive by changing its parent. Note
     * that a request to change the parent of the item may still fail depending on the new parent that
     * is being added.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveItemOutOfDrive() {
      return canMoveItemOutOfDrive;
    }

    /**
     * Whether the current user can move this item outside of this drive by changing its parent. Note
     * that a request to change the parent of the item may still fail depending on the new parent that
     * is being added.
     * @param canMoveItemOutOfDrive canMoveItemOutOfDrive or {@code null} for none
     */
    public Capabilities setCanMoveItemOutOfDrive(java.lang.Boolean canMoveItemOutOfDrive) {
      this.canMoveItemOutOfDrive = canMoveItemOutOfDrive;
      return this;
    }

    /**
     * Deprecated - use canMoveItemOutOfDrive instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveItemOutOfTeamDrive() {
      return canMoveItemOutOfTeamDrive;
    }

    /**
     * Deprecated - use canMoveItemOutOfDrive instead.
     * @param canMoveItemOutOfTeamDrive canMoveItemOutOfTeamDrive or {@code null} for none
     */
    public Capabilities setCanMoveItemOutOfTeamDrive(java.lang.Boolean canMoveItemOutOfTeamDrive) {
      this.canMoveItemOutOfTeamDrive = canMoveItemOutOfTeamDrive;
      return this;
    }

    /**
     * Whether the current user can move this item within this shared drive. Note that a request to
     * change the parent of the item may still fail depending on the new parent that is being added.
     * Only populated for items in shared drives.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveItemWithinDrive() {
      return canMoveItemWithinDrive;
    }

    /**
     * Whether the current user can move this item within this shared drive. Note that a request to
     * change the parent of the item may still fail depending on the new parent that is being added.
     * Only populated for items in shared drives.
     * @param canMoveItemWithinDrive canMoveItemWithinDrive or {@code null} for none
     */
    public Capabilities setCanMoveItemWithinDrive(java.lang.Boolean canMoveItemWithinDrive) {
      this.canMoveItemWithinDrive = canMoveItemWithinDrive;
      return this;
    }

    /**
     * Deprecated - use canMoveItemWithinDrive instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveItemWithinTeamDrive() {
      return canMoveItemWithinTeamDrive;
    }

    /**
     * Deprecated - use canMoveItemWithinDrive instead.
     * @param canMoveItemWithinTeamDrive canMoveItemWithinTeamDrive or {@code null} for none
     */
    public Capabilities setCanMoveItemWithinTeamDrive(java.lang.Boolean canMoveItemWithinTeamDrive) {
      this.canMoveItemWithinTeamDrive = canMoveItemWithinTeamDrive;
      return this;
    }

    /**
     * Deprecated - use canMoveItemWithinDrive or canMoveItemOutOfDrive instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveTeamDriveItem() {
      return canMoveTeamDriveItem;
    }

    /**
     * Deprecated - use canMoveItemWithinDrive or canMoveItemOutOfDrive instead.
     * @param canMoveTeamDriveItem canMoveTeamDriveItem or {@code null} for none
     */
    public Capabilities setCanMoveTeamDriveItem(java.lang.Boolean canMoveTeamDriveItem) {
      this.canMoveTeamDriveItem = canMoveTeamDriveItem;
      return this;
    }

    /**
     * Whether the current user can read the shared drive to which this file belongs. Only populated
     * for items in shared drives.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanReadDrive() {
      return canReadDrive;
    }

    /**
     * Whether the current user can read the shared drive to which this file belongs. Only populated
     * for items in shared drives.
     * @param canReadDrive canReadDrive or {@code null} for none
     */
    public Capabilities setCanReadDrive(java.lang.Boolean canReadDrive) {
      this.canReadDrive = canReadDrive;
      return this;
    }

    /**
     * Whether the current user can read the revisions resource of this file. For a shared drive item,
     * whether revisions of non-folder descendants of this item, or this item itself if it is not a
     * folder, can be read.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanReadRevisions() {
      return canReadRevisions;
    }

    /**
     * Whether the current user can read the revisions resource of this file. For a shared drive item,
     * whether revisions of non-folder descendants of this item, or this item itself if it is not a
     * folder, can be read.
     * @param canReadRevisions canReadRevisions or {@code null} for none
     */
    public Capabilities setCanReadRevisions(java.lang.Boolean canReadRevisions) {
      this.canReadRevisions = canReadRevisions;
      return this;
    }

    /**
     * Deprecated - use canReadDrive instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanReadTeamDrive() {
      return canReadTeamDrive;
    }

    /**
     * Deprecated - use canReadDrive instead.
     * @param canReadTeamDrive canReadTeamDrive or {@code null} for none
     */
    public Capabilities setCanReadTeamDrive(java.lang.Boolean canReadTeamDrive) {
      this.canReadTeamDrive = canReadTeamDrive;
      return this;
    }

    /**
     * Whether the current user can remove children from this folder. This is always false when the
     * item is not a folder. For a folder in a shared drive, use canDeleteChildren or canTrashChildren
     * instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanRemoveChildren() {
      return canRemoveChildren;
    }

    /**
     * Whether the current user can remove children from this folder. This is always false when the
     * item is not a folder. For a folder in a shared drive, use canDeleteChildren or canTrashChildren
     * instead.
     * @param canRemoveChildren canRemoveChildren or {@code null} for none
     */
    public Capabilities setCanRemoveChildren(java.lang.Boolean canRemoveChildren) {
      this.canRemoveChildren = canRemoveChildren;
      return this;
    }

    /**
     * Whether the current user can rename this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanRename() {
      return canRename;
    }

    /**
     * Whether the current user can rename this file.
     * @param canRename canRename or {@code null} for none
     */
    public Capabilities setCanRename(java.lang.Boolean canRename) {
      this.canRename = canRename;
      return this;
    }

    /**
     * Whether the current user can modify the sharing settings for this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanShare() {
      return canShare;
    }

    /**
     * Whether the current user can modify the sharing settings for this file.
     * @param canShare canShare or {@code null} for none
     */
    public Capabilities setCanShare(java.lang.Boolean canShare) {
      this.canShare = canShare;
      return this;
    }

    /**
     * Whether the current user can move this file to trash.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanTrash() {
      return canTrash;
    }

    /**
     * Whether the current user can move this file to trash.
     * @param canTrash canTrash or {@code null} for none
     */
    public Capabilities setCanTrash(java.lang.Boolean canTrash) {
      this.canTrash = canTrash;
      return this;
    }

    /**
     * Whether the current user can trash children of this folder. This is false when the item is not
     * a folder. Only populated for items in shared drives.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanTrashChildren() {
      return canTrashChildren;
    }

    /**
     * Whether the current user can trash children of this folder. This is false when the item is not
     * a folder. Only populated for items in shared drives.
     * @param canTrashChildren canTrashChildren or {@code null} for none
     */
    public Capabilities setCanTrashChildren(java.lang.Boolean canTrashChildren) {
      this.canTrashChildren = canTrashChildren;
      return this;
    }

    /**
     * Whether the current user can restore this file from trash.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanUntrash() {
      return canUntrash;
    }

    /**
     * Whether the current user can restore this file from trash.
     * @param canUntrash canUntrash or {@code null} for none
     */
    public Capabilities setCanUntrash(java.lang.Boolean canUntrash) {
      this.canUntrash = canUntrash;
      return this;
    }

    @Override
    public Capabilities set(String fieldName, Object value) {
      return (Capabilities) super.set(fieldName, value);
    }

    @Override
    public Capabilities clone() {
      return (Capabilities) super.clone();
    }

  }

  /**
   * Additional information about the content of the file. These fields are never populated in
   * responses.
   */
  public static final class ContentHints extends com.google.api.client.json.GenericJson {

    /**
     * Text to be indexed for the file to improve fullText queries. This is limited to 128KB in length
     * and may contain HTML elements.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String indexableText;

    /**
     * A thumbnail for the file. This will only be used if Google Drive cannot generate a standard
     * thumbnail.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Thumbnail thumbnail;

    /**
     * Text to be indexed for the file to improve fullText queries. This is limited to 128KB in length
     * and may contain HTML elements.
     * @return value or {@code null} for none
     */
    public java.lang.String getIndexableText() {
      return indexableText;
    }

    /**
     * Text to be indexed for the file to improve fullText queries. This is limited to 128KB in length
     * and may contain HTML elements.
     * @param indexableText indexableText or {@code null} for none
     */
    public ContentHints setIndexableText(java.lang.String indexableText) {
      this.indexableText = indexableText;
      return this;
    }

    /**
     * A thumbnail for the file. This will only be used if Google Drive cannot generate a standard
     * thumbnail.
     * @return value or {@code null} for none
     */
    public Thumbnail getThumbnail() {
      return thumbnail;
    }

    /**
     * A thumbnail for the file. This will only be used if Google Drive cannot generate a standard
     * thumbnail.
     * @param thumbnail thumbnail or {@code null} for none
     */
    public ContentHints setThumbnail(Thumbnail thumbnail) {
      this.thumbnail = thumbnail;
      return this;
    }

    @Override
    public ContentHints set(String fieldName, Object value) {
      return (ContentHints) super.set(fieldName, value);
    }

    @Override
    public ContentHints clone() {
      return (ContentHints) super.clone();
    }

    /**
     * A thumbnail for the file. This will only be used if Google Drive cannot generate a standard
     * thumbnail.
     */
    public static final class Thumbnail extends com.google.api.client.json.GenericJson {

      /**
       * The thumbnail data encoded with URL-safe Base64 (RFC 4648 section 5).
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /**
       * The MIME type of the thumbnail.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String mimeType;

      /**
       * The thumbnail data encoded with URL-safe Base64 (RFC 4648 section 5).
       * @see #decodeImage()
       * @return value or {@code null} for none
       */
      public java.lang.String getImage() {
        return image;
      }

      /**
       * The thumbnail data encoded with URL-safe Base64 (RFC 4648 section 5).
       * @see #getImage()
       * @return Base64 decoded value or {@code null} for none
       *
       * @since 1.14
       */
      public byte[] decodeImage() {
        return com.google.api.client.util.Base64.decodeBase64(image);
      }

      /**
       * The thumbnail data encoded with URL-safe Base64 (RFC 4648 section 5).
       * @see #encodeImage()
       * @param image image or {@code null} for none
       */
      public Thumbnail setImage(java.lang.String image) {
        this.image = image;
        return this;
      }

      /**
       * The thumbnail data encoded with URL-safe Base64 (RFC 4648 section 5).
       * @see #setImage()
       *
       * <p>
       * The value is encoded Base64 or {@code null} for none.
       * </p>
       *
       * @since 1.14
       */
      public Thumbnail encodeImage(byte[] image) {
        this.image = com.google.api.client.util.Base64.encodeBase64URLSafeString(image);
        return this;
      }

      /**
       * The MIME type of the thumbnail.
       * @return value or {@code null} for none
       */
      public java.lang.String getMimeType() {
        return mimeType;
      }

      /**
       * The MIME type of the thumbnail.
       * @param mimeType mimeType or {@code null} for none
       */
      public Thumbnail setMimeType(java.lang.String mimeType) {
        this.mimeType = mimeType;
        return this;
      }

      @Override
      public Thumbnail set(String fieldName, Object value) {
        return (Thumbnail) super.set(fieldName, value);
      }

      @Override
      public Thumbnail clone() {
        return (Thumbnail) super.clone();
      }

    }
  }

  /**
   * Additional metadata about image media, if available.
   */
  public static final class ImageMediaMetadata extends com.google.api.client.json.GenericJson {

    /**
     * The aperture used to create the photo (f-number).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float aperture;

    /**
     * The make of the camera used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String cameraMake;

    /**
     * The model of the camera used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String cameraModel;

    /**
     * The color space of the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String colorSpace;

    /**
     * The exposure bias of the photo (APEX value).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float exposureBias;

    /**
     * The exposure mode used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String exposureMode;

    /**
     * The length of the exposure, in seconds.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float exposureTime;

    /**
     * Whether a flash was used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean flashUsed;

    /**
     * The focal length used to create the photo, in millimeters.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float focalLength;

    /**
     * The height of the image in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer height;

    /**
     * The ISO speed used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer isoSpeed;

    /**
     * The lens used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String lens;

    /**
     * Geographic location information stored in the image.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Location location;

    /**
     * The smallest f-number of the lens at the focal length used to create the photo (APEX value).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float maxApertureValue;

    /**
     * The metering mode used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String meteringMode;

    /**
     * The rotation in clockwise degrees from the image's original orientation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer rotation;

    /**
     * The type of sensor used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String sensor;

    /**
     * The distance to the subject of the photo, in meters.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer subjectDistance;

    /**
     * The date and time the photo was taken (EXIF DateTime).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String time;

    /**
     * The white balance mode used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String whiteBalance;

    /**
     * The width of the image in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer width;

    /**
     * The aperture used to create the photo (f-number).
     * @return value or {@code null} for none
     */
    public java.lang.Float getAperture() {
      return aperture;
    }

    /**
     * The aperture used to create the photo (f-number).
     * @param aperture aperture or {@code null} for none
     */
    public ImageMediaMetadata setAperture(java.lang.Float aperture) {
      this.aperture = aperture;
      return this;
    }

    /**
     * The make of the camera used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getCameraMake() {
      return cameraMake;
    }

    /**
     * The make of the camera used to create the photo.
     * @param cameraMake cameraMake or {@code null} for none
     */
    public ImageMediaMetadata setCameraMake(java.lang.String cameraMake) {
      this.cameraMake = cameraMake;
      return this;
    }

    /**
     * The model of the camera used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getCameraModel() {
      return cameraModel;
    }

    /**
     * The model of the camera used to create the photo.
     * @param cameraModel cameraModel or {@code null} for none
     */
    public ImageMediaMetadata setCameraModel(java.lang.String cameraModel) {
      this.cameraModel = cameraModel;
      return this;
    }

    /**
     * The color space of the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getColorSpace() {
      return colorSpace;
    }

    /**
     * The color space of the photo.
     * @param colorSpace colorSpace or {@code null} for none
     */
    public ImageMediaMetadata setColorSpace(java.lang.String colorSpace) {
      this.colorSpace = colorSpace;
      return this;
    }

    /**
     * The exposure bias of the photo (APEX value).
     * @return value or {@code null} for none
     */
    public java.lang.Float getExposureBias() {
      return exposureBias;
    }

    /**
     * The exposure bias of the photo (APEX value).
     * @param exposureBias exposureBias or {@code null} for none
     */
    public ImageMediaMetadata setExposureBias(java.lang.Float exposureBias) {
      this.exposureBias = exposureBias;
      return this;
    }

    /**
     * The exposure mode used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getExposureMode() {
      return exposureMode;
    }

    /**
     * The exposure mode used to create the photo.
     * @param exposureMode exposureMode or {@code null} for none
     */
    public ImageMediaMetadata setExposureMode(java.lang.String exposureMode) {
      this.exposureMode = exposureMode;
      return this;
    }

    /**
     * The length of the exposure, in seconds.
     * @return value or {@code null} for none
     */
    public java.lang.Float getExposureTime() {
      return exposureTime;
    }

    /**
     * The length of the exposure, in seconds.
     * @param exposureTime exposureTime or {@code null} for none
     */
    public ImageMediaMetadata setExposureTime(java.lang.Float exposureTime) {
      this.exposureTime = exposureTime;
      return this;
    }

    /**
     * Whether a flash was used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getFlashUsed() {
      return flashUsed;
    }

    /**
     * Whether a flash was used to create the photo.
     * @param flashUsed flashUsed or {@code null} for none
     */
    public ImageMediaMetadata setFlashUsed(java.lang.Boolean flashUsed) {
      this.flashUsed = flashUsed;
      return this;
    }

    /**
     * The focal length used to create the photo, in millimeters.
     * @return value or {@code null} for none
     */
    public java.lang.Float getFocalLength() {
      return focalLength;
    }

    /**
     * The focal length used to create the photo, in millimeters.
     * @param focalLength focalLength or {@code null} for none
     */
    public ImageMediaMetadata setFocalLength(java.lang.Float focalLength) {
      this.focalLength = focalLength;
      return this;
    }

    /**
     * The height of the image in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getHeight() {
      return height;
    }

    /**
     * The height of the image in pixels.
     * @param height height or {@code null} for none
     */
    public ImageMediaMetadata setHeight(java.lang.Integer height) {
      this.height = height;
      return this;
    }

    /**
     * The ISO speed used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getIsoSpeed() {
      return isoSpeed;
    }

    /**
     * The ISO speed used to create the photo.
     * @param isoSpeed isoSpeed or {@code null} for none
     */
    public ImageMediaMetadata setIsoSpeed(java.lang.Integer isoSpeed) {
      this.isoSpeed = isoSpeed;
      return this;
    }

    /**
     * The lens used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getLens() {
      return lens;
    }

    /**
     * The lens used to create the photo.
     * @param lens lens or {@code null} for none
     */
    public ImageMediaMetadata setLens(java.lang.String lens) {
      this.lens = lens;
      return this;
    }

    /**
     * Geographic location information stored in the image.
     * @return value or {@code null} for none
     */
    public Location getLocation() {
      return location;
    }

    /**
     * Geographic location information stored in the image.
     * @param location location or {@code null} for none
     */
    public ImageMediaMetadata setLocation(Location location) {
      this.location = location;
      return this;
    }

    /**
     * The smallest f-number of the lens at the focal length used to create the photo (APEX value).
     * @return value or {@code null} for none
     */
    public java.lang.Float getMaxApertureValue() {
      return maxApertureValue;
    }

    /**
     * The smallest f-number of the lens at the focal length used to create the photo (APEX value).
     * @param maxApertureValue maxApertureValue or {@code null} for none
     */
    public ImageMediaMetadata setMaxApertureValue(java.lang.Float maxApertureValue) {
      this.maxApertureValue = maxApertureValue;
      return this;
    }

    /**
     * The metering mode used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getMeteringMode() {
      return meteringMode;
    }

    /**
     * The metering mode used to create the photo.
     * @param meteringMode meteringMode or {@code null} for none
     */
    public ImageMediaMetadata setMeteringMode(java.lang.String meteringMode) {
      this.meteringMode = meteringMode;
      return this;
    }

    /**
     * The rotation in clockwise degrees from the image's original orientation.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getRotation() {
      return rotation;
    }

    /**
     * The rotation in clockwise degrees from the image's original orientation.
     * @param rotation rotation or {@code null} for none
     */
    public ImageMediaMetadata setRotation(java.lang.Integer rotation) {
      this.rotation = rotation;
      return this;
    }

    /**
     * The type of sensor used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getSensor() {
      return sensor;
    }

    /**
     * The type of sensor used to create the photo.
     * @param sensor sensor or {@code null} for none
     */
    public ImageMediaMetadata setSensor(java.lang.String sensor) {
      this.sensor = sensor;
      return this;
    }

    /**
     * The distance to the subject of the photo, in meters.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getSubjectDistance() {
      return subjectDistance;
    }

    /**
     * The distance to the subject of the photo, in meters.
     * @param subjectDistance subjectDistance or {@code null} for none
     */
    public ImageMediaMetadata setSubjectDistance(java.lang.Integer subjectDistance) {
      this.subjectDistance = subjectDistance;
      return this;
    }

    /**
     * The date and time the photo was taken (EXIF DateTime).
     * @return value or {@code null} for none
     */
    public java.lang.String getTime() {
      return time;
    }

    /**
     * The date and time the photo was taken (EXIF DateTime).
     * @param time time or {@code null} for none
     */
    public ImageMediaMetadata setTime(java.lang.String time) {
      this.time = time;
      return this;
    }

    /**
     * The white balance mode used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getWhiteBalance() {
      return whiteBalance;
    }

    /**
     * The white balance mode used to create the photo.
     * @param whiteBalance whiteBalance or {@code null} for none
     */
    public ImageMediaMetadata setWhiteBalance(java.lang.String whiteBalance) {
      this.whiteBalance = whiteBalance;
      return this;
    }

    /**
     * The width of the image in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getWidth() {
      return width;
    }

    /**
     * The width of the image in pixels.
     * @param width width or {@code null} for none
     */
    public ImageMediaMetadata setWidth(java.lang.Integer width) {
      this.width = width;
      return this;
    }

    @Override
    public ImageMediaMetadata set(String fieldName, Object value) {
      return (ImageMediaMetadata) super.set(fieldName, value);
    }

    @Override
    public ImageMediaMetadata clone() {
      return (ImageMediaMetadata) super.clone();
    }

    /**
     * Geographic location information stored in the image.
     */
    public static final class Location extends com.google.api.client.json.GenericJson {

      /**
       * The altitude stored in the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Double altitude;

      /**
       * The latitude stored in the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Double latitude;

      /**
       * The longitude stored in the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Double longitude;

      /**
       * The altitude stored in the image.
       * @return value or {@code null} for none
       */
      public java.lang.Double getAltitude() {
        return altitude;
      }

      /**
       * The altitude stored in the image.
       * @param altitude altitude or {@code null} for none
       */
      public Location setAltitude(java.lang.Double altitude) {
        this.altitude = altitude;
        return this;
      }

      /**
       * The latitude stored in the image.
       * @return value or {@code null} for none
       */
      public java.lang.Double getLatitude() {
        return latitude;
      }

      /**
       * The latitude stored in the image.
       * @param latitude latitude or {@code null} for none
       */
      public Location setLatitude(java.lang.Double latitude) {
        this.latitude = latitude;
        return this;
      }

      /**
       * The longitude stored in the image.
       * @return value or {@code null} for none
       */
      public java.lang.Double getLongitude() {
        return longitude;
      }

      /**
       * The longitude stored in the image.
       * @param longitude longitude or {@code null} for none
       */
      public Location setLongitude(java.lang.Double longitude) {
        this.longitude = longitude;
        return this;
      }

      @Override
      public Location set(String fieldName, Object value) {
        return (Location) super.set(fieldName, value);
      }

      @Override
      public Location clone() {
        return (Location) super.clone();
      }

    }
  }

  /**
   * Additional metadata about video media. This may not be available immediately upon upload.
   */
  public static final class VideoMediaMetadata extends com.google.api.client.json.GenericJson {

    /**
     * The duration of the video in milliseconds.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long durationMillis;

    /**
     * The height of the video in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer height;

    /**
     * The width of the video in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer width;

    /**
     * The duration of the video in milliseconds.
     * @return value or {@code null} for none
     */
    public java.lang.Long getDurationMillis() {
      return durationMillis;
    }

    /**
     * The duration of the video in milliseconds.
     * @param durationMillis durationMillis or {@code null} for none
     */
    public VideoMediaMetadata setDurationMillis(java.lang.Long durationMillis) {
      this.durationMillis = durationMillis;
      return this;
    }

    /**
     * The height of the video in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getHeight() {
      return height;
    }

    /**
     * The height of the video in pixels.
     * @param height height or {@code null} for none
     */
    public VideoMediaMetadata setHeight(java.lang.Integer height) {
      this.height = height;
      return this;
    }

    /**
     * The width of the video in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getWidth() {
      return width;
    }

    /**
     * The width of the video in pixels.
     * @param width width or {@code null} for none
     */
    public VideoMediaMetadata setWidth(java.lang.Integer width) {
      this.width = width;
      return this;
    }

    @Override
    public VideoMediaMetadata set(String fieldName, Object value) {
      return (VideoMediaMetadata) super.set(fieldName, value);
    }

    @Override
    public VideoMediaMetadata clone() {
      return (VideoMediaMetadata) super.clone();
    }

  }

}
