/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A list of labels applied to a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LabelList extends com.google.api.client.json.GenericJson {

  /**
   * This is always drive#labelList
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The list of labels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Label> labels;

  static {
    // hack to force ProGuard to consider Label used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Label.class);
  }

  /**
   * The page token for the next page of labels. This field will be absent if the end of the list
   * has been reached. If the token is rejected for any reason, it should be discarded, and
   * pagination should be restarted from the first page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * This is always drive#labelList
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#labelList
   * @param kind kind or {@code null} for none
   */
  public LabelList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The list of labels.
   * @return value or {@code null} for none
   */
  public java.util.List<Label> getLabels() {
    return labels;
  }

  /**
   * The list of labels.
   * @param labels labels or {@code null} for none
   */
  public LabelList setLabels(java.util.List<Label> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The page token for the next page of labels. This field will be absent if the end of the list
   * has been reached. If the token is rejected for any reason, it should be discarded, and
   * pagination should be restarted from the first page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The page token for the next page of labels. This field will be absent if the end of the list
   * has been reached. If the token is rejected for any reason, it should be discarded, and
   * pagination should be restarted from the first page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public LabelList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public LabelList set(String fieldName, Object value) {
    return (LabelList) super.set(fieldName, value);
  }

  @Override
  public LabelList clone() {
    return (LabelList) super.clone();
  }

}
