/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.drive;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UriTemplate;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.drive.DriveRequest;
import com.google.api.services.drive.DriveRequestInitializer;
import com.google.api.services.drive.model.App;
import com.google.api.services.drive.model.AppList;
import com.google.api.services.drive.model.ChangeList;
import com.google.api.services.drive.model.Channel;
import com.google.api.services.drive.model.Comment;
import com.google.api.services.drive.model.CommentList;
import com.google.api.services.drive.model.DriveList;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.drive.model.GeneratedIds;
import com.google.api.services.drive.model.LabelList;
import com.google.api.services.drive.model.ModifyLabelsRequest;
import com.google.api.services.drive.model.ModifyLabelsResponse;
import com.google.api.services.drive.model.Permission;
import com.google.api.services.drive.model.PermissionList;
import com.google.api.services.drive.model.Reply;
import com.google.api.services.drive.model.ReplyList;
import com.google.api.services.drive.model.Revision;
import com.google.api.services.drive.model.RevisionList;
import com.google.api.services.drive.model.StartPageToken;
import com.google.api.services.drive.model.TeamDrive;
import com.google.api.services.drive.model.TeamDriveList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Drive
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://www.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "drive/v3/";
    public static final String DEFAULT_BATCH_PATH = "batch/drive/v3";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/drive/v3/";

    public Drive(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Drive(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public About about() {
        return new About();
    }

    public Apps apps() {
        return new Apps();
    }

    public Changes changes() {
        return new Changes();
    }

    public Channels channels() {
        return new Channels();
    }

    public Comments comments() {
        return new Comments();
    }

    public Drives drives() {
        return new Drives();
    }

    public Files files() {
        return new Files();
    }

    public Permissions permissions() {
        return new Permissions();
    }

    public Replies replies() {
        return new Replies();
    }

    public Revisions revisions() {
        return new Revisions();
    }

    public Teamdrives teamdrives() {
        return new Teamdrives();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Google Drive API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Drive.DEFAULT_MTLS_ROOT_URL;
            }
            return Drive.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Drive.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Drive.DEFAULT_BATCH_PATH);
        }

        public Drive build() {
            return new Drive(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDriveRequestInitializer(DriveRequestInitializer driveRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)driveRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Teamdrives {
        public Create create(String requestId, TeamDrive content) throws IOException {
            Create result = new Create(requestId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String teamDriveId) throws IOException {
            Delete result = new Delete(teamDriveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String teamDriveId) throws IOException {
            Get result = new Get(teamDriveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String teamDriveId, TeamDrive content) throws IOException {
            Update result = new Update(teamDriveId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<TeamDrive> {
            private static final String REST_PATH = "teamdrives/{teamDriveId}";
            @Key
            private String teamDriveId;
            @Key
            private Boolean useDomainAdminAccess;

            protected Update(String teamDriveId, TeamDrive content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, TeamDrive.class);
                this.teamDriveId = (String)Preconditions.checkNotNull((Object)teamDriveId, (Object)"Required parameter teamDriveId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Update setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Update setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<TeamDriveList> {
            private static final String REST_PATH = "teamdrives";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String q;
            @Key
            private Boolean useDomainAdminAccess;

            protected List() {
                super(Drive.this, "GET", REST_PATH, null, TeamDriveList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public List setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<TeamDrive> {
            private static final String REST_PATH = "teamdrives/{teamDriveId}";
            @Key
            private String teamDriveId;
            @Key
            private Boolean useDomainAdminAccess;

            protected Get(String teamDriveId) {
                super(Drive.this, "GET", REST_PATH, null, TeamDrive.class);
                this.teamDriveId = (String)Preconditions.checkNotNull((Object)teamDriveId, (Object)"Required parameter teamDriveId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Get setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Get setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "teamdrives/{teamDriveId}";
            @Key
            private String teamDriveId;

            protected Delete(String teamDriveId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.teamDriveId = (String)Preconditions.checkNotNull((Object)teamDriveId, (Object)"Required parameter teamDriveId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Delete setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DriveRequest<TeamDrive> {
            private static final String REST_PATH = "teamdrives";
            @Key
            private String requestId;

            protected Create(String requestId, TeamDrive content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, TeamDrive.class);
                this.requestId = (String)Preconditions.checkNotNull((Object)requestId, (Object)"Required parameter requestId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Create setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Revisions {
        public Delete delete(String fileId, String revisionId) throws IOException {
            Delete result = new Delete(fileId, revisionId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId, String revisionId) throws IOException {
            Get result = new Get(fileId, revisionId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String fileId) throws IOException {
            List result = new List(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, String revisionId, Revision content) throws IOException {
            Update result = new Update(fileId, revisionId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<Revision> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Update(String fileId, String revisionId, Revision content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, Revision.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.revisionId = (String)Preconditions.checkNotNull((Object)revisionId, (Object)"Required parameter revisionId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Update setRevisionId(String revisionId) {
                this.revisionId = revisionId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<RevisionList> {
            private static final String REST_PATH = "files/{fileId}/revisions";
            @Key
            private String fileId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String fileId) {
                super(Drive.this, "GET", REST_PATH, null, RevisionList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<Revision> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;
            @Key
            private Boolean acknowledgeAbuse;

            protected Get(String fileId, String revisionId) {
                super(Drive.this, "GET", REST_PATH, null, Revision.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.revisionId = (String)Preconditions.checkNotNull((Object)revisionId, (Object)"Required parameter revisionId must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public GenericUrl buildHttpRequestUrl() {
                String baseUrl = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? Drive.this.getRootUrl() + "download/" + Drive.this.getServicePath() : Drive.this.getBaseUrl();
                return new GenericUrl(UriTemplate.expand((String)baseUrl, (String)this.getUriTemplate(), (Object)((Object)this), (boolean)true));
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Get setRevisionId(String revisionId) {
                this.revisionId = revisionId;
                return this;
            }

            public Boolean getAcknowledgeAbuse() {
                return this.acknowledgeAbuse;
            }

            public Get setAcknowledgeAbuse(Boolean acknowledgeAbuse) {
                this.acknowledgeAbuse = acknowledgeAbuse;
                return this;
            }

            public boolean isAcknowledgeAbuse() {
                if (this.acknowledgeAbuse == null || this.acknowledgeAbuse == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.acknowledgeAbuse;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Delete(String fileId, String revisionId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.revisionId = (String)Preconditions.checkNotNull((Object)revisionId, (Object)"Required parameter revisionId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Delete setRevisionId(String revisionId) {
                this.revisionId = revisionId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Replies {
        public Create create(String fileId, String commentId, Reply content) throws IOException {
            Create result = new Create(fileId, commentId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String fileId, String commentId, String replyId) throws IOException {
            Delete result = new Delete(fileId, commentId, replyId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId, String commentId, String replyId) throws IOException {
            Get result = new Get(fileId, commentId, replyId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String fileId, String commentId) throws IOException {
            List result = new List(fileId, commentId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, String commentId, String replyId, Reply content) throws IOException {
            Update result = new Update(fileId, commentId, replyId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<Reply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;

            protected Update(String fileId, String commentId, String replyId, Reply content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, Reply.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
                this.replyId = (String)Preconditions.checkNotNull((Object)replyId, (Object)"Required parameter replyId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getContent(), "Reply.getContent()");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Update setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Update setReplyId(String replyId) {
                this.replyId = replyId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<ReplyList> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private Boolean includeDeleted;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String fileId, String commentId) {
                super(Drive.this, "GET", REST_PATH, null, ReplyList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public List setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public List setIncludeDeleted(Boolean includeDeleted) {
                this.includeDeleted = includeDeleted;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<Reply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;
            @Key
            private Boolean includeDeleted;

            protected Get(String fileId, String commentId, String replyId) {
                super(Drive.this, "GET", REST_PATH, null, Reply.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
                this.replyId = (String)Preconditions.checkNotNull((Object)replyId, (Object)"Required parameter replyId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Get setReplyId(String replyId) {
                this.replyId = replyId;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public Get setIncludeDeleted(Boolean includeDeleted) {
                this.includeDeleted = includeDeleted;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;

            protected Delete(String fileId, String commentId, String replyId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
                this.replyId = (String)Preconditions.checkNotNull((Object)replyId, (Object)"Required parameter replyId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Delete setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Delete setReplyId(String replyId) {
                this.replyId = replyId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DriveRequest<Reply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Create(String fileId, String commentId, Reply content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Reply.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Create setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Create setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Permissions {
        public Create create(String fileId, Permission content) throws IOException {
            Create result = new Create(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String fileId, String permissionId) throws IOException {
            Delete result = new Delete(fileId, permissionId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId, String permissionId) throws IOException {
            Get result = new Get(fileId, permissionId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String fileId) throws IOException {
            List result = new List(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, String permissionId, Permission content) throws IOException {
            Update result = new Update(fileId, permissionId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean removeExpiration;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean transferOwnership;
            @Key
            private Boolean useDomainAdminAccess;

            protected Update(String fileId, String permissionId, Permission content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, Permission.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.permissionId = (String)Preconditions.checkNotNull((Object)permissionId, (Object)"Required parameter permissionId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Update setPermissionId(String permissionId) {
                this.permissionId = permissionId;
                return this;
            }

            public Boolean getRemoveExpiration() {
                return this.removeExpiration;
            }

            public Update setRemoveExpiration(Boolean removeExpiration) {
                this.removeExpiration = removeExpiration;
                return this;
            }

            public boolean isRemoveExpiration() {
                if (this.removeExpiration == null || this.removeExpiration == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.removeExpiration;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Update setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Update setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getTransferOwnership() {
                return this.transferOwnership;
            }

            public Update setTransferOwnership(Boolean transferOwnership) {
                this.transferOwnership = transferOwnership;
                return this;
            }

            public boolean isTransferOwnership() {
                if (this.transferOwnership == null || this.transferOwnership == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.transferOwnership;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Update setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<PermissionList> {
            private static final String REST_PATH = "files/{fileId}/permissions";
            @Key
            private String fileId;
            @Key
            private String includePermissionsForView;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean useDomainAdminAccess;

            protected List(String fileId) {
                super(Drive.this, "GET", REST_PATH, null, PermissionList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public List setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public List setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public List setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public List setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean useDomainAdminAccess;

            protected Get(String fileId, String permissionId) {
                super(Drive.this, "GET", REST_PATH, null, Permission.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.permissionId = (String)Preconditions.checkNotNull((Object)permissionId, (Object)"Required parameter permissionId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Get setPermissionId(String permissionId) {
                this.permissionId = permissionId;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Get setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Get setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Get setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean useDomainAdminAccess;

            protected Delete(String fileId, String permissionId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.permissionId = (String)Preconditions.checkNotNull((Object)permissionId, (Object)"Required parameter permissionId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Delete setPermissionId(String permissionId) {
                this.permissionId = permissionId;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Delete setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Delete setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Delete setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions";
            @Key
            private String fileId;
            @Key
            private String emailMessage;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private Boolean moveToNewOwnersRoot;
            @Key
            private Boolean sendNotificationEmail;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean transferOwnership;
            @Key
            private Boolean useDomainAdminAccess;

            protected Create(String fileId, Permission content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Permission.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getRole(), "Permission.getRole()");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getType(), "Permission.getType()");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Create setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getEmailMessage() {
                return this.emailMessage;
            }

            public Create setEmailMessage(String emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Create setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public Boolean getMoveToNewOwnersRoot() {
                return this.moveToNewOwnersRoot;
            }

            public Create setMoveToNewOwnersRoot(Boolean moveToNewOwnersRoot) {
                this.moveToNewOwnersRoot = moveToNewOwnersRoot;
                return this;
            }

            public boolean isMoveToNewOwnersRoot() {
                if (this.moveToNewOwnersRoot == null || this.moveToNewOwnersRoot == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.moveToNewOwnersRoot;
            }

            public Boolean getSendNotificationEmail() {
                return this.sendNotificationEmail;
            }

            public Create setSendNotificationEmail(Boolean sendNotificationEmail) {
                this.sendNotificationEmail = sendNotificationEmail;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Create setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Create setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getTransferOwnership() {
                return this.transferOwnership;
            }

            public Create setTransferOwnership(Boolean transferOwnership) {
                this.transferOwnership = transferOwnership;
                return this;
            }

            public boolean isTransferOwnership() {
                if (this.transferOwnership == null || this.transferOwnership == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.transferOwnership;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Create setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Files {
        public Copy copy(String fileId, File content) throws IOException {
            Copy result = new Copy(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(File content) throws IOException {
            Create result = new Create(content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(File content, AbstractInputStreamContent mediaContent) throws IOException {
            Create result = new Create(content, mediaContent);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String fileId) throws IOException {
            Delete result = new Delete(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public EmptyTrash emptyTrash() throws IOException {
            EmptyTrash result = new EmptyTrash();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Export export(String fileId, String mimeType) throws IOException {
            Export result = new Export(fileId, mimeType);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GenerateIds generateIds() throws IOException {
            GenerateIds result = new GenerateIds();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId) throws IOException {
            Get result = new Get(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListLabels listLabels(String fileId) throws IOException {
            ListLabels result = new ListLabels(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ModifyLabels modifyLabels(String fileId, ModifyLabelsRequest content) throws IOException {
            ModifyLabels result = new ModifyLabels(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, File content) throws IOException {
            Update result = new Update(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, File content, AbstractInputStreamContent mediaContent) throws IOException {
            Update result = new Update(fileId, content, mediaContent);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Watch watch(String fileId, Channel content) throws IOException {
            Watch result = new Watch(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Watch
        extends DriveRequest<Channel> {
            private static final String REST_PATH = "files/{fileId}/watch";
            @Key
            private String fileId;
            @Key
            private Boolean acknowledgeAbuse;
            @Key
            private String includeLabels;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;

            protected Watch(String fileId, Channel content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Channel.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public Watch set$Xgafv(String $Xgafv) {
                return (Watch)super.set$Xgafv($Xgafv);
            }

            public Watch setAccessToken(String accessToken) {
                return (Watch)super.setAccessToken(accessToken);
            }

            public Watch setAlt(String alt) {
                return (Watch)super.setAlt(alt);
            }

            public Watch setCallback(String callback) {
                return (Watch)super.setCallback(callback);
            }

            public Watch setFields(String fields) {
                return (Watch)super.setFields(fields);
            }

            public Watch setKey(String key) {
                return (Watch)super.setKey(key);
            }

            public Watch setOauthToken(String oauthToken) {
                return (Watch)super.setOauthToken(oauthToken);
            }

            public Watch setPrettyPrint(Boolean prettyPrint) {
                return (Watch)super.setPrettyPrint(prettyPrint);
            }

            public Watch setQuotaUser(String quotaUser) {
                return (Watch)super.setQuotaUser(quotaUser);
            }

            public Watch setUploadType(String uploadType) {
                return (Watch)super.setUploadType(uploadType);
            }

            public Watch setUploadProtocol(String uploadProtocol) {
                return (Watch)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Watch setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Boolean getAcknowledgeAbuse() {
                return this.acknowledgeAbuse;
            }

            public Watch setAcknowledgeAbuse(Boolean acknowledgeAbuse) {
                this.acknowledgeAbuse = acknowledgeAbuse;
                return this;
            }

            public boolean isAcknowledgeAbuse() {
                if (this.acknowledgeAbuse == null || this.acknowledgeAbuse == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.acknowledgeAbuse;
            }

            public String getIncludeLabels() {
                return this.includeLabels;
            }

            public Watch setIncludeLabels(String includeLabels) {
                this.includeLabels = includeLabels;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Watch setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Watch setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Watch setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Watch set(String parameterName, Object value) {
                return (Watch)super.set(parameterName, value);
            }
        }

        public class Update
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private String addParents;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private String includeLabels;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean keepRevisionForever;
            @Key
            private String ocrLanguage;
            @Key
            private String removeParents;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean useContentAsIndexableText;

            protected Update(String fileId, File content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            protected Update(String fileId, File content, AbstractInputStreamContent mediaContent) {
                super(Drive.this, "PATCH", "/upload/" + Drive.this.getServicePath() + REST_PATH, (Object)content, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getAddParents() {
                return this.addParents;
            }

            public Update setAddParents(String addParents) {
                this.addParents = addParents;
                return this;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Update setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public String getIncludeLabels() {
                return this.includeLabels;
            }

            public Update setIncludeLabels(String includeLabels) {
                this.includeLabels = includeLabels;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Update setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getKeepRevisionForever() {
                return this.keepRevisionForever;
            }

            public Update setKeepRevisionForever(Boolean keepRevisionForever) {
                this.keepRevisionForever = keepRevisionForever;
                return this;
            }

            public boolean isKeepRevisionForever() {
                if (this.keepRevisionForever == null || this.keepRevisionForever == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.keepRevisionForever;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Update setOcrLanguage(String ocrLanguage) {
                this.ocrLanguage = ocrLanguage;
                return this;
            }

            public String getRemoveParents() {
                return this.removeParents;
            }

            public Update setRemoveParents(String removeParents) {
                this.removeParents = removeParents;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Update setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Update setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUseContentAsIndexableText() {
                return this.useContentAsIndexableText;
            }

            public Update setUseContentAsIndexableText(Boolean useContentAsIndexableText) {
                this.useContentAsIndexableText = useContentAsIndexableText;
                return this;
            }

            public boolean isUseContentAsIndexableText() {
                if (this.useContentAsIndexableText == null || this.useContentAsIndexableText == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useContentAsIndexableText;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class ModifyLabels
        extends DriveRequest<ModifyLabelsResponse> {
            private static final String REST_PATH = "files/{fileId}/modifyLabels";
            @Key
            private String fileId;

            protected ModifyLabels(String fileId, ModifyLabelsRequest content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, ModifyLabelsResponse.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public ModifyLabels set$Xgafv(String $Xgafv) {
                return (ModifyLabels)super.set$Xgafv($Xgafv);
            }

            public ModifyLabels setAccessToken(String accessToken) {
                return (ModifyLabels)super.setAccessToken(accessToken);
            }

            public ModifyLabels setAlt(String alt) {
                return (ModifyLabels)super.setAlt(alt);
            }

            public ModifyLabels setCallback(String callback) {
                return (ModifyLabels)super.setCallback(callback);
            }

            public ModifyLabels setFields(String fields) {
                return (ModifyLabels)super.setFields(fields);
            }

            public ModifyLabels setKey(String key) {
                return (ModifyLabels)super.setKey(key);
            }

            public ModifyLabels setOauthToken(String oauthToken) {
                return (ModifyLabels)super.setOauthToken(oauthToken);
            }

            public ModifyLabels setPrettyPrint(Boolean prettyPrint) {
                return (ModifyLabels)super.setPrettyPrint(prettyPrint);
            }

            public ModifyLabels setQuotaUser(String quotaUser) {
                return (ModifyLabels)super.setQuotaUser(quotaUser);
            }

            public ModifyLabels setUploadType(String uploadType) {
                return (ModifyLabels)super.setUploadType(uploadType);
            }

            public ModifyLabels setUploadProtocol(String uploadProtocol) {
                return (ModifyLabels)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public ModifyLabels setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            @Override
            public ModifyLabels set(String parameterName, Object value) {
                return (ModifyLabels)super.set(parameterName, value);
            }
        }

        public class ListLabels
        extends DriveRequest<LabelList> {
            private static final String REST_PATH = "files/{fileId}/listLabels";
            @Key
            private String fileId;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected ListLabels(String fileId) {
                super(Drive.this, "GET", REST_PATH, null, LabelList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListLabels set$Xgafv(String $Xgafv) {
                return (ListLabels)super.set$Xgafv($Xgafv);
            }

            public ListLabels setAccessToken(String accessToken) {
                return (ListLabels)super.setAccessToken(accessToken);
            }

            public ListLabels setAlt(String alt) {
                return (ListLabels)super.setAlt(alt);
            }

            public ListLabels setCallback(String callback) {
                return (ListLabels)super.setCallback(callback);
            }

            public ListLabels setFields(String fields) {
                return (ListLabels)super.setFields(fields);
            }

            public ListLabels setKey(String key) {
                return (ListLabels)super.setKey(key);
            }

            public ListLabels setOauthToken(String oauthToken) {
                return (ListLabels)super.setOauthToken(oauthToken);
            }

            public ListLabels setPrettyPrint(Boolean prettyPrint) {
                return (ListLabels)super.setPrettyPrint(prettyPrint);
            }

            public ListLabels setQuotaUser(String quotaUser) {
                return (ListLabels)super.setQuotaUser(quotaUser);
            }

            public ListLabels setUploadType(String uploadType) {
                return (ListLabels)super.setUploadType(uploadType);
            }

            public ListLabels setUploadProtocol(String uploadProtocol) {
                return (ListLabels)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public ListLabels setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public ListLabels setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListLabels setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public ListLabels set(String parameterName, Object value) {
                return (ListLabels)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<FileList> {
            private static final String REST_PATH = "files";
            @Key
            private String corpora;
            @Key
            private String corpus;
            @Key
            private String driveId;
            @Key
            private Boolean includeItemsFromAllDrives;
            @Key
            private String includeLabels;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean includeTeamDriveItems;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String q;
            @Key
            private String spaces;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected List() {
                super(Drive.this, "GET", REST_PATH, null, FileList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCorpora() {
                return this.corpora;
            }

            public List setCorpora(String corpora) {
                this.corpora = corpora;
                return this;
            }

            public String getCorpus() {
                return this.corpus;
            }

            public List setCorpus(String corpus) {
                this.corpus = corpus;
                return this;
            }

            public String getDriveId() {
                return this.driveId;
            }

            public List setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getIncludeItemsFromAllDrives() {
                return this.includeItemsFromAllDrives;
            }

            public List setIncludeItemsFromAllDrives(Boolean includeItemsFromAllDrives) {
                this.includeItemsFromAllDrives = includeItemsFromAllDrives;
                return this;
            }

            public boolean isIncludeItemsFromAllDrives() {
                if (this.includeItemsFromAllDrives == null || this.includeItemsFromAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeItemsFromAllDrives;
            }

            public String getIncludeLabels() {
                return this.includeLabels;
            }

            public List setIncludeLabels(String includeLabels) {
                this.includeLabels = includeLabels;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public List setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getIncludeTeamDriveItems() {
                return this.includeTeamDriveItems;
            }

            public List setIncludeTeamDriveItems(Boolean includeTeamDriveItems) {
                this.includeTeamDriveItems = includeTeamDriveItems;
                return this;
            }

            public boolean isIncludeTeamDriveItems() {
                if (this.includeTeamDriveItems == null || this.includeTeamDriveItems == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeTeamDriveItems;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public List setSpaces(String spaces) {
                this.spaces = spaces;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public List setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public List setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public List setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private Boolean acknowledgeAbuse;
            @Key
            private String includeLabels;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;

            protected Get(String fileId) {
                super(Drive.this, "GET", REST_PATH, null, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public GenericUrl buildHttpRequestUrl() {
                String baseUrl = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? Drive.this.getRootUrl() + "download/" + Drive.this.getServicePath() : Drive.this.getBaseUrl();
                return new GenericUrl(UriTemplate.expand((String)baseUrl, (String)this.getUriTemplate(), (Object)((Object)this), (boolean)true));
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Boolean getAcknowledgeAbuse() {
                return this.acknowledgeAbuse;
            }

            public Get setAcknowledgeAbuse(Boolean acknowledgeAbuse) {
                this.acknowledgeAbuse = acknowledgeAbuse;
                return this;
            }

            public boolean isAcknowledgeAbuse() {
                if (this.acknowledgeAbuse == null || this.acknowledgeAbuse == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.acknowledgeAbuse;
            }

            public String getIncludeLabels() {
                return this.includeLabels;
            }

            public Get setIncludeLabels(String includeLabels) {
                this.includeLabels = includeLabels;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Get setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Get setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Get setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class GenerateIds
        extends DriveRequest<GeneratedIds> {
            private static final String REST_PATH = "files/generateIds";
            @Key
            private Integer count;
            @Key
            private String space;
            @Key
            private String type;

            protected GenerateIds() {
                super(Drive.this, "GET", REST_PATH, null, GeneratedIds.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GenerateIds set$Xgafv(String $Xgafv) {
                return (GenerateIds)super.set$Xgafv($Xgafv);
            }

            public GenerateIds setAccessToken(String accessToken) {
                return (GenerateIds)super.setAccessToken(accessToken);
            }

            public GenerateIds setAlt(String alt) {
                return (GenerateIds)super.setAlt(alt);
            }

            public GenerateIds setCallback(String callback) {
                return (GenerateIds)super.setCallback(callback);
            }

            public GenerateIds setFields(String fields) {
                return (GenerateIds)super.setFields(fields);
            }

            public GenerateIds setKey(String key) {
                return (GenerateIds)super.setKey(key);
            }

            public GenerateIds setOauthToken(String oauthToken) {
                return (GenerateIds)super.setOauthToken(oauthToken);
            }

            public GenerateIds setPrettyPrint(Boolean prettyPrint) {
                return (GenerateIds)super.setPrettyPrint(prettyPrint);
            }

            public GenerateIds setQuotaUser(String quotaUser) {
                return (GenerateIds)super.setQuotaUser(quotaUser);
            }

            public GenerateIds setUploadType(String uploadType) {
                return (GenerateIds)super.setUploadType(uploadType);
            }

            public GenerateIds setUploadProtocol(String uploadProtocol) {
                return (GenerateIds)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getCount() {
                return this.count;
            }

            public GenerateIds setCount(Integer count) {
                this.count = count;
                return this;
            }

            public String getSpace() {
                return this.space;
            }

            public GenerateIds setSpace(String space) {
                this.space = space;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public GenerateIds setType(String type) {
                this.type = type;
                return this;
            }

            @Override
            public GenerateIds set(String parameterName, Object value) {
                return (GenerateIds)super.set(parameterName, value);
            }
        }

        public class Export
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/export";
            @Key
            private String fileId;
            @Key
            private String mimeType;

            protected Export(String fileId, String mimeType) {
                super(Drive.this, "GET", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.mimeType = (String)Preconditions.checkNotNull((Object)mimeType, (Object)"Required parameter mimeType must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public GenericUrl buildHttpRequestUrl() {
                String baseUrl = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? Drive.this.getRootUrl() + "download/" + Drive.this.getServicePath() : Drive.this.getBaseUrl();
                return new GenericUrl(UriTemplate.expand((String)baseUrl, (String)this.getUriTemplate(), (Object)((Object)this), (boolean)true));
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Export set$Xgafv(String $Xgafv) {
                return (Export)super.set$Xgafv($Xgafv);
            }

            public Export setAccessToken(String accessToken) {
                return (Export)super.setAccessToken(accessToken);
            }

            public Export setAlt(String alt) {
                return (Export)super.setAlt(alt);
            }

            public Export setCallback(String callback) {
                return (Export)super.setCallback(callback);
            }

            public Export setFields(String fields) {
                return (Export)super.setFields(fields);
            }

            public Export setKey(String key) {
                return (Export)super.setKey(key);
            }

            public Export setOauthToken(String oauthToken) {
                return (Export)super.setOauthToken(oauthToken);
            }

            public Export setPrettyPrint(Boolean prettyPrint) {
                return (Export)super.setPrettyPrint(prettyPrint);
            }

            public Export setQuotaUser(String quotaUser) {
                return (Export)super.setQuotaUser(quotaUser);
            }

            public Export setUploadType(String uploadType) {
                return (Export)super.setUploadType(uploadType);
            }

            public Export setUploadProtocol(String uploadProtocol) {
                return (Export)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Export setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public Export setMimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            @Override
            public Export set(String parameterName, Object value) {
                return (Export)super.set(parameterName, value);
            }
        }

        public class EmptyTrash
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/trash";
            @Key
            private String driveId;
            @Key
            private Boolean enforceSingleParent;

            protected EmptyTrash() {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
            }

            public EmptyTrash set$Xgafv(String $Xgafv) {
                return (EmptyTrash)super.set$Xgafv($Xgafv);
            }

            public EmptyTrash setAccessToken(String accessToken) {
                return (EmptyTrash)super.setAccessToken(accessToken);
            }

            public EmptyTrash setAlt(String alt) {
                return (EmptyTrash)super.setAlt(alt);
            }

            public EmptyTrash setCallback(String callback) {
                return (EmptyTrash)super.setCallback(callback);
            }

            public EmptyTrash setFields(String fields) {
                return (EmptyTrash)super.setFields(fields);
            }

            public EmptyTrash setKey(String key) {
                return (EmptyTrash)super.setKey(key);
            }

            public EmptyTrash setOauthToken(String oauthToken) {
                return (EmptyTrash)super.setOauthToken(oauthToken);
            }

            public EmptyTrash setPrettyPrint(Boolean prettyPrint) {
                return (EmptyTrash)super.setPrettyPrint(prettyPrint);
            }

            public EmptyTrash setQuotaUser(String quotaUser) {
                return (EmptyTrash)super.setQuotaUser(quotaUser);
            }

            public EmptyTrash setUploadType(String uploadType) {
                return (EmptyTrash)super.setUploadType(uploadType);
            }

            public EmptyTrash setUploadProtocol(String uploadProtocol) {
                return (EmptyTrash)super.setUploadProtocol(uploadProtocol);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public EmptyTrash setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public EmptyTrash setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            @Override
            public EmptyTrash set(String parameterName, Object value) {
                return (EmptyTrash)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;

            protected Delete(String fileId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Delete setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Delete setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Delete setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DriveRequest<File> {
            private static final String REST_PATH = "files";
            @Key
            private Boolean enforceSingleParent;
            @Key
            private Boolean ignoreDefaultVisibility;
            @Key
            private String includeLabels;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean keepRevisionForever;
            @Key
            private String ocrLanguage;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean useContentAsIndexableText;

            protected Create(File content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, File.class);
            }

            protected Create(File content, AbstractInputStreamContent mediaContent) {
                super(Drive.this, "POST", "/upload/" + Drive.this.getServicePath() + REST_PATH, (Object)content, File.class);
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Create setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public Boolean getIgnoreDefaultVisibility() {
                return this.ignoreDefaultVisibility;
            }

            public Create setIgnoreDefaultVisibility(Boolean ignoreDefaultVisibility) {
                this.ignoreDefaultVisibility = ignoreDefaultVisibility;
                return this;
            }

            public boolean isIgnoreDefaultVisibility() {
                if (this.ignoreDefaultVisibility == null || this.ignoreDefaultVisibility == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ignoreDefaultVisibility;
            }

            public String getIncludeLabels() {
                return this.includeLabels;
            }

            public Create setIncludeLabels(String includeLabels) {
                this.includeLabels = includeLabels;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Create setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getKeepRevisionForever() {
                return this.keepRevisionForever;
            }

            public Create setKeepRevisionForever(Boolean keepRevisionForever) {
                this.keepRevisionForever = keepRevisionForever;
                return this;
            }

            public boolean isKeepRevisionForever() {
                if (this.keepRevisionForever == null || this.keepRevisionForever == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.keepRevisionForever;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Create setOcrLanguage(String ocrLanguage) {
                this.ocrLanguage = ocrLanguage;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Create setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Create setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUseContentAsIndexableText() {
                return this.useContentAsIndexableText;
            }

            public Create setUseContentAsIndexableText(Boolean useContentAsIndexableText) {
                this.useContentAsIndexableText = useContentAsIndexableText;
                return this;
            }

            public boolean isUseContentAsIndexableText() {
                if (this.useContentAsIndexableText == null || this.useContentAsIndexableText == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useContentAsIndexableText;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class Copy
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}/copy";
            @Key
            private String fileId;
            @Key
            private Boolean enforceSingleParent;
            @Key
            private Boolean ignoreDefaultVisibility;
            @Key
            private String includeLabels;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean keepRevisionForever;
            @Key
            private String ocrLanguage;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;

            protected Copy(String fileId, File content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public Copy set$Xgafv(String $Xgafv) {
                return (Copy)super.set$Xgafv($Xgafv);
            }

            public Copy setAccessToken(String accessToken) {
                return (Copy)super.setAccessToken(accessToken);
            }

            public Copy setAlt(String alt) {
                return (Copy)super.setAlt(alt);
            }

            public Copy setCallback(String callback) {
                return (Copy)super.setCallback(callback);
            }

            public Copy setFields(String fields) {
                return (Copy)super.setFields(fields);
            }

            public Copy setKey(String key) {
                return (Copy)super.setKey(key);
            }

            public Copy setOauthToken(String oauthToken) {
                return (Copy)super.setOauthToken(oauthToken);
            }

            public Copy setPrettyPrint(Boolean prettyPrint) {
                return (Copy)super.setPrettyPrint(prettyPrint);
            }

            public Copy setQuotaUser(String quotaUser) {
                return (Copy)super.setQuotaUser(quotaUser);
            }

            public Copy setUploadType(String uploadType) {
                return (Copy)super.setUploadType(uploadType);
            }

            public Copy setUploadProtocol(String uploadProtocol) {
                return (Copy)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Copy setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Boolean getEnforceSingleParent() {
                return this.enforceSingleParent;
            }

            public Copy setEnforceSingleParent(Boolean enforceSingleParent) {
                this.enforceSingleParent = enforceSingleParent;
                return this;
            }

            public boolean isEnforceSingleParent() {
                if (this.enforceSingleParent == null || this.enforceSingleParent == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.enforceSingleParent;
            }

            public Boolean getIgnoreDefaultVisibility() {
                return this.ignoreDefaultVisibility;
            }

            public Copy setIgnoreDefaultVisibility(Boolean ignoreDefaultVisibility) {
                this.ignoreDefaultVisibility = ignoreDefaultVisibility;
                return this;
            }

            public boolean isIgnoreDefaultVisibility() {
                if (this.ignoreDefaultVisibility == null || this.ignoreDefaultVisibility == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ignoreDefaultVisibility;
            }

            public String getIncludeLabels() {
                return this.includeLabels;
            }

            public Copy setIncludeLabels(String includeLabels) {
                this.includeLabels = includeLabels;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Copy setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getKeepRevisionForever() {
                return this.keepRevisionForever;
            }

            public Copy setKeepRevisionForever(Boolean keepRevisionForever) {
                this.keepRevisionForever = keepRevisionForever;
                return this;
            }

            public boolean isKeepRevisionForever() {
                if (this.keepRevisionForever == null || this.keepRevisionForever == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.keepRevisionForever;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Copy setOcrLanguage(String ocrLanguage) {
                this.ocrLanguage = ocrLanguage;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Copy setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Copy setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Copy set(String parameterName, Object value) {
                return (Copy)super.set(parameterName, value);
            }
        }
    }

    public class Drives {
        public Create create(String requestId, com.google.api.services.drive.model.Drive content) throws IOException {
            Create result = new Create(requestId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String driveId) throws IOException {
            Delete result = new Delete(driveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String driveId) throws IOException {
            Get result = new Get(driveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Hide hide(String driveId) throws IOException {
            Hide result = new Hide(driveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Unhide unhide(String driveId) throws IOException {
            Unhide result = new Unhide(driveId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String driveId, com.google.api.services.drive.model.Drive content) throws IOException {
            Update result = new Update(driveId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<com.google.api.services.drive.model.Drive> {
            private static final String REST_PATH = "drives/{driveId}";
            @Key
            private String driveId;
            @Key
            private Boolean useDomainAdminAccess;

            protected Update(String driveId, com.google.api.services.drive.model.Drive content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.drive.model.Drive.class);
                this.driveId = (String)Preconditions.checkNotNull((Object)driveId, (Object)"Required parameter driveId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Update setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Update setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Unhide
        extends DriveRequest<com.google.api.services.drive.model.Drive> {
            private static final String REST_PATH = "drives/{driveId}/unhide";
            @Key
            private String driveId;

            protected Unhide(String driveId) {
                super(Drive.this, "POST", REST_PATH, null, com.google.api.services.drive.model.Drive.class);
                this.driveId = (String)Preconditions.checkNotNull((Object)driveId, (Object)"Required parameter driveId must be specified.");
            }

            public Unhide set$Xgafv(String $Xgafv) {
                return (Unhide)super.set$Xgafv($Xgafv);
            }

            public Unhide setAccessToken(String accessToken) {
                return (Unhide)super.setAccessToken(accessToken);
            }

            public Unhide setAlt(String alt) {
                return (Unhide)super.setAlt(alt);
            }

            public Unhide setCallback(String callback) {
                return (Unhide)super.setCallback(callback);
            }

            public Unhide setFields(String fields) {
                return (Unhide)super.setFields(fields);
            }

            public Unhide setKey(String key) {
                return (Unhide)super.setKey(key);
            }

            public Unhide setOauthToken(String oauthToken) {
                return (Unhide)super.setOauthToken(oauthToken);
            }

            public Unhide setPrettyPrint(Boolean prettyPrint) {
                return (Unhide)super.setPrettyPrint(prettyPrint);
            }

            public Unhide setQuotaUser(String quotaUser) {
                return (Unhide)super.setQuotaUser(quotaUser);
            }

            public Unhide setUploadType(String uploadType) {
                return (Unhide)super.setUploadType(uploadType);
            }

            public Unhide setUploadProtocol(String uploadProtocol) {
                return (Unhide)super.setUploadProtocol(uploadProtocol);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Unhide setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            @Override
            public Unhide set(String parameterName, Object value) {
                return (Unhide)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<DriveList> {
            private static final String REST_PATH = "drives";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String q;
            @Key
            private Boolean useDomainAdminAccess;

            protected List() {
                super(Drive.this, "GET", REST_PATH, null, DriveList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public List setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Hide
        extends DriveRequest<com.google.api.services.drive.model.Drive> {
            private static final String REST_PATH = "drives/{driveId}/hide";
            @Key
            private String driveId;

            protected Hide(String driveId) {
                super(Drive.this, "POST", REST_PATH, null, com.google.api.services.drive.model.Drive.class);
                this.driveId = (String)Preconditions.checkNotNull((Object)driveId, (Object)"Required parameter driveId must be specified.");
            }

            public Hide set$Xgafv(String $Xgafv) {
                return (Hide)super.set$Xgafv($Xgafv);
            }

            public Hide setAccessToken(String accessToken) {
                return (Hide)super.setAccessToken(accessToken);
            }

            public Hide setAlt(String alt) {
                return (Hide)super.setAlt(alt);
            }

            public Hide setCallback(String callback) {
                return (Hide)super.setCallback(callback);
            }

            public Hide setFields(String fields) {
                return (Hide)super.setFields(fields);
            }

            public Hide setKey(String key) {
                return (Hide)super.setKey(key);
            }

            public Hide setOauthToken(String oauthToken) {
                return (Hide)super.setOauthToken(oauthToken);
            }

            public Hide setPrettyPrint(Boolean prettyPrint) {
                return (Hide)super.setPrettyPrint(prettyPrint);
            }

            public Hide setQuotaUser(String quotaUser) {
                return (Hide)super.setQuotaUser(quotaUser);
            }

            public Hide setUploadType(String uploadType) {
                return (Hide)super.setUploadType(uploadType);
            }

            public Hide setUploadProtocol(String uploadProtocol) {
                return (Hide)super.setUploadProtocol(uploadProtocol);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Hide setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            @Override
            public Hide set(String parameterName, Object value) {
                return (Hide)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<com.google.api.services.drive.model.Drive> {
            private static final String REST_PATH = "drives/{driveId}";
            @Key
            private String driveId;
            @Key
            private Boolean useDomainAdminAccess;

            protected Get(String driveId) {
                super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Drive.class);
                this.driveId = (String)Preconditions.checkNotNull((Object)driveId, (Object)"Required parameter driveId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Get setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Get setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "drives/{driveId}";
            @Key
            private String driveId;
            @Key
            private Boolean allowItemDeletion;
            @Key
            private Boolean useDomainAdminAccess;

            protected Delete(String driveId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.driveId = (String)Preconditions.checkNotNull((Object)driveId, (Object)"Required parameter driveId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Delete setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getAllowItemDeletion() {
                return this.allowItemDeletion;
            }

            public Delete setAllowItemDeletion(Boolean allowItemDeletion) {
                this.allowItemDeletion = allowItemDeletion;
                return this;
            }

            public boolean isAllowItemDeletion() {
                if (this.allowItemDeletion == null || this.allowItemDeletion == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.allowItemDeletion;
            }

            public Boolean getUseDomainAdminAccess() {
                return this.useDomainAdminAccess;
            }

            public Delete setUseDomainAdminAccess(Boolean useDomainAdminAccess) {
                this.useDomainAdminAccess = useDomainAdminAccess;
                return this;
            }

            public boolean isUseDomainAdminAccess() {
                if (this.useDomainAdminAccess == null || this.useDomainAdminAccess == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useDomainAdminAccess;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DriveRequest<com.google.api.services.drive.model.Drive> {
            private static final String REST_PATH = "drives";
            @Key
            private String requestId;

            protected Create(String requestId, com.google.api.services.drive.model.Drive content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, com.google.api.services.drive.model.Drive.class);
                this.requestId = (String)Preconditions.checkNotNull((Object)requestId, (Object)"Required parameter requestId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Create setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Comments {
        public Create create(String fileId, Comment content) throws IOException {
            Create result = new Create(fileId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String fileId, String commentId) throws IOException {
            Delete result = new Delete(fileId, commentId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String fileId, String commentId) throws IOException {
            Get result = new Get(fileId, commentId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String fileId) throws IOException {
            List result = new List(fileId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String fileId, String commentId, Comment content) throws IOException {
            Update result = new Update(fileId, commentId, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Update(String fileId, String commentId, Comment content) {
                super(Drive.this, "PATCH", REST_PATH, (Object)content, Comment.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getContent(), "Comment.getContent()");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Update setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<CommentList> {
            private static final String REST_PATH = "files/{fileId}/comments";
            @Key
            private String fileId;
            @Key
            private Boolean includeDeleted;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String startModifiedTime;

            protected List(String fileId) {
                super(Drive.this, "GET", REST_PATH, null, CommentList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public List setIncludeDeleted(Boolean includeDeleted) {
                this.includeDeleted = includeDeleted;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getStartModifiedTime() {
                return this.startModifiedTime;
            }

            public List setStartModifiedTime(String startModifiedTime) {
                this.startModifiedTime = startModifiedTime;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private Boolean includeDeleted;

            protected Get(String fileId, String commentId) {
                super(Drive.this, "GET", REST_PATH, null, Comment.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public Get setIncludeDeleted(Boolean includeDeleted) {
                this.includeDeleted = includeDeleted;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Delete(String fileId, String commentId) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Delete setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments";
            @Key
            private String fileId;

            protected Create(String fileId, Comment content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Comment.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)fileId, (Object)"Required parameter fileId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getContent(), "Comment.getContent()");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Create setFileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel content) throws IOException {
            Stop result = new Stop(content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Stop
        extends DriveRequest<Void> {
            private static final String REST_PATH = "channels/stop";

            protected Stop(Channel content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Void.class);
            }

            public Stop set$Xgafv(String $Xgafv) {
                return (Stop)super.set$Xgafv($Xgafv);
            }

            public Stop setAccessToken(String accessToken) {
                return (Stop)super.setAccessToken(accessToken);
            }

            public Stop setAlt(String alt) {
                return (Stop)super.setAlt(alt);
            }

            public Stop setCallback(String callback) {
                return (Stop)super.setCallback(callback);
            }

            public Stop setFields(String fields) {
                return (Stop)super.setFields(fields);
            }

            public Stop setKey(String key) {
                return (Stop)super.setKey(key);
            }

            public Stop setOauthToken(String oauthToken) {
                return (Stop)super.setOauthToken(oauthToken);
            }

            public Stop setPrettyPrint(Boolean prettyPrint) {
                return (Stop)super.setPrettyPrint(prettyPrint);
            }

            public Stop setQuotaUser(String quotaUser) {
                return (Stop)super.setQuotaUser(quotaUser);
            }

            public Stop setUploadType(String uploadType) {
                return (Stop)super.setUploadType(uploadType);
            }

            public Stop setUploadProtocol(String uploadProtocol) {
                return (Stop)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Stop set(String parameterName, Object value) {
                return (Stop)super.set(parameterName, value);
            }
        }
    }

    public class Changes {
        public GetStartPageToken getStartPageToken() throws IOException {
            GetStartPageToken result = new GetStartPageToken();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String pageToken) throws IOException {
            List result = new List(pageToken);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Watch watch(String pageToken, Channel content) throws IOException {
            Watch result = new Watch(pageToken, content);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Watch
        extends DriveRequest<Channel> {
            private static final String REST_PATH = "changes/watch";
            @Key
            private String pageToken;
            @Key
            private String driveId;
            @Key
            private Boolean includeCorpusRemovals;
            @Key
            private Boolean includeItemsFromAllDrives;
            @Key
            private String includeLabels;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean includeRemoved;
            @Key
            private Boolean includeTeamDriveItems;
            @Key
            private Integer pageSize;
            @Key
            private Boolean restrictToMyDrive;
            @Key
            private String spaces;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected Watch(String pageToken, Channel content) {
                super(Drive.this, "POST", REST_PATH, (Object)content, Channel.class);
                this.pageToken = (String)Preconditions.checkNotNull((Object)pageToken, (Object)"Required parameter pageToken must be specified.");
            }

            public Watch set$Xgafv(String $Xgafv) {
                return (Watch)super.set$Xgafv($Xgafv);
            }

            public Watch setAccessToken(String accessToken) {
                return (Watch)super.setAccessToken(accessToken);
            }

            public Watch setAlt(String alt) {
                return (Watch)super.setAlt(alt);
            }

            public Watch setCallback(String callback) {
                return (Watch)super.setCallback(callback);
            }

            public Watch setFields(String fields) {
                return (Watch)super.setFields(fields);
            }

            public Watch setKey(String key) {
                return (Watch)super.setKey(key);
            }

            public Watch setOauthToken(String oauthToken) {
                return (Watch)super.setOauthToken(oauthToken);
            }

            public Watch setPrettyPrint(Boolean prettyPrint) {
                return (Watch)super.setPrettyPrint(prettyPrint);
            }

            public Watch setQuotaUser(String quotaUser) {
                return (Watch)super.setQuotaUser(quotaUser);
            }

            public Watch setUploadType(String uploadType) {
                return (Watch)super.setUploadType(uploadType);
            }

            public Watch setUploadProtocol(String uploadProtocol) {
                return (Watch)super.setUploadProtocol(uploadProtocol);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getDriveId() {
                return this.driveId;
            }

            public Watch setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getIncludeCorpusRemovals() {
                return this.includeCorpusRemovals;
            }

            public Watch setIncludeCorpusRemovals(Boolean includeCorpusRemovals) {
                this.includeCorpusRemovals = includeCorpusRemovals;
                return this;
            }

            public boolean isIncludeCorpusRemovals() {
                if (this.includeCorpusRemovals == null || this.includeCorpusRemovals == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeCorpusRemovals;
            }

            public Boolean getIncludeItemsFromAllDrives() {
                return this.includeItemsFromAllDrives;
            }

            public Watch setIncludeItemsFromAllDrives(Boolean includeItemsFromAllDrives) {
                this.includeItemsFromAllDrives = includeItemsFromAllDrives;
                return this;
            }

            public boolean isIncludeItemsFromAllDrives() {
                if (this.includeItemsFromAllDrives == null || this.includeItemsFromAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeItemsFromAllDrives;
            }

            public String getIncludeLabels() {
                return this.includeLabels;
            }

            public Watch setIncludeLabels(String includeLabels) {
                this.includeLabels = includeLabels;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public Watch setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getIncludeRemoved() {
                return this.includeRemoved;
            }

            public Watch setIncludeRemoved(Boolean includeRemoved) {
                this.includeRemoved = includeRemoved;
                return this;
            }

            public boolean isIncludeRemoved() {
                if (this.includeRemoved == null || this.includeRemoved == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeRemoved;
            }

            public Boolean getIncludeTeamDriveItems() {
                return this.includeTeamDriveItems;
            }

            public Watch setIncludeTeamDriveItems(Boolean includeTeamDriveItems) {
                this.includeTeamDriveItems = includeTeamDriveItems;
                return this;
            }

            public boolean isIncludeTeamDriveItems() {
                if (this.includeTeamDriveItems == null || this.includeTeamDriveItems == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeTeamDriveItems;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public Watch setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public Boolean getRestrictToMyDrive() {
                return this.restrictToMyDrive;
            }

            public Watch setRestrictToMyDrive(Boolean restrictToMyDrive) {
                this.restrictToMyDrive = restrictToMyDrive;
                return this;
            }

            public boolean isRestrictToMyDrive() {
                if (this.restrictToMyDrive == null || this.restrictToMyDrive == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.restrictToMyDrive;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public Watch setSpaces(String spaces) {
                this.spaces = spaces;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public Watch setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Watch setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Watch setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            @Override
            public Watch set(String parameterName, Object value) {
                return (Watch)super.set(parameterName, value);
            }
        }

        public class List
        extends DriveRequest<ChangeList> {
            private static final String REST_PATH = "changes";
            @Key
            private String pageToken;
            @Key
            private String driveId;
            @Key
            private Boolean includeCorpusRemovals;
            @Key
            private Boolean includeItemsFromAllDrives;
            @Key
            private String includeLabels;
            @Key
            private String includePermissionsForView;
            @Key
            private Boolean includeRemoved;
            @Key
            private Boolean includeTeamDriveItems;
            @Key
            private Integer pageSize;
            @Key
            private Boolean restrictToMyDrive;
            @Key
            private String spaces;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected List(String pageToken) {
                super(Drive.this, "GET", REST_PATH, null, ChangeList.class);
                this.pageToken = (String)Preconditions.checkNotNull((Object)pageToken, (Object)"Required parameter pageToken must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getDriveId() {
                return this.driveId;
            }

            public List setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getIncludeCorpusRemovals() {
                return this.includeCorpusRemovals;
            }

            public List setIncludeCorpusRemovals(Boolean includeCorpusRemovals) {
                this.includeCorpusRemovals = includeCorpusRemovals;
                return this;
            }

            public boolean isIncludeCorpusRemovals() {
                if (this.includeCorpusRemovals == null || this.includeCorpusRemovals == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeCorpusRemovals;
            }

            public Boolean getIncludeItemsFromAllDrives() {
                return this.includeItemsFromAllDrives;
            }

            public List setIncludeItemsFromAllDrives(Boolean includeItemsFromAllDrives) {
                this.includeItemsFromAllDrives = includeItemsFromAllDrives;
                return this;
            }

            public boolean isIncludeItemsFromAllDrives() {
                if (this.includeItemsFromAllDrives == null || this.includeItemsFromAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeItemsFromAllDrives;
            }

            public String getIncludeLabels() {
                return this.includeLabels;
            }

            public List setIncludeLabels(String includeLabels) {
                this.includeLabels = includeLabels;
                return this;
            }

            public String getIncludePermissionsForView() {
                return this.includePermissionsForView;
            }

            public List setIncludePermissionsForView(String includePermissionsForView) {
                this.includePermissionsForView = includePermissionsForView;
                return this;
            }

            public Boolean getIncludeRemoved() {
                return this.includeRemoved;
            }

            public List setIncludeRemoved(Boolean includeRemoved) {
                this.includeRemoved = includeRemoved;
                return this;
            }

            public boolean isIncludeRemoved() {
                if (this.includeRemoved == null || this.includeRemoved == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeRemoved;
            }

            public Boolean getIncludeTeamDriveItems() {
                return this.includeTeamDriveItems;
            }

            public List setIncludeTeamDriveItems(Boolean includeTeamDriveItems) {
                this.includeTeamDriveItems = includeTeamDriveItems;
                return this;
            }

            public boolean isIncludeTeamDriveItems() {
                if (this.includeTeamDriveItems == null || this.includeTeamDriveItems == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeTeamDriveItems;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public Boolean getRestrictToMyDrive() {
                return this.restrictToMyDrive;
            }

            public List setRestrictToMyDrive(Boolean restrictToMyDrive) {
                this.restrictToMyDrive = restrictToMyDrive;
                return this;
            }

            public boolean isRestrictToMyDrive() {
                if (this.restrictToMyDrive == null || this.restrictToMyDrive == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.restrictToMyDrive;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public List setSpaces(String spaces) {
                this.spaces = spaces;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public List setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public List setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public List setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetStartPageToken
        extends DriveRequest<StartPageToken> {
            private static final String REST_PATH = "changes/startPageToken";
            @Key
            private String driveId;
            @Key
            private Boolean supportsAllDrives;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected GetStartPageToken() {
                super(Drive.this, "GET", REST_PATH, null, StartPageToken.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetStartPageToken set$Xgafv(String $Xgafv) {
                return (GetStartPageToken)super.set$Xgafv($Xgafv);
            }

            public GetStartPageToken setAccessToken(String accessToken) {
                return (GetStartPageToken)super.setAccessToken(accessToken);
            }

            public GetStartPageToken setAlt(String alt) {
                return (GetStartPageToken)super.setAlt(alt);
            }

            public GetStartPageToken setCallback(String callback) {
                return (GetStartPageToken)super.setCallback(callback);
            }

            public GetStartPageToken setFields(String fields) {
                return (GetStartPageToken)super.setFields(fields);
            }

            public GetStartPageToken setKey(String key) {
                return (GetStartPageToken)super.setKey(key);
            }

            public GetStartPageToken setOauthToken(String oauthToken) {
                return (GetStartPageToken)super.setOauthToken(oauthToken);
            }

            public GetStartPageToken setPrettyPrint(Boolean prettyPrint) {
                return (GetStartPageToken)super.setPrettyPrint(prettyPrint);
            }

            public GetStartPageToken setQuotaUser(String quotaUser) {
                return (GetStartPageToken)super.setQuotaUser(quotaUser);
            }

            public GetStartPageToken setUploadType(String uploadType) {
                return (GetStartPageToken)super.setUploadType(uploadType);
            }

            public GetStartPageToken setUploadProtocol(String uploadProtocol) {
                return (GetStartPageToken)super.setUploadProtocol(uploadProtocol);
            }

            public String getDriveId() {
                return this.driveId;
            }

            public GetStartPageToken setDriveId(String driveId) {
                this.driveId = driveId;
                return this;
            }

            public Boolean getSupportsAllDrives() {
                return this.supportsAllDrives;
            }

            public GetStartPageToken setSupportsAllDrives(Boolean supportsAllDrives) {
                this.supportsAllDrives = supportsAllDrives;
                return this;
            }

            public boolean isSupportsAllDrives() {
                if (this.supportsAllDrives == null || this.supportsAllDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsAllDrives;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public GetStartPageToken setSupportsTeamDrives(Boolean supportsTeamDrives) {
                this.supportsTeamDrives = supportsTeamDrives;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public GetStartPageToken setTeamDriveId(String teamDriveId) {
                this.teamDriveId = teamDriveId;
                return this;
            }

            @Override
            public GetStartPageToken set(String parameterName, Object value) {
                return (GetStartPageToken)super.set(parameterName, value);
            }
        }
    }

    public class Apps {
        public Get get(String appId) throws IOException {
            Get result = new Get(appId);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DriveRequest<AppList> {
            private static final String REST_PATH = "apps";
            @Key
            private String appFilterExtensions;
            @Key
            private String appFilterMimeTypes;
            @Key
            private String languageCode;

            protected List() {
                super(Drive.this, "GET", REST_PATH, null, AppList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getAppFilterExtensions() {
                return this.appFilterExtensions;
            }

            public List setAppFilterExtensions(String appFilterExtensions) {
                this.appFilterExtensions = appFilterExtensions;
                return this;
            }

            public String getAppFilterMimeTypes() {
                return this.appFilterMimeTypes;
            }

            public List setAppFilterMimeTypes(String appFilterMimeTypes) {
                this.appFilterMimeTypes = appFilterMimeTypes;
                return this;
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public List setLanguageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DriveRequest<App> {
            private static final String REST_PATH = "apps/{appId}";
            @Key
            private String appId;

            protected Get(String appId) {
                super(Drive.this, "GET", REST_PATH, null, App.class);
                this.appId = (String)Preconditions.checkNotNull((Object)appId, (Object)"Required parameter appId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getAppId() {
                return this.appId;
            }

            public Get setAppId(String appId) {
                this.appId = appId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class About {
        public Get get() throws IOException {
            Get result = new Get();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends DriveRequest<com.google.api.services.drive.model.About> {
            private static final String REST_PATH = "about";

            protected Get() {
                super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.About.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

