/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Representation of field, which is a typed key-value pair.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LabelField extends com.google.api.client.json.GenericJson {

  /**
   * Only present if valueType is dateString. RFC 3339 formatted date: YYYY-MM-DD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<com.google.api.client.util.DateTime> dateString;

  /**
   * The identifier of this label field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Only present if `valueType` is `integer`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("integer") @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> integer__;

  /**
   * This is always drive#labelField.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Only present if `valueType` is `selection`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> selection;

  /**
   * Only present if `valueType` is `text`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> text;

  /**
   * Only present if `valueType` is `user`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<User> user;

  /**
   * The field type. While new values may be supported in the future, the following are currently
   * allowed: * `dateString` * `integer` * `selection` * `text` * `user`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String valueType;

  /**
   * Only present if valueType is dateString. RFC 3339 formatted date: YYYY-MM-DD.
   * @return value or {@code null} for none
   */
  public java.util.List<com.google.api.client.util.DateTime> getDateString() {
    return dateString;
  }

  /**
   * Only present if valueType is dateString. RFC 3339 formatted date: YYYY-MM-DD.
   * @param dateString dateString or {@code null} for none
   */
  public LabelField setDateString(java.util.List<com.google.api.client.util.DateTime> dateString) {
    this.dateString = dateString;
    return this;
  }

  /**
   * The identifier of this label field.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The identifier of this label field.
   * @param id id or {@code null} for none
   */
  public LabelField setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Only present if `valueType` is `integer`.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getInteger() {
    return integer__;
  }

  /**
   * Only present if `valueType` is `integer`.
   * @param integer__ integer__ or {@code null} for none
   */
  public LabelField setInteger(java.util.List<java.lang.Long> integer__) {
    this.integer__ = integer__;
    return this;
  }

  /**
   * This is always drive#labelField.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#labelField.
   * @param kind kind or {@code null} for none
   */
  public LabelField setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Only present if `valueType` is `selection`
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSelection() {
    return selection;
  }

  /**
   * Only present if `valueType` is `selection`
   * @param selection selection or {@code null} for none
   */
  public LabelField setSelection(java.util.List<java.lang.String> selection) {
    this.selection = selection;
    return this;
  }

  /**
   * Only present if `valueType` is `text`.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getText() {
    return text;
  }

  /**
   * Only present if `valueType` is `text`.
   * @param text text or {@code null} for none
   */
  public LabelField setText(java.util.List<java.lang.String> text) {
    this.text = text;
    return this;
  }

  /**
   * Only present if `valueType` is `user`.
   * @return value or {@code null} for none
   */
  public java.util.List<User> getUser() {
    return user;
  }

  /**
   * Only present if `valueType` is `user`.
   * @param user user or {@code null} for none
   */
  public LabelField setUser(java.util.List<User> user) {
    this.user = user;
    return this;
  }

  /**
   * The field type. While new values may be supported in the future, the following are currently
   * allowed: * `dateString` * `integer` * `selection` * `text` * `user`
   * @return value or {@code null} for none
   */
  public java.lang.String getValueType() {
    return valueType;
  }

  /**
   * The field type. While new values may be supported in the future, the following are currently
   * allowed: * `dateString` * `integer` * `selection` * `text` * `user`
   * @param valueType valueType or {@code null} for none
   */
  public LabelField setValueType(java.lang.String valueType) {
    this.valueType = valueType;
    return this;
  }

  @Override
  public LabelField set(String fieldName, Object value) {
    return (LabelField) super.set(fieldName, value);
  }

  @Override
  public LabelField clone() {
    return (LabelField) super.clone();
  }

}
