/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * The response to an Access Proposal list request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListAccessProposalsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The list of Access Proposals. This field is only populated in v3 and v3beta.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AccessProposal> accessProposals;

  static {
    // hack to force ProGuard to consider AccessProposal used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AccessProposal.class);
  }

  /**
   * The continuation token for the next page of results. This will be absent if the end of the
   * results list has been reached. If the token is rejected for any reason, it should be discarded,
   * and pagination should be restarted from the first page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The list of Access Proposals. This field is only populated in v3 and v3beta.
   * @return value or {@code null} for none
   */
  public java.util.List<AccessProposal> getAccessProposals() {
    return accessProposals;
  }

  /**
   * The list of Access Proposals. This field is only populated in v3 and v3beta.
   * @param accessProposals accessProposals or {@code null} for none
   */
  public ListAccessProposalsResponse setAccessProposals(java.util.List<AccessProposal> accessProposals) {
    this.accessProposals = accessProposals;
    return this;
  }

  /**
   * The continuation token for the next page of results. This will be absent if the end of the
   * results list has been reached. If the token is rejected for any reason, it should be discarded,
   * and pagination should be restarted from the first page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The continuation token for the next page of results. This will be absent if the end of the
   * results list has been reached. If the token is rejected for any reason, it should be discarded,
   * and pagination should be restarted from the first page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListAccessProposalsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListAccessProposalsResponse set(String fieldName, Object value) {
    return (ListAccessProposalsResponse) super.set(fieldName, value);
  }

  @Override
  public ListAccessProposalsResponse clone() {
    return (ListAccessProposalsResponse) super.clone();
  }

}
