/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A restriction for copy and download of the file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DownloadRestriction extends com.google.api.client.json.GenericJson {

  /**
   * Whether download and copy is restricted for readers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean restrictedForReaders;

  /**
   * Whether download and copy is restricted for writers. If true, download is also restricted for
   * readers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean restrictedForWriters;

  /**
   * Whether download and copy is restricted for readers.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRestrictedForReaders() {
    return restrictedForReaders;
  }

  /**
   * Whether download and copy is restricted for readers.
   * @param restrictedForReaders restrictedForReaders or {@code null} for none
   */
  public DownloadRestriction setRestrictedForReaders(java.lang.Boolean restrictedForReaders) {
    this.restrictedForReaders = restrictedForReaders;
    return this;
  }

  /**
   * Whether download and copy is restricted for writers. If true, download is also restricted for
   * readers.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRestrictedForWriters() {
    return restrictedForWriters;
  }

  /**
   * Whether download and copy is restricted for writers. If true, download is also restricted for
   * readers.
   * @param restrictedForWriters restrictedForWriters or {@code null} for none
   */
  public DownloadRestriction setRestrictedForWriters(java.lang.Boolean restrictedForWriters) {
    this.restrictedForWriters = restrictedForWriters;
    return this;
  }

  @Override
  public DownloadRestriction set(String fieldName, Object value) {
    return (DownloadRestriction) super.set(fieldName, value);
  }

  @Override
  public DownloadRestriction clone() {
    return (DownloadRestriction) super.clone();
  }

}
