/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Download restrictions applied to the file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DownloadRestrictionsMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The effective download restriction applied to this file. This considers all
   * restriction settings and DLP rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DownloadRestriction effectiveDownloadRestrictionWithContext;

  /**
   * The download restriction of the file applied directly by the owner or organizer. This does not
   * take into account shared drive settings or DLP rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DownloadRestriction itemDownloadRestriction;

  /**
   * Output only. The effective download restriction applied to this file. This considers all
   * restriction settings and DLP rules.
   * @return value or {@code null} for none
   */
  public DownloadRestriction getEffectiveDownloadRestrictionWithContext() {
    return effectiveDownloadRestrictionWithContext;
  }

  /**
   * Output only. The effective download restriction applied to this file. This considers all
   * restriction settings and DLP rules.
   * @param effectiveDownloadRestrictionWithContext effectiveDownloadRestrictionWithContext or {@code null} for none
   */
  public DownloadRestrictionsMetadata setEffectiveDownloadRestrictionWithContext(DownloadRestriction effectiveDownloadRestrictionWithContext) {
    this.effectiveDownloadRestrictionWithContext = effectiveDownloadRestrictionWithContext;
    return this;
  }

  /**
   * The download restriction of the file applied directly by the owner or organizer. This does not
   * take into account shared drive settings or DLP rules.
   * @return value or {@code null} for none
   */
  public DownloadRestriction getItemDownloadRestriction() {
    return itemDownloadRestriction;
  }

  /**
   * The download restriction of the file applied directly by the owner or organizer. This does not
   * take into account shared drive settings or DLP rules.
   * @param itemDownloadRestriction itemDownloadRestriction or {@code null} for none
   */
  public DownloadRestrictionsMetadata setItemDownloadRestriction(DownloadRestriction itemDownloadRestriction) {
    this.itemDownloadRestriction = itemDownloadRestriction;
    return this;
  }

  @Override
  public DownloadRestrictionsMetadata set(String fieldName, Object value) {
    return (DownloadRestrictionsMetadata) super.set(fieldName, value);
  }

  @Override
  public DownloadRestrictionsMetadata clone() {
    return (DownloadRestrictionsMetadata) super.clone();
  }

}
