/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-03 at 18:56:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A permission for a file. A permission grants a user, group, domain or the world access to a file
 * or a folder hierarchy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Permission extends com.google.api.client.json.GenericJson {

  /**
   * Whether the permission allows the file to be discovered through search. This is only applicable
   * for permissions of type domain or anyone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowFileDiscovery;

  /**
   * A displayable name for users, groups or domains.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The domain to which this permission refers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String domain;

  /**
   * The email address of the user or group to which this permission refers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String emailAddress;

  /**
   * The time at which this permission will expire (RFC 3339 date-time).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime expirationTime;

  /**
   * The ID of this permission. This is a unique identifier for the grantee, and is published in
   * User resources as permissionId.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * This is always drive#permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A link to the user's profile photo, if available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String photoLink;

  /**
   * The role granted by this permission. Valid values are: - owner  - writer  - commenter  - reader
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * The type of the grantee. Valid values are: - user  - group  - domain  - anyone
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Whether the permission allows the file to be discovered through search. This is only applicable
   * for permissions of type domain or anyone.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowFileDiscovery() {
    return allowFileDiscovery;
  }

  /**
   * Whether the permission allows the file to be discovered through search. This is only applicable
   * for permissions of type domain or anyone.
   * @param allowFileDiscovery allowFileDiscovery or {@code null} for none
   */
  public Permission setAllowFileDiscovery(java.lang.Boolean allowFileDiscovery) {
    this.allowFileDiscovery = allowFileDiscovery;
    return this;
  }

  /**
   * A displayable name for users, groups or domains.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * A displayable name for users, groups or domains.
   * @param displayName displayName or {@code null} for none
   */
  public Permission setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The domain to which this permission refers.
   * @return value or {@code null} for none
   */
  public java.lang.String getDomain() {
    return domain;
  }

  /**
   * The domain to which this permission refers.
   * @param domain domain or {@code null} for none
   */
  public Permission setDomain(java.lang.String domain) {
    this.domain = domain;
    return this;
  }

  /**
   * The email address of the user or group to which this permission refers.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmailAddress() {
    return emailAddress;
  }

  /**
   * The email address of the user or group to which this permission refers.
   * @param emailAddress emailAddress or {@code null} for none
   */
  public Permission setEmailAddress(java.lang.String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

  /**
   * The time at which this permission will expire (RFC 3339 date-time).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getExpirationTime() {
    return expirationTime;
  }

  /**
   * The time at which this permission will expire (RFC 3339 date-time).
   * @param expirationTime expirationTime or {@code null} for none
   */
  public Permission setExpirationTime(com.google.api.client.util.DateTime expirationTime) {
    this.expirationTime = expirationTime;
    return this;
  }

  /**
   * The ID of this permission. This is a unique identifier for the grantee, and is published in
   * User resources as permissionId.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of this permission. This is a unique identifier for the grantee, and is published in
   * User resources as permissionId.
   * @param id id or {@code null} for none
   */
  public Permission setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * This is always drive#permission.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#permission.
   * @param kind kind or {@code null} for none
   */
  public Permission setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A link to the user's profile photo, if available.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhotoLink() {
    return photoLink;
  }

  /**
   * A link to the user's profile photo, if available.
   * @param photoLink photoLink or {@code null} for none
   */
  public Permission setPhotoLink(java.lang.String photoLink) {
    this.photoLink = photoLink;
    return this;
  }

  /**
   * The role granted by this permission. Valid values are: - owner  - writer  - commenter  - reader
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * The role granted by this permission. Valid values are: - owner  - writer  - commenter  - reader
   * @param role role or {@code null} for none
   */
  public Permission setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * The type of the grantee. Valid values are: - user  - group  - domain  - anyone
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the grantee. Valid values are: - user  - group  - domain  - anyone
   * @param type type or {@code null} for none
   */
  public Permission setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Permission set(String fieldName, Object value) {
    return (Permission) super.set(fieldName, value);
  }

  @Override
  public Permission clone() {
    return (Permission) super.clone();
  }

}
